/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.rest.servlet;

import com.hazelcast.spi.impl.NodeEngineImpl;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.exporter.common.TextFormat;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.seatunnel.engine.server.NodeExtension;
import org.apache.seatunnel.engine.server.rest.servlet.BaseServlet;

public class MetricsServlet
extends BaseServlet {
    private final CollectorRegistry collectorRegistry;

    public MetricsServlet(NodeEngineImpl nodeEngine) {
        super(nodeEngine);
        NodeExtension nodeExtension = (NodeExtension)nodeEngine.getNode().getNodeExtension();
        this.collectorRegistry = nodeExtension.getCollectorRegistry();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String contentType;
        String servletPath = req.getServletPath();
        if (servletPath.endsWith("/metrics")) {
            contentType = "text/plain; version=0.0.4; charset=utf-8";
        } else if (servletPath.endsWith("/openmetrics")) {
            contentType = "application/openmetrics-text; version=1.0.0; charset=utf-8";
        } else {
            throw new IllegalArgumentException("Unsupported metrics format");
        }
        try (StringWriter stringWriter = new StringWriter();){
            TextFormat.writeFormat((String)contentType, (Writer)stringWriter, (Enumeration)this.collectorRegistry.metricFamilySamples());
            this.write(resp, stringWriter.toString());
        }
    }
}

