/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.rest.servlet;

import com.hazelcast.spi.impl.NodeEngineImpl;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.common.exception.SeaTunnelRuntimeException;
import org.apache.seatunnel.common.utils.FileUtils;
import org.apache.seatunnel.engine.server.rest.servlet.BaseServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogBaseServlet
extends BaseServlet {
    private static final Logger log = LoggerFactory.getLogger(LogBaseServlet.class);

    public LogBaseServlet(NodeEngineImpl nodeEngine) {
        super(nodeEngine);
    }

    protected void prepareLogResponse(HttpServletResponse resp, String logPath, String logName) {
        if (StringUtils.isBlank((CharSequence)logPath)) {
            resp.setStatus(400);
            log.warn("Log file path is empty, no log file path configured in the current configuration file");
            return;
        }
        String logFilePath = logPath + "/" + logName;
        try {
            String logContent = FileUtils.readFileToStr((Path)new File(logFilePath).toPath());
            this.write(resp, logContent);
        }
        catch (IOException | SeaTunnelRuntimeException e) {
            resp.setStatus(400);
            log.warn(String.format("Log file content is empty, get log path : %s", logFilePath));
        }
    }
}

