/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.rest.service;

import com.hazelcast.internal.json.JsonArray;
import com.hazelcast.internal.json.JsonObject;
import com.hazelcast.internal.json.JsonValue;
import com.hazelcast.map.IMap;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.NodeEngineImpl;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.seatunnel.api.common.metrics.JobMetrics;
import org.apache.seatunnel.common.utils.JsonUtils;
import org.apache.seatunnel.config.sql.SqlConfigBuilder;
import org.apache.seatunnel.engine.core.job.JobDAGInfo;
import org.apache.seatunnel.engine.core.job.JobInfo;
import org.apache.seatunnel.engine.server.SeaTunnelServer;
import org.apache.seatunnel.engine.server.master.JobHistoryService;
import org.apache.seatunnel.engine.server.operation.GetJobMetricsOperation;
import org.apache.seatunnel.engine.server.rest.ConfigFormat;
import org.apache.seatunnel.engine.server.rest.service.BaseService;
import org.apache.seatunnel.engine.server.utils.NodeEngineUtil;
import org.apache.seatunnel.engine.server.utils.RestUtil;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.JsonNode;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public class JobInfoService
extends BaseService {
    private static final Logger log = LoggerFactory.getLogger(JobInfoService.class);

    public JobInfoService(NodeEngineImpl nodeEngine) {
        super(nodeEngine);
    }

    public JsonObject getJobInfoJson(Long jobId) {
        IMap jobInfoMap = this.nodeEngine.getHazelcastInstance().getMap("engine_runningJobInfo");
        JobInfo jobInfo = (JobInfo)jobInfoMap.get((Object)jobId);
        IMap finishedJobStateMap = this.nodeEngine.getHazelcastInstance().getMap("engine_finishedJobState");
        JobHistoryService.JobState finishedJobState = (JobHistoryService.JobState)finishedJobStateMap.get((Object)jobId);
        if (jobInfo != null) {
            return this.convertToJson(jobInfo, jobId);
        }
        if (finishedJobState != null) {
            JobMetrics finishedJobMetrics = (JobMetrics)this.nodeEngine.getHazelcastInstance().getMap("engine_finishedJobMetrics").get((Object)jobId);
            JobDAGInfo finishedJobDAGInfo = (JobDAGInfo)this.nodeEngine.getHazelcastInstance().getMap("engine_finishedJobVertexInfo").get((Object)jobId);
            return this.getJobInfoJson(finishedJobState, finishedJobMetrics.toJsonString(), finishedJobDAGInfo);
        }
        return new JsonObject().add("jobId", jobId.toString());
    }

    public JsonArray getJobsByStateJson(String state) {
        IMap finishedJob = this.nodeEngine.getHazelcastInstance().getMap("engine_finishedJobState");
        IMap finishedJobDAGInfo = this.nodeEngine.getHazelcastInstance().getMap("engine_finishedJobVertexInfo");
        SeaTunnelServer seaTunnelServer = this.getSeaTunnelServer(true);
        return finishedJob.values().stream().filter(jobState -> {
            if (state.isEmpty()) {
                return true;
            }
            return jobState.getJobStatus().name().equals(state.toUpperCase());
        }).sorted(Comparator.comparing(JobHistoryService.JobState::getFinishTime)).map(jobState -> {
            Long jobId = jobState.getJobId();
            String jobMetrics = seaTunnelServer == null ? (String)NodeEngineUtil.sendOperationToMasterNode((NodeEngine)this.nodeEngine, new GetJobMetricsOperation(jobId)).join() : seaTunnelServer.getCoordinatorService().getJobMetrics(jobId).toJsonString();
            return this.getJobInfoJson((JobHistoryService.JobState)jobState, jobMetrics, (JobDAGInfo)finishedJobDAGInfo.get((Object)jobId));
        }).collect(JsonArray::new, JsonArray::add, JsonArray::add);
    }

    public JsonArray getRunningJobsJson() {
        IMap values = this.nodeEngine.getHazelcastInstance().getMap("engine_runningJobInfo");
        return values.entrySet().stream().map(jobInfoEntry -> this.convertToJson((JobInfo)jobInfoEntry.getValue(), (Long)jobInfoEntry.getKey())).collect(JsonArray::new, JsonArray::add, JsonArray::add);
    }

    public JsonObject stopJob(byte[] requestBody) {
        Map map = JsonUtils.toMap((JsonNode)this.requestHandle(requestBody));
        SeaTunnelServer seaTunnelServer = this.getSeaTunnelServer(false);
        this.handleStopJob(map, seaTunnelServer, this.nodeEngine.getNode());
        return new JsonObject().add("jobId", map.get("jobId").toString());
    }

    public JsonArray stopJobs(byte[] requestBody) {
        JsonArray jsonResponse = new JsonArray();
        List jobList = JsonUtils.toList((String)this.requestHandle(requestBody).toString(), Map.class);
        jobList.forEach(job -> {
            this.handleStopJob((Map<String, Object>)job, this.getSeaTunnelServer(false), this.nodeEngine.getNode());
            jsonResponse.add((JsonValue)new JsonObject().add("jobId", ((Long)job.get("jobId")).longValue()));
        });
        return jsonResponse;
    }

    public JsonObject submitJob(Map<String, String> requestParams, byte[] requestBody) {
        Config config;
        if (Boolean.parseBoolean(requestParams.get("isStartWithSavePoint")) && requestParams.get("jobId") == null) {
            throw new IllegalArgumentException("Please provide jobId when start with save point.");
        }
        ConfigFormat configFormat = ConfigFormat.fromString(requestParams.get("format"));
        switch (configFormat) {
            case HOCON: {
                config = ConfigFactory.parseString((String)new String(requestBody, StandardCharsets.UTF_8));
                break;
            }
            case SQL: {
                config = SqlConfigBuilder.of((String)new String(requestBody, StandardCharsets.UTF_8));
                break;
            }
            default: {
                config = RestUtil.buildConfig(this.requestHandle(requestBody), false);
            }
        }
        SeaTunnelServer seaTunnelServer = this.getSeaTunnelServer(false);
        return this.submitJobInternal(config, requestParams, seaTunnelServer, this.nodeEngine.getNode());
    }

    public JsonObject submitJob(Map<String, String> requestParams, Config config) {
        if (Boolean.parseBoolean(requestParams.get("isStartWithSavePoint")) && requestParams.get("jobId") == null) {
            throw new IllegalArgumentException("Please provide jobId when start with save point.");
        }
        SeaTunnelServer seaTunnelServer = this.getSeaTunnelServer(false);
        return this.submitJobInternal(config, requestParams, seaTunnelServer, this.nodeEngine.getNode());
    }

    public JsonArray submitJobs(byte[] requestBody) {
        List<Tuple2<Map<String, String>, Config>> configTuples = RestUtil.buildConfigList(this.requestHandle(requestBody), false);
        return configTuples.stream().map(tuple -> {
            String urlParams = this.mapToUrlParams((Map)tuple._1);
            HashMap<String, String> requestParams = new HashMap<String, String>();
            RestUtil.buildRequestParams(requestParams, urlParams);
            SeaTunnelServer seaTunnelServer = this.getSeaTunnelServer(false);
            return this.submitJobInternal((Config)tuple._2, requestParams, seaTunnelServer, this.nodeEngine.getNode());
        }).collect(JsonArray::new, JsonArray::add, JsonArray::add);
    }
}

