/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.rest.filter;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.seatunnel.engine.common.config.server.HttpConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicAuthFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(BasicAuthFilter.class);
    private final HttpConfig httpConfig;
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String BASIC_PREFIX = "Basic ";
    private static final String WWW_AUTHENTICATE_HEADER = "WWW-Authenticate";
    private static final String BASIC_REALM = "Basic realm=\"SeaTunnel Web UI\"";

    public BasicAuthFilter(HttpConfig httpConfig) {
        this.httpConfig = httpConfig;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String base64Credentials;
        String credentials;
        String[] values;
        if (!this.httpConfig.isEnableBasicAuth()) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String authHeader = httpRequest.getHeader(AUTHORIZATION_HEADER);
        if (authHeader != null && authHeader.startsWith(BASIC_PREFIX) && (values = (credentials = new String(Base64.decodeBase64((String)(base64Credentials = authHeader.substring(BASIC_PREFIX.length()))), StandardCharsets.UTF_8)).split(":", 2)).length == 2) {
            String username = values[0];
            String password = values[1];
            if (username.equals(this.httpConfig.getBasicAuthUsername()) && password.equals(this.httpConfig.getBasicAuthPassword())) {
                chain.doFilter(request, response);
                return;
            }
        }
        httpResponse.setHeader(WWW_AUTHENTICATE_HEADER, BASIC_REALM);
        httpResponse.sendError(401, "Unauthorized");
    }

    public void destroy() {
    }
}

