/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.master;

import com.hazelcast.cluster.Address;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.IMap;
import com.hazelcast.map.listener.EntryExpiredListener;
import com.hazelcast.map.listener.MapListener;
import com.hazelcast.spi.impl.NodeEngine;
import java.io.Serializable;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.seatunnel.api.common.metrics.JobMetrics;
import org.apache.seatunnel.engine.common.exception.SeaTunnelEngineException;
import org.apache.seatunnel.engine.common.job.JobStatus;
import org.apache.seatunnel.engine.common.job.JobStatusData;
import org.apache.seatunnel.engine.core.job.JobDAGInfo;
import org.apache.seatunnel.engine.core.job.JobImmutableInformation;
import org.apache.seatunnel.engine.core.job.PipelineStatus;
import org.apache.seatunnel.engine.server.dag.physical.PipelineLocation;
import org.apache.seatunnel.engine.server.execution.ExecutionState;
import org.apache.seatunnel.engine.server.execution.PendingSourceState;
import org.apache.seatunnel.engine.server.execution.TaskGroupLocation;
import org.apache.seatunnel.engine.server.master.JobMaster;
import org.apache.seatunnel.engine.server.telemetry.log.operation.CleanLogOperation;
import org.apache.seatunnel.engine.server.utils.NodeEngineUtil;
import org.apache.seatunnel.shade.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.SerializationFeature;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.node.ObjectNode;
import scala.Tuple2;

public class JobHistoryService {
    private final NodeEngine nodeEngine;
    private final IMap<Object, Object> runningJobStateIMap;
    private final ILogger logger;
    private final Map<Long, JobMaster> runningJobMasterMap;
    private final Map<Long, Tuple2<PendingSourceState, JobMaster>> pendingJobMasterMap;
    private final IMap<Long, JobDAGInfo> finishedJobDAGInfoImap;
    private final IMap<Long, JobState> finishedJobStateImap;
    private final IMap<Long, JobMetrics> finishedJobMetricsImap;
    private final ObjectMapper objectMapper;
    private final int finishedJobExpireTime;

    public JobHistoryService(NodeEngine nodeEngine, IMap<Object, Object> runningJobStateIMap, ILogger logger, Map<Long, Tuple2<PendingSourceState, JobMaster>> pendingJobMasterMap, Map<Long, JobMaster> runningJobMasterMap, IMap<Long, JobState> finishedJobStateImap, IMap<Long, JobMetrics> finishedJobMetricsImap, IMap<Long, JobDAGInfo> finishedJobVertexInfoImap, int finishedJobExpireTime) {
        this.nodeEngine = nodeEngine;
        this.runningJobStateIMap = runningJobStateIMap;
        this.logger = logger;
        this.pendingJobMasterMap = pendingJobMasterMap;
        this.runningJobMasterMap = runningJobMasterMap;
        this.finishedJobStateImap = finishedJobStateImap;
        this.finishedJobMetricsImap = finishedJobMetricsImap;
        this.finishedJobDAGInfoImap = finishedJobVertexInfoImap;
        this.finishedJobDAGInfoImap.addEntryListener((MapListener)new JobInfoExpiredListener(), true);
        this.objectMapper = new ObjectMapper();
        this.objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        this.finishedJobExpireTime = finishedJobExpireTime;
    }

    public String listAllJob() {
        List<JobStatusData> status = this.getJobStatusData();
        try {
            return this.objectMapper.writeValueAsString(status);
        }
        catch (JsonProcessingException e) {
            this.logger.severe("Failed to list all job", (Throwable)e);
            throw new SeaTunnelEngineException((Throwable)e);
        }
    }

    public List<JobStatusData> getJobStatusData() {
        ArrayList<JobStatusData> status = new ArrayList<JobStatusData>();
        List runningJobStateList = this.runningJobMasterMap.values().stream().map(master -> this.toJobStateMapper((JobMaster)master, true)).collect(Collectors.toList());
        Set runningJonIds = runningJobStateList.stream().map(JobState::getJobId).collect(Collectors.toSet());
        List pendingJobStateList = this.pendingJobMasterMap.entrySet().stream().map(entry -> {
            Long jobId = (Long)entry.getKey();
            JobImmutableInformation jobImmutableInformation = ((JobMaster)((Tuple2)entry.getValue())._2).getJobImmutableInformation();
            return new JobState(jobId, jobImmutableInformation.getJobName(), JobStatus.PENDING, jobImmutableInformation.getCreateTime(), null, null, null, null);
        }).collect(Collectors.toList());
        Set pendingJobIds = pendingJobStateList.stream().map(JobState::getJobId).collect(Collectors.toSet());
        Stream.concat(Stream.concat(runningJobStateList.stream(), pendingJobStateList.stream()), this.finishedJobStateImap.values().stream().filter(jobState -> !runningJonIds.contains(jobState.getJobId()) && !pendingJobIds.contains(jobState.getJobId()))).forEach(jobState -> {
            JobStatusData jobStatusData = new JobStatusData(jobState.getJobId(), jobState.getJobName(), jobState.getJobStatus(), jobState.getSubmitTime(), jobState.getStartTime(), jobState.getFinishTime());
            status.add(jobStatusData);
        });
        return status;
    }

    public JobState getJobDetailState(Long jobId) {
        if (this.pendingJobMasterMap.containsKey(jobId)) {
            JobImmutableInformation jobImmutableInformation = ((JobMaster)this.pendingJobMasterMap.get((Object)jobId)._2).getJobImmutableInformation();
            return new JobState(jobId, jobImmutableInformation.getJobName(), JobStatus.PENDING, jobImmutableInformation.getCreateTime(), null, null, null, null);
        }
        return this.runningJobMasterMap.containsKey(jobId) ? this.toJobStateMapper(this.runningJobMasterMap.get(jobId), false) : (JobState)this.finishedJobStateImap.getOrDefault((Object)jobId, null);
    }

    public JobMetrics getJobMetrics(Long jobId) {
        return (JobMetrics)this.finishedJobMetricsImap.getOrDefault((Object)jobId, (Object)JobMetrics.empty());
    }

    public JobDAGInfo getJobDAGInfo(Long jobId) {
        return (JobDAGInfo)this.finishedJobDAGInfoImap.getOrDefault((Object)jobId, null);
    }

    public String getJobDetailStateAsString(Long jobId) {
        JobState jobStatus = this.getJobDetailState(jobId);
        if (null != jobStatus) {
            try {
                return this.objectMapper.writeValueAsString((Object)jobStatus);
            }
            catch (JsonProcessingException e) {
                this.logger.severe("serialize jobStateMapper err", (Throwable)e);
                ObjectNode objectNode = this.objectMapper.createObjectNode();
                objectNode.put("err", "serialize jobStateMapper err");
                return objectNode.toString();
            }
        }
        ObjectNode objectNode = this.objectMapper.createObjectNode();
        objectNode.put("err", String.format("jobId : %s not found", jobId));
        return objectNode.toString();
    }

    public void storeFinishedJobState(JobMaster jobMaster) {
        JobState jobState = this.toJobStateMapper(jobMaster, false);
        jobState.setStartTime(jobMaster.getStateTimestamp(JobStatus.SCHEDULED));
        jobState.setFinishTime(System.currentTimeMillis());
        jobState.setErrorMessage(jobMaster.getErrorMessage());
        this.finishedJobStateImap.put((Object)jobState.jobId, (Object)jobState, (long)this.finishedJobExpireTime, TimeUnit.MINUTES);
    }

    public void storeFinishedPipelineMetrics(long jobId, JobMetrics metrics) {
        this.finishedJobMetricsImap.computeIfAbsent((Object)jobId, key -> JobMetrics.of(new HashMap()));
        JobMetrics newMetrics = ((JobMetrics)this.finishedJobMetricsImap.get((Object)jobId)).merge(metrics);
        this.finishedJobMetricsImap.put((Object)jobId, (Object)newMetrics, (long)this.finishedJobExpireTime, TimeUnit.MINUTES);
    }

    private JobState toJobStateMapper(JobMaster jobMaster, boolean simple) {
        Long jobId = jobMaster.getJobImmutableInformation().getJobId();
        HashMap<PipelineLocation, PipelineStateData> pipelineStateMapperMap = new HashMap<PipelineLocation, PipelineStateData>();
        if (!simple) {
            try {
                jobMaster.getPhysicalPlan().getPipelineList().forEach(pipeline -> {
                    PipelineLocation pipelineLocation = pipeline.getPipelineLocation();
                    PipelineStatus pipelineState = (PipelineStatus)this.runningJobStateIMap.get((Object)pipelineLocation);
                    HashMap<TaskGroupLocation, ExecutionState> taskStateMap = new HashMap<TaskGroupLocation, ExecutionState>();
                    pipeline.getCoordinatorVertexList().forEach(coordinator -> {
                        TaskGroupLocation taskGroupLocation = coordinator.getTaskGroupLocation();
                        taskStateMap.put(taskGroupLocation, (ExecutionState)this.runningJobStateIMap.get((Object)taskGroupLocation));
                    });
                    pipeline.getPhysicalVertexList().forEach(task -> {
                        TaskGroupLocation taskGroupLocation = task.getTaskGroupLocation();
                        taskStateMap.put(taskGroupLocation, (ExecutionState)this.runningJobStateIMap.get((Object)taskGroupLocation));
                    });
                    PipelineStateData pipelineStateData = new PipelineStateData(pipelineState, taskStateMap);
                    pipelineStateMapperMap.put(pipelineLocation, pipelineStateData);
                });
            }
            catch (Exception e) {
                this.logger.warning("get job pipeline state err", (Throwable)e);
            }
        }
        JobStatus jobStatus = (JobStatus)this.runningJobStateIMap.get((Object)jobId);
        String jobName = jobMaster.getJobImmutableInformation().getJobName();
        long submitTime = jobMaster.getJobImmutableInformation().getCreateTime();
        Long startTime = jobMaster.getStateTimestamp(JobStatus.SCHEDULED);
        return new JobState(jobId, jobName, jobStatus, submitTime, startTime, null, pipelineStateMapperMap, null);
    }

    public void storeJobInfo(long jobId, JobDAGInfo jobInfo) {
        this.finishedJobDAGInfoImap.put((Object)jobId, (Object)jobInfo, (long)this.finishedJobExpireTime, TimeUnit.MINUTES);
    }

    public IMap<Long, JobState> getFinishedJobStateImap() {
        return this.finishedJobStateImap;
    }

    private class JobInfoExpiredListener
    implements EntryExpiredListener<Long, JobDAGInfo> {
        private JobInfoExpiredListener() {
        }

        public void entryExpired(EntryEvent<Long, JobDAGInfo> event) {
            Long jobId = (Long)event.getKey();
            JobDAGInfo jobDagInfo = (JobDAGInfo)event.getOldValue();
            try {
                Set historyExecutionPlan = jobDagInfo.getHistoryExecutionPlan();
                Stream.concat(historyExecutionPlan.stream(), Stream.of(jobDagInfo.getMaster())).forEach(address -> {
                    JobHistoryService.this.logger.info("clean job log, jobId: " + jobId + ", address: " + address);
                    try {
                        NodeEngineUtil.sendOperationToMemberNode(JobHistoryService.this.nodeEngine, new CleanLogOperation(jobId), new Address(address.getHostname(), address.getPort())).join();
                    }
                    catch (UnknownHostException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
            catch (Exception e) {
                JobHistoryService.this.logger.warning("clean job log err", (Throwable)e);
            }
        }
    }

    public static final class PipelineStateData
    implements Serializable {
        private static final long serialVersionUID = -7875004875757861958L;
        private PipelineStatus pipelineStatus;
        private Map<TaskGroupLocation, ExecutionState> executionStateMap;

        public PipelineStateData(PipelineStatus pipelineStatus, Map<TaskGroupLocation, ExecutionState> executionStateMap) {
            this.pipelineStatus = pipelineStatus;
            this.executionStateMap = executionStateMap;
        }

        public PipelineStatus getPipelineStatus() {
            return this.pipelineStatus;
        }

        public Map<TaskGroupLocation, ExecutionState> getExecutionStateMap() {
            return this.executionStateMap;
        }

        public void setPipelineStatus(PipelineStatus pipelineStatus) {
            this.pipelineStatus = pipelineStatus;
        }

        public void setExecutionStateMap(Map<TaskGroupLocation, ExecutionState> executionStateMap) {
            this.executionStateMap = executionStateMap;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PipelineStateData)) {
                return false;
            }
            PipelineStateData other = (PipelineStateData)o;
            PipelineStatus this$pipelineStatus = this.getPipelineStatus();
            PipelineStatus other$pipelineStatus = other.getPipelineStatus();
            if (this$pipelineStatus == null ? other$pipelineStatus != null : !this$pipelineStatus.equals(other$pipelineStatus)) {
                return false;
            }
            Map<TaskGroupLocation, ExecutionState> this$executionStateMap = this.getExecutionStateMap();
            Map<TaskGroupLocation, ExecutionState> other$executionStateMap = other.getExecutionStateMap();
            return !(this$executionStateMap == null ? other$executionStateMap != null : !((Object)this$executionStateMap).equals(other$executionStateMap));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            PipelineStatus $pipelineStatus = this.getPipelineStatus();
            result = result * 59 + ($pipelineStatus == null ? 43 : $pipelineStatus.hashCode());
            Map<TaskGroupLocation, ExecutionState> $executionStateMap = this.getExecutionStateMap();
            result = result * 59 + ($executionStateMap == null ? 43 : ((Object)$executionStateMap).hashCode());
            return result;
        }

        public String toString() {
            return "JobHistoryService.PipelineStateData(pipelineStatus=" + this.getPipelineStatus() + ", executionStateMap=" + this.getExecutionStateMap() + ")";
        }
    }

    public static final class JobState
    implements Serializable {
        private static final long serialVersionUID = -1176348098833918960L;
        private Long jobId;
        private String jobName;
        private JobStatus jobStatus;
        private long submitTime;
        private Long startTime;
        private Long finishTime;
        private Map<PipelineLocation, PipelineStateData> pipelineStateMapperMap;
        private String errorMessage;

        public JobState(Long jobId, String jobName, JobStatus jobStatus, long submitTime, Long startTime, Long finishTime, Map<PipelineLocation, PipelineStateData> pipelineStateMapperMap, String errorMessage) {
            this.jobId = jobId;
            this.jobName = jobName;
            this.jobStatus = jobStatus;
            this.submitTime = submitTime;
            this.startTime = startTime;
            this.finishTime = finishTime;
            this.pipelineStateMapperMap = pipelineStateMapperMap;
            this.errorMessage = errorMessage;
        }

        public Long getJobId() {
            return this.jobId;
        }

        public String getJobName() {
            return this.jobName;
        }

        public JobStatus getJobStatus() {
            return this.jobStatus;
        }

        public long getSubmitTime() {
            return this.submitTime;
        }

        public Long getStartTime() {
            return this.startTime;
        }

        public Long getFinishTime() {
            return this.finishTime;
        }

        public Map<PipelineLocation, PipelineStateData> getPipelineStateMapperMap() {
            return this.pipelineStateMapperMap;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public void setJobId(Long jobId) {
            this.jobId = jobId;
        }

        public void setJobName(String jobName) {
            this.jobName = jobName;
        }

        public void setJobStatus(JobStatus jobStatus) {
            this.jobStatus = jobStatus;
        }

        public void setSubmitTime(long submitTime) {
            this.submitTime = submitTime;
        }

        public void setStartTime(Long startTime) {
            this.startTime = startTime;
        }

        public void setFinishTime(Long finishTime) {
            this.finishTime = finishTime;
        }

        public void setPipelineStateMapperMap(Map<PipelineLocation, PipelineStateData> pipelineStateMapperMap) {
            this.pipelineStateMapperMap = pipelineStateMapperMap;
        }

        public void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JobState)) {
                return false;
            }
            JobState other = (JobState)o;
            if (this.getSubmitTime() != other.getSubmitTime()) {
                return false;
            }
            Long this$jobId = this.getJobId();
            Long other$jobId = other.getJobId();
            if (this$jobId == null ? other$jobId != null : !((Object)this$jobId).equals(other$jobId)) {
                return false;
            }
            Long this$startTime = this.getStartTime();
            Long other$startTime = other.getStartTime();
            if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
                return false;
            }
            Long this$finishTime = this.getFinishTime();
            Long other$finishTime = other.getFinishTime();
            if (this$finishTime == null ? other$finishTime != null : !((Object)this$finishTime).equals(other$finishTime)) {
                return false;
            }
            String this$jobName = this.getJobName();
            String other$jobName = other.getJobName();
            if (this$jobName == null ? other$jobName != null : !this$jobName.equals(other$jobName)) {
                return false;
            }
            JobStatus this$jobStatus = this.getJobStatus();
            JobStatus other$jobStatus = other.getJobStatus();
            if (this$jobStatus == null ? other$jobStatus != null : !this$jobStatus.equals(other$jobStatus)) {
                return false;
            }
            Map<PipelineLocation, PipelineStateData> this$pipelineStateMapperMap = this.getPipelineStateMapperMap();
            Map<PipelineLocation, PipelineStateData> other$pipelineStateMapperMap = other.getPipelineStateMapperMap();
            if (this$pipelineStateMapperMap == null ? other$pipelineStateMapperMap != null : !((Object)this$pipelineStateMapperMap).equals(other$pipelineStateMapperMap)) {
                return false;
            }
            String this$errorMessage = this.getErrorMessage();
            String other$errorMessage = other.getErrorMessage();
            return !(this$errorMessage == null ? other$errorMessage != null : !this$errorMessage.equals(other$errorMessage));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $submitTime = this.getSubmitTime();
            result = result * 59 + (int)($submitTime >>> 32 ^ $submitTime);
            Long $jobId = this.getJobId();
            result = result * 59 + ($jobId == null ? 43 : ((Object)$jobId).hashCode());
            Long $startTime = this.getStartTime();
            result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
            Long $finishTime = this.getFinishTime();
            result = result * 59 + ($finishTime == null ? 43 : ((Object)$finishTime).hashCode());
            String $jobName = this.getJobName();
            result = result * 59 + ($jobName == null ? 43 : $jobName.hashCode());
            JobStatus $jobStatus = this.getJobStatus();
            result = result * 59 + ($jobStatus == null ? 43 : $jobStatus.hashCode());
            Map<PipelineLocation, PipelineStateData> $pipelineStateMapperMap = this.getPipelineStateMapperMap();
            result = result * 59 + ($pipelineStateMapperMap == null ? 43 : ((Object)$pipelineStateMapperMap).hashCode());
            String $errorMessage = this.getErrorMessage();
            result = result * 59 + ($errorMessage == null ? 43 : $errorMessage.hashCode());
            return result;
        }

        public String toString() {
            return "JobHistoryService.JobState(jobId=" + this.getJobId() + ", jobName=" + this.getJobName() + ", jobStatus=" + this.getJobStatus() + ", submitTime=" + this.getSubmitTime() + ", startTime=" + this.getStartTime() + ", finishTime=" + this.getFinishTime() + ", pipelineStateMapperMap=" + this.getPipelineStateMapperMap() + ", errorMessage=" + this.getErrorMessage() + ")";
        }
    }
}

