/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.joiner;

import com.hazelcast.cluster.Address;
import com.hazelcast.config.Config;
import com.hazelcast.config.ConfigAccessor;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.cluster.impl.JoinMessage;
import com.hazelcast.internal.cluster.impl.JoinRequest;
import com.hazelcast.internal.cluster.impl.MulticastJoiner;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.internal.util.RandomPicker;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiteNodeDropOutMulticastJoiner
extends MulticastJoiner {
    private static final Logger log = LoggerFactory.getLogger(LiteNodeDropOutMulticastJoiner.class);
    private static final long JOIN_RETRY_INTERVAL = 1000L;
    private final AtomicInteger currentTryCount = new AtomicInteger(0);
    private final AtomicInteger maxTryCount = new AtomicInteger(this.calculateTryCount());

    public LiteNodeDropOutMulticastJoiner(Node node) {
        super(node);
    }

    public void doJoin() {
        long joinStartTime = Clock.currentTimeMillis();
        long maxJoinMillis = this.getMaxJoinMillis();
        Address thisAddress = this.node.getThisAddress();
        while (this.shouldRetry() && Clock.currentTimeMillis() - joinStartTime < maxJoinMillis) {
            this.clusterService.setMasterAddressToJoin(null);
            Address masterAddress = this.getTargetAddress();
            if (masterAddress == null) {
                masterAddress = this.findMasterWithMulticast();
            }
            this.clusterService.setMasterAddressToJoin(masterAddress);
            if (masterAddress == null || thisAddress.equals((Object)masterAddress)) {
                if (this.node.isLiteMember()) {
                    log.info("This node is lite member. No need to join to a master node.");
                    continue;
                }
                this.clusterJoinManager.setThisMemberAsMaster();
                return;
            }
            this.logger.info("Trying to join to discovered node: " + masterAddress);
            this.joinMaster();
        }
    }

    private void joinMaster() {
        Address master;
        long maxMasterJoinTime = this.getMaxJoinTimeToMasterNode();
        long start = Clock.currentTimeMillis();
        while (this.shouldRetry() && Clock.currentTimeMillis() - start < maxMasterJoinTime && (master = this.clusterService.getMasterAddress()) != null) {
            if (this.logger.isFineEnabled()) {
                this.logger.fine("Joining to master " + master);
            }
            this.clusterJoinManager.sendJoinRequest(master);
            try {
                this.clusterService.blockOnJoin(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            if (!this.isBlacklisted(master)) continue;
            this.clusterService.setMasterAddressToJoin(null);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Address findMasterWithMulticast() {
        try {
            Address masterAddress;
            if (this.logger.isFineEnabled()) {
                this.logger.fine("Searching for master node. Max tries: " + this.maxTryCount.get());
            }
            JoinRequest joinRequest = this.node.createJoinRequest((Address)null);
            while (this.node.isRunning() && this.currentTryCount.incrementAndGet() <= this.maxTryCount.get()) {
                joinRequest.setTryCount(this.currentTryCount.get());
                this.node.multicastService.send((JoinMessage)joinRequest);
                masterAddress = this.clusterService.getMasterAddress();
                if (masterAddress != null) {
                    Address var3;
                    Address address = var3 = masterAddress;
                    return address;
                }
                Thread.sleep(this.getPublishInterval());
            }
            masterAddress = null;
            return masterAddress;
        }
        catch (Exception var7) {
            Exception e = var7;
            if (this.logger != null) {
                this.logger.warning((Throwable)e);
            }
            Address address = null;
            return address;
        }
        finally {
            this.currentTryCount.set(0);
        }
    }

    private int calculateTryCount() {
        int lastDigits;
        NetworkConfig networkConfig = ConfigAccessor.getActiveMemberNetworkConfig((Config)this.config);
        long timeoutMillis = TimeUnit.SECONDS.toMillis(networkConfig.getJoin().getMulticastConfig().getMulticastTimeoutSeconds());
        int avgPublishInterval = 125;
        int tryCount = (int)timeoutMillis / avgPublishInterval;
        String host = this.node.getThisAddress().getHost();
        try {
            lastDigits = Integer.parseInt(host.substring(host.lastIndexOf(46) + 1));
        }
        catch (NumberFormatException var9) {
            lastDigits = RandomPicker.getInt((int)512);
        }
        int portDiff = this.node.getThisAddress().getPort() - networkConfig.getPort();
        return tryCount += (lastDigits + portDiff) % 10;
    }

    private int getPublishInterval() {
        return RandomPicker.getInt((int)50, (int)200);
    }
}

