/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.dag;

import com.hazelcast.internal.serialization.SerializationService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.seatunnel.api.sink.SeaTunnelSink;
import org.apache.seatunnel.api.sink.multitablesink.MultiTableSink;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.engine.common.config.EngineConfig;
import org.apache.seatunnel.engine.core.classloader.ClassLoaderService;
import org.apache.seatunnel.engine.core.dag.actions.Action;
import org.apache.seatunnel.engine.core.dag.actions.ActionUtils;
import org.apache.seatunnel.engine.core.dag.actions.SinkAction;
import org.apache.seatunnel.engine.core.dag.actions.SourceAction;
import org.apache.seatunnel.engine.core.dag.logical.LogicalDag;
import org.apache.seatunnel.engine.core.dag.logical.LogicalVertex;
import org.apache.seatunnel.engine.core.job.Edge;
import org.apache.seatunnel.engine.core.job.ExecutionAddress;
import org.apache.seatunnel.engine.core.job.JobDAGInfo;
import org.apache.seatunnel.engine.core.job.JobImmutableInformation;
import org.apache.seatunnel.engine.core.job.VertexInfo;
import org.apache.seatunnel.engine.server.dag.execution.ExecutionPlanGenerator;
import org.apache.seatunnel.engine.server.dag.execution.Pipeline;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DAGUtils {
    private static final Logger log = LoggerFactory.getLogger(DAGUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LogicalDag restoreLogicalDag(JobImmutableInformation jobImmutableInformation, SerializationService serializationService, List<ClassLoader> classLoaders) {
        LogicalDag logicalDag = (LogicalDag)serializationService.toObject((Object)jobImmutableInformation.getLogicalDag());
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            List logicalVertexDataList = jobImmutableInformation.getLogicalVertexDataList();
            for (int i = 0; i < jobImmutableInformation.getLogicalVertexDataList().size(); ++i) {
                Thread.currentThread().setContextClassLoader(classLoaders.get(i));
                logicalDag.addLogicalVertex((LogicalVertex)serializationService.toObject(logicalVertexDataList.get(i)));
            }
            LogicalDag logicalDag2 = logicalDag;
            return logicalDag2;
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LogicalDag restoreLogicalDag(JobImmutableInformation jobImmutableInformation, SerializationService serializationService, ClassLoaderService classLoaderService) {
        List logicalVertexJarsList = jobImmutableInformation.getLogicalVertexJarsList();
        ArrayList<ClassLoader> classLoaders = new ArrayList<ClassLoader>();
        try {
            for (Set urls : logicalVertexJarsList) {
                classLoaders.add(classLoaderService.getClassLoader(jobImmutableInformation.getJobId(), (Collection)urls));
            }
            LogicalDag logicalDag = DAGUtils.restoreLogicalDag(jobImmutableInformation, serializationService, classLoaders);
            return logicalDag;
        }
        finally {
            for (Set urls : logicalVertexJarsList) {
                classLoaderService.releaseClassLoader(jobImmutableInformation.getJobId(), (Collection)urls);
            }
        }
    }

    public static JobDAGInfo getJobDAGInfo(LogicalDag logicalDag, JobImmutableInformation jobImmutableInformation, EngineConfig engineConfig, boolean isPhysicalDAGIInfo, ExecutionAddress master, Set<ExecutionAddress> historyExecutionAddress) {
        List<Pipeline> pipelines = new ExecutionPlanGenerator(logicalDag, jobImmutableInformation, engineConfig).generate().getPipelines();
        if (isPhysicalDAGIInfo) {
            HashMap pipelineWithEdges = new HashMap();
            HashMap vertexInfoMap = new HashMap();
            pipelines.forEach(pipeline -> {
                pipelineWithEdges.put(pipeline.getId(), pipeline.getEdges().stream().map(e -> new Edge(e.getLeftVertexId(), e.getRightVertexId())).collect(Collectors.toList()));
                pipeline.getVertexes().forEach((id, vertex) -> vertexInfoMap.put(id, new VertexInfo(vertex.getVertexId().longValue(), ActionUtils.getActionType((Action)vertex.getAction()), vertex.getAction().getName(), DAGUtils.getTablePaths(vertex.getAction()))));
            });
            return new JobDAGInfo(Long.valueOf(jobImmutableInformation.getJobId()), logicalDag.getJobConfig().getEnvOptions(), pipelineWithEdges, vertexInfoMap, master, historyExecutionAddress);
        }
        List edges = logicalDag.getEdges().stream().map(e -> new Edge(e.getInputVertexId(), e.getTargetVertexId())).collect(Collectors.toList());
        LinkedHashMap logicalVertexMap = logicalDag.getLogicalVertexMap();
        Map vertexInfoMap = logicalVertexMap.values().stream().map(v -> new VertexInfo(v.getVertexId().longValue(), ActionUtils.getActionType((Action)v.getAction()), v.getAction().getName(), DAGUtils.getTablePaths(v.getAction()))).collect(Collectors.toMap(VertexInfo::getVertexId, Function.identity()));
        Map pipelineWithEdges = edges.stream().collect(Collectors.groupingBy(e -> {
            LogicalVertex info = (LogicalVertex)logicalVertexMap.get(e.getInputVertexId() != null ? e.getInputVertexId() : e.getTargetVertexId());
            return pipelines.stream().filter(p -> p.getActions().containsKey(info.getAction().getId())).findFirst().get().getId();
        }, Collectors.toList()));
        return new JobDAGInfo(Long.valueOf(jobImmutableInformation.getJobId()), logicalDag.getJobConfig().getEnvOptions(), pipelineWithEdges, vertexInfoMap, master, historyExecutionAddress);
    }

    private static List<TablePath> getTablePaths(Action action) {
        ArrayList<TablePath> tablePaths = new ArrayList<TablePath>();
        if (action instanceof SourceAction) {
            SourceAction sourceAction = (SourceAction)action;
            try {
                List producedCatalogTables = sourceAction.getSource().getProducedCatalogTables();
                List sourceTablePaths = producedCatalogTables.stream().map(CatalogTable::getTablePath).collect(Collectors.toList());
                tablePaths.addAll(sourceTablePaths);
            }
            catch (UnsupportedOperationException e) {
                log.warn("SourceAction {} does not support getProducedCatalogTables, fallback to default table path", (Object)action.getName());
                tablePaths.add(TablePath.DEFAULT);
            }
        } else if (action instanceof SinkAction) {
            SeaTunnelSink seaTunnelSink = ((SinkAction)action).getSink();
            if (seaTunnelSink instanceof MultiTableSink) {
                ArrayList sinkTablePaths = new ArrayList(((MultiTableSink)seaTunnelSink).getSinkTables());
                tablePaths.addAll(sinkTablePaths);
            } else {
                Optional catalogTable = seaTunnelSink.getWriteCatalogTable();
                catalogTable.ifPresent(table -> tablePaths.add(table.getTablePath()));
            }
        }
        return tablePaths;
    }
}

