/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.utils;

import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import java.math.BigInteger;

public class Flowables {
    public static Flowable<BigInteger> range(BigInteger startValue, BigInteger endValue) {
        return Flowables.range(startValue, endValue, true);
    }

    public static Flowable<BigInteger> range(BigInteger startValue, BigInteger endValue, boolean ascending) {
        if (startValue.compareTo(BigInteger.ZERO) == -1) {
            throw new IllegalArgumentException("Negative start index cannot be used");
        }
        if (startValue.compareTo(endValue) > 0) {
            throw new IllegalArgumentException("Negative start index cannot be greater then end index");
        }
        if (ascending) {
            return Flowable.create(subscriber -> {
                BigInteger i = startValue;
                while (i.compareTo(endValue) < 1 && !subscriber.isCancelled()) {
                    subscriber.onNext(i);
                    i = i.add(BigInteger.ONE);
                }
                if (!subscriber.isCancelled()) {
                    subscriber.onComplete();
                }
            }, BackpressureStrategy.BUFFER);
        }
        return Flowable.create(subscriber -> {
            BigInteger i = endValue;
            while (i.compareTo(startValue) > -1 && !subscriber.isCancelled()) {
                subscriber.onNext(i);
                i = i.subtract(BigInteger.ONE);
            }
            if (!subscriber.isCancelled()) {
                subscriber.onComplete();
            }
        }, BackpressureStrategy.BUFFER);
    }
}

