/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Flowable;
import io.reactivex.FlowableSubscriber;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.exceptions.MissingBackpressureException;
import io.reactivex.functions.Function;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.fuseable.QueueSubscription;
import io.reactivex.internal.fuseable.SimplePlainQueue;
import io.reactivex.internal.fuseable.SimpleQueue;
import io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.internal.operators.flowable.FlowableScalarXMap;
import io.reactivex.internal.queue.SpscArrayQueue;
import io.reactivex.internal.queue.SpscLinkedArrayQueue;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.AtomicThrowable;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.internal.util.ExceptionHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableFlatMap<T, U>
extends AbstractFlowableWithUpstream<T, U> {
    final Function<? super T, ? extends Publisher<? extends U>> mapper;
    final boolean delayErrors;
    final int maxConcurrency;
    final int bufferSize;

    public FlowableFlatMap(Flowable<T> source2, Function<? super T, ? extends Publisher<? extends U>> mapper, boolean delayErrors, int maxConcurrency, int bufferSize) {
        super(source2);
        this.mapper = mapper;
        this.delayErrors = delayErrors;
        this.maxConcurrency = maxConcurrency;
        this.bufferSize = bufferSize;
    }

    @Override
    protected void subscribeActual(Subscriber<? super U> s) {
        if (FlowableScalarXMap.tryScalarXMapSubscribe(this.source, s, this.mapper)) {
            return;
        }
        this.source.subscribe(FlowableFlatMap.subscribe(s, this.mapper, this.delayErrors, this.maxConcurrency, this.bufferSize));
    }

    public static <T, U> FlowableSubscriber<T> subscribe(Subscriber<? super U> s, Function<? super T, ? extends Publisher<? extends U>> mapper, boolean delayErrors, int maxConcurrency, int bufferSize) {
        return new MergeSubscriber<T, U>(s, mapper, delayErrors, maxConcurrency, bufferSize);
    }

    static final class InnerSubscriber<T, U>
    extends AtomicReference<Subscription>
    implements FlowableSubscriber<U>,
    Disposable {
        private static final long serialVersionUID = -4606175640614850599L;
        final long id;
        final MergeSubscriber<T, U> parent;
        final int limit;
        final int bufferSize;
        volatile boolean done;
        volatile SimpleQueue<U> queue;
        long produced;
        int fusionMode;

        InnerSubscriber(MergeSubscriber<T, U> parent, long id) {
            this.id = id;
            this.parent = parent;
            this.bufferSize = parent.bufferSize;
            this.limit = this.bufferSize >> 2;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.setOnce(this, s)) {
                if (s instanceof QueueSubscription) {
                    QueueSubscription qs = (QueueSubscription)s;
                    int m = qs.requestFusion(7);
                    if (m == 1) {
                        this.fusionMode = m;
                        this.queue = qs;
                        this.done = true;
                        this.parent.drain();
                        return;
                    }
                    if (m == 2) {
                        this.fusionMode = m;
                        this.queue = qs;
                    }
                }
                s.request(this.bufferSize);
            }
        }

        @Override
        public void onNext(U t) {
            if (this.fusionMode != 2) {
                this.parent.tryEmit(t, this);
            } else {
                this.parent.drain();
            }
        }

        @Override
        public void onError(Throwable t) {
            this.lazySet(SubscriptionHelper.CANCELLED);
            this.parent.innerError(this, t);
        }

        @Override
        public void onComplete() {
            this.done = true;
            this.parent.drain();
        }

        void requestMore(long n) {
            if (this.fusionMode != 1) {
                long p = this.produced + n;
                if (p >= (long)this.limit) {
                    this.produced = 0L;
                    ((Subscription)this.get()).request(p);
                } else {
                    this.produced = p;
                }
            }
        }

        @Override
        public void dispose() {
            SubscriptionHelper.cancel(this);
        }

        @Override
        public boolean isDisposed() {
            return this.get() == SubscriptionHelper.CANCELLED;
        }
    }

    static final class MergeSubscriber<T, U>
    extends AtomicInteger
    implements FlowableSubscriber<T>,
    Subscription {
        private static final long serialVersionUID = -2117620485640801370L;
        final Subscriber<? super U> downstream;
        final Function<? super T, ? extends Publisher<? extends U>> mapper;
        final boolean delayErrors;
        final int maxConcurrency;
        final int bufferSize;
        volatile SimplePlainQueue<U> queue;
        volatile boolean done;
        final AtomicThrowable errs = new AtomicThrowable();
        volatile boolean cancelled;
        final AtomicReference<InnerSubscriber<?, ?>[]> subscribers = new AtomicReference();
        static final InnerSubscriber<?, ?>[] EMPTY = new InnerSubscriber[0];
        static final InnerSubscriber<?, ?>[] CANCELLED = new InnerSubscriber[0];
        final AtomicLong requested = new AtomicLong();
        Subscription upstream;
        long uniqueId;
        long lastId;
        int lastIndex;
        int scalarEmitted;
        final int scalarLimit;

        MergeSubscriber(Subscriber<? super U> actual, Function<? super T, ? extends Publisher<? extends U>> mapper, boolean delayErrors, int maxConcurrency, int bufferSize) {
            this.downstream = actual;
            this.mapper = mapper;
            this.delayErrors = delayErrors;
            this.maxConcurrency = maxConcurrency;
            this.bufferSize = bufferSize;
            this.scalarLimit = Math.max(1, maxConcurrency >> 1);
            this.subscribers.lazySet(EMPTY);
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.upstream, s)) {
                this.upstream = s;
                this.downstream.onSubscribe(this);
                if (!this.cancelled) {
                    if (this.maxConcurrency == Integer.MAX_VALUE) {
                        s.request(Long.MAX_VALUE);
                    } else {
                        s.request(this.maxConcurrency);
                    }
                }
            }
        }

        @Override
        public void onNext(T t) {
            InnerSubscriber inner;
            Publisher<U> p;
            if (this.done) {
                return;
            }
            try {
                p = ObjectHelper.requireNonNull(this.mapper.apply(t), "The mapper returned a null Publisher");
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.upstream.cancel();
                this.onError(e);
                return;
            }
            if (p instanceof Callable) {
                Object u;
                try {
                    u = ((Callable)((Object)p)).call();
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    this.errs.addThrowable(ex);
                    this.drain();
                    return;
                }
                if (u != null) {
                    this.tryEmitScalar(u);
                } else if (this.maxConcurrency != Integer.MAX_VALUE && !this.cancelled && ++this.scalarEmitted == this.scalarLimit) {
                    this.scalarEmitted = 0;
                    this.upstream.request(this.scalarLimit);
                }
            } else if (this.addInner(inner = new InnerSubscriber(this, this.uniqueId++))) {
                p.subscribe(inner);
            }
        }

        boolean addInner(InnerSubscriber<T, U> inner) {
            InnerSubscriber[] b;
            InnerSubscriber<?, ?>[] a;
            do {
                if ((a = this.subscribers.get()) == CANCELLED) {
                    inner.dispose();
                    return false;
                }
                int n = a.length;
                b = new InnerSubscriber[n + 1];
                System.arraycopy(a, 0, b, 0, n);
                b[n] = inner;
            } while (!this.subscribers.compareAndSet(a, b));
            return true;
        }

        void removeInner(InnerSubscriber<T, U> inner) {
            InnerSubscriber<?, ?>[] b;
            InnerSubscriber<?, ?>[] a;
            do {
                int n;
                if ((n = (a = this.subscribers.get()).length) == 0) {
                    return;
                }
                int j = -1;
                for (int i = 0; i < n; ++i) {
                    if (a[i] != inner) continue;
                    j = i;
                    break;
                }
                if (j < 0) {
                    return;
                }
                if (n == 1) {
                    b = EMPTY;
                    continue;
                }
                b = new InnerSubscriber[n - 1];
                System.arraycopy(a, 0, b, 0, j);
                System.arraycopy(a, j + 1, b, j, n - j - 1);
            } while (!this.subscribers.compareAndSet(a, b));
        }

        SimpleQueue<U> getMainQueue() {
            SimplePlainQueue<U> q = this.queue;
            if (q == null) {
                q = this.maxConcurrency == Integer.MAX_VALUE ? new SpscLinkedArrayQueue<U>(this.bufferSize) : new SpscArrayQueue<U>(this.maxConcurrency);
                this.queue = q;
            }
            return q;
        }

        void tryEmitScalar(U value) {
            if (this.get() == 0 && this.compareAndSet(0, 1)) {
                long r = this.requested.get();
                SimpleQueue<U> q = this.queue;
                if (r != 0L && (q == null || q.isEmpty())) {
                    this.downstream.onNext(value);
                    if (r != Long.MAX_VALUE) {
                        this.requested.decrementAndGet();
                    }
                    if (this.maxConcurrency != Integer.MAX_VALUE && !this.cancelled && ++this.scalarEmitted == this.scalarLimit) {
                        this.scalarEmitted = 0;
                        this.upstream.request(this.scalarLimit);
                    }
                } else {
                    if (q == null) {
                        q = this.getMainQueue();
                    }
                    if (!q.offer(value)) {
                        this.onError(new IllegalStateException("Scalar queue full?!"));
                        return;
                    }
                }
                if (this.decrementAndGet() == 0) {
                    return;
                }
            } else {
                SimpleQueue<U> q = this.getMainQueue();
                if (!q.offer(value)) {
                    this.onError(new IllegalStateException("Scalar queue full?!"));
                    return;
                }
                if (this.getAndIncrement() != 0) {
                    return;
                }
            }
            this.drainLoop();
        }

        SimpleQueue<U> getInnerQueue(InnerSubscriber<T, U> inner) {
            SimpleQueue q = inner.queue;
            if (q == null) {
                inner.queue = q = new SpscArrayQueue(this.bufferSize);
            }
            return q;
        }

        void tryEmit(U value, InnerSubscriber<T, U> inner) {
            if (this.get() == 0 && this.compareAndSet(0, 1)) {
                long r = this.requested.get();
                SimpleQueue q = inner.queue;
                if (r != 0L && (q == null || q.isEmpty())) {
                    this.downstream.onNext(value);
                    if (r != Long.MAX_VALUE) {
                        this.requested.decrementAndGet();
                    }
                    inner.requestMore(1L);
                } else {
                    if (q == null) {
                        q = this.getInnerQueue(inner);
                    }
                    if (!q.offer(value)) {
                        this.onError(new MissingBackpressureException("Inner queue full?!"));
                        return;
                    }
                }
                if (this.decrementAndGet() == 0) {
                    return;
                }
            } else {
                SimpleQueue q = inner.queue;
                if (q == null) {
                    q = new SpscArrayQueue(this.bufferSize);
                    inner.queue = q;
                }
                if (!q.offer(value)) {
                    this.onError(new MissingBackpressureException("Inner queue full?!"));
                    return;
                }
                if (this.getAndIncrement() != 0) {
                    return;
                }
            }
            this.drainLoop();
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            if (this.errs.addThrowable(t)) {
                this.done = true;
                this.drain();
            } else {
                RxJavaPlugins.onError(t);
            }
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.drain();
        }

        @Override
        public void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                BackpressureHelper.add(this.requested, n);
                this.drain();
            }
        }

        @Override
        public void cancel() {
            if (!this.cancelled) {
                SimplePlainQueue<U> q;
                this.cancelled = true;
                this.upstream.cancel();
                this.disposeAll();
                if (this.getAndIncrement() == 0 && (q = this.queue) != null) {
                    q.clear();
                }
            }
        }

        void drain() {
            if (this.getAndIncrement() == 0) {
                this.drainLoop();
            }
        }

        void drainLoop() {
            boolean innerCompleted;
            Subscriber<U> child = this.downstream;
            int missed = 1;
            do {
                if (this.checkTerminate()) {
                    return;
                }
                SimplePlainQueue<U> svq = this.queue;
                long r = this.requested.get();
                boolean unbounded = r == Long.MAX_VALUE;
                long replenishMain = 0L;
                if (svq != null) {
                    Object o;
                    do {
                        long scalarEmission = 0L;
                        o = null;
                        while (r != 0L) {
                            o = svq.poll();
                            if (this.checkTerminate()) {
                                return;
                            }
                            if (o == null) break;
                            child.onNext(o);
                            ++replenishMain;
                            ++scalarEmission;
                            --r;
                        }
                        if (scalarEmission == 0L) continue;
                        r = unbounded ? Long.MAX_VALUE : this.requested.addAndGet(-scalarEmission);
                    } while (r != 0L && o != null);
                }
                boolean d = this.done;
                svq = this.queue;
                InnerSubscriber<?, ?>[] inner = this.subscribers.get();
                int n = inner.length;
                if (d && (svq == null || svq.isEmpty()) && n == 0) {
                    Throwable ex = this.errs.terminate();
                    if (ex != ExceptionHelper.TERMINATED) {
                        if (ex == null) {
                            child.onComplete();
                        } else {
                            child.onError(ex);
                        }
                    }
                    return;
                }
                innerCompleted = false;
                if (n != 0) {
                    int i;
                    int j;
                    long startId = this.lastId;
                    int index = this.lastIndex;
                    if (n <= index || inner[index].id != startId) {
                        if (n <= index) {
                            index = 0;
                        }
                        j = index;
                        for (i = 0; i < n && inner[j].id != startId; ++i) {
                            if (++j != n) continue;
                            j = 0;
                        }
                        index = j;
                        this.lastIndex = j;
                        this.lastId = inner[j].id;
                    }
                    j = index;
                    block6: for (i = 0; i < n; ++i) {
                        if (this.checkTerminate()) {
                            return;
                        }
                        InnerSubscriber<?, ?> is = inner[j];
                        Object o = null;
                        do {
                            if (this.checkTerminate()) {
                                return;
                            }
                            SimpleQueue q = is.queue;
                            if (q == null) break;
                            long produced = 0L;
                            while (r != 0L) {
                                try {
                                    o = q.poll();
                                }
                                catch (Throwable ex) {
                                    Exceptions.throwIfFatal(ex);
                                    is.dispose();
                                    this.errs.addThrowable(ex);
                                    if (!this.delayErrors) {
                                        this.upstream.cancel();
                                    }
                                    if (this.checkTerminate()) {
                                        return;
                                    }
                                    this.removeInner(is);
                                    innerCompleted = true;
                                    ++i;
                                    continue block6;
                                }
                                if (o == null) break;
                                child.onNext(o);
                                if (this.checkTerminate()) {
                                    return;
                                }
                                --r;
                                ++produced;
                            }
                            if (produced == 0L) continue;
                            r = !unbounded ? this.requested.addAndGet(-produced) : Long.MAX_VALUE;
                            is.requestMore(produced);
                        } while (r != 0L && o != null);
                        boolean innerDone = is.done;
                        SimpleQueue innerQueue = is.queue;
                        if (innerDone && (innerQueue == null || innerQueue.isEmpty())) {
                            this.removeInner(is);
                            if (this.checkTerminate()) {
                                return;
                            }
                            ++replenishMain;
                            innerCompleted = true;
                        }
                        if (r == 0L) break;
                        if (++j != n) continue;
                        j = 0;
                    }
                    this.lastIndex = j;
                    this.lastId = inner[j].id;
                }
                if (replenishMain == 0L || this.cancelled) continue;
                this.upstream.request(replenishMain);
            } while (innerCompleted || (missed = this.addAndGet(-missed)) != 0);
        }

        boolean checkTerminate() {
            if (this.cancelled) {
                this.clearScalarQueue();
                return true;
            }
            if (!this.delayErrors && this.errs.get() != null) {
                this.clearScalarQueue();
                Throwable ex = this.errs.terminate();
                if (ex != ExceptionHelper.TERMINATED) {
                    this.downstream.onError(ex);
                }
                return true;
            }
            return false;
        }

        void clearScalarQueue() {
            SimplePlainQueue<U> q = this.queue;
            if (q != null) {
                q.clear();
            }
        }

        void disposeAll() {
            InnerSubscriber<?, ?>[] a = this.subscribers.get();
            if (a != CANCELLED && (a = this.subscribers.getAndSet(CANCELLED)) != CANCELLED) {
                for (InnerSubscriber<?, ?> inner : a) {
                    inner.dispose();
                }
                Throwable ex = this.errs.terminate();
                if (ex != null && ex != ExceptionHelper.TERMINATED) {
                    RxJavaPlugins.onError(ex);
                }
            }
        }

        void innerError(InnerSubscriber<T, U> inner, Throwable t) {
            if (this.errs.addThrowable(t)) {
                inner.done = true;
                if (!this.delayErrors) {
                    this.upstream.cancel();
                    for (InnerSubscriber<?, ?> a : this.subscribers.getAndSet(CANCELLED)) {
                        a.dispose();
                    }
                }
                this.drain();
            } else {
                RxJavaPlugins.onError(t);
            }
        }
    }
}

