/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Flowable;
import io.reactivex.FlowableSubscriber;
import io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.internal.util.LinkedArrayList;
import io.reactivex.internal.util.NotificationLite;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableCache<T>
extends AbstractFlowableWithUpstream<T, T> {
    final CacheState<T> state;
    final AtomicBoolean once;

    public FlowableCache(Flowable<T> source2, int capacityHint) {
        super(source2);
        this.state = new CacheState<T>(source2, capacityHint);
        this.once = new AtomicBoolean();
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> t) {
        ReplaySubscription<T> rp = new ReplaySubscription<T>(t, this.state);
        t.onSubscribe(rp);
        boolean doReplay = true;
        if (this.state.addChild(rp) && rp.requested.get() == Long.MIN_VALUE) {
            this.state.removeChild(rp);
            doReplay = false;
        }
        if (!this.once.get() && this.once.compareAndSet(false, true)) {
            this.state.connect();
        }
        if (doReplay) {
            rp.replay();
        }
    }

    boolean isConnected() {
        return this.state.isConnected;
    }

    boolean hasSubscribers() {
        return this.state.subscribers.get().length != 0;
    }

    int cachedEventCount() {
        return this.state.size();
    }

    static final class ReplaySubscription<T>
    extends AtomicInteger
    implements Subscription {
        private static final long serialVersionUID = -2557562030197141021L;
        private static final long CANCELLED = Long.MIN_VALUE;
        final Subscriber<? super T> child;
        final CacheState<T> state;
        final AtomicLong requested;
        Object[] currentBuffer;
        int currentIndexInBuffer;
        int index;
        long emitted;

        ReplaySubscription(Subscriber<? super T> child, CacheState<T> state) {
            this.child = child;
            this.state = state;
            this.requested = new AtomicLong();
        }

        @Override
        public void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                BackpressureHelper.addCancel(this.requested, n);
                this.replay();
            }
        }

        @Override
        public void cancel() {
            if (this.requested.getAndSet(Long.MIN_VALUE) != Long.MIN_VALUE) {
                this.state.removeChild(this);
            }
        }

        public void replay() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            Subscriber<T> child = this.child;
            AtomicLong rq = this.requested;
            long e = this.emitted;
            do {
                long r;
                if ((r = rq.get()) == Long.MIN_VALUE) {
                    return;
                }
                int s = this.state.size();
                if (s != 0) {
                    Object o;
                    int j;
                    Object[] b = this.currentBuffer;
                    if (b == null) {
                        this.currentBuffer = b = this.state.head();
                    }
                    int n = b.length - 1;
                    int k = this.currentIndexInBuffer;
                    for (j = this.index; j < s && e != r; ++j, ++e) {
                        if (rq.get() == Long.MIN_VALUE) {
                            return;
                        }
                        if (k == n) {
                            b = (Object[])b[n];
                            k = 0;
                        }
                        if (NotificationLite.accept(o = b[k], child)) {
                            return;
                        }
                        ++k;
                    }
                    if (rq.get() == Long.MIN_VALUE) {
                        return;
                    }
                    if (r == e) {
                        o = b[k];
                        if (NotificationLite.isComplete(o)) {
                            child.onComplete();
                            return;
                        }
                        if (NotificationLite.isError(o)) {
                            child.onError(NotificationLite.getError(o));
                            return;
                        }
                    }
                    this.index = j;
                    this.currentIndexInBuffer = k;
                    this.currentBuffer = b;
                }
                this.emitted = e;
            } while ((missed = this.addAndGet(-missed)) != 0);
        }
    }

    static final class CacheState<T>
    extends LinkedArrayList
    implements FlowableSubscriber<T> {
        final Flowable<T> source;
        final AtomicReference<Subscription> connection = new AtomicReference();
        final AtomicReference<ReplaySubscription<T>[]> subscribers;
        static final ReplaySubscription[] EMPTY = new ReplaySubscription[0];
        static final ReplaySubscription[] TERMINATED = new ReplaySubscription[0];
        volatile boolean isConnected;
        boolean sourceDone;

        CacheState(Flowable<T> source2, int capacityHint) {
            super(capacityHint);
            this.source = source2;
            this.subscribers = new AtomicReference<ReplaySubscription[]>(EMPTY);
        }

        public boolean addChild(ReplaySubscription<T> p) {
            ReplaySubscription[] b;
            ReplaySubscription<T>[] a;
            do {
                if ((a = this.subscribers.get()) == TERMINATED) {
                    return false;
                }
                int n = a.length;
                b = new ReplaySubscription[n + 1];
                System.arraycopy(a, 0, b, 0, n);
                b[n] = p;
            } while (!this.subscribers.compareAndSet(a, b));
            return true;
        }

        public void removeChild(ReplaySubscription<T> p) {
            ReplaySubscription[] b;
            ReplaySubscription<T>[] a;
            do {
                int n;
                if ((n = (a = this.subscribers.get()).length) == 0) {
                    return;
                }
                int j = -1;
                for (int i = 0; i < n; ++i) {
                    if (!a[i].equals(p)) continue;
                    j = i;
                    break;
                }
                if (j < 0) {
                    return;
                }
                if (n == 1) {
                    b = EMPTY;
                    continue;
                }
                b = new ReplaySubscription[n - 1];
                System.arraycopy(a, 0, b, 0, j);
                System.arraycopy(a, j + 1, b, j, n - j - 1);
            } while (!this.subscribers.compareAndSet(a, b));
        }

        @Override
        public void onSubscribe(Subscription s) {
            SubscriptionHelper.setOnce(this.connection, s, Long.MAX_VALUE);
        }

        public void connect() {
            this.source.subscribe(this);
            this.isConnected = true;
        }

        @Override
        public void onNext(T t) {
            if (!this.sourceDone) {
                Object o = NotificationLite.next(t);
                this.add(o);
                for (ReplaySubscription<T> rp : this.subscribers.get()) {
                    rp.replay();
                }
            }
        }

        @Override
        public void onError(Throwable e) {
            if (!this.sourceDone) {
                this.sourceDone = true;
                Object o = NotificationLite.error(e);
                this.add(o);
                SubscriptionHelper.cancel(this.connection);
                for (ReplaySubscription rp : this.subscribers.getAndSet(TERMINATED)) {
                    rp.replay();
                }
            } else {
                RxJavaPlugins.onError(e);
            }
        }

        @Override
        public void onComplete() {
            if (!this.sourceDone) {
                this.sourceDone = true;
                Object o = NotificationLite.complete();
                this.add(o);
                SubscriptionHelper.cancel(this.connection);
                for (ReplaySubscription rp : this.subscribers.getAndSet(TERMINATED)) {
                    rp.replay();
                }
            }
        }
    }
}

