/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.observers;

import io.reactivex.SingleObserver;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.util.BlockingHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;

public final class FutureSingleObserver<T>
extends CountDownLatch
implements SingleObserver<T>,
Future<T>,
Disposable {
    T value;
    Throwable error;
    final AtomicReference<Disposable> upstream = new AtomicReference();

    public FutureSingleObserver() {
        super(1);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        Disposable a;
        do {
            if ((a = this.upstream.get()) != this && a != DisposableHelper.DISPOSED) continue;
            return false;
        } while (!this.upstream.compareAndSet(a, DisposableHelper.DISPOSED));
        if (a != null) {
            a.dispose();
        }
        this.countDown();
        return true;
    }

    @Override
    public boolean isCancelled() {
        return DisposableHelper.isDisposed(this.upstream.get());
    }

    @Override
    public boolean isDone() {
        return this.getCount() == 0L;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        if (this.getCount() != 0L) {
            BlockingHelper.verifyNonBlocking();
            this.await();
        }
        if (this.isCancelled()) {
            throw new CancellationException();
        }
        Throwable ex = this.error;
        if (ex != null) {
            throw new ExecutionException(ex);
        }
        return this.value;
    }

    @Override
    public T get(long timeout2, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (this.getCount() != 0L) {
            BlockingHelper.verifyNonBlocking();
            if (!this.await(timeout2, unit)) {
                throw new TimeoutException();
            }
        }
        if (this.isCancelled()) {
            throw new CancellationException();
        }
        Throwable ex = this.error;
        if (ex != null) {
            throw new ExecutionException(ex);
        }
        return this.value;
    }

    @Override
    public void onSubscribe(Disposable d) {
        DisposableHelper.setOnce(this.upstream, d);
    }

    @Override
    public void onSuccess(T t) {
        Disposable a = this.upstream.get();
        if (a == DisposableHelper.DISPOSED) {
            return;
        }
        this.value = t;
        this.upstream.compareAndSet(a, this);
        this.countDown();
    }

    @Override
    public void onError(Throwable t) {
        Disposable a;
        do {
            if ((a = this.upstream.get()) == DisposableHelper.DISPOSED) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.error = t;
        } while (!this.upstream.compareAndSet(a, this));
        this.countDown();
    }

    @Override
    public void dispose() {
    }

    @Override
    public boolean isDisposed() {
        return this.isDone();
    }
}

