/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.tdengine.config;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.connectors.seatunnel.tdengine.config.TDengineSourceOptions;

public class TDengineSourceConfig
implements Serializable {
    private String url;
    private String username;
    private String password;
    private String database;
    private String stable;
    private String lowerBound;
    private String upperBound;
    private List<String> tags;
    private Set<String> subTables;
    private Set<String> readColumns;

    public static TDengineSourceConfig buildSourceConfig(ReadonlyConfig pluginConfig) {
        TDengineSourceConfig tdengineSourceConfig = new TDengineSourceConfig();
        tdengineSourceConfig.setUrl((String)pluginConfig.get(TDengineSourceOptions.URL));
        tdengineSourceConfig.setDatabase((String)pluginConfig.get(TDengineSourceOptions.DATABASE));
        tdengineSourceConfig.setStable((String)pluginConfig.get(TDengineSourceOptions.STABLE));
        tdengineSourceConfig.setUsername((String)pluginConfig.get(TDengineSourceOptions.USERNAME));
        tdengineSourceConfig.setPassword((String)pluginConfig.get(TDengineSourceOptions.PASSWORD));
        tdengineSourceConfig.setUpperBound((String)pluginConfig.get(TDengineSourceOptions.UPPER_BOUND));
        tdengineSourceConfig.setLowerBound((String)pluginConfig.get(TDengineSourceOptions.LOWER_BOUND));
        if (pluginConfig.getOptional(TDengineSourceOptions.SUB_TABLES).isPresent()) {
            tdengineSourceConfig.setSubTables(((List)pluginConfig.get(TDengineSourceOptions.SUB_TABLES)).stream().collect(Collectors.toSet()));
        }
        if (pluginConfig.getOptional(TDengineSourceOptions.READ_COLUMNS).isPresent()) {
            tdengineSourceConfig.setReadColumns(((List)pluginConfig.get(TDengineSourceOptions.READ_COLUMNS)).stream().collect(Collectors.toSet()));
        } else {
            tdengineSourceConfig.setReadColumns(null);
        }
        return tdengineSourceConfig;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getStable() {
        return this.stable;
    }

    public String getLowerBound() {
        return this.lowerBound;
    }

    public String getUpperBound() {
        return this.upperBound;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public Set<String> getSubTables() {
        return this.subTables;
    }

    public Set<String> getReadColumns() {
        return this.readColumns;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public void setStable(String stable) {
        this.stable = stable;
    }

    public void setLowerBound(String lowerBound) {
        this.lowerBound = lowerBound;
    }

    public void setUpperBound(String upperBound) {
        this.upperBound = upperBound;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public void setSubTables(Set<String> subTables) {
        this.subTables = subTables;
    }

    public void setReadColumns(Set<String> readColumns) {
        this.readColumns = readColumns;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TDengineSourceConfig)) {
            return false;
        }
        TDengineSourceConfig other = (TDengineSourceConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$database = this.getDatabase();
        String other$database = other.getDatabase();
        if (this$database == null ? other$database != null : !this$database.equals(other$database)) {
            return false;
        }
        String this$stable = this.getStable();
        String other$stable = other.getStable();
        if (this$stable == null ? other$stable != null : !this$stable.equals(other$stable)) {
            return false;
        }
        String this$lowerBound = this.getLowerBound();
        String other$lowerBound = other.getLowerBound();
        if (this$lowerBound == null ? other$lowerBound != null : !this$lowerBound.equals(other$lowerBound)) {
            return false;
        }
        String this$upperBound = this.getUpperBound();
        String other$upperBound = other.getUpperBound();
        if (this$upperBound == null ? other$upperBound != null : !this$upperBound.equals(other$upperBound)) {
            return false;
        }
        List<String> this$tags = this.getTags();
        List<String> other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        Set<String> this$subTables = this.getSubTables();
        Set<String> other$subTables = other.getSubTables();
        if (this$subTables == null ? other$subTables != null : !((Object)this$subTables).equals(other$subTables)) {
            return false;
        }
        Set<String> this$readColumns = this.getReadColumns();
        Set<String> other$readColumns = other.getReadColumns();
        return !(this$readColumns == null ? other$readColumns != null : !((Object)this$readColumns).equals(other$readColumns));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TDengineSourceConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $database = this.getDatabase();
        result = result * 59 + ($database == null ? 43 : $database.hashCode());
        String $stable = this.getStable();
        result = result * 59 + ($stable == null ? 43 : $stable.hashCode());
        String $lowerBound = this.getLowerBound();
        result = result * 59 + ($lowerBound == null ? 43 : $lowerBound.hashCode());
        String $upperBound = this.getUpperBound();
        result = result * 59 + ($upperBound == null ? 43 : $upperBound.hashCode());
        List<String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        Set<String> $subTables = this.getSubTables();
        result = result * 59 + ($subTables == null ? 43 : ((Object)$subTables).hashCode());
        Set<String> $readColumns = this.getReadColumns();
        result = result * 59 + ($readColumns == null ? 43 : ((Object)$readColumns).hashCode());
        return result;
    }

    public String toString() {
        return "TDengineSourceConfig(url=" + this.getUrl() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", database=" + this.getDatabase() + ", stable=" + this.getStable() + ", lowerBound=" + this.getLowerBound() + ", upperBound=" + this.getUpperBound() + ", tags=" + this.getTags() + ", subTables=" + this.getSubTables() + ", readColumns=" + this.getReadColumns() + ")";
    }
}

