/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.tdengine.sink;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.sink.SupportMultiTableSinkWriter;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.exception.CommonErrorCodeDeprecated;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.common.sink.AbstractSinkWriter;
import org.apache.seatunnel.connectors.seatunnel.tdengine.config.TDengineSinkConfig;
import org.apache.seatunnel.connectors.seatunnel.tdengine.exception.TDengineConnectorException;
import org.apache.seatunnel.connectors.seatunnel.tdengine.utils.TDengineUtil;
import org.apache.seatunnel.shade.com.google.common.annotations.VisibleForTesting;
import org.apache.seatunnel.shade.com.google.common.base.Throwables;
import org.apache.seatunnel.shade.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TDengineSinkWriter
extends AbstractSinkWriter<SeaTunnelRow, Void>
implements SupportMultiTableSinkWriter<Void> {
    private static final Logger log = LoggerFactory.getLogger(TDengineSinkWriter.class);
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
    private final Connection conn;
    private final TDengineSinkConfig config;
    private int tagsNum;

    public TDengineSinkWriter(TDengineSinkConfig config, SeaTunnelRowType seaTunnelRowType) {
        this.config = config;
        String jdbcUrl = StringUtils.join((Object[])new String[]{config.getUrl(), config.getDatabase(), "?user=", config.getUsername(), "&password=", config.getPassword()});
        TDengineUtil.checkDriverExist(jdbcUrl);
        this.conn = DriverManager.getConnection(jdbcUrl);
        try (Statement statement = this.conn.createStatement();
             ResultSet metaResultSet = statement.executeQuery("desc " + config.getDatabase() + "." + config.getStable());){
            while (metaResultSet.next()) {
                if (!StringUtils.equals((CharSequence)"TAG", (CharSequence)metaResultSet.getString("note"))) continue;
                ++this.tagsNum;
            }
        }
    }

    public void write(SeaTunnelRow element) {
        ArrayList tags = Lists.newArrayList();
        for (int i = element.getArity() - this.tagsNum; i < element.getArity(); ++i) {
            tags.add(element.getField(i));
        }
        String tagValues = StringUtils.join((Object[])this.convertDataType(tags.toArray()), (String)",");
        Object[] metrics = ArrayUtils.subarray((Object[])element.getFields(), (int)1, (int)(element.getArity() - this.tagsNum));
        try (Statement statement = this.conn.createStatement(1003, 1007);){
            String sql = String.format("INSERT INTO %s using %s tags ( %s ) VALUES ( %s );", element.getField(0), this.config.getStable(), tagValues, StringUtils.join((Object[])this.convertDataType(metrics), (String)","));
            int rowCount = statement.executeUpdate(sql);
            if (rowCount == 0) {
                Throwables.propagateIfPossible((Throwable)((Object)new TDengineConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.SQL_OPERATION_FAILED, "insert error:" + element)));
            }
        }
    }

    public void close() {
        if (Objects.nonNull(this.conn)) {
            try {
                this.conn.close();
            }
            catch (SQLException e) {
                throw new TDengineConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.WRITER_OPERATION_FAILED, "TDengine writer connection close failed", e);
            }
        }
    }

    @VisibleForTesting
    Object[] convertDataType(Object[] objects) {
        return Arrays.stream(objects).map(object -> {
            if (object == null) {
                return null;
            }
            if (LocalDateTime.class.equals(object.getClass())) {
                return "'" + ((LocalDateTime)object).atZone(ZoneId.systemDefault()).withZoneSameInstant(ZoneId.of(this.config.getTimezone())).format(FORMATTER) + "'";
            }
            if (String.class.equals(object.getClass())) {
                return "'" + object + "'";
            }
            return object;
        }).toArray();
    }
}

