/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.sls.source;

import com.aliyun.openservices.log.common.LogGroupData;
import com.aliyun.openservices.log.exception.LogException;
import com.aliyun.openservices.log.request.PullLogsRequest;
import com.aliyun.openservices.log.response.PullLogsResponse;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.stream.Collectors;
import org.apache.seatunnel.api.source.Boundedness;
import org.apache.seatunnel.api.source.Collector;
import org.apache.seatunnel.api.source.SourceReader;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.connectors.seatunnel.sls.serialization.FastLogDeserialization;
import org.apache.seatunnel.connectors.seatunnel.sls.source.SlsConsumerThread;
import org.apache.seatunnel.connectors.seatunnel.sls.source.SlsSourceConfig;
import org.apache.seatunnel.connectors.seatunnel.sls.source.SlsSourceSplit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlsSourceReader
implements SourceReader<SeaTunnelRow, SlsSourceSplit> {
    private static final Logger log = LoggerFactory.getLogger(SlsSourceReader.class);
    private static final long THREAD_WAIT_TIME = 500L;
    private final SourceReader.Context context;
    private volatile boolean running = false;
    private final LinkedBlockingQueue<SlsSourceSplit> pendingShardsQueue = new LinkedBlockingQueue();
    private final Set<SlsSourceSplit> sourceSplits = new HashSet<SlsSourceSplit>();
    private final Map<String, SlsConsumerThread> consumerThreadMap = new ConcurrentHashMap<String, SlsConsumerThread>();
    private final SlsSourceConfig slsSourceConfig;
    private final ExecutorService executorService;
    private final Map<Long, Map<String, SlsSourceSplit>> checkpointOffsetMap;

    SlsSourceReader(SlsSourceConfig slsSourceConfig, SourceReader.Context context) {
        this.slsSourceConfig = slsSourceConfig;
        this.context = context;
        this.executorService = Executors.newCachedThreadPool(r -> new Thread(r, "Sls Source Data Consumer"));
        this.checkpointOffsetMap = new ConcurrentHashMap<Long, Map<String, SlsSourceSplit>>();
    }

    public void open() throws Exception {
    }

    public void close() throws IOException {
        if (this.executorService != null) {
            this.executorService.shutdownNow();
        }
    }

    public void pollNext(Collector<SeaTunnelRow> collector) throws Exception {
        if (!this.running) {
            Thread.sleep(500L);
            return;
        }
        while (!this.pendingShardsQueue.isEmpty()) {
            this.sourceSplits.add(this.pendingShardsQueue.poll());
        }
        this.sourceSplits.forEach(sourceSplit -> this.consumerThreadMap.computeIfAbsent(sourceSplit.splitId(), s -> {
            SlsConsumerThread thread = new SlsConsumerThread(this.slsSourceConfig);
            this.executorService.submit(thread);
            return thread;
        }));
        CopyOnWriteArrayList finishedSplits = new CopyOnWriteArrayList();
        FastLogDeserialization<SeaTunnelRow> fastLogDeserialization = this.slsSourceConfig.getConsumerMetaData().getDeserializationSchema();
        this.sourceSplits.forEach(sourceSplit -> {
            CompletableFuture completableFuture = new CompletableFuture();
            try {
                this.consumerThreadMap.get(sourceSplit.splitId()).getTasks().put(consumer -> {
                    try {
                        PullLogsRequest request = new PullLogsRequest(sourceSplit.getProject(), sourceSplit.getLogStore(), sourceSplit.getShardId(), sourceSplit.getFetchSize(), sourceSplit.getStartCursor());
                        PullLogsResponse response = consumer.pullLogs(request);
                        List<LogGroupData> logGroupDatas = response.getLogGroups();
                        fastLogDeserialization.deserialize(logGroupDatas, collector);
                        sourceSplit.setStartCursor(response.getNextCursor());
                        completableFuture.complete(true);
                    }
                    catch (Throwable e) {
                        log.error("pull logs failed", e);
                        completableFuture.completeExceptionally(e);
                        throw new RuntimeException(e);
                    }
                    completableFuture.complete(false);
                });
                if (((Boolean)completableFuture.get()).booleanValue()) {
                    finishedSplits.add(sourceSplit);
                }
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        });
        if (Boundedness.BOUNDED.equals((Object)this.context.getBoundedness())) {
            for (SlsSourceSplit split : finishedSplits) {
                split.setFinish(true);
            }
            if (this.sourceSplits.stream().allMatch(SlsSourceSplit::isFinish)) {
                log.info("sls batch mode finished");
                this.context.signalNoMoreElement();
            }
        }
    }

    public List<SlsSourceSplit> snapshotState(long checkpointId) throws Exception {
        this.checkpointOffsetMap.put(checkpointId, this.sourceSplits.stream().collect(Collectors.toMap(SlsSourceSplit::splitId, SlsSourceSplit::copy)));
        return this.sourceSplits.stream().map(SlsSourceSplit::copy).collect(Collectors.toList());
    }

    public void addSplits(List<SlsSourceSplit> splits) {
        this.running = true;
        splits.forEach(s -> {
            try {
                this.pendingShardsQueue.put((SlsSourceSplit)s);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public void handleNoMoreSplits() {
        log.info("receive no more splits message, this reader will not add new split.");
    }

    public void notifyCheckpointComplete(long checkpointId) throws Exception {
        if (!this.checkpointOffsetMap.containsKey(checkpointId)) {
            log.warn("checkpoint {} do not exist or have already been committed.", (Object)checkpointId);
        } else {
            this.checkpointOffsetMap.remove(checkpointId).forEach((sharId, slsSourceSplit) -> {
                try {
                    this.consumerThreadMap.get(sharId).getTasks().put(client -> {
                        try {
                            client.UpdateCheckPoint(slsSourceSplit.getProject(), slsSourceSplit.getLogStore(), slsSourceSplit.getConsumer(), slsSourceSplit.getShardId(), slsSourceSplit.getStartCursor());
                        }
                        catch (LogException e) {
                            log.error("LogException: commit cursor to sls failed", (Throwable)e);
                            throw new RuntimeException(e);
                        }
                    });
                }
                catch (InterruptedException e) {
                    log.error("InterruptedException: commit cursor to sls failed", (Throwable)e);
                }
            });
        }
    }
}

