/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.request;

import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.log.request.Request;
import com.aliyun.openservices.log.util.Args;

public class GetLogsRequestV2
extends Request {
    private static final long DEFAULT_OFFSET = -1L;
    private static final long DEFAULT_LINE = -1L;
    private static final int DEFAULT_SHARD = -1;
    private static final long serialVersionUID = 3360163999513216113L;
    private String logstore;
    private int from;
    private int to;
    private String topic;
    private String query;
    private long offset = -1L;
    private long line = -1L;
    private boolean reverse;
    private boolean powerSql;
    private boolean forward;
    private int shard = -1;
    private String session;
    private boolean accurate;
    private boolean highlight;
    private String acceptEncoding = "lz4";

    public GetLogsRequestV2(String project, String logstore, int from, int to, String topic, String query) {
        super(project);
        this.logstore = logstore;
        this.from = from;
        this.to = to;
        this.topic = topic;
        this.query = query;
        this.SetParam("type", "log");
    }

    public GetLogsRequestV2(String project, String logstore, int from, int to, String topic, String query, long offset, long line, boolean reverse) {
        this(project, logstore, from, to, topic, query);
        Args.check(offset >= 0L, "offset must be >= 0");
        Args.check(line > 0L, "line must be > 0");
        this.offset = offset;
        this.line = line;
        this.reverse = reverse;
    }

    public String getLogstore() {
        return this.logstore;
    }

    public void setLogstore(String logstore) {
        this.logstore = logstore;
    }

    public int getFrom() {
        return this.from;
    }

    public void setFrom(int from) {
        this.from = from;
    }

    public int getTo() {
        return this.to;
    }

    public void setTo(int to) {
        this.to = to;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(long offset) {
        Args.check(offset >= 0L, "offset must be >= 0");
        this.offset = offset;
    }

    public long getLine() {
        return this.line;
    }

    public void setLine(long line) {
        Args.check(line > 0L, "line must be > 0");
        this.line = line;
    }

    public boolean isReverse() {
        return this.reverse;
    }

    public void setReverse(boolean reverse) {
        this.reverse = reverse;
    }

    public boolean isPowerSql() {
        return this.powerSql;
    }

    public void setPowerSql(boolean powerSql) {
        this.powerSql = powerSql;
    }

    public boolean isForward() {
        return this.forward;
    }

    public void setForward(boolean forward) {
        this.forward = forward;
    }

    public int getShard() {
        return this.shard;
    }

    public void SetAccurate(boolean accurate) {
        this.accurate = accurate;
    }

    public boolean GetAccurate() {
        return this.accurate;
    }

    public void SetNeedHighlight(boolean highlight) {
        this.highlight = highlight;
    }

    public boolean GetNeedHighlight() {
        return this.highlight;
    }

    public void setShard(int shard) {
        Args.check(shard >= 0, "shard must be >= 0");
        this.shard = shard;
    }

    public String getSession() {
        return this.session;
    }

    public void setSession(String session) {
        this.session = session;
    }

    public String getAcceptEncoding() {
        return this.acceptEncoding;
    }

    public String getRequestBody() {
        JSONObject body = new JSONObject();
        body.put("from", (Object)this.from);
        body.put("to", (Object)this.to);
        if (this.line > 0L) {
            body.put("line", (Object)this.line);
        }
        if (this.offset >= 0L) {
            body.put("offset", (Object)this.offset);
        }
        body.put("reverse", (Object)this.reverse);
        body.put("powerSql", (Object)this.powerSql);
        if (this.session != null) {
            body.put("session", (Object)this.session);
        }
        if (this.shard >= 0) {
            body.put("shard", (Object)this.shard);
        }
        body.put("topic", (Object)this.topic);
        body.put("query", (Object)this.query);
        body.put("forward", (Object)this.forward);
        body.put("accurate", (Object)this.accurate);
        body.put("highlight", (Object)this.highlight);
        return body.toString();
    }
}

