/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.common;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.log.exception.LogException;
import java.io.Serializable;
import java.util.Map;

public class TopostoreNode
implements Serializable {
    private String nodeId = "";
    private String nodeType = "";
    private String property = null;
    private String description = null;
    private String displayName = null;
    private long createTime = 0L;
    private long lastModifyTime = 0L;

    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    public void setLastModifyTime(long lastModifyTime) {
        this.lastModifyTime = lastModifyTime;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public long getLastModifyTime() {
        return this.lastModifyTime;
    }

    public TopostoreNode(String nodeId, String nodeType) {
        this(nodeId, nodeType, null, null);
    }

    public TopostoreNode(String nodeId, String nodeType, String property) {
        this(nodeId, nodeType, property, null);
    }

    public TopostoreNode(String nodeId, String nodeType, String property, String description) {
        this.nodeId = nodeId;
        this.nodeType = nodeType;
        this.property = property;
        this.description = description;
    }

    public TopostoreNode() {
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public String getNodeType() {
        return this.nodeType;
    }

    public void setNodeType(String nodeType) {
        this.nodeType = nodeType;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public void setProperty(Map<String, String> properties) {
        if (properties == null) {
            return;
        }
        JSONObject proObj = new JSONObject();
        for (Map.Entry<String, String> kv : properties.entrySet()) {
            proObj.put(kv.getKey(), (Object)kv.getValue());
        }
        this.setProperty(proObj.toJSONString());
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public JSONObject ToJsonObject() throws LogException {
        JSONObject result = new JSONObject();
        result.put("nodeId", (Object)this.getNodeId());
        result.put("nodeType", (Object)this.getNodeType());
        if (this.property != null) {
            result.put("property", (Object)this.getProperty());
        }
        if (this.description != null) {
            result.put("description", (Object)this.getDescription());
        }
        if (this.displayName != null) {
            result.put("displayName", (Object)this.getDisplayName());
        }
        return result;
    }

    public String ToJsonString() throws LogException {
        return this.ToJsonObject().toJSONString();
    }

    public void FromJsonObject(JSONObject dict) throws LogException {
        this.setNodeId(dict.getString("nodeId"));
        this.setNodeType(dict.getString("nodeType"));
        if (dict.containsKey("property")) {
            this.setProperty(dict.getString("property"));
        }
        if (dict.containsKey("displayName")) {
            this.setDisplayName(dict.getString("displayName"));
        }
        if (dict.containsKey("description")) {
            this.setDescription(dict.getString("description"));
        }
        if (dict.containsKey("createTime")) {
            this.createTime = dict.getIntValue("createTime");
        }
        if (dict.containsKey("lastModifyTime")) {
            this.lastModifyTime = dict.getIntValue("lastModifyTime");
        }
    }

    public void FromJsonString(String content) throws LogException {
        JSONObject dict = JSONObject.parseObject(content);
        this.FromJsonObject(dict);
    }

    public void checkForCreate() throws IllegalArgumentException {
        if (this.nodeId == null || this.nodeId.isEmpty()) {
            throw new IllegalArgumentException("topostore node id is null/empty");
        }
        if (this.nodeType == null || this.nodeType.isEmpty()) {
            throw new IllegalArgumentException("topostore node type is null/empty");
        }
        if (this.property != null) {
            try {
                JSONObject.parseObject(this.property);
            }
            catch (JSONException e) {
                throw new IllegalArgumentException("topostore node property not valid json");
            }
        }
    }

    public void checkForUpsert() throws IllegalArgumentException {
        this.checkForCreate();
    }

    public void checkForUpdate() throws IllegalArgumentException {
        this.checkForCreate();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TopostoreNode)) {
            return false;
        }
        TopostoreNode that = (TopostoreNode)o;
        if (this.nodeId != null ? !this.nodeId.equals(that.nodeId) : that.nodeId != null) {
            return false;
        }
        return this.nodeType != null ? this.nodeType.equals(that.nodeType) : that.nodeType == null;
    }

    public int hashCode() {
        int result = this.nodeId != null ? this.nodeId.hashCode() : 0;
        result = 31 * result + (this.nodeType != null ? this.nodeType.hashCode() : 0);
        return result;
    }
}

