/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.common;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.aliyun.openservices.log.common.LogContent;
import com.aliyun.openservices.log.common.LogItem;
import com.aliyun.openservices.log.common.QueriedLog;
import com.aliyun.openservices.log.exception.LogException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class QueryResult {
    private static final String METADATA_KEY = "meta";
    private static final String DATA_KEY = "data";
    private String aggQuery = "";
    private String whereQuery = "";
    private boolean isCompleted = false;
    private boolean hasSQL = false;
    private long processedRows = 0L;
    private long elapsedMillisecond = 0L;
    private double cpuSec = 0.0;
    private long cpuCores = 0L;
    private List<String> keys;
    private List<Term> terms;
    private long limited = 0L;
    private String marker = "";
    private int queryMode = 0;
    private boolean isPhraseQuery = false;
    private PhraseQueryInfo phraseQueryInfo;
    private int shard = 0;
    private long scanBytes = 0L;
    private List<List<LogContent>> highlights;
    private List<String> columnTypes;
    private List<QueriedLog> logs;

    public String getAggQuery() {
        return this.aggQuery;
    }

    public void setAggQuery(String aggQuery) {
        this.aggQuery = aggQuery;
    }

    public String getWhereQuery() {
        return this.whereQuery;
    }

    public void setWhereQuery(String whereQuery) {
        this.whereQuery = whereQuery;
    }

    public boolean isHasSQL() {
        return this.hasSQL;
    }

    public void setHasSQL(boolean hasSQL) {
        this.hasSQL = hasSQL;
    }

    public long getProcessedRows() {
        return this.processedRows;
    }

    public void setProcessedRows(long processedRows) {
        this.processedRows = processedRows;
    }

    public long getElapsedMillisecond() {
        return this.elapsedMillisecond;
    }

    public void setElapsedMillisecond(long elapsedMillisecond) {
        this.elapsedMillisecond = elapsedMillisecond;
    }

    public double getCpuSec() {
        return this.cpuSec;
    }

    public void setCpuSec(double cpuSec) {
        this.cpuSec = cpuSec;
    }

    public long getCpuCores() {
        return this.cpuCores;
    }

    public void setCpuCores(long cpuCores) {
        this.cpuCores = cpuCores;
    }

    public List<String> getKeys() {
        return this.keys;
    }

    public void setKeys(List<String> keys) {
        this.keys = keys;
    }

    public List<Term> getTerms() {
        return this.terms;
    }

    public long getLimited() {
        return this.limited;
    }

    public void setLimited(long limited) {
        this.limited = limited;
    }

    public String getMarker() {
        return this.marker;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public void setProcessStatus(String processStatus) {
        this.isCompleted = processStatus.equals("Complete");
    }

    public boolean isCompleted() {
        return this.isCompleted;
    }

    public void setCompleted(boolean completed) {
        this.isCompleted = completed;
    }

    public void setTerms(List<Term> terms) {
        this.terms = terms;
    }

    public int getQueryMode() {
        return this.queryMode;
    }

    public void setQueryMode(int queryMode) {
        this.queryMode = queryMode;
    }

    public boolean isPhraseQuery() {
        return this.isPhraseQuery;
    }

    public void setPhraseQuery(boolean phraseQuery) {
        this.isPhraseQuery = phraseQuery;
    }

    public PhraseQueryInfo getPhraseQueryInfo() {
        return this.phraseQueryInfo;
    }

    public void setPhraseQueryInfo(PhraseQueryInfo phraseQueryInfo) {
        this.phraseQueryInfo = phraseQueryInfo;
    }

    public int getShard() {
        return this.shard;
    }

    public void setShard(int shard) {
        this.shard = shard;
    }

    public long getScanBytes() {
        return this.scanBytes;
    }

    public void setScanBytes(long scanBytes) {
        this.scanBytes = scanBytes;
    }

    public List<List<LogContent>> getHighlights() {
        return this.highlights;
    }

    public void setHighlights(List<List<LogContent>> highlights) {
        this.highlights = highlights;
    }

    public List<String> getColumnTypes() {
        return this.columnTypes;
    }

    public void setColumnTypes(List<String> columnTypes) {
        this.columnTypes = columnTypes;
    }

    public List<QueriedLog> getLogs() {
        return this.logs;
    }

    public void setLogs(List<QueriedLog> logs) {
        this.logs = logs;
    }

    public void deserializeFrom(String rawResult, String requestId) throws LogException {
        JSONObject asJsonObj = JSONObject.parseObject(rawResult, Feature.DisableSpecialKeyDetect);
        this.parseMetadata(asJsonObj.getJSONObject(METADATA_KEY));
        this.logs = QueryResult.parseData(asJsonObj.getJSONArray(DATA_KEY), requestId);
    }

    public static QueriedLog extractLogFromJSON(JSONObject log, String requestId) throws JSONException, LogException {
        String source = "";
        LogItem logItem = new LogItem();
        Set<String> keySet = log.keySet();
        for (String key : keySet) {
            String value = log.getString(key);
            if (key.equals("__source__")) {
                source = value;
                continue;
            }
            if (key.equals("__time__")) {
                try {
                    logItem.mLogTime = Integer.parseInt(value);
                    continue;
                }
                catch (NumberFormatException ex) {
                    throw new LogException("InvalidLogTime", "The field __time__ is invalid in your query result: " + value, requestId);
                }
            }
            if (key.equals("__time_ns_part__")) {
                try {
                    logItem.mLogTimeNsPart = Integer.parseInt(value);
                    continue;
                }
                catch (NumberFormatException ex) {
                    throw new LogException("InvalidLogTime", "The field __time_ns_part__ is invalid in your query result: " + value, requestId);
                }
            }
            logItem.PushBack(key, value);
        }
        return new QueriedLog(source, logItem);
    }

    public static List<QueriedLog> parseData(JSONArray array, String requestId) throws LogException {
        if (array == null) {
            return new ArrayList<QueriedLog>();
        }
        int count = array.size();
        ArrayList<QueriedLog> logs = new ArrayList<QueriedLog>(count);
        try {
            for (int i = 0; i < count; ++i) {
                JSONObject jsonObject = array.getJSONObject(i);
                if (jsonObject == null) continue;
                logs.add(QueryResult.extractLogFromJSON(jsonObject, requestId));
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return logs;
    }

    private void parseMetadata(JSONObject asJsonObj) {
        JSONArray columnTypesAsJson;
        JSONArray jsonArray;
        JSONArray keyList;
        this.setProcessStatus(asJsonObj.getString("progress"));
        if (asJsonObj.containsKey("aggQuery")) {
            this.setAggQuery(asJsonObj.getString("aggQuery"));
        }
        if (asJsonObj.containsKey("whereQuery")) {
            this.setWhereQuery(asJsonObj.getString("whereQuery"));
        }
        if (asJsonObj.containsKey("hasSQL")) {
            this.setHasSQL(asJsonObj.getBooleanValue("hasSQL"));
        }
        if (asJsonObj.containsKey("processedRows")) {
            this.setProcessedRows(asJsonObj.getLongValue("processedRows"));
        }
        if (asJsonObj.containsKey("elapsedMillisecond")) {
            this.setElapsedMillisecond(asJsonObj.getLongValue("elapsedMillisecond"));
        }
        if (asJsonObj.containsKey("cpuSec")) {
            this.setCpuSec(asJsonObj.getDoubleValue("cpuSec"));
        }
        if (asJsonObj.containsKey("cpuCores")) {
            this.setCpuCores(asJsonObj.getLongValue("cpuCores"));
        }
        if ((keyList = asJsonObj.getJSONArray("keys")) != null) {
            this.keys = new ArrayList<String>(keyList.size());
            for (int i = 0; i < keyList.size(); ++i) {
                this.keys.add(keyList.getString(i));
            }
        } else {
            this.keys = new ArrayList<String>();
        }
        JSONArray termsAsJson = asJsonObj.getJSONArray("terms");
        this.terms = new ArrayList<Term>();
        if (termsAsJson != null) {
            for (int i = 0; i < termsAsJson.size(); ++i) {
                JSONObject term = termsAsJson.getJSONObject(i);
                if (term.size() != 2) continue;
                this.terms.add(new Term(term.getString("key"), term.getString("term")));
            }
        }
        if (asJsonObj.containsKey("limited")) {
            this.limited = asJsonObj.getLongValue("limited");
        }
        if (asJsonObj.containsKey("marker")) {
            this.marker = asJsonObj.getString("marker");
        }
        if (asJsonObj.containsKey("mode")) {
            this.queryMode = asJsonObj.getIntValue("mode");
            if (this.queryMode == 1) {
                this.isPhraseQuery = true;
            }
        }
        this.setPhraseQueryInfo(PhraseQueryInfo.deserializeFrom(asJsonObj.getJSONObject("phraseQueryInfo")));
        if (asJsonObj.containsKey("shard")) {
            this.shard = asJsonObj.getIntValue("shard");
        }
        if (asJsonObj.containsKey("scanBytes")) {
            this.scanBytes = asJsonObj.getLongValue("scanBytes");
        }
        if ((jsonArray = asJsonObj.getJSONArray("highlights")) != null) {
            this.highlights = new ArrayList<List<LogContent>>(jsonArray.size());
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                if (jsonObject == null) {
                    this.highlights.add(new ArrayList());
                    continue;
                }
                ArrayList<LogContent> logContents = new ArrayList<LogContent>(jsonObject.size());
                Set<String> keySey = jsonObject.keySet();
                for (String key : keySey) {
                    String value = jsonObject.getString(key);
                    logContents.add(new LogContent(key, value));
                }
                this.highlights.add(logContents);
            }
        }
        if ((columnTypesAsJson = asJsonObj.getJSONArray("columnTypes")) != null) {
            this.columnTypes = new ArrayList<String>(columnTypesAsJson.size());
            for (int i = 0; i < columnTypesAsJson.size(); ++i) {
                this.columnTypes.add(columnTypesAsJson.getString(i));
            }
        }
    }

    public static class PhraseQueryInfo {
        private boolean scanAll = false;
        private long beginOffset = 0L;
        private long endOffset = 0L;
        private long endTime = 0L;

        public void setScanAll(boolean scanAll) {
            this.scanAll = scanAll;
        }

        public void setBeginOffset(long beginOffset) {
            this.beginOffset = beginOffset;
        }

        public void setEndOffset(long endOffset) {
            this.endOffset = endOffset;
        }

        public void setEndTime(long endTime) {
            this.endTime = endTime;
        }

        public boolean isScanAll() {
            return this.scanAll;
        }

        public long getBeginOffset() {
            return this.beginOffset;
        }

        public long getEndOffset() {
            return this.endOffset;
        }

        public long getEndTime() {
            return this.endTime;
        }

        public static PhraseQueryInfo deserializeFrom(JSONObject asJson) {
            PhraseQueryInfo queryInfo = new PhraseQueryInfo();
            if (asJson == null) {
                return queryInfo;
            }
            if (asJson.containsKey("scanAll")) {
                queryInfo.setScanAll(asJson.getBooleanValue("scanAll"));
            }
            if (asJson.containsKey("beginOffset")) {
                queryInfo.setBeginOffset(asJson.getLongValue("beginOffset"));
            }
            if (asJson.containsKey("endOffset")) {
                queryInfo.setEndOffset(asJson.getLongValue("endOffset"));
            }
            if (asJson.containsKey("endTime")) {
                queryInfo.setEndTime(asJson.getLongValue("endTime"));
            }
            return queryInfo;
        }
    }

    public static class Term {
        private final String key;
        private final String term;

        public Term(String key, String term) {
            this.key = key;
            this.term = term;
        }

        public String getKey() {
            return this.key;
        }

        public String getTerm() {
            return this.term;
        }
    }
}

