/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.common;

import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.log.common.DataFormat;
import com.aliyun.openservices.log.common.DataSource;
import com.aliyun.openservices.log.common.DataSourceType;
import com.aliyun.openservices.log.common.DelimitedTextFormat;
import com.aliyun.openservices.log.common.JSONFormat;
import com.aliyun.openservices.log.common.LineFormat;
import com.aliyun.openservices.log.common.MultilineFormat;
import com.aliyun.openservices.log.common.ParquetFormat;
import com.aliyun.openservices.log.common.StructuredDataFormat;
import com.aliyun.openservices.log.util.JsonUtils;

public class AliyunOSSSource
extends DataSource {
    private String bucket;
    private String endpoint;
    private String roleARN;
    private String prefix;
    private String pattern;
    private String compressionCodec;
    private String encoding;
    private DataFormat format;
    private boolean restoreObjectEnabled;
    private boolean lastModifyTimeAsLogTime = false;

    public AliyunOSSSource() {
        super(DataSourceType.ALIYUN_OSS);
    }

    public String getBucket() {
        return this.bucket;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getRoleARN() {
        return this.roleARN;
    }

    public void setRoleARN(String roleARN) {
        this.roleARN = roleARN;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getCompressionCodec() {
        return this.compressionCodec;
    }

    public void setCompressionCodec(String compressionCodec) {
        this.compressionCodec = compressionCodec;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public DataFormat getFormat() {
        return this.format;
    }

    public void setFormat(DataFormat format) {
        this.format = format;
    }

    public boolean isRestoreObjectEnabled() {
        return this.restoreObjectEnabled;
    }

    public void setRestoreObjectEnabled(boolean restoreObjectEnabled) {
        this.restoreObjectEnabled = restoreObjectEnabled;
    }

    public boolean isLastModifyTimeAsLogTime() {
        return this.lastModifyTimeAsLogTime;
    }

    public void setLastModifyTimeAsLogTime(boolean lastModifyTimeAsLogTime) {
        this.lastModifyTimeAsLogTime = lastModifyTimeAsLogTime;
    }

    private static DataFormat createFormat(String type) {
        if ("DelimitedText".equalsIgnoreCase(type)) {
            return new DelimitedTextFormat();
        }
        if ("JSON".equalsIgnoreCase(type)) {
            return new JSONFormat();
        }
        if ("Multiline".equalsIgnoreCase(type)) {
            return new MultilineFormat();
        }
        if ("Parquet".equalsIgnoreCase(type)) {
            return new ParquetFormat();
        }
        if ("Line".equalsIgnoreCase(type)) {
            return new LineFormat();
        }
        return new StructuredDataFormat(type);
    }

    @Override
    public void deserialize(JSONObject jsonObject) {
        String type;
        super.deserialize(jsonObject);
        this.bucket = jsonObject.getString("bucket");
        this.endpoint = jsonObject.getString("endpoint");
        this.roleARN = jsonObject.getString("roleARN");
        this.prefix = JsonUtils.readOptionalString(jsonObject, "prefix");
        this.pattern = JsonUtils.readOptionalString(jsonObject, "pattern");
        this.compressionCodec = JsonUtils.readOptionalString(jsonObject, "compressionCodec");
        this.encoding = JsonUtils.readOptionalString(jsonObject, "encoding");
        JSONObject formatObject = jsonObject.getJSONObject("format");
        this.restoreObjectEnabled = JsonUtils.readBool(jsonObject, "restoreObjectEnabled", false);
        this.lastModifyTimeAsLogTime = JsonUtils.readBool(jsonObject, "lastModifyTimeAsLogTime", false);
        if (formatObject != null && !formatObject.isEmpty() && (type = JsonUtils.readOptionalString(formatObject, "type")) != null && !type.equals("")) {
            this.format = AliyunOSSSource.createFormat(type);
            this.format.deserialize(formatObject);
        }
    }
}

