/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.common;

import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.log.common.DataSink;
import com.aliyun.openservices.log.common.DataSinkType;
import com.aliyun.openservices.log.common.ExportContentColumnStorageDetail;
import com.aliyun.openservices.log.common.ExportContentCsvDetail;
import com.aliyun.openservices.log.common.ExportContentDetail;
import com.aliyun.openservices.log.common.ExportContentJsonDetail;
import com.aliyun.openservices.log.util.JsonUtils;

public class AliyunOSSSink
extends DataSink {
    private String roleArn;
    private String bucket;
    private String prefix;
    private String suffix;
    private String pathFormat;
    private String pathFormatType;
    private int bufferSize;
    private int bufferInterval;
    private String timeZone;
    private String contentType;
    private String compressionType;
    private ExportContentDetail contentDetail;
    private String endpoint;
    private int delaySeconds;

    public int getDelaySeconds() {
        return this.delaySeconds;
    }

    public void setDelaySeconds(int delaySeconds) {
        this.delaySeconds = delaySeconds;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public AliyunOSSSink() {
        super(DataSinkType.ALIYUN_OSS);
    }

    public AliyunOSSSink(String roleArn, String bucket, String prefix, String suffix, String pathFormat, String pathFormatType, int bufferSize, int bufferInterval, String timeZone, String contentType, String compressionType, ExportContentDetail contentDetail) {
        super(DataSinkType.ALIYUN_OSS);
        this.roleArn = roleArn;
        this.bucket = bucket;
        this.prefix = prefix;
        this.suffix = suffix;
        this.pathFormat = pathFormat;
        this.pathFormatType = pathFormatType;
        this.bufferSize = bufferSize;
        this.bufferInterval = bufferInterval;
        this.timeZone = timeZone;
        this.contentType = contentType;
        this.compressionType = compressionType;
        this.contentDetail = contentDetail;
    }

    public String getRoleArn() {
        return this.roleArn;
    }

    public void setRoleArn(String roleArn) {
        this.roleArn = roleArn;
    }

    public String getBucket() {
        return this.bucket;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public String getPathFormat() {
        return this.pathFormat;
    }

    public void setPathFormat(String pathFormat) {
        this.pathFormat = pathFormat;
    }

    public String getPathFormatType() {
        return this.pathFormatType;
    }

    public void setPathFormatType(String pathFormatType) {
        this.pathFormatType = pathFormatType;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public int getBufferInterval() {
        return this.bufferInterval;
    }

    public void setBufferInterval(int bufferInterval) {
        this.bufferInterval = bufferInterval;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getCompressionType() {
        return this.compressionType;
    }

    public void setCompressionType(String compressionType) {
        this.compressionType = compressionType;
    }

    public ExportContentDetail getContentDetail() {
        return this.contentDetail;
    }

    public void setContentDetail(ExportContentDetail contentDetail) {
        this.contentDetail = contentDetail;
    }

    @Override
    public void deserialize(JSONObject value) {
        this.roleArn = value.getString("roleArn");
        this.bucket = value.getString("bucket");
        this.prefix = value.getString("prefix");
        this.suffix = value.getString("suffix");
        this.pathFormat = value.getString("pathFormat");
        this.pathFormatType = JsonUtils.readOptionalString(value, "pathFormatType", "time");
        this.bufferSize = value.getIntValue("bufferSize");
        this.bufferInterval = value.getIntValue("bufferInterval");
        this.delaySeconds = value.getIntValue("delaySeconds");
        this.endpoint = value.getString("endpoint");
        this.timeZone = value.getString("timeZone");
        this.compressionType = value.getString("compressionType");
        this.contentType = value.getString("contentType");
        JSONObject obj = value.getJSONObject("contentDetail");
        if ("csv".equals(this.contentType)) {
            this.contentDetail = new ExportContentCsvDetail();
        } else if ("parquet".equals(this.contentType) || "orc".equals(this.contentType)) {
            this.contentDetail = new ExportContentColumnStorageDetail();
        } else if ("json".equals(this.contentType)) {
            this.contentDetail = new ExportContentJsonDetail();
        } else {
            throw new RuntimeException("ContentType should be json/csv/parquet/orc");
        }
        this.contentDetail.deserialize(obj);
    }
}

