/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.aliyun.openservices.log.LogService;
import com.aliyun.openservices.log.common.Chart;
import com.aliyun.openservices.log.common.Config;
import com.aliyun.openservices.log.common.Consts;
import com.aliyun.openservices.log.common.ConsumerGroup;
import com.aliyun.openservices.log.common.Dashboard;
import com.aliyun.openservices.log.common.Domain;
import com.aliyun.openservices.log.common.EtlJob;
import com.aliyun.openservices.log.common.EtlMeta;
import com.aliyun.openservices.log.common.ExternalStore;
import com.aliyun.openservices.log.common.Index;
import com.aliyun.openservices.log.common.InternalLogStore;
import com.aliyun.openservices.log.common.LinkStore;
import com.aliyun.openservices.log.common.LogContent;
import com.aliyun.openservices.log.common.LogGroup;
import com.aliyun.openservices.log.common.LogItem;
import com.aliyun.openservices.log.common.LogStore;
import com.aliyun.openservices.log.common.Logging;
import com.aliyun.openservices.log.common.Logs;
import com.aliyun.openservices.log.common.LogtailProfile;
import com.aliyun.openservices.log.common.Machine;
import com.aliyun.openservices.log.common.MachineGroup;
import com.aliyun.openservices.log.common.MachineList;
import com.aliyun.openservices.log.common.OdpsShipperConfig;
import com.aliyun.openservices.log.common.OssShipperConfig;
import com.aliyun.openservices.log.common.ProjectConsumerGroup;
import com.aliyun.openservices.log.common.QueryResult;
import com.aliyun.openservices.log.common.Resource;
import com.aliyun.openservices.log.common.ResourceRecord;
import com.aliyun.openservices.log.common.SavedSearch;
import com.aliyun.openservices.log.common.ScheduledSQL;
import com.aliyun.openservices.log.common.Shard;
import com.aliyun.openservices.log.common.ShipperConfig;
import com.aliyun.openservices.log.common.ShipperMigration;
import com.aliyun.openservices.log.common.ShipperTask;
import com.aliyun.openservices.log.common.ShipperTasksStatistic;
import com.aliyun.openservices.log.common.SqlInstance;
import com.aliyun.openservices.log.common.SubStore;
import com.aliyun.openservices.log.common.SubStoreKey;
import com.aliyun.openservices.log.common.TagContent;
import com.aliyun.openservices.log.common.TagResource;
import com.aliyun.openservices.log.common.Topostore;
import com.aliyun.openservices.log.common.TopostoreNode;
import com.aliyun.openservices.log.common.TopostoreRelation;
import com.aliyun.openservices.log.common.auth.Credentials;
import com.aliyun.openservices.log.common.auth.CredentialsProvider;
import com.aliyun.openservices.log.common.auth.DefaultCredentials;
import com.aliyun.openservices.log.common.auth.ECSRoleCredentialsProvider;
import com.aliyun.openservices.log.common.auth.StaticCredentialsProvider;
import com.aliyun.openservices.log.exception.LogException;
import com.aliyun.openservices.log.http.client.ClientConfiguration;
import com.aliyun.openservices.log.http.client.ClientConnectionContainer;
import com.aliyun.openservices.log.http.client.ClientConnectionHelper;
import com.aliyun.openservices.log.http.client.ClientConnectionStatus;
import com.aliyun.openservices.log.http.client.ClientException;
import com.aliyun.openservices.log.http.client.HttpMethod;
import com.aliyun.openservices.log.http.client.ServiceException;
import com.aliyun.openservices.log.http.comm.DefaultServiceClient;
import com.aliyun.openservices.log.http.comm.RequestMessage;
import com.aliyun.openservices.log.http.comm.ResponseMessage;
import com.aliyun.openservices.log.http.comm.ServiceClient;
import com.aliyun.openservices.log.http.comm.TimeoutServiceClient;
import com.aliyun.openservices.log.http.signer.SignVersion;
import com.aliyun.openservices.log.http.signer.SlsSigner;
import com.aliyun.openservices.log.http.signer.SlsSignerBase;
import com.aliyun.openservices.log.http.utils.CodingUtils;
import com.aliyun.openservices.log.request.ApplyConfigToMachineGroupRequest;
import com.aliyun.openservices.log.request.ApproveMachineGroupRequest;
import com.aliyun.openservices.log.request.BasicRequest;
import com.aliyun.openservices.log.request.BatchGetLogRequest;
import com.aliyun.openservices.log.request.BatchPutLogsRequest;
import com.aliyun.openservices.log.request.ClearLogStoreStorageRequest;
import com.aliyun.openservices.log.request.ConsumerGroupGetCheckPointRequest;
import com.aliyun.openservices.log.request.ConsumerGroupHeartBeatRequest;
import com.aliyun.openservices.log.request.ConsumerGroupUpdateCheckPointRequest;
import com.aliyun.openservices.log.request.CreateAlertRequest;
import com.aliyun.openservices.log.request.CreateAuditJobRequest;
import com.aliyun.openservices.log.request.CreateChartRequest;
import com.aliyun.openservices.log.request.CreateConfigRequest;
import com.aliyun.openservices.log.request.CreateConsumerGroupRequest;
import com.aliyun.openservices.log.request.CreateDashboardRequest;
import com.aliyun.openservices.log.request.CreateDomainRequest;
import com.aliyun.openservices.log.request.CreateETLV2Request;
import com.aliyun.openservices.log.request.CreateEtlJobRequest;
import com.aliyun.openservices.log.request.CreateExportRequest;
import com.aliyun.openservices.log.request.CreateExternalStoreRequest;
import com.aliyun.openservices.log.request.CreateIndexRequest;
import com.aliyun.openservices.log.request.CreateIngestionRequest;
import com.aliyun.openservices.log.request.CreateJobRequest;
import com.aliyun.openservices.log.request.CreateLinkStoreRequest;
import com.aliyun.openservices.log.request.CreateLogStoreRequest;
import com.aliyun.openservices.log.request.CreateLoggingRequest;
import com.aliyun.openservices.log.request.CreateMachineGroupRequest;
import com.aliyun.openservices.log.request.CreateMetricsConfigRequest;
import com.aliyun.openservices.log.request.CreateOrUpdateSqlInstanceRequest;
import com.aliyun.openservices.log.request.CreateProjectConsumerGroupRequest;
import com.aliyun.openservices.log.request.CreateProjectRequest;
import com.aliyun.openservices.log.request.CreateRebuildIndexRequest;
import com.aliyun.openservices.log.request.CreateReportRequest;
import com.aliyun.openservices.log.request.CreateResourceRecordRequest;
import com.aliyun.openservices.log.request.CreateResourceRequest;
import com.aliyun.openservices.log.request.CreateSavedSearchRequest;
import com.aliyun.openservices.log.request.CreateScheduledSQLRequest;
import com.aliyun.openservices.log.request.CreateShipperMigrationRequest;
import com.aliyun.openservices.log.request.CreateSubStoreRequest;
import com.aliyun.openservices.log.request.CreateTopostoreNodeRequest;
import com.aliyun.openservices.log.request.CreateTopostoreRelationRequest;
import com.aliyun.openservices.log.request.CreateTopostoreRequest;
import com.aliyun.openservices.log.request.DeleteAlertRequest;
import com.aliyun.openservices.log.request.DeleteAuditJobRequest;
import com.aliyun.openservices.log.request.DeleteChartRequest;
import com.aliyun.openservices.log.request.DeleteConfigRequest;
import com.aliyun.openservices.log.request.DeleteDashboardRequest;
import com.aliyun.openservices.log.request.DeleteDomainRequest;
import com.aliyun.openservices.log.request.DeleteETLV2Request;
import com.aliyun.openservices.log.request.DeleteEtlJobRequest;
import com.aliyun.openservices.log.request.DeleteExportRequest;
import com.aliyun.openservices.log.request.DeleteExternalStoreRequest;
import com.aliyun.openservices.log.request.DeleteIndexRequest;
import com.aliyun.openservices.log.request.DeleteIngestionRequest;
import com.aliyun.openservices.log.request.DeleteJobRequest;
import com.aliyun.openservices.log.request.DeleteLinkStoreRequest;
import com.aliyun.openservices.log.request.DeleteLogStoreRequest;
import com.aliyun.openservices.log.request.DeleteLoggingRequest;
import com.aliyun.openservices.log.request.DeleteMachineGroupRequest;
import com.aliyun.openservices.log.request.DeleteMetricsConfigRequest;
import com.aliyun.openservices.log.request.DeleteRebuildIndexRequest;
import com.aliyun.openservices.log.request.DeleteReportRequest;
import com.aliyun.openservices.log.request.DeleteResourceRecordRequest;
import com.aliyun.openservices.log.request.DeleteResourceRequest;
import com.aliyun.openservices.log.request.DeleteSavedSearchRequest;
import com.aliyun.openservices.log.request.DeleteScheduledSQLRequest;
import com.aliyun.openservices.log.request.DeleteSubStoreRequest;
import com.aliyun.openservices.log.request.DeleteTopostoreNodeRequest;
import com.aliyun.openservices.log.request.DeleteTopostoreRelationRequest;
import com.aliyun.openservices.log.request.DeleteTopostoreRequest;
import com.aliyun.openservices.log.request.DisableAlertRequest;
import com.aliyun.openservices.log.request.DisableJobRequest;
import com.aliyun.openservices.log.request.DisableReportRequest;
import com.aliyun.openservices.log.request.EnableAlertRequest;
import com.aliyun.openservices.log.request.EnableJobRequest;
import com.aliyun.openservices.log.request.EnableReportRequest;
import com.aliyun.openservices.log.request.GetAlertRequest;
import com.aliyun.openservices.log.request.GetAppliedConfigsRequest;
import com.aliyun.openservices.log.request.GetAppliedMachineGroupRequest;
import com.aliyun.openservices.log.request.GetAuditJobRequest;
import com.aliyun.openservices.log.request.GetChartRequest;
import com.aliyun.openservices.log.request.GetConfigRequest;
import com.aliyun.openservices.log.request.GetContextLogsRequest;
import com.aliyun.openservices.log.request.GetCursorRequest;
import com.aliyun.openservices.log.request.GetCursorTimeRequest;
import com.aliyun.openservices.log.request.GetDashboardRequest;
import com.aliyun.openservices.log.request.GetETLV2Request;
import com.aliyun.openservices.log.request.GetEtlJobRequest;
import com.aliyun.openservices.log.request.GetExportRequest;
import com.aliyun.openservices.log.request.GetExternalStoreRequest;
import com.aliyun.openservices.log.request.GetHistogramsRequest;
import com.aliyun.openservices.log.request.GetIndexRequest;
import com.aliyun.openservices.log.request.GetIngestionRequest;
import com.aliyun.openservices.log.request.GetJobInstanceRequest;
import com.aliyun.openservices.log.request.GetJobRequest;
import com.aliyun.openservices.log.request.GetLogStoreMeteringModeRequest;
import com.aliyun.openservices.log.request.GetLogStoreRequest;
import com.aliyun.openservices.log.request.GetLoggingRequest;
import com.aliyun.openservices.log.request.GetLogsRequest;
import com.aliyun.openservices.log.request.GetLogsRequestV2;
import com.aliyun.openservices.log.request.GetLogstoreReplicationRequest;
import com.aliyun.openservices.log.request.GetLogtailProfileRequest;
import com.aliyun.openservices.log.request.GetMachineGroupRequest;
import com.aliyun.openservices.log.request.GetMetricsConfigRequest;
import com.aliyun.openservices.log.request.GetProjectLogsRequest;
import com.aliyun.openservices.log.request.GetRebuildIndexRequest;
import com.aliyun.openservices.log.request.GetReportRequest;
import com.aliyun.openservices.log.request.GetResourceRecordRequest;
import com.aliyun.openservices.log.request.GetResourceRequest;
import com.aliyun.openservices.log.request.GetSavedSearchRequest;
import com.aliyun.openservices.log.request.GetScheduledSQLRequest;
import com.aliyun.openservices.log.request.GetShipperMigrationRequest;
import com.aliyun.openservices.log.request.GetSubStoreRequest;
import com.aliyun.openservices.log.request.GetSubStoreTTLResquest;
import com.aliyun.openservices.log.request.GetTopostoreNodeRequest;
import com.aliyun.openservices.log.request.GetTopostoreRelationRequest;
import com.aliyun.openservices.log.request.GetTopostoreRequest;
import com.aliyun.openservices.log.request.ListAlertRequest;
import com.aliyun.openservices.log.request.ListAuditJobRequest;
import com.aliyun.openservices.log.request.ListConfigRequest;
import com.aliyun.openservices.log.request.ListDashboardRequest;
import com.aliyun.openservices.log.request.ListDomainsRequest;
import com.aliyun.openservices.log.request.ListETLV2Request;
import com.aliyun.openservices.log.request.ListEtlJobRequest;
import com.aliyun.openservices.log.request.ListEtlMetaRequest;
import com.aliyun.openservices.log.request.ListExportRequest;
import com.aliyun.openservices.log.request.ListExternalStoresRequest;
import com.aliyun.openservices.log.request.ListIngestionRequest;
import com.aliyun.openservices.log.request.ListJobInstancesRequest;
import com.aliyun.openservices.log.request.ListJobsRequest;
import com.aliyun.openservices.log.request.ListLogStoresRequest;
import com.aliyun.openservices.log.request.ListMachineGroupRequest;
import com.aliyun.openservices.log.request.ListMetricsConfigRequest;
import com.aliyun.openservices.log.request.ListProjectRequest;
import com.aliyun.openservices.log.request.ListRebuildIndexRequest;
import com.aliyun.openservices.log.request.ListReportRequest;
import com.aliyun.openservices.log.request.ListResourceRecordRequest;
import com.aliyun.openservices.log.request.ListResourceRequest;
import com.aliyun.openservices.log.request.ListSavedSearchRequest;
import com.aliyun.openservices.log.request.ListScheduledSQLRequest;
import com.aliyun.openservices.log.request.ListShardRequest;
import com.aliyun.openservices.log.request.ListShipperMigrationRequest;
import com.aliyun.openservices.log.request.ListSqlInstanceRequest;
import com.aliyun.openservices.log.request.ListSubStoreRequest;
import com.aliyun.openservices.log.request.ListSystemTagResourcesRequest;
import com.aliyun.openservices.log.request.ListTagResourcesRequest;
import com.aliyun.openservices.log.request.ListTopostoreNodeRelationRequest;
import com.aliyun.openservices.log.request.ListTopostoreNodeRelationResponse;
import com.aliyun.openservices.log.request.ListTopostoreNodeRequest;
import com.aliyun.openservices.log.request.ListTopostoreRelationRequest;
import com.aliyun.openservices.log.request.ListTopostoreRequest;
import com.aliyun.openservices.log.request.MergeShardsRequest;
import com.aliyun.openservices.log.request.ModifyJobInstanceStateRequest;
import com.aliyun.openservices.log.request.ProjectConsumerGroupGetCheckPointRequest;
import com.aliyun.openservices.log.request.ProjectConsumerGroupHeartBeatRequest;
import com.aliyun.openservices.log.request.ProjectConsumerGroupUpdateCheckPointRequest;
import com.aliyun.openservices.log.request.PullLogsRequest;
import com.aliyun.openservices.log.request.PutLogsRequest;
import com.aliyun.openservices.log.request.ReStartETLV2Request;
import com.aliyun.openservices.log.request.RemoveConfigFromMachineGroupRequest;
import com.aliyun.openservices.log.request.RestartExportRequest;
import com.aliyun.openservices.log.request.RestartIngestionRequest;
import com.aliyun.openservices.log.request.SetLogstoreReplicationRequest;
import com.aliyun.openservices.log.request.SetProjectCnameRequest;
import com.aliyun.openservices.log.request.SplitShardRequest;
import com.aliyun.openservices.log.request.StartAuditJobRequest;
import com.aliyun.openservices.log.request.StartETLV2Request;
import com.aliyun.openservices.log.request.StartExportRequest;
import com.aliyun.openservices.log.request.StartIngestionRequest;
import com.aliyun.openservices.log.request.StopAuditJobRequest;
import com.aliyun.openservices.log.request.StopETLV2Request;
import com.aliyun.openservices.log.request.StopExportRequest;
import com.aliyun.openservices.log.request.StopIngestionRequest;
import com.aliyun.openservices.log.request.StopRebuildIndexRequest;
import com.aliyun.openservices.log.request.TagResourcesRequest;
import com.aliyun.openservices.log.request.TagResourcesSystemTagsRequest;
import com.aliyun.openservices.log.request.UntagResourcesRequest;
import com.aliyun.openservices.log.request.UntagResourcesSystemTagsRequest;
import com.aliyun.openservices.log.request.UpdateAlertRequest;
import com.aliyun.openservices.log.request.UpdateAuditJobRequest;
import com.aliyun.openservices.log.request.UpdateChartRequest;
import com.aliyun.openservices.log.request.UpdateConfigRequest;
import com.aliyun.openservices.log.request.UpdateDashboardRequest;
import com.aliyun.openservices.log.request.UpdateETLV2Request;
import com.aliyun.openservices.log.request.UpdateEtlJobRequest;
import com.aliyun.openservices.log.request.UpdateExportRequest;
import com.aliyun.openservices.log.request.UpdateExternalStoreRequest;
import com.aliyun.openservices.log.request.UpdateIndexRequest;
import com.aliyun.openservices.log.request.UpdateIngestionRequest;
import com.aliyun.openservices.log.request.UpdateJobRequest;
import com.aliyun.openservices.log.request.UpdateLogStoreMeteringModeRequest;
import com.aliyun.openservices.log.request.UpdateLogStoreRequest;
import com.aliyun.openservices.log.request.UpdateLoggingRequest;
import com.aliyun.openservices.log.request.UpdateMachineGroupMachineRequest;
import com.aliyun.openservices.log.request.UpdateMachineGroupRequest;
import com.aliyun.openservices.log.request.UpdateMetricsConfigRequest;
import com.aliyun.openservices.log.request.UpdateProjectRequest;
import com.aliyun.openservices.log.request.UpdateReportRequest;
import com.aliyun.openservices.log.request.UpdateResourceRecordRequest;
import com.aliyun.openservices.log.request.UpdateResourceRequest;
import com.aliyun.openservices.log.request.UpdateSavedSearchRequest;
import com.aliyun.openservices.log.request.UpdateScheduledSQLRequest;
import com.aliyun.openservices.log.request.UpdateSubStoreRequest;
import com.aliyun.openservices.log.request.UpdateSubStoreTTLRequest;
import com.aliyun.openservices.log.request.UpdateTopostoreNodeRequest;
import com.aliyun.openservices.log.request.UpdateTopostoreRelationRequest;
import com.aliyun.openservices.log.request.UpdateTopostoreRequest;
import com.aliyun.openservices.log.request.UpsertResourceRecordRequest;
import com.aliyun.openservices.log.request.UpsertTopostoreNodeRequest;
import com.aliyun.openservices.log.request.UpsertTopostoreRelationRequest;
import com.aliyun.openservices.log.response.ApplyConfigToMachineGroupResponse;
import com.aliyun.openservices.log.response.ApproveMachineGroupResponse;
import com.aliyun.openservices.log.response.BatchGetLogResponse;
import com.aliyun.openservices.log.response.BatchModifyEtlMetaStatusResponse;
import com.aliyun.openservices.log.response.BatchPutLogsResponse;
import com.aliyun.openservices.log.response.ChangeResourceGroupResponse;
import com.aliyun.openservices.log.response.ClearLogStoreStorageResponse;
import com.aliyun.openservices.log.response.ConsumerGroupCheckPointResponse;
import com.aliyun.openservices.log.response.ConsumerGroupHeartBeatResponse;
import com.aliyun.openservices.log.response.ConsumerGroupUpdateCheckPointResponse;
import com.aliyun.openservices.log.response.CreateAlertResponse;
import com.aliyun.openservices.log.response.CreateAuditJobResponse;
import com.aliyun.openservices.log.response.CreateChartResponse;
import com.aliyun.openservices.log.response.CreateConfigResponse;
import com.aliyun.openservices.log.response.CreateConsumerGroupResponse;
import com.aliyun.openservices.log.response.CreateDashboardResponse;
import com.aliyun.openservices.log.response.CreateDomainResponse;
import com.aliyun.openservices.log.response.CreateETLV2Response;
import com.aliyun.openservices.log.response.CreateEtlJobResponse;
import com.aliyun.openservices.log.response.CreateEtlMetaResponse;
import com.aliyun.openservices.log.response.CreateExportResponse;
import com.aliyun.openservices.log.response.CreateExternalStoreResponse;
import com.aliyun.openservices.log.response.CreateIndexResponse;
import com.aliyun.openservices.log.response.CreateIngestionResponse;
import com.aliyun.openservices.log.response.CreateJobResponse;
import com.aliyun.openservices.log.response.CreateLinkStoreResponse;
import com.aliyun.openservices.log.response.CreateLogStoreInternalResponse;
import com.aliyun.openservices.log.response.CreateLogStoreResponse;
import com.aliyun.openservices.log.response.CreateLoggingResponse;
import com.aliyun.openservices.log.response.CreateMachineGroupResponse;
import com.aliyun.openservices.log.response.CreateMetricsConfigResponse;
import com.aliyun.openservices.log.response.CreateOrUpdateSqlInstanceResponse;
import com.aliyun.openservices.log.response.CreateProjectConsumerGroupResponse;
import com.aliyun.openservices.log.response.CreateProjectResponse;
import com.aliyun.openservices.log.response.CreateRebuildIndexResponse;
import com.aliyun.openservices.log.response.CreateReportResponse;
import com.aliyun.openservices.log.response.CreateResourceRecordResponse;
import com.aliyun.openservices.log.response.CreateResourceResponse;
import com.aliyun.openservices.log.response.CreateSavedSearchResponse;
import com.aliyun.openservices.log.response.CreateScheduledSQLResponse;
import com.aliyun.openservices.log.response.CreateShipperMigrationResponse;
import com.aliyun.openservices.log.response.CreateShipperResponse;
import com.aliyun.openservices.log.response.CreateSubStoreResponse;
import com.aliyun.openservices.log.response.CreateTopostoreNodeResponse;
import com.aliyun.openservices.log.response.CreateTopostoreRelationResponse;
import com.aliyun.openservices.log.response.CreateTopostoreResponse;
import com.aliyun.openservices.log.response.DeleteAlertResponse;
import com.aliyun.openservices.log.response.DeleteAuditJobResponse;
import com.aliyun.openservices.log.response.DeleteChartResponse;
import com.aliyun.openservices.log.response.DeleteConfigResponse;
import com.aliyun.openservices.log.response.DeleteConsumerGroupResponse;
import com.aliyun.openservices.log.response.DeleteDashboardResponse;
import com.aliyun.openservices.log.response.DeleteDomainResponse;
import com.aliyun.openservices.log.response.DeleteETLV2Response;
import com.aliyun.openservices.log.response.DeleteEtlJobResponse;
import com.aliyun.openservices.log.response.DeleteEtlMetaResponse;
import com.aliyun.openservices.log.response.DeleteExportResponse;
import com.aliyun.openservices.log.response.DeleteExternalStoreResponse;
import com.aliyun.openservices.log.response.DeleteIndexResponse;
import com.aliyun.openservices.log.response.DeleteIngestionResponse;
import com.aliyun.openservices.log.response.DeleteJobResponse;
import com.aliyun.openservices.log.response.DeleteLinkStoreResponse;
import com.aliyun.openservices.log.response.DeleteLogStoreResponse;
import com.aliyun.openservices.log.response.DeleteLoggingResponse;
import com.aliyun.openservices.log.response.DeleteMachineGroupResponse;
import com.aliyun.openservices.log.response.DeleteMetricsConfigResponse;
import com.aliyun.openservices.log.response.DeleteProjectConsumerGroupResponse;
import com.aliyun.openservices.log.response.DeleteProjectPolicyReponse;
import com.aliyun.openservices.log.response.DeleteProjectResponse;
import com.aliyun.openservices.log.response.DeleteRebuildIndexResponse;
import com.aliyun.openservices.log.response.DeleteReportResponse;
import com.aliyun.openservices.log.response.DeleteResourceRecordResponse;
import com.aliyun.openservices.log.response.DeleteResourceResponse;
import com.aliyun.openservices.log.response.DeleteSavedSearchResponse;
import com.aliyun.openservices.log.response.DeleteScheduledSQLResponse;
import com.aliyun.openservices.log.response.DeleteShipperResponse;
import com.aliyun.openservices.log.response.DeleteSubStoreResponse;
import com.aliyun.openservices.log.response.DeleteTopostoreNodeResponse;
import com.aliyun.openservices.log.response.DeleteTopostoreRelationResponse;
import com.aliyun.openservices.log.response.DeleteTopostoreResponse;
import com.aliyun.openservices.log.response.DisableAlertResponse;
import com.aliyun.openservices.log.response.DisableJobResponse;
import com.aliyun.openservices.log.response.DisableReportResponse;
import com.aliyun.openservices.log.response.EnableAlertResponse;
import com.aliyun.openservices.log.response.EnableJobResponse;
import com.aliyun.openservices.log.response.EnableReportResponse;
import com.aliyun.openservices.log.response.GetAlertResponse;
import com.aliyun.openservices.log.response.GetAppliedConfigResponse;
import com.aliyun.openservices.log.response.GetAppliedMachineGroupsResponse;
import com.aliyun.openservices.log.response.GetAuditJobResponse;
import com.aliyun.openservices.log.response.GetChartResponse;
import com.aliyun.openservices.log.response.GetCheckPointResponse;
import com.aliyun.openservices.log.response.GetConfigResponse;
import com.aliyun.openservices.log.response.GetContextLogsResponse;
import com.aliyun.openservices.log.response.GetCursorResponse;
import com.aliyun.openservices.log.response.GetCursorTimeResponse;
import com.aliyun.openservices.log.response.GetDashboardResponse;
import com.aliyun.openservices.log.response.GetETLV2Response;
import com.aliyun.openservices.log.response.GetEtlJobResponse;
import com.aliyun.openservices.log.response.GetExportResponse;
import com.aliyun.openservices.log.response.GetExternalStoreResponse;
import com.aliyun.openservices.log.response.GetHistogramsResponse;
import com.aliyun.openservices.log.response.GetIndexResponse;
import com.aliyun.openservices.log.response.GetIndexStringResponse;
import com.aliyun.openservices.log.response.GetIngestionResponse;
import com.aliyun.openservices.log.response.GetJobInstanceResponse;
import com.aliyun.openservices.log.response.GetJobResponse;
import com.aliyun.openservices.log.response.GetLogStoreMeteringModeResponse;
import com.aliyun.openservices.log.response.GetLogStoreResponse;
import com.aliyun.openservices.log.response.GetLoggingResponse;
import com.aliyun.openservices.log.response.GetLogsResponse;
import com.aliyun.openservices.log.response.GetLogsResponseV2;
import com.aliyun.openservices.log.response.GetLogstoreReplicationResponse;
import com.aliyun.openservices.log.response.GetLogtailProfileResponse;
import com.aliyun.openservices.log.response.GetMachineGroupResponse;
import com.aliyun.openservices.log.response.GetMetricsConfigResponse;
import com.aliyun.openservices.log.response.GetProjectPolicyReponse;
import com.aliyun.openservices.log.response.GetProjectResponse;
import com.aliyun.openservices.log.response.GetRebuildIndexResponse;
import com.aliyun.openservices.log.response.GetReportResponse;
import com.aliyun.openservices.log.response.GetResourceRecordResponse;
import com.aliyun.openservices.log.response.GetResourceResponse;
import com.aliyun.openservices.log.response.GetSavedSearchResponse;
import com.aliyun.openservices.log.response.GetScheduledSQLResponse;
import com.aliyun.openservices.log.response.GetShipperMigrationResponse;
import com.aliyun.openservices.log.response.GetShipperResponse;
import com.aliyun.openservices.log.response.GetShipperTasksResponse;
import com.aliyun.openservices.log.response.GetSubStoreResponse;
import com.aliyun.openservices.log.response.GetSubStoreTTLResponse;
import com.aliyun.openservices.log.response.GetTopostoreNodeResponse;
import com.aliyun.openservices.log.response.GetTopostoreRelationResponse;
import com.aliyun.openservices.log.response.GetTopostoreResponse;
import com.aliyun.openservices.log.response.ListAlertResponse;
import com.aliyun.openservices.log.response.ListAuditJobResponse;
import com.aliyun.openservices.log.response.ListConfigResponse;
import com.aliyun.openservices.log.response.ListConsumerGroupResponse;
import com.aliyun.openservices.log.response.ListDashboardResponse;
import com.aliyun.openservices.log.response.ListDomainsResponse;
import com.aliyun.openservices.log.response.ListETLV2Response;
import com.aliyun.openservices.log.response.ListEtlJobResponse;
import com.aliyun.openservices.log.response.ListEtlMetaNameResponse;
import com.aliyun.openservices.log.response.ListEtlMetaResponse;
import com.aliyun.openservices.log.response.ListExportResponse;
import com.aliyun.openservices.log.response.ListExternalStroesResponse;
import com.aliyun.openservices.log.response.ListIngestionResponse;
import com.aliyun.openservices.log.response.ListJobInstancesResponse;
import com.aliyun.openservices.log.response.ListJobsResponse;
import com.aliyun.openservices.log.response.ListLogStoresResponse;
import com.aliyun.openservices.log.response.ListMachineGroupResponse;
import com.aliyun.openservices.log.response.ListMachinesResponse;
import com.aliyun.openservices.log.response.ListMetricsConfigResponse;
import com.aliyun.openservices.log.response.ListProjectCnameResponse;
import com.aliyun.openservices.log.response.ListProjectConsumerGroupResponse;
import com.aliyun.openservices.log.response.ListProjectResponse;
import com.aliyun.openservices.log.response.ListRebuildIndexResponse;
import com.aliyun.openservices.log.response.ListReportResponse;
import com.aliyun.openservices.log.response.ListResourceRecordResponse;
import com.aliyun.openservices.log.response.ListResourceResponse;
import com.aliyun.openservices.log.response.ListSavedSearchResponse;
import com.aliyun.openservices.log.response.ListScheduledSQLResponse;
import com.aliyun.openservices.log.response.ListShardResponse;
import com.aliyun.openservices.log.response.ListShipperMigrationResponse;
import com.aliyun.openservices.log.response.ListShipperResponse;
import com.aliyun.openservices.log.response.ListSqlInstanceResponse;
import com.aliyun.openservices.log.response.ListSubStoreResponse;
import com.aliyun.openservices.log.response.ListTagResourcesResponse;
import com.aliyun.openservices.log.response.ListTopostoreNodeResponse;
import com.aliyun.openservices.log.response.ListTopostoreRelationResponse;
import com.aliyun.openservices.log.response.ListTopostoreResponse;
import com.aliyun.openservices.log.response.ModifyJobInstanceStateResponse;
import com.aliyun.openservices.log.response.ProjectConsumerGroupCheckPointResponse;
import com.aliyun.openservices.log.response.ProjectConsumerGroupHeartBeatResponse;
import com.aliyun.openservices.log.response.ProjectConsumerGroupUpdateCheckPointResponse;
import com.aliyun.openservices.log.response.PullLogsResponse;
import com.aliyun.openservices.log.response.PutLogsResponse;
import com.aliyun.openservices.log.response.ReStartETLV2Response;
import com.aliyun.openservices.log.response.RemoveConfigFromMachineGroupResponse;
import com.aliyun.openservices.log.response.RestartExportResponse;
import com.aliyun.openservices.log.response.RetryShipperTasksResponse;
import com.aliyun.openservices.log.response.SetLogstoreReplicationResponse;
import com.aliyun.openservices.log.response.SetProjectCnameResponse;
import com.aliyun.openservices.log.response.SetProjectPolicyResponse;
import com.aliyun.openservices.log.response.StartAuditJobResponse;
import com.aliyun.openservices.log.response.StartETLV2Response;
import com.aliyun.openservices.log.response.StartExportResponse;
import com.aliyun.openservices.log.response.StartIngestionResponse;
import com.aliyun.openservices.log.response.StopAuditJobResponse;
import com.aliyun.openservices.log.response.StopETLV2Response;
import com.aliyun.openservices.log.response.StopExportResponse;
import com.aliyun.openservices.log.response.StopIngestionResponse;
import com.aliyun.openservices.log.response.StopRebuildIndexResponse;
import com.aliyun.openservices.log.response.TagResourcesResponse;
import com.aliyun.openservices.log.response.UntagResourcesResponse;
import com.aliyun.openservices.log.response.UpdateAlertResponse;
import com.aliyun.openservices.log.response.UpdateAuditJobResponse;
import com.aliyun.openservices.log.response.UpdateChartResponse;
import com.aliyun.openservices.log.response.UpdateConfigResponse;
import com.aliyun.openservices.log.response.UpdateConsumerGroupResponse;
import com.aliyun.openservices.log.response.UpdateDashboardResponse;
import com.aliyun.openservices.log.response.UpdateETLV2Response;
import com.aliyun.openservices.log.response.UpdateEtlJobResponse;
import com.aliyun.openservices.log.response.UpdateEtlMetaResponse;
import com.aliyun.openservices.log.response.UpdateExportResponse;
import com.aliyun.openservices.log.response.UpdateExternalStoreResponse;
import com.aliyun.openservices.log.response.UpdateIndexResponse;
import com.aliyun.openservices.log.response.UpdateIngestionResponse;
import com.aliyun.openservices.log.response.UpdateJobResponse;
import com.aliyun.openservices.log.response.UpdateLogStoreInternalResponse;
import com.aliyun.openservices.log.response.UpdateLogStoreResponse;
import com.aliyun.openservices.log.response.UpdateLoggingResponse;
import com.aliyun.openservices.log.response.UpdateMachineGroupMachineResponse;
import com.aliyun.openservices.log.response.UpdateMachineGroupResponse;
import com.aliyun.openservices.log.response.UpdateMetricsConfigResponse;
import com.aliyun.openservices.log.response.UpdateProjectConsumerGroupResponse;
import com.aliyun.openservices.log.response.UpdateProjectResponse;
import com.aliyun.openservices.log.response.UpdateReportResponse;
import com.aliyun.openservices.log.response.UpdateResourceRecordResponse;
import com.aliyun.openservices.log.response.UpdateResourceResponse;
import com.aliyun.openservices.log.response.UpdateSavedSearchResponse;
import com.aliyun.openservices.log.response.UpdateScheduledSQLResponse;
import com.aliyun.openservices.log.response.UpdateShipperResponse;
import com.aliyun.openservices.log.response.UpdateSubStoreResponse;
import com.aliyun.openservices.log.response.UpdateSubStoreTTLResponse;
import com.aliyun.openservices.log.response.UpdateTopostoreNodeResponse;
import com.aliyun.openservices.log.response.UpdateTopostoreRelationResponse;
import com.aliyun.openservices.log.response.UpdateTopostoreResponse;
import com.aliyun.openservices.log.response.UpsertResourceRecordResponse;
import com.aliyun.openservices.log.response.UpsertTopostoreNodeResponse;
import com.aliyun.openservices.log.response.UpsertTopostoreRelationResponse;
import com.aliyun.openservices.log.response.VoidResponse;
import com.aliyun.openservices.log.util.Args;
import com.aliyun.openservices.log.util.JsonUtils;
import com.aliyun.openservices.log.util.NetworkUtils;
import com.aliyun.openservices.log.util.Utils;
import com.aliyun.openservices.log.util.VersionInfoUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.conn.HttpClientConnectionManager;

public class Client
implements LogService {
    private static final String DEFAULT_USER_AGENT = VersionInfoUtils.getDefaultUserAgent();
    private String httpType;
    private String hostName;
    private CredentialsProvider credentialsProvider;
    private String sourceIp;
    private ServiceClient serviceClient;
    private String realIpForConsole;
    private Boolean useSSLForConsole;
    private String userAgent = DEFAULT_USER_AGENT;
    private boolean mUUIDTag = false;
    private boolean useDirectMode = false;
    private String realServerIP = null;
    private String resourceOwnerAccount = null;
    private SlsSigner signer;

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public String getRealIpForConsole() {
        return this.realIpForConsole;
    }

    public void setRealIpForConsole(String realIpForConsole) {
        this.realIpForConsole = realIpForConsole;
    }

    public boolean isUseSSLForConsole() {
        return this.useSSLForConsole;
    }

    public void setUseSSLForConsole(boolean useSSLForConsole) {
        this.useSSLForConsole = useSSLForConsole;
    }

    public void ClearConsoleResources() {
        this.realIpForConsole = null;
        this.useSSLForConsole = null;
    }

    public void EnableUUIDTag() {
        this.mUUIDTag = true;
    }

    public void DisableUUIDTag() {
        this.mUUIDTag = false;
    }

    @Deprecated
    public void EnableDirectMode() {
        this.setUseDirectMode(true);
    }

    @Deprecated
    public void DisableDirectMode() {
        this.setUseDirectMode(false);
    }

    public void setUseDirectMode(boolean useDirectMode) {
        this.useDirectMode = useDirectMode;
    }

    public boolean isUseDirectMode() {
        return this.useDirectMode;
    }

    public String getResourceOwnerAccount() {
        return this.resourceOwnerAccount;
    }

    public void setResourceOwnerAccount(String resourceOwnerAccount) {
        this.resourceOwnerAccount = resourceOwnerAccount;
    }

    public HttpClientConnectionManager getConnectionManager() {
        return this.serviceClient.getConnectionManager();
    }

    public Client(String endpoint, String accessId, String accessKey) {
        this(endpoint, new DefaultCredentials(accessId, accessKey), null);
    }

    public Client(String endpoint, String accessId, String accessKey, ClientConfiguration configuration) {
        this(endpoint, accessId, accessKey, null, configuration);
    }

    public Client(String endpoint, String roleName) {
        this(endpoint, new ECSRoleCredentialsProvider(roleName), null);
    }

    public Client(String endpoint, String accessId, String accessKey, String sourceIp) {
        this(endpoint, new DefaultCredentials(accessId, accessKey), sourceIp);
    }

    public Client(String endpoint, Credentials credentials, String sourceIp) {
        ClientConfiguration clientConfig = Client.getDefaultClientConfiguration();
        this.serviceClient = Client.buildServiceClient(clientConfig);
        this.configure(endpoint, credentials, sourceIp);
    }

    public Client(String endpoint, CredentialsProvider credentialsProvider) {
        this(endpoint, credentialsProvider, "");
    }

    static ClientConfiguration getDefaultClientConfiguration() {
        ClientConfiguration clientConfig = new ClientConfiguration();
        clientConfig.setMaxConnections(Consts.HTTP_CONNECT_MAX_COUNT);
        clientConfig.setConnectionTimeout(Consts.HTTP_CONNECT_TIME_OUT);
        clientConfig.setSocketTimeout(Consts.HTTP_SEND_TIME_OUT);
        return clientConfig;
    }

    static ServiceClient buildServiceClient(ClientConfiguration clientConfig) {
        if (clientConfig.isRequestTimeoutEnabled()) {
            return new TimeoutServiceClient(clientConfig);
        }
        return new DefaultServiceClient(clientConfig);
    }

    public Client(String endpoint, CredentialsProvider credentialsProvider, String sourceIp) {
        this(endpoint, credentialsProvider, new DefaultServiceClient(Client.getDefaultClientConfiguration()), sourceIp);
    }

    public Client(String endpoint, CredentialsProvider credentialsProvider, ServiceClient serviceClient, String sourceIp) {
        this.serviceClient = serviceClient;
        this.configure(endpoint, credentialsProvider, sourceIp);
    }

    @Deprecated
    public Client(String endpoint, String accessId, String accessKey, String sourceIp, int connectMaxCount, int connectTimeout, int sendTimeout) {
        ClientConfiguration clientConfig = new ClientConfiguration();
        clientConfig.setMaxConnections(connectMaxCount);
        clientConfig.setConnectionTimeout(connectTimeout);
        clientConfig.setSocketTimeout(sendTimeout);
        this.serviceClient = Client.buildServiceClient(clientConfig);
        this.configure(endpoint, new DefaultCredentials(accessId, accessKey), sourceIp);
    }

    public Client(String endpoint, String accessId, String accessKey, ServiceClient serviceClient) {
        this.serviceClient = serviceClient;
        this.configure(endpoint, new DefaultCredentials(accessId, accessKey), null);
    }

    public synchronized void setEndpoint(String endpoint) {
        Args.notNullOrEmpty(endpoint, "endpoint");
        endpoint = endpoint.trim();
        if (endpoint.startsWith("http://")) {
            this.hostName = endpoint.substring(7);
            this.httpType = "http://";
        } else if (endpoint.startsWith("https://")) {
            this.hostName = endpoint.substring(8);
            this.httpType = "https://";
        } else {
            this.hostName = endpoint;
            this.httpType = "http://";
        }
        this.hostName = Utils.normalizeHostName(this.hostName);
        if (this.hostName == null) {
            throw new IllegalArgumentException("Invalid endpoint: " + endpoint);
        }
        if (NetworkUtils.isIPAddr(this.hostName)) {
            throw new IllegalArgumentException("The ip address is not supported");
        }
        if (this.getClientConfiguration().getRegion() == null) {
            this.setSignV4IfInAcdr(endpoint);
        }
    }

    private void configure(String endpoint, Credentials credentials, String sourceIp) {
        this.configure(endpoint, new StaticCredentialsProvider(credentials), sourceIp);
    }

    private void configure(String endpoint, CredentialsProvider credentialsProvider, String sourceIp) {
        this.setEndpoint(endpoint);
        this.sourceIp = sourceIp;
        if (sourceIp == null || sourceIp.isEmpty()) {
            this.sourceIp = NetworkUtils.getLocalMachineIP();
        }
        this.credentialsProvider = credentialsProvider;
        this.updateSigner(credentialsProvider);
    }

    public Client(String endpoint, CredentialsProvider credentialsProvider, ClientConfiguration config, String sourceIp) {
        Args.notNull(config, "Config");
        this.serviceClient = Client.buildServiceClient(config);
        this.configure(endpoint, credentialsProvider, sourceIp);
    }

    @Deprecated
    public Client(String endpoint, String accessId, String accessKey, String sourceIp, ClientConfiguration config) {
        this(endpoint, (CredentialsProvider)new StaticCredentialsProvider(new DefaultCredentials(accessId, accessKey)), config, sourceIp);
    }

    public void setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
        this.updateSigner(credentialsProvider);
    }

    private void updateSigner(CredentialsProvider credentialsProvider) {
        ClientConfiguration clientConfiguration = this.serviceClient.getClientConfiguration();
        this.signer = SlsSignerBase.createRequestSigner(clientConfiguration, credentialsProvider);
    }

    private void ensureStaticCredentialProvider() {
        if (!(this.credentialsProvider instanceof StaticCredentialsProvider)) {
            throw new RuntimeException("can only set or get AccessId/AccessKey/SecurityToken on StaticCredentialProvider");
        }
    }

    public String getAccessId() {
        this.ensureStaticCredentialProvider();
        return this.credentialsProvider.getCredentials().getAccessKeyId();
    }

    public void setAccessId(String accessId) {
        this.ensureStaticCredentialProvider();
        StaticCredentialsProvider scp = (StaticCredentialsProvider)this.credentialsProvider;
        scp.setAccessKeyId(accessId);
    }

    public String getAccessKey() {
        this.ensureStaticCredentialProvider();
        return this.credentialsProvider.getCredentials().getAccessKeySecret();
    }

    public void setAccessKey(String accessKey) {
        this.ensureStaticCredentialProvider();
        StaticCredentialsProvider scp = (StaticCredentialsProvider)this.credentialsProvider;
        scp.setAccessKeySecret(accessKey);
    }

    public String getSecurityToken() {
        this.ensureStaticCredentialProvider();
        return this.credentialsProvider.getCredentials().getSecurityToken();
    }

    public void setSecurityToken(String securityToken) {
        this.ensureStaticCredentialProvider();
        StaticCredentialsProvider scp = (StaticCredentialsProvider)this.credentialsProvider;
        scp.setSecurityToken(securityToken);
    }

    public void shutdown() {
        this.serviceClient.shutdown();
    }

    public ClientConfiguration getClientConfiguration() {
        return this.serviceClient.getClientConfiguration();
    }

    URI GetHostURI(String project) {
        String endPointUrl = this.httpType + this.hostName;
        if (project != null && !project.isEmpty()) {
            if (!Utils.validateProject(project)) {
                throw new IllegalArgumentException("Invalid project: " + project);
            }
            endPointUrl = this.httpType + project + "." + this.hostName;
        }
        try {
            return new URI(endPointUrl);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid endpoint: " + endPointUrl, e);
        }
    }

    private URI GetHostURIByIp(String ip_addr) throws LogException {
        String endPointUrl = this.httpType + ip_addr;
        try {
            return new URI(endPointUrl);
        }
        catch (URISyntaxException e) {
            throw new LogException("EndpointInvalid", "Failed to get real server ip when direct mode in enabled", "");
        }
    }

    private static byte[] encodeToUtf8(String source) throws LogException {
        try {
            return source.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new LogException("EncodingException", e.getMessage(), "");
        }
    }

    private static String encodeResponseBodyToUtf8String(ResponseMessage response, String requestId) throws LogException {
        byte[] body = response.GetRawBody();
        if (body == null) {
            throw new LogException("BadResponse", "The response body is null", null, requestId);
        }
        try {
            return new String(body, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new LogException("BadResponse", "The response is not valid utf-8 string: ", e, requestId);
        }
    }

    public GetLogtailProfileResponse ExtractLogtailProfile(Map<String, String> resHeaders, JSONObject object) throws LogException {
        try {
            int count = object.getIntValue("count");
            int total = object.getIntValue("total");
            JSONArray array = object.getJSONArray("profile");
            ArrayList<LogtailProfile> logtailProfiles = new ArrayList<LogtailProfile>();
            if (array != null) {
                for (int i = 0; i < array.size(); ++i) {
                    JSONObject profileObj = array.getJSONObject(i);
                    if (profileObj == null) continue;
                    LogtailProfile logtailProfile = new LogtailProfile();
                    logtailProfile.FromJsonObject(profileObj);
                    logtailProfiles.add(logtailProfile);
                }
            }
            return new GetLogtailProfileResponse(resHeaders, count, total, logtailProfiles);
        }
        catch (LogException e) {
            throw new LogException(e.getErrorCode(), e.getMessage(), e.getCause(), this.GetRequestId(resHeaders));
        }
    }

    public TagResourcesResponse tagResources(String tagResourcesStr) throws LogException {
        CodingUtils.assertParameterNotNull(tagResourcesStr, "tagResourcesStr");
        Map<String, String> headParameter = this.GetCommonHeadPara("");
        byte[] body = Client.encodeToUtf8(tagResourcesStr);
        String resourceUri = "/tag";
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData("", HttpMethod.POST, resourceUri, urlParameter, headParameter, body);
        Map<String, String> resHeaders = response.getHeaders();
        return new TagResourcesResponse(resHeaders);
    }

    public TagResourcesResponse tagResources(TagResourcesRequest request) throws LogException {
        Args.notNull(request, "request");
        return this.tagResources(JsonUtils.serialize(request));
    }

    public UntagResourcesResponse untagResources(String untagResourcesStr) throws LogException {
        CodingUtils.assertParameterNotNull(untagResourcesStr, "tagResourcesStr");
        Map<String, String> headParameter = this.GetCommonHeadPara("");
        byte[] body = Client.encodeToUtf8(untagResourcesStr);
        String resourceUri = "/untag";
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData("", HttpMethod.POST, resourceUri, urlParameter, headParameter, body);
        Map<String, String> resHeaders = response.getHeaders();
        return new UntagResourcesResponse(resHeaders);
    }

    public UntagResourcesResponse untagResources(UntagResourcesRequest request) throws LogException {
        Args.notNull(request, "request");
        return this.untagResources(JsonUtils.serialize(request));
    }

    public TagResourcesResponse tagResourcesSystemTags(TagResourcesSystemTagsRequest request) throws LogException {
        Args.notNull(request, "request");
        Map<String, String> headParameter = this.GetCommonHeadPara("");
        String tagResourcesStr = JsonUtils.serialize(request);
        byte[] body = Client.encodeToUtf8(tagResourcesStr);
        String resourceUri = "/systemtag";
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData("", HttpMethod.POST, resourceUri, urlParameter, headParameter, body);
        Map<String, String> resHeaders = response.getHeaders();
        return new TagResourcesResponse(resHeaders);
    }

    public UntagResourcesResponse untagResourcesSystemTags(UntagResourcesSystemTagsRequest request) throws LogException {
        Args.notNull(request, "request");
        String untagResourcesStr = JsonUtils.serialize(request);
        Map<String, String> headParameter = this.GetCommonHeadPara("");
        byte[] body = Client.encodeToUtf8(untagResourcesStr);
        String resourceUri = "/systemuntag";
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData("", HttpMethod.POST, resourceUri, urlParameter, headParameter, body);
        Map<String, String> resHeaders = response.getHeaders();
        return new UntagResourcesResponse(resHeaders);
    }

    public ListTagResourcesResponse listSystemTagResources(ListSystemTagResourcesRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        Map<String, String> urlParameter = request.GetAllParams();
        Map<String, String> headParameter = this.GetCommonHeadPara("");
        String resourceUri = "/systemtags";
        ResponseMessage response = this.SendData("", HttpMethod.GET, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        String requestId = this.GetRequestId(response.getHeaders());
        JSONObject object = this.parseResponseBody(response, requestId);
        List<TagResource> tagResources = this.ExtractTagResources(object, requestId);
        String nextToken = object.getString("nextToken");
        return new ListTagResourcesResponse(resHeaders, nextToken, tagResources);
    }

    protected List<TagResource> ExtractTagResources(JSONObject object, String requestId) throws LogException {
        ArrayList<TagResource> tagResources = new ArrayList<TagResource>();
        if (object == null) {
            return tagResources;
        }
        try {
            JSONArray array = object.getJSONArray("tagResources");
            if (array == null) {
                return tagResources;
            }
            for (int index = 0; index < array.size(); ++index) {
                JSONObject item = array.getJSONObject(index);
                if (item == null) continue;
                tagResources.add(TagResource.FromJsonObject(item));
            }
        }
        catch (JSONException e) {
            throw new LogException("BadResponse", "The response is not valid config json array string : " + object.toString(), e, requestId);
        }
        return tagResources;
    }

    public ListTagResourcesResponse listTagResources(ListTagResourcesRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        Map<String, String> urlParameter = request.GetAllParams();
        Map<String, String> headParameter = this.GetCommonHeadPara("");
        String resourceUri = "/tags";
        ResponseMessage response = this.SendData("", HttpMethod.GET, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        String requestId = this.GetRequestId(response.getHeaders());
        JSONObject object = this.parseResponseBody(response, requestId);
        List<TagResource> tagResources = this.ExtractTagResources(object, requestId);
        String nextToken = object.getString("nextToken");
        return new ListTagResourcesResponse(resHeaders, nextToken, tagResources);
    }

    public GetLogtailProfileResponse GetLogtailProfile(String project, String logstore, String source, int line, int offset) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(logstore, "logstore");
        GetLogtailProfileRequest request = new GetLogtailProfileRequest(project, logstore, source, line, offset);
        return this.GetLogtailProfile(request);
    }

    public GetLogtailProfileResponse GetLogtailProfile(GetLogtailProfileRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        Map<String, String> urlParameter = request.GetAllParams();
        String project = request.GetProject();
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        CodingUtils.validateLogstore(request.getLogStore());
        String resourceUri = "/logstores/" + request.getLogStore() + "/logtailprofile";
        ResponseMessage response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        String requestId = this.GetRequestId(resHeaders);
        JSONObject object = this.parseResponseBody(response, requestId);
        return this.ExtractLogtailProfile(resHeaders, object);
    }

    @Override
    public GetHistogramsResponse GetHistograms(String project, String logStore, int from, int to, String topic, String query) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        CodingUtils.assertParameterNotNull(topic, "topic");
        CodingUtils.assertParameterNotNull(query, "query");
        GetHistogramsRequest request = new GetHistogramsRequest(project, logStore, topic, query, from, to);
        return this.GetHistograms(request);
    }

    @Override
    public GetHistogramsResponse GetHistograms(GetHistogramsRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        Map<String, String> urlParameter = request.GetAllParams();
        String project = request.GetProject();
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        CodingUtils.validateLogstore(request.GetLogStore());
        String resourceUri = "/logstores/" + request.GetLogStore() + "/index";
        ResponseMessage response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        String requestId = this.GetRequestId(resHeaders);
        JSONArray object = this.ParseResponseMessageToArray(response, requestId);
        GetHistogramsResponse histogramResponse = new GetHistogramsResponse(resHeaders);
        histogramResponse.fromJSON(object);
        return histogramResponse;
    }

    public PutLogsResponse PutLogs(String project, String logStore, byte[] logGroupBytes, String compressType, String shardHash) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        CodingUtils.assertParameterNotNull(logGroupBytes, "logGroupBytes");
        PutLogsRequest request = new PutLogsRequest(project, logStore, null, null, logGroupBytes, shardHash);
        request.SetCompressType(Consts.CompressType.fromString(compressType));
        return this.PutLogs(request);
    }

    @Override
    public PutLogsResponse PutLogs(String project, String logStore, String topic, List<LogItem> logItems, String source, String shardHash) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        CodingUtils.assertParameterNotNull(topic, "topic");
        CodingUtils.assertParameterNotNull(logItems, "logGroup");
        PutLogsRequest request = new PutLogsRequest(project, logStore, topic, source, logItems, shardHash);
        request.SetCompressType(Consts.CompressType.LZ4);
        return this.PutLogs(request);
    }

    @Override
    public PutLogsResponse PutLogs(String project, String logStore, String topic, List<LogItem> logItems, String source) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        CodingUtils.assertParameterNotNull(topic, "topic");
        CodingUtils.assertParameterNotNull(logItems, "logGroup");
        PutLogsRequest request = new PutLogsRequest(project, logStore, topic, source, logItems, null);
        request.SetCompressType(Consts.CompressType.LZ4);
        return this.PutLogs(request);
    }

    @Override
    public BatchPutLogsResponse batchPutLogs(BatchPutLogsRequest request) throws LogException {
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(request.getLogStore(), "logStore");
        Consts.CompressType compressType = request.getCompressType();
        CodingUtils.assertParameterNotNull((Object)compressType, "compressType");
        if (compressType != Consts.CompressType.ZSTD && compressType != Consts.CompressType.LZ4) {
            throw new LogException("InvalidParameter", "Unsupported compress type:" + (Object)((Object)compressType), "");
        }
        List<LogGroup> logGroups = request.getLogGroups();
        if (logGroups == null || logGroups.isEmpty()) {
            throw new LogException("InvalidParameter", "LogGroups is empty", "");
        }
        byte[] logBytes = request.serializeToPb();
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        headParameter.put("x-log-mode", "batch_group");
        headParameter.put("Content-Type", "application/x-protobuf");
        headParameter.put("x-log-bodyrawsize", String.valueOf(logBytes.length));
        headParameter.put("x-log-compresstype", compressType.toString());
        this.checkBodyRawSize(logBytes.length);
        String resourceUri = "/logstores/" + request.getLogStore();
        String shardKey = request.getHashKey();
        Map<String, String> urlParameter = request.GetAllParams();
        if (shardKey == null || shardKey.isEmpty()) {
            resourceUri = resourceUri + "/shards/lb";
        } else {
            resourceUri = resourceUri + "/shards/route";
            urlParameter.put("key", shardKey);
        }
        ResponseMessage response = this.sendLogBytes(project, logBytes, resourceUri, urlParameter, headParameter);
        if (response != null) {
            return new BatchPutLogsResponse(response.getHeaders());
        }
        return null;
    }

    @Override
    public PutLogsResponse PutLogs(PutLogsRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String logStore = request.GetLogStore();
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        String shardKey = request.getHashKey();
        Consts.CompressType compressType = request.getCompressType();
        CodingUtils.assertParameterNotNull((Object)compressType, "compressType");
        byte[] logBytes = request.GetLogGroupBytes();
        if (logBytes == null) {
            ArrayList<LogItem> logItems = request.GetLogItems();
            String topic = request.GetTopic();
            CodingUtils.assertParameterNotNull(topic, "topic");
            String source = request.GetSource();
            if (!"application/json".equals(request.getContentType())) {
                Logs.LogGroup.Builder logs = Logs.LogGroup.newBuilder();
                logs.setTopic(topic);
                if (source == null || source.isEmpty()) {
                    logs.setSource(this.sourceIp);
                } else {
                    logs.setSource(source);
                }
                ArrayList<TagContent> tags = request.GetTags();
                if (tags != null && tags.size() > 0) {
                    for (TagContent tag : tags) {
                        Logs.LogTag.Builder tagBuilder = logs.addLogTagsBuilder();
                        tagBuilder.setKey(tag.getKey());
                        tagBuilder.setValue(tag.getValue());
                    }
                }
                if (this.mUUIDTag) {
                    Logs.LogTag.Builder tagBuilder = logs.addLogTagsBuilder();
                    tagBuilder.setKey("__pack_unique_id__");
                    tagBuilder.setValue(UUID.randomUUID().toString() + "-" + Math.random());
                }
                for (LogItem item : logItems) {
                    Logs.Log.Builder log = logs.addLogsBuilder();
                    log.setTime(item.mLogTime);
                    if (item.mLogTimeNsPart != 0) {
                        log.setTimeNs(item.mLogTimeNsPart);
                    }
                    for (LogContent content : item.mContents) {
                        CodingUtils.assertStringNotNullOrEmpty(content.mKey, "key");
                        Logs.Log.Content.Builder contentBuilder = log.addContentsBuilder();
                        contentBuilder.setKey(content.mKey);
                        if (content.mValue == null) {
                            contentBuilder.setValue("");
                            continue;
                        }
                        contentBuilder.setValue(content.mValue);
                    }
                }
                logBytes = logs.build().toByteArray();
            } else {
                JSONObject jsonObj = new JSONObject();
                jsonObj.put("__topic__", (Object)topic);
                if (source == null || source.isEmpty()) {
                    jsonObj.put("__source__", (Object)this.sourceIp);
                } else {
                    jsonObj.put("__source__", (Object)source);
                }
                JSONArray logsArray = new JSONArray();
                for (LogItem item : logItems) {
                    JSONObject jsonObjInner = new JSONObject();
                    jsonObjInner.put("__time__", (Object)item.mLogTime);
                    if (item.mLogTimeNsPart != 0) {
                        jsonObjInner.put("__time_ns_part__", (Object)item.mLogTimeNsPart);
                    }
                    for (LogContent content : item.mContents) {
                        jsonObjInner.put(content.mKey, (Object)content.mValue);
                    }
                    logsArray.add(jsonObjInner);
                }
                jsonObj.put("__logs__", (Object)logsArray);
                JSONObject tagObj = new JSONObject();
                ArrayList<TagContent> tags = request.GetTags();
                if (tags != null && tags.size() > 0) {
                    for (TagContent tag : tags) {
                        tagObj.put(tag.getKey(), (Object)tag.getValue());
                    }
                }
                if (this.mUUIDTag) {
                    tagObj.put("__pack_unique_id__", (Object)(UUID.randomUUID().toString() + "-" + Math.random()));
                }
                if (tagObj.size() > 0) {
                    jsonObj.put("__tags__", (Object)tagObj);
                }
                logBytes = Client.encodeToUtf8(jsonObj.toString());
            }
        }
        this.checkBodyRawSize(logBytes.length);
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        headParameter.put("Content-Type", request.getContentType());
        headParameter.put("x-log-bodyrawsize", String.valueOf(logBytes.length));
        if (request.getCompressType() != Consts.CompressType.NONE) {
            headParameter.put("x-log-compresstype", request.getCompressType().toString());
        }
        logBytes = Utils.compressLogBytes(logBytes, request.getCompressType());
        Map<String, String> urlParameter = request.GetAllParams();
        String resourceUri = "/logstores/" + logStore;
        if (shardKey == null || shardKey.length() == 0) {
            resourceUri = resourceUri + "/shards/lb";
        } else {
            resourceUri = resourceUri + "/shards/route";
            urlParameter.put("key", shardKey);
            if (request.getHashRouteKeySeqId() != null) {
                urlParameter.put("seqid", String.valueOf(request.getHashRouteKeySeqId()));
            }
        }
        ResponseMessage response = this.sendLogBytes(project, logBytes, resourceUri, urlParameter, headParameter);
        if (response != null) {
            return new PutLogsResponse(response.getHeaders());
        }
        return null;
    }

    private ResponseMessage sendLogBytes(String project, byte[] logBytes, String resourceUri, Map<String, String> urlParameter, Map<String, String> headParameter) throws LogException {
        for (int i = 0; i < 2; ++i) {
            String server_ip = this.realServerIP;
            ClientConnectionStatus connection_status = null;
            if (this.useDirectMode) {
                connection_status = this.GetGlobalConnectionStatus();
                server_ip = connection_status.GetIpAddress();
            }
            try {
                ResponseMessage response = this.SendData(project, HttpMethod.POST, resourceUri, urlParameter, headParameter, logBytes, null, server_ip);
                if (connection_status != null) {
                    connection_status.AddSendDataSize(logBytes.length);
                    connection_status.UpdateLastUsedTime(System.nanoTime());
                }
                return response;
            }
            catch (LogException e) {
                String requestId = e.getRequestId();
                if (i == 1 || requestId != null && !requestId.isEmpty()) {
                    throw e;
                }
                if (connection_status == null) continue;
                connection_status.DisableConnection();
                continue;
            }
        }
        return null;
    }

    private void checkBodyRawSize(int bodySize) throws LogException {
        if (bodySize > Consts.CONST_MAX_PUT_SIZE) {
            throw new LogException("InvalidLogSize", "logItems' size exceeds maximum limitation : " + Consts.CONST_MAX_PUT_SIZE + " bytes", "");
        }
        if (bodySize > Consts.CONST_MAX_POST_BODY_SIZE) {
            throw new LogException("PostBodyTooLarge", "body size " + bodySize + " must little than " + Consts.CONST_MAX_POST_BODY_SIZE, "");
        }
    }

    private ClientConnectionStatus GetGlobalConnectionStatus() throws LogException {
        ClientConnectionContainer connection_container = ClientConnectionHelper.getInstance().GetConnectionContainer(this.hostName, this.credentialsProvider);
        ClientConnectionStatus connection_status = connection_container.GetGlobalConnection();
        if (connection_status == null || !connection_status.IsValidConnection()) {
            connection_container.UpdateGlobalConnection();
            connection_status = connection_container.GetGlobalConnection();
            if (connection_status == null || connection_status.GetIpAddress() == null || connection_status.GetIpAddress().isEmpty()) {
                throw new LogException("EndpointInvalid", "Failed to get real server ip when direct mode is enabled", "");
            }
        }
        return connection_status;
    }

    private ClientConnectionStatus GetShardConnectionStatus(String project, String logstore, int shard_id) throws LogException {
        ClientConnectionContainer connection_container = ClientConnectionHelper.getInstance().GetConnectionContainer(this.hostName, this.credentialsProvider);
        ClientConnectionStatus connection_status = connection_container.GetShardConnection(project, logstore, shard_id);
        if (connection_status != null && connection_status.IsValidConnection()) {
            return connection_status;
        }
        return this.GetGlobalConnectionStatus();
    }

    @Override
    public GetLogsResponse GetLogs(String project, String logStore, int from, int to, String topic, String query) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        CodingUtils.assertParameterNotNull(topic, "topic");
        CodingUtils.assertParameterNotNull(query, "query");
        GetLogsRequest request = new GetLogsRequest(project, logStore, from, to, topic, query);
        return this.GetLogs(request);
    }

    public GetLogsResponse GetLogs(String project, String logStore, int from, int to, String topic, String query, long line, long offset, boolean reverse) throws LogException {
        return this.GetLogs(project, logStore, from, to, topic, query, line, offset, reverse, false);
    }

    @Override
    public GetLogsResponse GetLogs(String project, String logStore, int from, int to, String topic, String query, long line, long offset, boolean reverse, boolean powerSql) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        CodingUtils.assertParameterNotNull(topic, "topic");
        CodingUtils.assertParameterNotNull(query, "query");
        CodingUtils.validateOffset(offset);
        GetLogsRequest request = new GetLogsRequest(project, logStore, from, to, topic, query, offset, line, reverse, powerSql);
        return this.GetLogs(request);
    }

    @Override
    public GetLogsResponse GetLogs(String project, String logStore, int from, int to, String topic, String query, long line, long offset, boolean reverse, boolean powerSql, boolean forward) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        CodingUtils.assertParameterNotNull(topic, "topic");
        CodingUtils.assertParameterNotNull(query, "query");
        CodingUtils.validateOffset(offset);
        GetLogsRequest request = new GetLogsRequest(project, logStore, from, to, topic, query, offset, line, reverse, powerSql, forward);
        return this.GetLogs(request);
    }

    @Override
    public GetLogsResponse GetLogs(String project, String logStore, int from, int to, String topic, String query, long line, long offset, boolean reverse, int shard) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        CodingUtils.assertParameterNotNull(topic, "topic");
        CodingUtils.assertParameterNotNull(query, "query");
        CodingUtils.validateOffset(offset);
        GetLogsRequest request = new GetLogsRequest(project, logStore, from, to, topic, query, offset, line, reverse, shard);
        return this.GetLogs(request);
    }

    @Override
    public GetLogsResponse GetLogs(String project, String logStore, int from, int to, String topic, String query, long line, long offset, boolean reverse, boolean forward, String session) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        CodingUtils.assertParameterNotNull(topic, "topic");
        CodingUtils.assertParameterNotNull(query, "query");
        CodingUtils.validateOffset(offset);
        GetLogsRequest request = new GetLogsRequest(project, logStore, from, to, topic, query, offset, line, reverse, forward, session);
        return this.GetLogs(request);
    }

    @Override
    public GetLogsResponse executeLogstoreSql(String project, String logStore, int from, int to, String sql, boolean powerSql) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        CodingUtils.assertParameterNotNull(sql, "sql");
        GetLogsRequest request = new GetLogsRequest(project, logStore, from, to, "", sql);
        request.SetPowerSql(powerSql);
        return this.GetLogs(request);
    }

    public GetContextLogsResponse getContextLogs(String project, String logstore, String packID, String packMeta, int backLines, int forwardLines) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(logstore, "logStore");
        GetContextLogsRequest request = new GetContextLogsRequest(project, logstore, packID, packMeta, backLines, forwardLines);
        return this.getContextLogs(request);
    }

    @Override
    public GetLogsResponse GetProjectLogs(String project, String query) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertParameterNotNull(query, "query");
        GetProjectLogsRequest request = new GetProjectLogsRequest(project, query);
        return this.GetProjectLogs(request);
    }

    @Override
    public GetLogsResponse GetProjectLogs(GetProjectLogsRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        Map<String, String> urlParameter = request.GetAllParams();
        String project = request.GetProject();
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/logs";
        ResponseMessage response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        GetLogsResponse getLogsResponse = new GetLogsResponse(resHeaders);
        String requestId = this.GetRequestId(resHeaders);
        JSONArray object = this.ParseResponseMessageToArrayWithFastJson(response, requestId);
        getLogsResponse.setLogs(QueryResult.parseData(object, requestId));
        return getLogsResponse;
    }

    @Override
    public GetLogsResponse executeProjectSql(String project, String sql, boolean powerSql) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertParameterNotNull(sql, "sql");
        GetProjectLogsRequest request = new GetProjectLogsRequest(project, sql);
        request.SetPowerSql(powerSql);
        return this.GetProjectLogs(request);
    }

    private JSONArray ParseResponseMessageToArrayWithFastJson(ResponseMessage response, String requestId) throws LogException {
        String returnStr = Client.encodeResponseBodyToUtf8String(response, requestId);
        try {
            return (JSONArray)JSONObject.parse(returnStr, Feature.DisableSpecialKeyDetect);
        }
        catch (JSONException e) {
            throw new LogException("BadResponse", "The response is not valid json string : " + returnStr, e, requestId);
        }
    }

    public GetLogsResponse GetRawLogs(GetLogsRequest request) throws LogException {
        return this.getLogsInternal(request, false);
    }

    private GetLogsResponse getLogsInternal(GetLogsRequest request, boolean deserialize) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        Map<String, String> urlParameter = request.GetAllParams();
        String project = request.GetProject();
        String logStore = request.GetLogStore();
        CodingUtils.validateLogstore(logStore);
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        Consts.CompressType compressType = request.getCompressType();
        if (compressType != null && compressType != Consts.CompressType.NONE) {
            headParameter.put("Accept-Encoding", compressType.toString());
        }
        String resourceUri = "/logstores/" + logStore + "/logs";
        ResponseMessage response = this.SendData(project, HttpMethod.POST, resourceUri, urlParameter, headParameter, request.getRequestBody());
        return GetLogsResponse.deserializeFrom(response, deserialize);
    }

    @Override
    public GetLogsResponse GetLogs(GetLogsRequest request) throws LogException {
        return this.getLogsInternal(request, true);
    }

    @Deprecated
    public GetLogsResponseV2 GetLogsV2(GetLogsRequestV2 request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        Map<String, String> urlParameter = request.GetAllParams();
        String project = request.GetProject();
        String logstore = request.getLogstore();
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        headParameter.put("Accept-Encoding", request.getAcceptEncoding());
        CodingUtils.validateLogstore(logstore);
        String resourceUri = "/logstores/" + logstore + "/logs";
        ResponseMessage response = this.SendData(project, HttpMethod.POST, resourceUri, urlParameter, headParameter, request.getRequestBody());
        return GetLogsResponseV2.deserializeFrom(response);
    }

    public GetContextLogsResponse getContextLogs(GetContextLogsRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        Map<String, String> urlParameter = request.GetAllParams();
        String project = request.GetProject();
        String logStore = request.getLogstore();
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        CodingUtils.validateLogstore(logStore);
        String resourceUri = "/logstores/" + logStore;
        ResponseMessage response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        String requestId = this.GetRequestId(resHeaders);
        JSONObject object = this.parseResponseBody(response, requestId);
        GetContextLogsResponse logsResponse = new GetContextLogsResponse(resHeaders, object);
        logsResponse.setLogs(QueryResult.parseData(object.getJSONArray("logs"), requestId));
        return logsResponse;
    }

    @Override
    public ListLogStoresResponse ListLogStores(String project, int offset, int size) throws LogException {
        return this.ListLogStores(project, offset, size, "");
    }

    @Override
    public ListLogStoresResponse ListLogStores(String project, int offset, int size, String logstoreName) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        ListLogStoresRequest request = new ListLogStoresRequest(project, offset, size, logstoreName);
        return this.ListLogStores(request);
    }

    @Override
    public ListLogStoresResponse ListLogStores(ListLogStoresRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        Map<String, String> urlParameter = request.GetAllParams();
        String resourceUri = "/logstores";
        String project = request.GetProject();
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        ResponseMessage response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        String requestId = this.GetRequestId(resHeaders);
        JSONObject object = this.parseResponseBody(response, requestId);
        ListLogStoresResponse listLogStoresResponse = new ListLogStoresResponse(resHeaders);
        listLogStoresResponse.SetLogStores(this.ExtractJsonArray("logstores", object));
        listLogStoresResponse.SetTotal(object.getIntValue("total"));
        return listLogStoresResponse;
    }

    @Override
    public GetCursorResponse GetCursor(String project, String logStore, int shardId, long fromTime) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        GetCursorRequest request = new GetCursorRequest(project, logStore, shardId, fromTime);
        return this.GetCursor(request);
    }

    @Override
    public GetCursorResponse GetCursor(String project, String logStore, int shardId, Date fromTime) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStream");
        CodingUtils.assertParameterNotNull(fromTime, "fromTime");
        long timeStamp = Utils.dateToTimestamp(fromTime);
        GetCursorRequest request = new GetCursorRequest(project, logStore, shardId, timeStamp);
        return this.GetCursor(request);
    }

    @Override
    public GetCursorResponse GetCursor(String project, String logStream, int shardId, Consts.CursorMode mode) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(logStream, "logStream");
        GetCursorRequest request = new GetCursorRequest(project, logStream, shardId, mode);
        return this.GetCursor(request);
    }

    @Override
    public GetCursorResponse GetCursor(GetCursorRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String logStore = request.GetLogStore();
        String shardId = String.valueOf(request.GetShardId());
        CodingUtils.validateLogstore(logStore);
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/logstores/" + logStore + "/shards/" + shardId;
        headParameter.put("Content-Length", String.valueOf(0));
        Map<String, String> urlParameter = request.GetAllParams();
        ResponseMessage response = new ResponseMessage();
        try {
            response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
            Map<String, String> resHeaders = response.getHeaders();
            String requestId = this.GetRequestId(resHeaders);
            JSONObject object = this.parseResponseBody(response, requestId);
            return new GetCursorResponse(resHeaders, object.getString("cursor"));
        }
        catch (JSONException e) {
            throw new LogException("FailToCreateCursor", e.getMessage(), e, this.GetRequestId(response.getHeaders()));
        }
    }

    @Override
    public GetCursorTimeResponse GetCursorTime(GetCursorTimeRequest request) throws LogException {
        GetCursorTimeResponse getCursorTimeResponse;
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String logStore = request.GetLogStore();
        String shardId = String.valueOf(request.GetShardId());
        CodingUtils.validateLogstore(logStore);
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/logstores/" + logStore + "/shards/" + shardId;
        headParameter.put("Content-Length", String.valueOf(0));
        Map<String, String> urlParameter = request.GetAllParams();
        ResponseMessage response = new ResponseMessage();
        try {
            response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
            Map<String, String> resHeaders = response.getHeaders();
            String requestId = this.GetRequestId(resHeaders);
            JSONObject object = this.parseResponseBody(response, requestId);
            getCursorTimeResponse = new GetCursorTimeResponse(resHeaders, object.getIntValue("cursor_time"));
        }
        catch (JSONException e) {
            throw new LogException("FailToCreateCursor", e.getMessage(), e, this.GetRequestId(response.getHeaders()));
        }
        return getCursorTimeResponse;
    }

    public GetCursorTimeResponse GetPrevCursorTime(String project, String logStore, int shardId, String cursor) throws LogException {
        if (cursor.isEmpty()) {
            throw new LogException("InvalidCursor", "empty cursor string", "");
        }
        long prv = Long.parseLong(new String(Base64.decodeBase64(cursor))) - 1L;
        if (prv < 0L) {
            throw new LogException("InvalidCursor", "this cursor has no prev value", "");
        }
        cursor = new String(Base64.encodeBase64(Long.toString(prv).getBytes()));
        GetCursorTimeRequest request = new GetCursorTimeRequest(project, logStore, shardId, cursor);
        return this.GetCursorTime(request);
    }

    @Override
    public GetCursorTimeResponse GetCursorTime(String project, String logStore, int shardId, String cursor) throws LogException {
        GetCursorTimeRequest request = new GetCursorTimeRequest(project, logStore, shardId, cursor);
        return this.GetCursorTime(request);
    }

    @Override
    public ListShardResponse SplitShard(String project, String logStore, int shardId, String midHash) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        CodingUtils.assertStringNotNullOrEmpty(logStore, "shardId");
        return this.SplitShard(new SplitShardRequest(project, logStore, shardId, midHash));
    }

    @Override
    public ListShardResponse SplitShard(SplitShardRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String logStore = request.GetLogStore();
        CodingUtils.validateLogstore(logStore);
        int shardId = request.GetShardId();
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/logstores/" + logStore + "/shards/" + shardId;
        Map<String, String> urlParameter = request.GetAllParams();
        ResponseMessage response = this.SendData(project, HttpMethod.POST, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        String requestId = this.GetRequestId(resHeaders);
        JSONArray array = this.ParseResponseMessageToArray(response, requestId);
        ArrayList<Shard> shards = this.ExtractShards(array, requestId);
        return new ListShardResponse(resHeaders, shards);
    }

    @Override
    public ListShardResponse MergeShards(String project, String logStore, int shardId) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        CodingUtils.assertStringNotNullOrEmpty(logStore, "shardId");
        return this.MergeShards(new MergeShardsRequest(project, logStore, shardId));
    }

    @Override
    public ListShardResponse MergeShards(MergeShardsRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String logStore = request.GetLogStore();
        CodingUtils.validateLogstore(logStore);
        int shardId = request.GetShardId();
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/logstores/" + logStore + "/shards/" + shardId;
        Map<String, String> urlParameter = request.GetAllParams();
        ResponseMessage response = this.SendData(project, HttpMethod.POST, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        String requestId = this.GetRequestId(resHeaders);
        JSONArray array = this.ParseResponseMessageToArray(response, requestId);
        ArrayList<Shard> shards = this.ExtractShards(array, requestId);
        return new ListShardResponse(resHeaders, shards);
    }

    @Override
    public ListShardResponse ListShard(String project, String logStore) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        return this.ListShard(new ListShardRequest(project, logStore));
    }

    public String GetServerIpAddress(String project) {
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/direct_mode_ip";
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        HashMap<String, String> out_header = new HashMap<String, String>();
        try {
            this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter, new byte[0], out_header, null);
        }
        catch (LogException logException) {
            // empty catch block
        }
        return Utils.getOrEmpty(out_header, "x-log-hostip");
    }

    @Override
    public ListShardResponse ListShard(ListShardRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String logStore = request.GetLogStore();
        CodingUtils.validateLogstore(logStore);
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/logstores/" + logStore + "/shards";
        Map<String, String> urlParameter = request.GetAllParams();
        ResponseMessage response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        String requestId = this.GetRequestId(resHeaders);
        JSONArray array = this.ParseResponseMessageToArray(response, requestId);
        ArrayList<Shard> shards = this.ExtractShards(array, requestId);
        return new ListShardResponse(resHeaders, shards);
    }

    protected String GetRequestId(Map<String, String> headers) {
        return Utils.getOrEmpty(headers, "x-log-requestid");
    }

    @Override
    @Deprecated
    public BatchGetLogResponse BatchGetLog(String project, String logStore, int shardId, int count, String cursor) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        return this.BatchGetLog(new BatchGetLogRequest(project, logStore, shardId, count, cursor));
    }

    @Override
    @Deprecated
    public BatchGetLogResponse BatchGetLog(String project, String logStore, int shardId, int count, String cursor, String end_cursor) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        return this.BatchGetLog(new BatchGetLogRequest(project, logStore, shardId, count, cursor, end_cursor));
    }

    @Override
    @Deprecated
    public BatchGetLogResponse BatchGetLog(BatchGetLogRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String logStore = request.GetLogStore();
        CodingUtils.validateLogstore(logStore);
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/logstores/" + logStore + "/shards/" + request.GetShardId();
        Consts.CompressType compressType = request.getCompressType();
        if (compressType == null || compressType == Consts.CompressType.NONE) {
            compressType = Consts.CompressType.LZ4;
        }
        headParameter.put("Accept-Encoding", compressType.toString());
        headParameter.put("accept", "application/x-protobuf");
        Map<String, String> urlParameter = request.GetAllParams();
        for (int i = 0; i < 2; ++i) {
            String server_ip = this.realServerIP;
            ClientConnectionStatus connection_status = null;
            if (this.useDirectMode) {
                connection_status = this.GetShardConnectionStatus(project, logStore, request.GetShardId());
                server_ip = connection_status.GetIpAddress();
            }
            try {
                ResponseMessage response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter, new byte[0], null, server_ip);
                Map<String, String> resHeaders = response.getHeaders();
                byte[] rawData = response.GetRawBody();
                BatchGetLogResponse batchGetLogResponse = new BatchGetLogResponse(resHeaders, rawData);
                if (connection_status != null) {
                    connection_status.UpdateLastUsedTime(System.nanoTime());
                    connection_status.AddPullDataSize(batchGetLogResponse.GetRawSize());
                }
                return batchGetLogResponse;
            }
            catch (LogException e) {
                if (i == 1 || e.getRequestId() != null && !e.getRequestId().isEmpty()) {
                    throw e;
                }
                if (connection_status == null) continue;
                connection_status.DisableConnection();
                continue;
            }
        }
        return null;
    }

    @Override
    public PullLogsResponse pullLogs(PullLogsRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        String logStore = request.getLogStore();
        CodingUtils.validateLogstore(logStore);
        Map<String, String> headers = this.GetCommonHeadPara(project);
        String resourceUri = "/logstores/" + logStore + "/shards/" + request.getShardId();
        Consts.CompressType compressType = request.getCompressType();
        if (compressType == null || compressType == Consts.CompressType.NONE) {
            compressType = Consts.CompressType.LZ4;
        }
        headers.put("Accept-Encoding", compressType.toString());
        headers.put("accept", "application/x-protobuf");
        Map<String, String> urlParameter = request.GetAllParams();
        for (int i = 0; i < 2; ++i) {
            String serverIp = this.realServerIP;
            ClientConnectionStatus connectionStatus = null;
            if (this.useDirectMode) {
                connectionStatus = this.GetShardConnectionStatus(project, logStore, request.getShardId());
                serverIp = connectionStatus.GetIpAddress();
            }
            try {
                ResponseMessage response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headers, new byte[0], null, serverIp);
                Map<String, String> resHeaders = response.getHeaders();
                PullLogsResponse plr = new PullLogsResponse(resHeaders, response.GetRawBody());
                if (connectionStatus != null) {
                    connectionStatus.UpdateLastUsedTime(System.nanoTime());
                    connectionStatus.AddPullDataSize(plr.getRawSize());
                }
                return plr;
            }
            catch (LogException ex) {
                if (i == 1 || ex.getRequestId() != null && !ex.getRequestId().isEmpty()) {
                    throw ex;
                }
                if (connectionStatus == null) continue;
                connectionStatus.DisableConnection();
                continue;
            }
        }
        return null;
    }

    @Override
    public CreateConfigResponse CreateConfig(String project, Config config) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertParameterNotNull(config, "config");
        return this.CreateConfig(new CreateConfigRequest(project, config));
    }

    @Override
    public CreateConfigResponse CreateConfig(CreateConfigRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        Config config = request.GetConfig();
        CodingUtils.assertParameterNotNull(config, "config");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        byte[] body = Client.encodeToUtf8(config.ToRequestString());
        headParameter.put("Content-Type", "application/json");
        String resourceUri = "/configs";
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(project, HttpMethod.POST, resourceUri, urlParameter, headParameter, body);
        Map<String, String> resHeaders = response.getHeaders();
        return new CreateConfigResponse(resHeaders);
    }

    @Override
    public UpdateConfigResponse UpdateConfig(String project, Config config) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertParameterNotNull(config, "config");
        return this.UpdateConfig(new UpdateConfigRequest(project, config));
    }

    @Override
    public UpdateConfigResponse UpdateConfig(UpdateConfigRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        Config config = request.GetConfig();
        CodingUtils.assertParameterNotNull(config, "config");
        String configName = config.GetConfigName();
        CodingUtils.validateConfig(configName);
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        byte[] body = Client.encodeToUtf8(config.ToRequestString());
        headParameter.put("Content-Type", "application/json");
        String resourceUri = "/configs/" + configName;
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(project, HttpMethod.PUT, resourceUri, urlParameter, headParameter, body);
        Map<String, String> resHeaders = response.getHeaders();
        return new UpdateConfigResponse(resHeaders);
    }

    protected Config ExtractConfigFromResponse(JSONObject dict, String requestId) throws LogException {
        Config config = new Config();
        try {
            config.FromJsonString(dict.toString());
        }
        catch (LogException e) {
            throw new LogException(e.getErrorCode(), e.getMessage(), e.getCause(), requestId);
        }
        return config;
    }

    @Override
    public GetConfigResponse GetConfig(String project, String configName) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(configName, "configName");
        return this.GetConfig(new GetConfigRequest(project, configName));
    }

    @Override
    public GetConfigResponse GetConfig(GetConfigRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String configName = request.GetConfigName();
        CodingUtils.validateConfig(configName);
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/configs/" + configName;
        Map<String, String> urlParameter = request.GetAllParams();
        ResponseMessage response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        String requestId = this.GetRequestId(resHeaders);
        JSONObject object = this.parseResponseBody(response, requestId);
        Config config = this.ExtractConfigFromResponse(object, requestId);
        return new GetConfigResponse(resHeaders, config);
    }

    @Override
    public DeleteConfigResponse DeleteConfig(String project, String configName) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(configName, "configName");
        return this.DeleteConfig(new DeleteConfigRequest(project, configName));
    }

    @Override
    public DeleteConfigResponse DeleteConfig(DeleteConfigRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String configName = request.GetConfigName();
        CodingUtils.validateConfig(configName);
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/configs/" + configName;
        Map<String, String> urlParameter = request.GetAllParams();
        ResponseMessage response = this.SendData(project, HttpMethod.DELETE, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        return new DeleteConfigResponse(resHeaders);
    }

    protected List<String> ExtractConfigs(JSONObject object, String requestId) throws LogException {
        ArrayList<String> configs = new ArrayList<String>();
        if (object == null) {
            return configs;
        }
        JSONArray array = new JSONArray();
        try {
            array = object.getJSONArray("configs");
            if (array == null) {
                return configs;
            }
            for (int i = 0; i < array.size(); ++i) {
                String configName = array.getString(i);
                configs.add(configName);
            }
        }
        catch (JSONException e) {
            throw new LogException("BadResponse", "The response is not valid config json array string : " + array.toString(), e, requestId);
        }
        return configs;
    }

    @Override
    public ListConfigResponse ListConfig(String project) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        return this.ListConfig(new ListConfigRequest(project));
    }

    @Override
    public ListConfigResponse ListConfig(String project, int offset, int size) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        return this.ListConfig(new ListConfigRequest(project, offset, size));
    }

    @Override
    public ListConfigResponse ListConfig(String project, String configName, int offset, int size) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(configName, "configName");
        return this.ListConfig(new ListConfigRequest(project, configName, offset, size));
    }

    public ListConfigResponse ListConfig(String project, String configName, String logstoreName, int offset, int size) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(configName, "configName");
        CodingUtils.assertStringNotNullOrEmpty(logstoreName, "logstoreName");
        return this.ListConfig(new ListConfigRequest(project, configName, logstoreName, offset, size));
    }

    @Override
    public ListConfigResponse ListConfig(ListConfigRequest request) throws LogException {
        ListConfigResponse listConfigResponse;
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/configs";
        Map<String, String> urlParameter = request.GetAllParams();
        ResponseMessage response = new ResponseMessage();
        JSONObject object = null;
        try {
            response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
            Map<String, String> resHeaders = response.getHeaders();
            String requestId = this.GetRequestId(resHeaders);
            object = this.parseResponseBody(response, requestId);
            int total = object.getIntValue("total");
            int count = object.getIntValue("count");
            List<String> configs = this.ExtractConfigs(object, requestId);
            listConfigResponse = new ListConfigResponse(resHeaders, count, total, configs);
        }
        catch (JSONException e) {
            throw new LogException("BadResponse", "The response is not valid list config json string : " + Utils.safeToString(object), e, this.GetRequestId(response.getHeaders()));
        }
        return listConfigResponse;
    }

    @Override
    public CreateMachineGroupResponse CreateMachineGroup(String project, MachineGroup group) throws LogException {
        CodingUtils.assertParameterNotNull(project, "project");
        CodingUtils.assertParameterNotNull(group, "group");
        return this.CreateMachineGroup(new CreateMachineGroupRequest(project, group));
    }

    @Override
    public CreateMachineGroupResponse CreateMachineGroup(CreateMachineGroupRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        MachineGroup group = request.GetMachineGroup();
        CodingUtils.assertParameterNotNull(group, "group");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        headParameter.put("Content-Type", "application/json");
        byte[] body = Client.encodeToUtf8(group.ToRequestString());
        String resourceUri = "/machinegroups";
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(project, HttpMethod.POST, resourceUri, urlParameter, headParameter, body);
        Map<String, String> resHeaders = response.getHeaders();
        return new CreateMachineGroupResponse(resHeaders);
    }

    @Override
    public UpdateMachineGroupResponse UpdateMachineGroup(String project, MachineGroup group) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertParameterNotNull(group, "group");
        return this.UpdateMachineGroup(new UpdateMachineGroupRequest(project, group));
    }

    @Override
    public UpdateMachineGroupResponse UpdateMachineGroup(UpdateMachineGroupRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        MachineGroup group = request.GetMachineGroup();
        CodingUtils.assertParameterNotNull(group, "group");
        String groupName = group.GetGroupName();
        CodingUtils.validateMachineGroup(groupName);
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        byte[] body = Client.encodeToUtf8(group.ToRequestString());
        headParameter.put("Content-Type", "application/json");
        String resourceUri = "/machinegroups/" + groupName;
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(project, HttpMethod.PUT, resourceUri, urlParameter, headParameter, body);
        Map<String, String> resHeaders = response.getHeaders();
        return new UpdateMachineGroupResponse(resHeaders);
    }

    protected MachineGroup ExtractMachineGroupFromResponse(JSONObject dict, String requestId) throws LogException {
        MachineGroup group = new MachineGroup();
        try {
            group.FromJsonString(dict.toString());
        }
        catch (LogException e) {
            throw new LogException(e.getErrorCode(), e.getMessage(), e.getCause(), requestId);
        }
        return group;
    }

    @Override
    public GetAppliedConfigResponse GetAppliedConfig(String project, String groupName) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(groupName, "groupName");
        return this.GetAppliedConfig(new GetAppliedConfigsRequest(project, groupName));
    }

    @Override
    public GetAppliedConfigResponse GetAppliedConfig(GetAppliedConfigsRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String groupName = request.GetGroupName();
        CodingUtils.validateMachineGroup(groupName);
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/machinegroups/" + groupName + "/configs";
        Map<String, String> urlParameter = request.GetAllParams();
        ResponseMessage response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        String requestId = this.GetRequestId(resHeaders);
        JSONObject object = this.parseResponseBody(response, requestId);
        List<String> group = this.ExtractJsonArray("configs", object);
        return new GetAppliedConfigResponse(resHeaders, group);
    }

    @Override
    public GetAppliedMachineGroupsResponse GetAppliedMachineGroups(String project, String configName) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(configName, "configName");
        return this.GetAppliedMachineGroups(new GetAppliedMachineGroupRequest(project, configName));
    }

    @Override
    public GetAppliedMachineGroupsResponse GetAppliedMachineGroups(GetAppliedMachineGroupRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String configName = request.GetConfigName();
        CodingUtils.assertStringNotNullOrEmpty(configName, "groupName");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/configs/" + configName + "/machinegroups";
        Map<String, String> urlParameter = request.GetAllParams();
        ResponseMessage response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        String requestId = this.GetRequestId(resHeaders);
        JSONObject object = this.parseResponseBody(response, requestId);
        List<String> group = this.ExtractJsonArray("machinegroups", object);
        return new GetAppliedMachineGroupsResponse(resHeaders, group);
    }

    @Override
    public GetMachineGroupResponse GetMachineGroup(String project, String groupName) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(groupName, "groupName");
        return this.GetMachineGroup(new GetMachineGroupRequest(project, groupName));
    }

    @Override
    public GetMachineGroupResponse GetMachineGroup(GetMachineGroupRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String groupName = request.GetGroupName();
        CodingUtils.validateMachineGroup(groupName);
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/machinegroups/" + groupName;
        Map<String, String> urlParameter = request.GetAllParams();
        ResponseMessage response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        String requestId = this.GetRequestId(resHeaders);
        JSONObject object = this.parseResponseBody(response, requestId);
        MachineGroup group = this.ExtractMachineGroupFromResponse(object, requestId);
        return new GetMachineGroupResponse(resHeaders, group);
    }

    @Override
    public ListMachinesResponse ListMachines(String project, String machineGroup, int offset, int size) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.validateMachineGroup(machineGroup);
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/machinegroups/" + machineGroup + "/machines";
        headParameter.put("Content-Length", String.valueOf(0));
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        urlParameter.put("offset", String.valueOf(offset));
        urlParameter.put("size", String.valueOf(size));
        ResponseMessage response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        String requestId = this.GetRequestId(resHeaders);
        JSONObject object = this.parseResponseBody(response, requestId);
        return this.ExtractMachinesFromResponse(resHeaders, object);
    }

    private ListMachinesResponse ExtractMachinesFromResponse(Map<String, String> resHeaders, JSONObject dict) throws LogException {
        try {
            int count = dict.getIntValue("count");
            int total = dict.getIntValue("total");
            JSONArray array = dict.getJSONArray("machines");
            ArrayList<Machine> machines = new ArrayList<Machine>();
            if (array != null) {
                for (int i = 0; i < array.size(); ++i) {
                    JSONObject machine_obj = array.getJSONObject(i);
                    if (machine_obj == null) continue;
                    Machine machine = new Machine();
                    machine.FromJsonObject(machine_obj);
                    machines.add(machine);
                }
            }
            return new ListMachinesResponse(resHeaders, count, total, machines);
        }
        catch (LogException e) {
            throw new LogException(e.GetErrorCode(), e.GetErrorMessage(), e.getCause(), this.GetRequestId(resHeaders));
        }
    }

    @Override
    public ApproveMachineGroupResponse ApproveMachineGroup(String project, String groupName) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(groupName, "groupName");
        return this.ApproveMachineGroup(new ApproveMachineGroupRequest(project, groupName));
    }

    @Override
    public ApproveMachineGroupResponse ApproveMachineGroup(ApproveMachineGroupRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String groupName = request.GetGroupName();
        CodingUtils.validateMachineGroup(groupName);
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/machinegroups/" + groupName + "/approve";
        Map<String, String> urlParameter = request.GetAllParams();
        ResponseMessage response = this.SendData(project, HttpMethod.PUT, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        return new ApproveMachineGroupResponse(resHeaders);
    }

    @Override
    public DeleteMachineGroupResponse DeleteMachineGroup(String project, String groupName) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(groupName, "groupName");
        return this.DeleteMachineGroup(new DeleteMachineGroupRequest(project, groupName));
    }

    @Override
    public DeleteMachineGroupResponse DeleteMachineGroup(DeleteMachineGroupRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String groupName = request.GetGroupName();
        CodingUtils.validateMachineGroup(groupName);
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/machinegroups/" + groupName;
        Map<String, String> urlParameter = request.GetAllParams();
        ResponseMessage response = this.SendData(project, HttpMethod.DELETE, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        return new DeleteMachineGroupResponse(resHeaders);
    }

    protected List<String> ExtractMachineGroups(JSONObject object, String requestId) throws LogException {
        try {
            return JsonUtils.readOptionalStrings(object, "machinegroups");
        }
        catch (JSONException e) {
            throw new LogException("BadResponse", "The response is not valid machine group json array string : " + object, e, requestId);
        }
    }

    @Override
    public ListMachineGroupResponse ListMachineGroup(String project) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        return this.ListMachineGroup(new ListMachineGroupRequest(project));
    }

    @Override
    public ListMachineGroupResponse ListMachineGroup(String project, int offset, int size) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        return this.ListMachineGroup(new ListMachineGroupRequest(project, offset, size));
    }

    @Override
    public ListMachineGroupResponse ListMachineGroup(String project, String groupName, int offset, int size) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(groupName, "groupName");
        return this.ListMachineGroup(new ListMachineGroupRequest(project, groupName, offset, size));
    }

    @Override
    public ListMachineGroupResponse ListMachineGroup(ListMachineGroupRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/machinegroups";
        Map<String, String> urlParameter = request.GetAllParams();
        ResponseMessage response = new ResponseMessage();
        ListMachineGroupResponse listMachineGroupResponse = null;
        JSONObject object = null;
        try {
            response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
            Map<String, String> resHeaders = response.getHeaders();
            String requestId = this.GetRequestId(resHeaders);
            object = this.parseResponseBody(response, requestId);
            int total = object.getIntValue("total");
            int count = object.getIntValue("count");
            List<String> groups = this.ExtractMachineGroups(object, requestId);
            listMachineGroupResponse = new ListMachineGroupResponse(resHeaders, count, total, groups);
        }
        catch (JSONException e) {
            throw new LogException("BadResponse", "The response is not valid config json string : " + Utils.safeToString(object), e, this.GetRequestId(response.getHeaders()));
        }
        return listMachineGroupResponse;
    }

    @Override
    public ApplyConfigToMachineGroupResponse ApplyConfigToMachineGroup(String project, String groupName, String configName) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(groupName, "groupName");
        CodingUtils.assertStringNotNullOrEmpty(configName, "configName");
        return this.ApplyConfigToMachineGroup(new ApplyConfigToMachineGroupRequest(project, groupName, configName));
    }

    @Override
    public ApplyConfigToMachineGroupResponse ApplyConfigToMachineGroup(ApplyConfigToMachineGroupRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String groupName = request.GetGroupName();
        CodingUtils.validateMachineGroup(groupName);
        String configName = request.GetConfigName();
        CodingUtils.validateConfig(configName);
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/machinegroups/" + groupName + "/configs/" + configName;
        Map<String, String> urlParameter = request.GetAllParams();
        ResponseMessage response = this.SendData(project, HttpMethod.PUT, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        return new ApplyConfigToMachineGroupResponse(resHeaders);
    }

    @Override
    public RemoveConfigFromMachineGroupResponse RemoveConfigFromMachineGroup(String project, String groupName, String configName) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(groupName, "groupName");
        CodingUtils.assertStringNotNullOrEmpty(configName, "configName");
        return this.RemoveConfigFromMachineGroup(new RemoveConfigFromMachineGroupRequest(project, groupName, configName));
    }

    @Override
    public RemoveConfigFromMachineGroupResponse RemoveConfigFromMachineGroup(RemoveConfigFromMachineGroupRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String groupName = request.GetGroupName();
        CodingUtils.validateMachineGroup(groupName);
        String configName = request.GetConfigName();
        CodingUtils.validateConfig(configName);
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/machinegroups/" + groupName + "/configs/" + configName;
        Map<String, String> urlParameter = request.GetAllParams();
        ResponseMessage response = this.SendData(project, HttpMethod.DELETE, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        return new RemoveConfigFromMachineGroupResponse(resHeaders);
    }

    private List<String> ExtractJsonArray(String nodeKey, JSONObject object) {
        try {
            return JsonUtils.readOptionalStrings(object, nodeKey);
        }
        catch (JSONException e) {
            return new ArrayList<String>();
        }
    }

    void ErrorCheck(JSONObject object, String requestId, int httpCode, String response) throws LogException {
        if (object.containsKey("errorCode")) {
            try {
                String errorCode = object.getString("errorCode");
                String errorMessage = object.getString("errorMessage");
                throw new LogException(httpCode, errorCode, errorMessage, requestId, response);
            }
            catch (JSONException e) {
                throw new LogException(httpCode, "InvalidErrorResponse", "Error response is not a valid error json : \n" + object.toString(), requestId);
            }
        }
        throw new LogException(httpCode, "InvalidErrorResponse", "Error response is not a valid error json : \n" + object.toString(), requestId);
    }

    private void ExtractResponseBody(ResponseMessage response) throws LogException {
        InputStream in = response.getContent();
        if (in == null) {
            return;
        }
        ByteArrayOutputStream bytestream = new ByteArrayOutputStream();
        String requestId = this.GetRequestId(response.getHeaders());
        try {
            int ch;
            byte[] cache = new byte[1024];
            while ((ch = in.read(cache, 0, 1024)) != -1) {
                bytestream.write(cache, 0, ch);
            }
        }
        catch (IOException e) {
            throw new LogException("BadResponse", "Io exception happened when parse the response data : ", e, requestId);
        }
        response.SetBody(bytestream.toByteArray());
    }

    private JSONObject parseResponseBody(ResponseMessage response, String requestId) throws LogException {
        String body = Client.encodeResponseBodyToUtf8String(response, requestId);
        try {
            return JSONObject.parseObject(body, Feature.DisableSpecialKeyDetect);
        }
        catch (JSONException ex) {
            throw new LogException("BadResponse", "The response is not valid json string : " + body, ex, requestId);
        }
    }

    JSONArray ParseResponseMessageToArray(ResponseMessage response, String requestId) throws LogException {
        String returnStr = Client.encodeResponseBodyToUtf8String(response, requestId);
        try {
            return JSONArray.parseArray(returnStr);
        }
        catch (JSONException e) {
            throw new LogException("BadResponse", "The response is not valid json string : " + returnStr, e, requestId);
        }
    }

    private Map<String, String> GetCommonHeadPara(String project) {
        ClientConfiguration clientConfiguration;
        HashMap<String, String> headParameter = new HashMap<String, String>();
        headParameter.put("User-Agent", this.userAgent);
        headParameter.put("x-log-bodyrawsize", "0");
        headParameter.put("Content-Type", "application/x-protobuf");
        if (!project.isEmpty()) {
            headParameter.put("Host", project + "." + this.hostName);
        } else {
            headParameter.put("Host", this.hostName);
        }
        headParameter.put("x-log-apiversion", "0.6.0");
        if (this.realIpForConsole != null && !this.realIpForConsole.isEmpty()) {
            headParameter.put("x-log-ip", this.realIpForConsole);
        }
        if (this.useSSLForConsole != null) {
            headParameter.put("x-log-ssl", this.useSSLForConsole != false ? "true" : "false");
        }
        if ((clientConfiguration = this.serviceClient.getClientConfiguration()) != null) {
            headParameter.putAll(clientConfiguration.getDefaultHeaders());
        }
        return headParameter;
    }

    private ResponseMessage SendDataWithResolveResponse(String project, HttpMethod method, String resourceUri, Map<String, String> urlParams, Map<String, String> headParams) throws LogException {
        return this.SendDataWithResolveResponse(project, method, resourceUri, urlParams, headParams, new byte[0]);
    }

    protected ResponseMessage SendDataWithResolveResponse(String project, HttpMethod method, String resourceUri, Map<String, String> parameters, Map<String, String> headers, byte[] body) throws LogException {
        return this.SendDataWithResolveResponse(project, method, resourceUri, parameters, headers, body, null, null);
    }

    private ResponseMessage SendDataWithResolveResponse(String project, HttpMethod method, String resourceUri, Map<String, String> parameters, Map<String, String> headers, byte[] body, Map<String, String> outputHeader, String serverIp) throws LogException {
        if (this.resourceOwnerAccount != null && !this.resourceOwnerAccount.isEmpty()) {
            headers.put("x-log-resourceowneraccount", this.resourceOwnerAccount);
        }
        this.signer.sign(method, headers, resourceUri, parameters, body);
        URI uri = serverIp == null ? this.GetHostURI(project) : this.GetHostURIByIp(serverIp);
        RequestMessage request = Client.BuildRequest(uri, method, resourceUri, parameters, headers, new ByteArrayInputStream(body), body.length);
        ResponseMessage response = null;
        try {
            response = this.serviceClient.sendRequest(request, "UTF-8");
        }
        catch (ServiceException e) {
            throw new LogException("RequestError", "Web request failed: " + e.getMessage(), e, "");
        }
        catch (ClientException e) {
            throw new LogException("RequestError", "Web request failed: " + e.getMessage(), e, "");
        }
        return response;
    }

    private ResponseMessage SendData(String project, HttpMethod method, String resourceUri, Map<String, String> urlParams, Map<String, String> headParams) throws LogException {
        return this.SendData(project, method, resourceUri, urlParams, headParams, new byte[0]);
    }

    protected ResponseMessage SendData(String project, HttpMethod method, String resourceUri, Map<String, String> parameters, Map<String, String> headers, String requestBody) throws LogException {
        byte[] body = Client.encodeToUtf8(requestBody);
        return this.SendData(project, method, resourceUri, parameters, headers, body);
    }

    protected ResponseMessage SendData(String project, HttpMethod method, String resourceUri, Map<String, String> parameters, Map<String, String> headers, byte[] body) throws LogException {
        return this.SendData(project, method, resourceUri, parameters, headers, body, null, null);
    }

    private ResponseMessage SendData(String project, HttpMethod method, String resourceUri, Map<String, String> parameters, Map<String, String> headers, byte[] body, Map<String, String> outputHeader, String serverIp) throws LogException {
        ResponseMessage response;
        block17: {
            if (this.resourceOwnerAccount != null && !this.resourceOwnerAccount.isEmpty()) {
                headers.put("x-log-resourceowneraccount", this.resourceOwnerAccount);
            }
            this.signer.sign(method, headers, resourceUri, parameters, body);
            URI uri = serverIp == null ? this.GetHostURI(project) : this.GetHostURIByIp(serverIp);
            RequestMessage request = Client.BuildRequest(uri, method, resourceUri, parameters, headers, new ByteArrayInputStream(body), body.length);
            response = null;
            try {
                int statusCode;
                response = this.serviceClient.sendRequest(request, "UTF-8");
                this.ExtractResponseBody(response);
                if (outputHeader != null) {
                    outputHeader.putAll(response.getHeaders());
                }
                if ((statusCode = response.getStatusCode()) == 200) break block17;
                String requestId = this.GetRequestId(response.getHeaders());
                try {
                    String responseBody = Client.encodeResponseBodyToUtf8String(response, requestId);
                    try {
                        JSONObject object = JSONObject.parseObject(responseBody, Feature.DisableSpecialKeyDetect);
                        this.ErrorCheck(object, requestId, statusCode, responseBody);
                    }
                    catch (JSONException ex) {
                        throw new LogException("BadResponse", "The response is not valid json string : " + body, ex, requestId);
                    }
                }
                catch (LogException ex) {
                    ex.setHttpCode(response.getStatusCode());
                    throw ex;
                }
            }
            catch (ServiceException e) {
                throw new LogException("RequestError", "Web request failed: " + e.getMessage(), e, "");
            }
            catch (ClientException e) {
                throw new LogException("RequestError", "Web request failed: " + e.getMessage(), e, "");
            }
            finally {
                try {
                    if (response != null) {
                        response.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return response;
    }

    private static RequestMessage BuildRequest(URI endpoint, HttpMethod httpMethod, String resourceUri, Map<String, String> parameters, Map<String, String> headers, InputStream content, long size) {
        RequestMessage request = new RequestMessage();
        request.setMethod(httpMethod);
        request.setEndpoint(endpoint);
        request.setResourcePath(resourceUri);
        request.setParameters(parameters);
        request.setHeaders(headers);
        request.setContent(content);
        request.setContentLength(size);
        return request;
    }

    ArrayList<Shard> ExtractShards(JSONArray array, String requestId) throws LogException {
        ArrayList<Shard> shards = new ArrayList<Shard>();
        if (array == null) {
            return shards;
        }
        try {
            for (int i = 0; i < array.size(); ++i) {
                JSONObject shardDict = array.getJSONObject(i);
                if (shardDict == null) continue;
                int shardId = shardDict.getIntValue("shardID");
                String status = shardDict.getString("status");
                String begin = shardDict.getString("inclusiveBeginKey");
                String end = shardDict.getString("exclusiveEndKey");
                int createTime = shardDict.getIntValue("createTime");
                Shard shard = new Shard(shardId, status, begin, end, createTime);
                if (shardDict.containsKey("serverIp")) {
                    shard.setServerIp(shardDict.getString("serverIp"));
                }
                shards.add(shard);
            }
        }
        catch (JSONException e) {
            throw new LogException("BadResponse", "The response is not valid shard json array string : " + array.toString() + e.getMessage(), e, requestId);
        }
        return shards;
    }

    @Override
    public UpdateLogStoreInternalResponse UpdateLogStoreInternal(String project, InternalLogStore internalLogStore) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertParameterNotNull(internalLogStore, "InternallogStore");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        byte[] body = Client.encodeToUtf8(internalLogStore.ToRequestString());
        headParameter.put("Content-Type", "application/json");
        String resourceUri = "/logstores/" + internalLogStore.GetLogStoreName();
        Map<String, String> urlParameter = Collections.singletonMap("type", "inner");
        ResponseMessage response = this.SendData(project, HttpMethod.PUT, resourceUri, urlParameter, headParameter, body);
        Map<String, String> resHeaders = response.getHeaders();
        return new UpdateLogStoreInternalResponse(resHeaders);
    }

    @Override
    public CreateLogStoreInternalResponse CreateLogStoreInternal(String project, InternalLogStore internalLogStore) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertParameterNotNull(internalLogStore, "InternallogStore");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        byte[] body = Client.encodeToUtf8(internalLogStore.ToRequestString());
        headParameter.put("Content-Type", "application/json");
        String resourceUri = "/logstores";
        Map<String, String> urlParameter = Collections.singletonMap("type", "inner");
        ResponseMessage response = this.SendData(project, HttpMethod.POST, resourceUri, urlParameter, headParameter, body);
        Map<String, String> resHeaders = response.getHeaders();
        return new CreateLogStoreInternalResponse(resHeaders);
    }

    @Override
    public CreateLogStoreResponse CreateLogStore(String project, LogStore logStore) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertParameterNotNull(logStore, "logStore");
        return this.CreateLogStore(new CreateLogStoreRequest(project, logStore));
    }

    @Override
    public CreateLogStoreResponse CreateLogStore(CreateLogStoreRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        LogStore logStore = request.GetLogStore();
        CodingUtils.assertParameterNotNull(logStore, "logStore");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        byte[] body = Client.encodeToUtf8(logStore.ToRequestString());
        headParameter.put("Content-Type", "application/json");
        String resourceUri = "/logstores";
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(project, HttpMethod.POST, resourceUri, urlParameter, headParameter, body);
        Map<String, String> resHeaders = response.getHeaders();
        return new CreateLogStoreResponse(resHeaders);
    }

    @Override
    public CreateLinkStoreResponse CreateLinkStore(String project, LinkStore linkStore) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertParameterNotNull(linkStore, "logStore");
        return this.CreateLinkStore(new CreateLinkStoreRequest(project, linkStore));
    }

    @Override
    public CreateLinkStoreResponse CreateLinkStore(CreateLinkStoreRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        LinkStore linkStore = request.getLinkStore();
        CodingUtils.assertParameterNotNull(linkStore, "linkStore");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        byte[] body = Client.encodeToUtf8(linkStore.ToRequestString());
        headParameter.put("Content-Type", "application/json");
        String resourceUri = "/logstores";
        Map<String, String> urlParameter = request.GetAllParams();
        ResponseMessage response = this.SendData(project, HttpMethod.POST, resourceUri, urlParameter, headParameter, body);
        Map<String, String> resHeaders = response.getHeaders();
        return new CreateLinkStoreResponse(resHeaders);
    }

    @Override
    public DeleteLogStoreResponse DeleteLogStore(String project, String logStoreName) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(logStoreName, "logStoreName");
        return this.DeleteLogStore(new DeleteLogStoreRequest(project, logStoreName));
    }

    @Override
    public DeleteLogStoreResponse DeleteLogStore(DeleteLogStoreRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String logStoreName = request.GetLogStoreName();
        CodingUtils.validateLogstore(logStoreName);
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/logstores/" + logStoreName;
        Map<String, String> urlParameter = request.GetAllParams();
        ResponseMessage response = this.SendData(project, HttpMethod.DELETE, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        return new DeleteLogStoreResponse(resHeaders);
    }

    @Override
    public DeleteLinkStoreResponse DeleteLinkStore(String project, String linkStoreName) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(linkStoreName, "linkStoreName");
        return this.DeleteLinkStore(new DeleteLinkStoreRequest(project, linkStoreName));
    }

    @Override
    public DeleteLinkStoreResponse DeleteLinkStore(DeleteLinkStoreRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String linkStoreName = request.getLinkStoreName();
        CodingUtils.validateLogstore(linkStoreName);
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/logstores/" + linkStoreName;
        Map<String, String> urlParameter = request.GetAllParams();
        ResponseMessage response = this.SendData(project, HttpMethod.DELETE, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        return new DeleteLinkStoreResponse(resHeaders);
    }

    @Override
    public ClearLogStoreStorageResponse ClearLogStoreStorage(String project, String logStoreName) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(logStoreName, "logStoreName");
        return this.ClearLogStoreStorage(new ClearLogStoreStorageRequest(project, logStoreName));
    }

    @Override
    public CreateProjectConsumerGroupResponse CreateProjectConsumerGroup(CreateProjectConsumerGroupRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        ProjectConsumerGroup projectConsumerGroup = request.getConsumerGroup();
        CodingUtils.assertParameterNotNull(projectConsumerGroup, "consumerGroup");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        byte[] body = Client.encodeToUtf8(projectConsumerGroup.ToRequestString());
        headParameter.put("Content-Type", "application/json");
        String resourceUri = "/consumergroups";
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(project, HttpMethod.POST, resourceUri, urlParameter, headParameter, body);
        Map<String, String> resHeaders = response.getHeaders();
        return new CreateProjectConsumerGroupResponse(resHeaders);
    }

    @Override
    public CreateProjectConsumerGroupResponse CreateProjectConsumerGroup(String project, ProjectConsumerGroup consumerGroup) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        return this.CreateProjectConsumerGroup(new CreateProjectConsumerGroupRequest(project, consumerGroup));
    }

    @Override
    public DeleteProjectConsumerGroupResponse DeleteProjectConsumerGroup(String project, String consumerGroup) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.validateConsumerGroup(consumerGroup);
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/consumergroups/" + consumerGroup;
        headParameter.put("Content-Type", String.valueOf(0));
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(project, HttpMethod.DELETE, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        return new DeleteProjectConsumerGroupResponse(resHeaders);
    }

    @Override
    public ListProjectConsumerGroupResponse ListProjectConsumerGroup(String project) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String resourceUri = "/consumergroups";
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        headParameter.put("Content-Type", "application/json");
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
        ArrayList<ProjectConsumerGroup> consumerGroups = new ArrayList<ProjectConsumerGroup>();
        Map<String, String> resHeaders = response.getHeaders();
        String requestId = this.GetRequestId(resHeaders);
        JSONArray array = this.ParseResponseMessageToArray(response, requestId);
        this.ExtractProjectConsumerGroup(array, requestId, consumerGroups);
        ListProjectConsumerGroupResponse listProjectConsumerGroupResponse = new ListProjectConsumerGroupResponse(resHeaders);
        listProjectConsumerGroupResponse.setConsumerGroups(consumerGroups);
        return listProjectConsumerGroupResponse;
    }

    @Override
    public UpdateProjectConsumerGroupResponse UpdateProjectConsumerGroup(String project, String consumerGroup, boolean inOrder, int timeoutInSec) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.validateConsumerGroup(consumerGroup);
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        JSONObject asJson = new JSONObject();
        asJson.put("order", (Object)inOrder);
        asJson.put("timeout", (Object)timeoutInSec);
        byte[] body = Client.encodeToUtf8(asJson.toString());
        headParameter.put("Content-Type", "application/json");
        String resourceUri = "/consumergroups/" + consumerGroup;
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(project, HttpMethod.PUT, resourceUri, urlParameter, headParameter, body);
        Map<String, String> resHeaders = response.getHeaders();
        return new UpdateProjectConsumerGroupResponse(resHeaders);
    }

    @Override
    public ProjectConsumerGroupUpdateCheckPointResponse UpdateProjectConsumerGroupCheckPoint(String project, String consumerGroup, String consumer, String logStore, int shard, String checkpoint) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.validateConsumerGroup(consumerGroup);
        CodingUtils.assertStringNotNullOrEmpty(consumer, "consumer");
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        CodingUtils.assertStringNotNullOrEmpty(checkpoint, "checkpoint");
        return this.UpdateProjectConsumerGroupCheckPoint(project, consumerGroup, consumer, logStore, shard, checkpoint, false);
    }

    @Override
    public ProjectConsumerGroupUpdateCheckPointResponse UpdateProjectConsumerGroupCheckPoint(String project, String consumerGroup, String logStore, int shard, String checkpoint) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.validateConsumerGroup(consumerGroup);
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        CodingUtils.assertStringNotNullOrEmpty(checkpoint, "checkpoint");
        return this.UpdateProjectConsumerGroupCheckPoint(project, consumerGroup, "", logStore, shard, checkpoint, true);
    }

    private ProjectConsumerGroupUpdateCheckPointResponse UpdateProjectConsumerGroupCheckPoint(String project, String consumerGroup, String consumer, String logStore, int shard, String checkpoint, boolean forceSuccess) throws LogException {
        String resourceUri = "/consumergroups/" + consumerGroup;
        ProjectConsumerGroupUpdateCheckPointRequest request = new ProjectConsumerGroupUpdateCheckPointRequest(project, consumerGroup, consumer, logStore, shard, checkpoint, forceSuccess);
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        headParameter.put("Content-Type", "application/json");
        Map<String, String> urlParameter = request.GetAllParams();
        byte[] body = Client.encodeToUtf8(request.GetRequestBody());
        ResponseMessage response = this.SendData(project, HttpMethod.POST, resourceUri, urlParameter, headParameter, body);
        Map<String, String> resHeaders = response.getHeaders();
        return new ProjectConsumerGroupUpdateCheckPointResponse(resHeaders);
    }

    @Override
    public ProjectConsumerGroupCheckPointResponse GetProjectConsumerGroupCheckPoint(String project, String consumerGroup, String logStore, int shard) throws LogException {
        ProjectConsumerGroupGetCheckPointRequest request = new ProjectConsumerGroupGetCheckPointRequest(project, consumerGroup, logStore, shard);
        Map<String, String> urlParameter = request.GetAllParams();
        String resourceUri = "/consumergroups/" + consumerGroup;
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        headParameter.put("Content-Type", "application/json");
        ResponseMessage response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        String requestId = this.GetRequestId(resHeaders);
        JSONObject object = this.parseResponseBody(response, requestId);
        return new ProjectConsumerGroupCheckPointResponse(resHeaders, object);
    }

    @Override
    public ProjectConsumerGroupCheckPointResponse GetProjectConsumerGroupCheckPoint(String project, String consumerGroup, String logStore) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.validateConsumerGroup(consumerGroup);
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        return this.GetProjectConsumerGroupCheckPoint(project, consumerGroup, logStore, -1);
    }

    @Override
    public ProjectConsumerGroupCheckPointResponse GetProjectConsumerGroupCheckPoint(String project, String consumerGroup) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.validateConsumerGroup(consumerGroup);
        return this.GetProjectConsumerGroupCheckPoint(project, consumerGroup, "", -1);
    }

    @Override
    public ProjectConsumerGroupHeartBeatResponse ProjectConsumerGroupHeartBeat(String project, String consumerGroup, String consumer, Map<String, ArrayList<Integer>> logStoreShards) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.validateConsumerGroup(consumerGroup);
        CodingUtils.assertStringNotNullOrEmpty(consumer, "consumer");
        String resourceUri = "/consumergroups/" + consumerGroup;
        ProjectConsumerGroupHeartBeatRequest request = new ProjectConsumerGroupHeartBeatRequest(project, consumer, logStoreShards == null ? new HashMap() : logStoreShards);
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        Map<String, String> urlParameter = request.GetAllParams();
        byte[] body = Client.encodeToUtf8(request.GetRequestBody());
        headParameter.put("Content-Type", "application/json");
        ResponseMessage response = this.SendData(project, HttpMethod.POST, resourceUri, urlParameter, headParameter, body);
        Map<String, String> resHeaders = response.getHeaders();
        String requestId = this.GetRequestId(resHeaders);
        JSONObject object = this.parseResponseBody(response, requestId);
        return new ProjectConsumerGroupHeartBeatResponse(resHeaders, object);
    }

    @Override
    public ClearLogStoreStorageResponse ClearLogStoreStorage(ClearLogStoreStorageRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String logStoreName = request.GetLogStoreName();
        CodingUtils.validateLogstore(logStoreName);
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/logstores/" + logStoreName + "/storage";
        Map<String, String> urlParameter = request.GetAllParams();
        ResponseMessage response = this.SendData(project, HttpMethod.DELETE, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        return new ClearLogStoreStorageResponse(resHeaders);
    }

    @Override
    public UpdateLogStoreResponse UpdateLogStore(String project, LogStore logStore) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertParameterNotNull(logStore, "logStore");
        return this.UpdateLogStore(new UpdateLogStoreRequest(project, logStore));
    }

    @Override
    public UpdateLogStoreResponse UpdateLogStore(UpdateLogStoreRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        LogStore logStore = request.GetLogStore();
        CodingUtils.assertParameterNotNull(logStore, "logStore");
        String logStoreName = logStore.GetLogStoreName();
        CodingUtils.validateLogstore(logStoreName);
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        byte[] body = Client.encodeToUtf8(logStore.ToRequestString());
        headParameter.put("Content-Type", "application/json");
        String resourceUri = "/logstores/" + logStoreName;
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(project, HttpMethod.PUT, resourceUri, urlParameter, headParameter, body);
        Map<String, String> resHeaders = response.getHeaders();
        return new UpdateLogStoreResponse(resHeaders);
    }

    @Override
    public GetLogStoreResponse GetLogStore(String project, String logStoreName) throws LogException {
        CodingUtils.validateProject(project);
        CodingUtils.validateLogstore(logStoreName);
        return this.GetLogStore(new GetLogStoreRequest(project, logStoreName));
    }

    private LogStore ExtractLogStoreFromResponse(JSONObject dict, String requestId) throws LogException {
        LogStore logStore = new LogStore();
        try {
            logStore.FromJsonString(dict.toString());
        }
        catch (LogException e) {
            throw new LogException(e.GetErrorCode(), e.GetErrorMessage(), e.getCause(), requestId);
        }
        return logStore;
    }

    @Override
    public GetLogStoreResponse GetLogStore(GetLogStoreRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String logStoreName = request.GetLogStore();
        CodingUtils.validateLogstore(logStoreName);
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/logstores/" + logStoreName;
        Map<String, String> urlParameter = request.GetAllParams();
        ResponseMessage response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        String requestId = this.GetRequestId(resHeaders);
        JSONObject object = this.parseResponseBody(response, requestId);
        LogStore logStore = this.ExtractLogStoreFromResponse(object, requestId);
        return new GetLogStoreResponse(resHeaders, logStore);
    }

    @Override
    public CreateLogStoreResponse createMetricStore(String project, LogStore metricStore) throws LogException {
        metricStore.setTelemetryType("Metrics");
        CreateLogStoreResponse createLogStoreResponse = this.CreateLogStore(project, metricStore);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            throw new LogException("Sleep Interrupted", e.getMessage(), "");
        }
        ArrayList<SubStoreKey> list = new ArrayList<SubStoreKey>();
        list.add(new SubStoreKey("__name__", "text"));
        list.add(new SubStoreKey("__labels__", "text"));
        list.add(new SubStoreKey("__time_nano__", "long"));
        list.add(new SubStoreKey("__value__", "double"));
        SubStore subStore = new SubStore("prom", metricStore.GetTtl(), 2, 2, list);
        this.createSubStore(project, metricStore.GetLogStoreName(), subStore);
        return createLogStoreResponse;
    }

    @Override
    public CreateLogStoreResponse createMetricStore(CreateLogStoreRequest request) throws LogException {
        return this.createMetricStore(request.GetProject(), request.GetLogStore());
    }

    @Override
    public UpdateLogStoreResponse updateMetricStore(String project, LogStore metricStore) throws LogException {
        metricStore.setTelemetryType("Metrics");
        UpdateLogStoreResponse updateLogStoreResponse = this.UpdateLogStore(project, metricStore);
        this.updateSubStoreTTL(project, metricStore.GetLogStoreName(), metricStore.GetTtl());
        return updateLogStoreResponse;
    }

    @Override
    public UpdateLogStoreResponse updateMetricStore(UpdateLogStoreRequest request) throws LogException {
        return this.updateMetricStore(request.GetProject(), request.GetLogStore());
    }

    @Override
    public DeleteLogStoreResponse deleteMetricStore(String project, String metricStoreName) throws LogException {
        return this.DeleteLogStore(project, metricStoreName);
    }

    @Override
    public DeleteLogStoreResponse deleteMetricStore(DeleteLogStoreRequest request) throws LogException {
        return this.deleteMetricStore(request.GetProject(), request.GetLogStoreName());
    }

    @Override
    public GetLogStoreResponse getMetricStore(String project, String metricStoreName) throws LogException {
        return this.GetLogStore(project, metricStoreName);
    }

    @Override
    public GetLogStoreResponse getMetricStore(GetLogStoreRequest request) throws LogException {
        return this.getMetricStore(request.GetProject(), request.GetLogStore());
    }

    @Override
    public ListSubStoreResponse listSubStore(String project, String logstore) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(logstore, "logstore");
        return this.listSubStore(new ListSubStoreRequest(project, logstore));
    }

    @Override
    public ListSubStoreResponse listSubStore(ListSubStoreRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        Map<String, String> urlParameter = request.GetAllParams();
        CodingUtils.validateLogstore(request.getLogstoreName());
        String resourceUri = "/logstores/" + request.getLogstoreName() + "/substores";
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        ResponseMessage response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        String requestId = this.GetRequestId(resHeaders);
        JSONObject object = this.parseResponseBody(response, requestId);
        ListSubStoreResponse listSubStoreResponse = new ListSubStoreResponse(resHeaders);
        listSubStoreResponse.setSubStoreNames(this.ExtractJsonArray("substores", object));
        return listSubStoreResponse;
    }

    @Override
    public GetSubStoreResponse getSubStore(String project, String logstore, String subStoreName) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(logstore, "logstore");
        CodingUtils.assertStringNotNullOrEmpty(subStoreName, "subStoreName");
        return this.getSubStore(new GetSubStoreRequest(project, logstore, subStoreName));
    }

    @Override
    public GetSubStoreResponse getSubStore(GetSubStoreRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String subStoreName = request.getSubStoreName();
        CodingUtils.assertStringNotNullOrEmpty(project, "subStoreName");
        Map<String, String> urlParameter = request.GetAllParams();
        CodingUtils.validateLogstore(request.getLogstoreName());
        String resourceUri = "/logstores/" + request.getLogstoreName() + "/substores/" + subStoreName;
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        ResponseMessage response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        String requestId = this.GetRequestId(resHeaders);
        JSONObject object = this.parseResponseBody(response, requestId);
        SubStore subStore = new SubStore();
        subStore.fromJsonString(object.toString());
        return new GetSubStoreResponse(resHeaders, subStore);
    }

    @Override
    public CreateSubStoreResponse createSubStore(String project, String logStoreName, SubStore subStore) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertParameterNotNull(logStoreName, "logStoreName");
        CodingUtils.assertParameterNotNull(subStore, "subStore");
        return this.createSubStore(new CreateSubStoreRequest(project, logStoreName, subStore));
    }

    @Override
    public CreateSubStoreResponse createSubStore(CreateSubStoreRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String logStoreName = request.getLogStoreName();
        CodingUtils.validateLogstore(logStoreName);
        SubStore subStore = request.getSubStore();
        CodingUtils.assertParameterNotNull(subStore, "subStore");
        if (!subStore.isValid()) {
            throw new IllegalArgumentException("SubStore is invalid");
        }
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        byte[] body = Client.encodeToUtf8(subStore.toRequestString());
        headParameter.put("Content-Type", "application/json");
        String resourceUri = "/logstores/" + logStoreName + "/substores";
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(project, HttpMethod.POST, resourceUri, urlParameter, headParameter, body);
        Map<String, String> resHeaders = response.getHeaders();
        return new CreateSubStoreResponse(resHeaders);
    }

    @Override
    public UpdateSubStoreResponse updateSubStore(String project, String logStoreName, SubStore subStore) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertParameterNotNull(logStoreName, "logStoreName");
        CodingUtils.assertParameterNotNull(subStore, "subStore");
        return this.updateSubStore(new UpdateSubStoreRequest(project, logStoreName, subStore));
    }

    @Override
    public UpdateSubStoreResponse updateSubStore(UpdateSubStoreRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String logStoreName = request.getLogStoreName();
        CodingUtils.validateLogstore(logStoreName);
        SubStore subStore = request.getSubStore();
        CodingUtils.assertParameterNotNull(subStore, "subStore");
        if (!subStore.isValid()) {
            throw new IllegalArgumentException("SubStore is invalid");
        }
        String subStoreName = subStore.getName();
        CodingUtils.assertStringNotNullOrEmpty(subStoreName, "subStoreName");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        byte[] body = Client.encodeToUtf8(subStore.toRequestString());
        headParameter.put("Content-Type", "application/json");
        String resourceUri = "/logstores/" + logStoreName + "/substores/" + subStoreName;
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(project, HttpMethod.PUT, resourceUri, urlParameter, headParameter, body);
        Map<String, String> resHeaders = response.getHeaders();
        return new UpdateSubStoreResponse(resHeaders);
    }

    @Override
    public DeleteSubStoreResponse deleteSubStore(String project, String logStoreName, String subStoreName) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(logStoreName, "logStoreName");
        CodingUtils.assertStringNotNullOrEmpty(subStoreName, "subStoreName");
        return this.deleteSubStore(new DeleteSubStoreRequest(project, logStoreName, subStoreName));
    }

    @Override
    public DeleteSubStoreResponse deleteSubStore(DeleteSubStoreRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String logStoreName = request.getLogStoreName();
        CodingUtils.validateLogstore(logStoreName);
        String subStoreName = request.getSubStoreName();
        CodingUtils.assertStringNotNullOrEmpty(subStoreName, "subStoreName");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/logstores/" + logStoreName + "/substores/" + subStoreName;
        Map<String, String> urlParameter = request.GetAllParams();
        ResponseMessage response = this.SendData(project, HttpMethod.DELETE, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        return new DeleteSubStoreResponse(resHeaders);
    }

    @Override
    public GetSubStoreTTLResponse getSubStoreTTL(String project, String logstoreName) throws LogException {
        return this.getSubStoreTTL(new GetSubStoreTTLResquest(project, logstoreName));
    }

    @Override
    public GetSubStoreTTLResponse getSubStoreTTL(GetSubStoreTTLResquest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        Map<String, String> urlParameter = request.GetAllParams();
        String logstoreName = request.getLogstoreName();
        CodingUtils.validateLogstore(logstoreName);
        String resourceUri = "/logstores/" + logstoreName + "/substores/storage/ttl";
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        ResponseMessage response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        String requestId = this.GetRequestId(resHeaders);
        JSONObject object = this.parseResponseBody(response, requestId);
        GetSubStoreTTLResponse getSubStoreTTLResponse = new GetSubStoreTTLResponse(resHeaders);
        int ttl = object.getIntValue("ttl");
        getSubStoreTTLResponse.setTtl(ttl);
        return getSubStoreTTLResponse;
    }

    @Override
    public UpdateSubStoreTTLResponse updateSubStoreTTL(String project, String logstore, int ttl) throws LogException {
        return this.updateSubStoreTTL(new UpdateSubStoreTTLRequest(project, logstore, ttl));
    }

    @Override
    public UpdateSubStoreTTLResponse updateSubStoreTTL(UpdateSubStoreTTLRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        Map<String, String> urlParameter = request.GetAllParams();
        String logstoreName = request.getLogstoreName();
        CodingUtils.validateLogstore(logstoreName);
        String resourceUri = "/logstores/" + logstoreName + "/substores/storage/ttl";
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        ResponseMessage response = this.SendData(project, HttpMethod.PUT, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        String requestId = this.GetRequestId(resHeaders);
        JSONObject object = this.parseResponseBody(response, requestId);
        UpdateSubStoreTTLResponse updateSubStoreTTLResponse = new UpdateSubStoreTTLResponse(resHeaders);
        return updateSubStoreTTLResponse;
    }

    @Override
    public ListLogStoresResponse listLogStores(String project, int offset, int size, String logstoreName, String telemetryType) throws LogException {
        return this.ListLogStores(new ListLogStoresRequest(project, offset, size, logstoreName, telemetryType));
    }

    public CreateExternalStoreResponse createExternalStore(CreateExternalStoreRequest request) throws LogException {
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        ExternalStore externalStore = request.getExternalStore();
        CodingUtils.assertParameterNotNull(externalStore, "ExternalStore");
        String externalStoreName = externalStore.getExternalStoreName();
        CodingUtils.assertStringNotNullOrEmpty(externalStoreName, "externalStoreName");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        byte[] body = Client.encodeToUtf8(externalStore.toJson().toJSONString());
        headParameter.put("Content-Type", "application/json");
        String resourceUri = "/externalstores";
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(project, HttpMethod.POST, resourceUri, urlParameter, headParameter, body);
        Map<String, String> resHeaders = response.getHeaders();
        return new CreateExternalStoreResponse(resHeaders);
    }

    public DeleteExternalStoreResponse deleteExternalStore(DeleteExternalStoreRequest request) throws LogException {
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String externalStoreName = request.getExternalStoreName();
        CodingUtils.assertStringNotNullOrEmpty(externalStoreName, "externalStoreName");
        Map<String, String> urlParameter = request.GetAllParams();
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/externalstores/" + externalStoreName;
        ResponseMessage response = this.SendData(project, HttpMethod.DELETE, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        return new DeleteExternalStoreResponse(resHeaders);
    }

    public UpdateExternalStoreResponse updateExternalStore(UpdateExternalStoreRequest request) throws LogException {
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        ExternalStore externalStore = request.getExternalStore();
        CodingUtils.assertParameterNotNull(externalStore, "ExternalStore");
        String externalStoreName = externalStore.getExternalStoreName();
        CodingUtils.assertParameterNotNull(externalStoreName, "externalStoreName");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        byte[] body = Client.encodeToUtf8(externalStore.toJson().toJSONString());
        headParameter.put("Content-Type", "application/json");
        String resourceUri = "/externalstores/" + externalStoreName;
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(project, HttpMethod.PUT, resourceUri, urlParameter, headParameter, body);
        Map<String, String> resHeaders = response.getHeaders();
        return new UpdateExternalStoreResponse(resHeaders);
    }

    public GetExternalStoreResponse getExternalStore(GetExternalStoreRequest request) throws LogException {
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String externalStoreName = request.getExternalStoreName();
        CodingUtils.assertStringNotNullOrEmpty(externalStoreName, "externalStoreName");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/externalstores/" + externalStoreName;
        Map<String, String> urlParameter = request.GetAllParams();
        ResponseMessage response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        String requestId = this.GetRequestId(resHeaders);
        JSONObject object = this.parseResponseBody(response, requestId);
        ExternalStore externalStore = new ExternalStore(object);
        externalStore.setExternalStoreName(externalStoreName);
        return new GetExternalStoreResponse(resHeaders, externalStore);
    }

    public ListExternalStroesResponse listExternalStores(ListExternalStoresRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        Map<String, String> urlParameter = request.GetAllParams();
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/externalstores";
        ResponseMessage response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        String requestId = this.GetRequestId(resHeaders);
        JSONObject object = this.parseResponseBody(response, requestId);
        ListExternalStroesResponse listExternalStroesResponse = new ListExternalStroesResponse(resHeaders);
        listExternalStroesResponse.setExternalStores(this.ExtractJsonArray("externalstores", object));
        listExternalStroesResponse.setTotal(object.getIntValue("total"));
        listExternalStroesResponse.setCount(object.getIntValue("count"));
        return listExternalStroesResponse;
    }

    @Override
    public CreateIndexResponse CreateIndex(String project, String logStore, String indexJsonString) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.validateLogstore(logStore);
        CodingUtils.assertParameterNotNull(indexJsonString, "indexJsonString");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        byte[] body = Client.encodeToUtf8(indexJsonString);
        headParameter.put("Content-Type", "application/json");
        String resourceUri = "/logstores/" + logStore + "/index";
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(project, HttpMethod.POST, resourceUri, urlParameter, headParameter, body);
        Map<String, String> resHeaders = response.getHeaders();
        return new CreateIndexResponse(resHeaders);
    }

    @Override
    public CreateIndexResponse CreateIndex(String project, String logStore, Index index) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        CodingUtils.assertParameterNotNull(index, "index");
        return this.CreateIndex(new CreateIndexRequest(project, logStore, index));
    }

    @Override
    public CreateIndexResponse CreateIndex(CreateIndexRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String logStore = request.GetLogStore();
        CodingUtils.validateLogstore(logStore);
        Index index = request.GetIndex();
        CodingUtils.assertParameterNotNull(index, "index");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        byte[] body = Client.encodeToUtf8(index.ToRequestString());
        headParameter.put("Content-Type", "application/json");
        String resourceUri = "/logstores/" + logStore + "/index";
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(project, HttpMethod.POST, resourceUri, urlParameter, headParameter, body);
        Map<String, String> resHeaders = response.getHeaders();
        return new CreateIndexResponse(resHeaders);
    }

    @Override
    public UpdateIndexResponse UpdateIndex(String project, String logStore, String indexJsonString) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.validateLogstore(logStore);
        CodingUtils.assertParameterNotNull(indexJsonString, "indexJsonString");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        byte[] body = Client.encodeToUtf8(indexJsonString);
        headParameter.put("Content-Type", "application/json");
        String resourceUri = "/logstores/" + logStore + "/index";
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(project, HttpMethod.PUT, resourceUri, urlParameter, headParameter, body);
        Map<String, String> resHeaders = response.getHeaders();
        return new UpdateIndexResponse(resHeaders);
    }

    @Override
    public UpdateIndexResponse UpdateIndex(String project, String logStore, Index index) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        CodingUtils.assertParameterNotNull(index, "index");
        return this.UpdateIndex(new UpdateIndexRequest(project, logStore, index));
    }

    @Override
    public UpdateIndexResponse UpdateIndex(UpdateIndexRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String logStore = request.GetLogStore();
        CodingUtils.validateLogstore(logStore);
        Index index = request.GetIndex();
        CodingUtils.assertParameterNotNull(index, "index");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        byte[] body = Client.encodeToUtf8(index.ToRequestString());
        headParameter.put("Content-Type", "application/json");
        String resourceUri = "/logstores/" + logStore + "/index";
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(project, HttpMethod.PUT, resourceUri, urlParameter, headParameter, body);
        Map<String, String> resHeaders = response.getHeaders();
        return new UpdateIndexResponse(resHeaders);
    }

    @Override
    public DeleteIndexResponse DeleteIndex(String project, String logStore) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        return this.DeleteIndex(new DeleteIndexRequest(project, logStore));
    }

    @Override
    public DeleteIndexResponse DeleteIndex(DeleteIndexRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String logStore = request.GetLogStore();
        CodingUtils.validateLogstore(logStore);
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/logstores/" + logStore + "/index";
        Map<String, String> urlParameter = request.GetAllParams();
        ResponseMessage response = this.SendData(project, HttpMethod.DELETE, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        return new DeleteIndexResponse(resHeaders);
    }

    @Override
    public GetIndexResponse GetIndex(String project, String logStore) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        return this.GetIndex(new GetIndexRequest(project, logStore));
    }

    @Override
    public GetIndexStringResponse GetIndexString(String project, String logStore) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        return this.GetIndexString(new GetIndexRequest(project, logStore));
    }

    private Index ExtractIndexFromResponseWithFastJson(JSONObject dict, String requestId) throws LogException {
        Index index = new Index();
        try {
            index.FromJsonString(dict.toJSONString());
        }
        catch (LogException e) {
            throw new LogException(e.GetErrorCode(), e.GetErrorMessage(), e.getCause(), requestId);
        }
        return index;
    }

    @Override
    public GetIndexResponse GetIndex(GetIndexRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String logStore = request.GetLogStore();
        CodingUtils.validateLogstore(logStore);
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/logstores/" + logStore + "/index";
        Map<String, String> urlParameter = request.GetAllParams();
        ResponseMessage response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        String requestId = this.GetRequestId(resHeaders);
        JSONObject object = this.parseResponseBody(response, requestId);
        Index index = this.ExtractIndexFromResponseWithFastJson(object, requestId);
        return new GetIndexResponse(resHeaders, index);
    }

    @Override
    public GetIndexStringResponse GetIndexString(GetIndexRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String logStore = request.GetLogStore();
        CodingUtils.validateLogstore(logStore);
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/logstores/" + logStore + "/index";
        Map<String, String> urlParameter = request.GetAllParams();
        ResponseMessage response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        return new GetIndexStringResponse(resHeaders, response.GetStringBody());
    }

    @Override
    public CreateShipperResponse CreateShipper(String project, String logStore, String shipperName, ShipperConfig shipConfig) throws LogException {
        CodingUtils.assertParameterNotNull(project, "project");
        CodingUtils.validateLogstore(logStore);
        CodingUtils.assertParameterNotNull(shipperName, "shipperName");
        CodingUtils.assertParameterNotNull(shipConfig, "shipConfig");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        headParameter.put("Content-Type", "application/json");
        String resourceUri = "/logstores/" + logStore + "/shipper";
        JSONObject jsonBody = new JSONObject();
        jsonBody.put("shipperName", (Object)shipperName);
        jsonBody.put("targetType", (Object)shipConfig.GetShipperType());
        jsonBody.put("targetConfiguration", (Object)shipConfig.GetJsonObj());
        byte[] body = Client.encodeToUtf8(jsonBody.toString());
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(project, HttpMethod.POST, resourceUri, urlParameter, headParameter, body);
        Map<String, String> resHeaders = response.getHeaders();
        return new CreateShipperResponse(resHeaders);
    }

    @Override
    public UpdateShipperResponse UpdateShipper(String project, String logStore, String shipperName, ShipperConfig shipConfig) throws LogException {
        CodingUtils.assertParameterNotNull(project, "project");
        CodingUtils.validateLogstore(logStore);
        CodingUtils.validateShipper(shipperName);
        CodingUtils.assertParameterNotNull(shipConfig, "shipConfig");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/logstores/" + logStore + "/shipper/" + shipperName;
        JSONObject jsonBody = new JSONObject();
        jsonBody.put("shipperName", (Object)shipperName);
        jsonBody.put("targetType", (Object)shipConfig.GetShipperType());
        jsonBody.put("targetConfiguration", (Object)shipConfig.GetJsonObj());
        byte[] body = Client.encodeToUtf8(jsonBody.toString());
        headParameter.put("Content-Type", "application/json");
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(project, HttpMethod.PUT, resourceUri, urlParameter, headParameter, body);
        Map<String, String> resHeaders = response.getHeaders();
        return new UpdateShipperResponse(resHeaders);
    }

    @Override
    public DeleteShipperResponse DeleteShipper(String project, String logStore, String shipperName) throws LogException {
        CodingUtils.assertParameterNotNull(project, "project");
        CodingUtils.validateLogstore(logStore);
        CodingUtils.validateShipper(shipperName);
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/logstores/" + logStore + "/shipper/" + shipperName;
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(project, HttpMethod.DELETE, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        return new DeleteShipperResponse(resHeaders);
    }

    @Override
    public GetShipperResponse GetShipperConfig(String project, String logStore, String shipperName) throws LogException {
        ShipperConfig config;
        CodingUtils.assertParameterNotNull(project, "project");
        CodingUtils.validateLogstore(logStore);
        CodingUtils.validateShipper(shipperName);
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/logstores/" + logStore + "/shipper/" + shipperName;
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        String requestId = this.GetRequestId(resHeaders);
        JSONObject object = this.parseResponseBody(response, requestId);
        if (object.containsKey("targetType") && object.getString("targetType").equals("odps")) {
            config = new OdpsShipperConfig();
            config.FromJsonObj(object.getJSONObject("targetConfiguration"));
        } else if (object.containsKey("targetType") && object.getString("targetType").equals("oss")) {
            config = new OssShipperConfig();
            config.FromJsonObj(object.getJSONObject("targetConfiguration"));
        } else {
            throw new LogException("InvalidShipperType", "The return shipper config is:" + object.toString(), null, requestId);
        }
        return new GetShipperResponse(resHeaders, config);
    }

    @Override
    public ListShipperResponse ListShipper(String project, String logStore) throws LogException {
        CodingUtils.assertParameterNotNull(project, "project");
        CodingUtils.validateLogstore(logStore);
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/logstores/" + logStore + "/shipper";
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        String requestId = this.GetRequestId(resHeaders);
        JSONObject object = this.parseResponseBody(response, requestId);
        return new ListShipperResponse(resHeaders, object.getIntValue("count"), object.getIntValue("total"), this.ExtractJsonArray("shipper", object));
    }

    @Override
    public GetShipperTasksResponse GetShipperTasks(String project, String logStore, String shipperName, int startTime, int endTime, String statusType, int offset, int size) throws LogException {
        CodingUtils.assertParameterNotNull(project, "project");
        CodingUtils.validateLogstore(logStore);
        CodingUtils.validateShipper(shipperName);
        CodingUtils.assertParameterNotNull(statusType, "statusType");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/logstores/" + logStore + "/shipper/" + shipperName + "/tasks";
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        urlParameter.put("from", String.valueOf(startTime));
        urlParameter.put("to", String.valueOf(endTime));
        urlParameter.put("status", statusType);
        urlParameter.put("offset", String.valueOf(offset));
        urlParameter.put("size", String.valueOf(size));
        ResponseMessage response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        String requestId = this.GetRequestId(resHeaders);
        JSONObject object = this.parseResponseBody(response, requestId);
        return new GetShipperTasksResponse(resHeaders, object.getIntValue("count"), object.getIntValue("total"), this.ExtractTasksStatisTic(object), this.ExtractShipperTask(object));
    }

    @Override
    public RetryShipperTasksResponse RetryShipperTasks(String project, String logStore, String shipperName, List<String> taskList) throws LogException {
        CodingUtils.assertParameterNotNull(project, "project");
        CodingUtils.validateLogstore(logStore);
        CodingUtils.validateShipper(shipperName);
        CodingUtils.assertParameterNotNull(taskList, "taskList");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/logstores/" + logStore + "/shipper/" + shipperName + "/tasks";
        JSONArray array = new JSONArray();
        array.addAll((Collection<?>)taskList);
        byte[] body = Client.encodeToUtf8(array.toString());
        headParameter.put("Content-Type", "application/json");
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(project, HttpMethod.PUT, resourceUri, urlParameter, headParameter, body);
        Map<String, String> resHeaders = response.getHeaders();
        return new RetryShipperTasksResponse(resHeaders);
    }

    private ShipperTasksStatistic ExtractTasksStatisTic(JSONObject obj) {
        JSONObject statistic_obj = obj.getJSONObject("statistics");
        return new ShipperTasksStatistic(statistic_obj.getIntValue("running"), statistic_obj.getIntValue("success"), statistic_obj.getIntValue("fail"));
    }

    private List<ShipperTask> ExtractShipperTask(JSONObject object) {
        ArrayList<ShipperTask> res = new ArrayList<ShipperTask>();
        JSONArray array = object.getJSONArray("tasks");
        if (array == null) {
            return res;
        }
        for (int i = 0; i < array.size(); ++i) {
            JSONObject item = array.getJSONObject(i);
            if (item == null) continue;
            ShipperTask task = new ShipperTask();
            task.FromJsonObject(item);
            res.add(task);
        }
        return res;
    }

    @Override
    public CreateConsumerGroupResponse CreateConsumerGroup(String project, String logStore, ConsumerGroup consumerGroup) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertParameterNotNull(logStore, "logStore");
        return this.CreateConsumerGroup(new CreateConsumerGroupRequest(project, logStore, consumerGroup));
    }

    @Override
    public CreateConsumerGroupResponse CreateConsumerGroup(CreateConsumerGroupRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        ConsumerGroup consumerGroup = request.GetConsumerGroup();
        CodingUtils.assertParameterNotNull(consumerGroup, "consumerGroup");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        byte[] body = Client.encodeToUtf8(consumerGroup.ToRequestString());
        headParameter.put("Content-Type", "application/json");
        CodingUtils.validateLogstore(request.GetLogStore());
        String resourceUri = "/logstores/" + request.GetLogStore() + "/consumergroups";
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(project, HttpMethod.POST, resourceUri, urlParameter, headParameter, body);
        Map<String, String> resHeaders = response.getHeaders();
        return new CreateConsumerGroupResponse(resHeaders);
    }

    protected UpdateConsumerGroupResponse UpdateConsumerGroup(String project, String logStore, String consumerGroup, Boolean inOrder, Integer timeoutInSec) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.validateLogstore(logStore);
        CodingUtils.assertStringNotNullOrEmpty(consumerGroup, "consumerGroup");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        JSONObject asJson = new JSONObject();
        if (inOrder != null) {
            asJson.put("order", (Object)inOrder);
        }
        if (timeoutInSec != null) {
            asJson.put("timeout", (Object)timeoutInSec);
        }
        byte[] body = Client.encodeToUtf8(asJson.toString());
        headParameter.put("Content-Type", "application/json");
        String resourceUri = "/logstores/" + logStore + "/consumergroups/" + consumerGroup;
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(project, HttpMethod.PUT, resourceUri, urlParameter, headParameter, body);
        Map<String, String> resHeaders = response.getHeaders();
        return new UpdateConsumerGroupResponse(resHeaders);
    }

    @Override
    public UpdateConsumerGroupResponse UpdateConsumerGroup(String project, String logStore, String consumerGroup, boolean inOrder, int timeoutInSec) throws LogException {
        return this.UpdateConsumerGroup(project, logStore, consumerGroup, (Boolean)inOrder, (Integer)timeoutInSec);
    }

    @Override
    public UpdateConsumerGroupResponse UpdateConsumerGroup(String project, String logStore, String consumerGroup, boolean inOrder) throws LogException {
        return this.UpdateConsumerGroup(project, logStore, consumerGroup, (Boolean)inOrder, null);
    }

    @Override
    public UpdateConsumerGroupResponse UpdateConsumerGroup(String project, String logStore, String consumerGroup, int timeoutInSec) throws LogException {
        return this.UpdateConsumerGroup(project, logStore, consumerGroup, null, (Integer)timeoutInSec);
    }

    @Override
    public DeleteConsumerGroupResponse DeleteConsumerGroup(String project, String logStore, String consumerGroup) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.validateLogstore(logStore);
        CodingUtils.validateConsumerGroup(consumerGroup);
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/logstores/" + logStore + "/consumergroups/" + consumerGroup;
        headParameter.put("Content-Length", String.valueOf(0));
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(project, HttpMethod.DELETE, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        return new DeleteConsumerGroupResponse(resHeaders);
    }

    @Override
    public ListConsumerGroupResponse ListConsumerGroup(String project, String logStore) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.validateLogstore(logStore);
        String resourceUri = "/logstores/" + logStore + "/consumergroups";
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
        ArrayList<ConsumerGroup> consumerGroups = new ArrayList<ConsumerGroup>();
        Map<String, String> resHeaders = response.getHeaders();
        String requestId = this.GetRequestId(resHeaders);
        JSONArray array = this.ParseResponseMessageToArray(response, requestId);
        this.ExtractConsumerGroups(array, requestId, consumerGroups);
        ListConsumerGroupResponse listConsumerGroupResponse = new ListConsumerGroupResponse(resHeaders);
        listConsumerGroupResponse.SetConsumerGroups(consumerGroups);
        return listConsumerGroupResponse;
    }

    private void ExtractConsumerGroups(JSONArray array, String requestId, ArrayList<ConsumerGroup> consumerGroups) throws LogException {
        try {
            for (int i = 0; i < array.size(); ++i) {
                JSONObject consumerGroup = array.getJSONObject(i);
                if (consumerGroup == null) continue;
                consumerGroups.add(new ConsumerGroup(consumerGroup.getString("name"), consumerGroup.getIntValue("timeout"), consumerGroup.getBoolean("order")));
            }
        }
        catch (JSONException e) {
            throw new LogException("BadResponse", "The response is not valid consumer group json array string : " + array.toString(), e, requestId);
        }
    }

    @Override
    public ConsumerGroupUpdateCheckPointResponse UpdateCheckPoint(String project, String logStore, String consumerGroup, String consumer, int shard, String checkpoint) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.validateLogstore(logStore);
        CodingUtils.assertStringNotNullOrEmpty(consumerGroup, "consumerGroup");
        CodingUtils.assertStringNotNullOrEmpty(consumer, "consumer");
        CodingUtils.assertStringNotNullOrEmpty(checkpoint, "checkpoint");
        return this.UpdateCheckPoint(project, logStore, consumerGroup, consumer, shard, checkpoint, false);
    }

    @Override
    public ConsumerGroupUpdateCheckPointResponse UpdateCheckPoint(String project, String logStore, String consumerGroup, int shard, String checkpoint) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.validateLogstore(logStore);
        CodingUtils.assertStringNotNullOrEmpty(consumerGroup, "consumerGroup");
        CodingUtils.assertStringNotNullOrEmpty(checkpoint, "checkpoint");
        return this.UpdateCheckPoint(project, logStore, consumerGroup, "", shard, checkpoint, true);
    }

    protected ConsumerGroupUpdateCheckPointResponse UpdateCheckPoint(String project, String logStore, String consumerGroup, String consumer, int shard, String checkpoint, boolean forceSuccess) throws LogException {
        String resourceUri = "/logstores/" + logStore + "/consumergroups/" + consumerGroup;
        ConsumerGroupUpdateCheckPointRequest request = new ConsumerGroupUpdateCheckPointRequest(project, logStore, consumerGroup, consumer, forceSuccess, shard, checkpoint);
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        Map<String, String> urlParameter = request.GetAllParams();
        byte[] body = Client.encodeToUtf8(request.GetRequestBody());
        headParameter.put("Content-Type", "application/json");
        ResponseMessage response = this.SendData(project, HttpMethod.POST, resourceUri, urlParameter, headParameter, body);
        Map<String, String> resHeaders = response.getHeaders();
        return new ConsumerGroupUpdateCheckPointResponse(resHeaders);
    }

    @Override
    public ConsumerGroupHeartBeatResponse HeartBeat(String project, String logStore, String consumerGroup, String consumer, List<Integer> shards) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.validateLogstore(logStore);
        CodingUtils.validateConsumerGroup(consumerGroup);
        CodingUtils.assertStringNotNullOrEmpty(consumer, "consumer");
        String resourceUri = "/logstores/" + logStore + "/consumergroups/" + consumerGroup;
        ConsumerGroupHeartBeatRequest request = new ConsumerGroupHeartBeatRequest(project, logStore, consumerGroup, consumer, shards == null ? new ArrayList() : shards);
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        Map<String, String> urlParameter = request.GetAllParams();
        byte[] body = Client.encodeToUtf8(request.GetRequestBody());
        headParameter.put("Content-Type", "application/json");
        ArrayList<Integer> responseShards = new ArrayList<Integer>();
        ResponseMessage response = this.SendData(project, HttpMethod.POST, resourceUri, urlParameter, headParameter, body);
        Map<String, String> resHeaders = response.getHeaders();
        String requestId = this.GetRequestId(resHeaders);
        JSONArray array = this.ParseResponseMessageToArray(response, requestId);
        this.ExtractShards(array, requestId, responseShards);
        return new ConsumerGroupHeartBeatResponse(resHeaders, (List<Integer>)responseShards);
    }

    protected void ExtractShards(JSONArray array, String requestId, List<Integer> shards) throws LogException {
        if (array == null) {
            return;
        }
        try {
            for (int i = 0; i < array.size(); ++i) {
                shards.add(array.getIntValue(i));
            }
        }
        catch (JSONException e) {
            throw new LogException("BadResponse", "The response is not valid shard json array string : " + array.toString(), e, requestId);
        }
    }

    @Override
    public GetCheckPointResponse getCheckpoint(String project, String logstore, String consumerGroup, int shard) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.validateLogstore(logstore);
        CodingUtils.validateConsumerGroup(consumerGroup);
        Args.check(shard >= 0, "Shard must be >= 0");
        ConsumerGroupGetCheckPointRequest request = new ConsumerGroupGetCheckPointRequest(project, logstore, consumerGroup, shard);
        Map<String, String> urlParameter = request.GetAllParams();
        String resourceUri = "/logstores/" + logstore + "/consumergroups/" + consumerGroup;
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        ResponseMessage response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        String requestId = this.GetRequestId(resHeaders);
        JSONArray array = this.ParseResponseMessageToArray(response, requestId);
        return new GetCheckPointResponse(resHeaders, array);
    }

    @Override
    public ConsumerGroupCheckPointResponse GetCheckPoint(String project, String logStore, String consumerGroup) throws LogException {
        return this.GetCheckPoint(project, logStore, consumerGroup, -1);
    }

    @Override
    @Deprecated
    public ConsumerGroupCheckPointResponse GetCheckPoint(String project, String logStore, String consumerGroup, int shard) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.validateLogstore(logStore);
        CodingUtils.validateConsumerGroup(consumerGroup);
        ConsumerGroupGetCheckPointRequest request = new ConsumerGroupGetCheckPointRequest(project, logStore, consumerGroup, shard);
        Map<String, String> urlParameter = request.GetAllParams();
        String resourceUri = "/logstores/" + logStore + "/consumergroups/" + consumerGroup;
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        ResponseMessage response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        String requestId = this.GetRequestId(resHeaders);
        JSONArray array = this.ParseResponseMessageToArray(response, requestId);
        return new ConsumerGroupCheckPointResponse(resHeaders, array);
    }

    @Override
    public CreateProjectResponse CreateProject(String project, String projectDescription) throws LogException {
        return this.createProject(project, projectDescription, null);
    }

    @Override
    public CreateProjectResponse createProject(String project, String projectDescription, String resourceGroupId) throws LogException {
        return this.createProject(new CreateProjectRequest(project, projectDescription, resourceGroupId));
    }

    @Override
    public CreateProjectResponse createProject(CreateProjectRequest request) throws LogException {
        Args.notNull(request, "request");
        CodingUtils.assertStringNotNullOrEmpty(request.GetProject(), "project");
        Map<String, String> headParameter = this.GetCommonHeadPara(request.GetProject());
        String resourceUri = "/";
        byte[] body = Client.encodeToUtf8(request.getRequestBody());
        headParameter.put("Content-Type", "application/json");
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(request.GetProject(), HttpMethod.POST, resourceUri, urlParameter, headParameter, body);
        Map<String, String> resHeaders = response.getHeaders();
        return new CreateProjectResponse(resHeaders);
    }

    @Override
    public GetProjectResponse GetProject(String project) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/";
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        GetProjectResponse getProjectResponse = new GetProjectResponse(resHeaders);
        String requestId = this.GetRequestId(resHeaders);
        JSONObject object = this.parseResponseBody(response, requestId);
        getProjectResponse.FromJsonObject(object);
        return getProjectResponse;
    }

    @Override
    public DeleteProjectResponse DeleteProject(String project) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String resourceUri = "/";
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        ResponseMessage response = this.SendData(project, HttpMethod.DELETE, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        return new DeleteProjectResponse(resHeaders);
    }

    @Override
    public UpdateProjectResponse updateProject(UpdateProjectRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String resourceUri = "/";
        String project = request.GetProject();
        Map<String, String> headers = this.GetCommonHeadPara(project);
        ResponseMessage response = this.SendData(project, HttpMethod.PUT, "/", Collections.<String, String>emptyMap(), headers, JsonUtils.serialize(request.getBody()));
        return new UpdateProjectResponse(response.getHeaders());
    }

    @Override
    public ChangeResourceGroupResponse changeResourceGroup(String resourceType, String resourceId, String resourceGroupId) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(resourceType, "resourceType");
        CodingUtils.assertStringNotNullOrEmpty(resourceId, "resourceId");
        CodingUtils.assertStringNotNullOrEmpty(resourceGroupId, "resourceGroupId");
        Map<String, String> headParameter = this.GetCommonHeadPara("");
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        String resourceUri = "/resourcegroup";
        JSONObject jsonBody = new JSONObject();
        jsonBody.put("resourceType", (Object)resourceType);
        jsonBody.put("resourceId", (Object)resourceId);
        jsonBody.put("resourceGroupId", (Object)resourceGroupId);
        byte[] body = Client.encodeToUtf8(jsonBody.toString());
        headParameter.put("Content-Type", "application/json");
        ResponseMessage response = this.SendData("", HttpMethod.PUT, resourceUri, urlParameter, headParameter, body);
        Map<String, String> resHeaders = response.getHeaders();
        return new ChangeResourceGroupResponse(resHeaders);
    }

    @Override
    public UpdateMachineGroupMachineResponse AddMachineIntoMahineGroup(String project, String groupName, MachineList machineList) throws LogException {
        return this.UpdateMachineGroupMachine(project, groupName, machineList, false);
    }

    @Override
    public UpdateMachineGroupMachineResponse AddMachineIntoMachineGroup(UpdateMachineGroupMachineRequest request) throws LogException {
        return this.UpdateMachineGroupMachine(request.GetProject(), request.GetGroupName(), request.GetMachineList(), false);
    }

    @Override
    public UpdateMachineGroupMachineResponse DeleteMachineFromMachineGroup(String project, String groupName, MachineList machineList) throws LogException {
        return this.UpdateMachineGroupMachine(project, groupName, machineList, true);
    }

    @Override
    public UpdateMachineGroupMachineResponse DeleteMachineFromMachineGroup(UpdateMachineGroupMachineRequest request) throws LogException {
        return this.UpdateMachineGroupMachine(request.GetProject(), request.GetGroupName(), request.GetMachineList(), true);
    }

    protected UpdateMachineGroupMachineResponse UpdateMachineGroupMachine(String project, String groupName, MachineList machineList, boolean isDelete) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(groupName, "groupName");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        byte[] body = Client.encodeToUtf8(machineList.ToRequestString());
        headParameter.put("Content-Type", "application/json");
        String resourceUri = "/machinegroups/" + groupName + "/machines";
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        urlParameter.put("action", isDelete ? "delete" : "add");
        ResponseMessage response = this.SendData(project, HttpMethod.PUT, resourceUri, urlParameter, headParameter, body);
        Map<String, String> resHeaders = response.getHeaders();
        return new UpdateMachineGroupMachineResponse(resHeaders);
    }

    @Override
    public ListProjectResponse ListProject() throws LogException {
        ListProjectRequest listProjectRequest = new ListProjectRequest("", 0, 500);
        return this.ListProject(listProjectRequest);
    }

    @Override
    public ListProjectResponse ListProject(String projectName, int offset, int size) throws LogException {
        ListProjectRequest listProjectRequest = new ListProjectRequest(projectName, offset, size);
        return this.ListProject(listProjectRequest);
    }

    @Override
    public ListProjectResponse ListProject(ListProjectRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/";
        Map<String, String> urlParameter = request.GetAllParams();
        ResponseMessage response = new ResponseMessage();
        ListProjectResponse listProjectResponse = null;
        JSONObject object = null;
        try {
            response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
            Map<String, String> resHeaders = response.getHeaders();
            String requestId = this.GetRequestId(resHeaders);
            object = this.parseResponseBody(response, requestId);
            listProjectResponse = new ListProjectResponse(resHeaders);
            listProjectResponse.fromJSON(object);
        }
        catch (JSONException e) {
            throw new LogException("BadResponse", "The response is not valid list project json string : " + Utils.safeToString(object), e, this.GetRequestId(response.getHeaders()));
        }
        return listProjectResponse;
    }

    private void checkSavedSearchResource(SavedSearch savedSearch) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(savedSearch.getSavedSearchName(), "savedsearchName");
        CodingUtils.assertStringNotNullOrEmpty(savedSearch.getLogstore(), "logstore");
    }

    @Override
    public CreateChartResponse createChart(CreateChartRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        CodingUtils.assertStringNotNullOrEmpty(request.GetProject(), "projectName");
        Map<String, String> headParameter = this.GetCommonHeadPara(request.GetProject());
        CodingUtils.validateDashboardName(request.getDashboardName());
        String resourceUri = "/dashboards/" + request.getDashboardName() + "/charts";
        headParameter.put("Content-Type", "application/json");
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(request.GetProject(), HttpMethod.POST, resourceUri, urlParameter, headParameter, request.getChart().ToJsonString());
        return new CreateChartResponse(response.getHeaders());
    }

    @Override
    public UpdateChartResponse updateChart(UpdateChartRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        CodingUtils.assertStringNotNullOrEmpty(request.GetProject(), "projectName");
        Map<String, String> headParameter = this.GetCommonHeadPara(request.GetProject());
        CodingUtils.validateDashboardName(request.getDashboardName());
        String resourceUri = "/dashboards/" + request.getDashboardName() + "/charts/" + request.getChartName();
        headParameter.put("Content-Type", "application/json");
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(request.GetProject(), HttpMethod.PUT, resourceUri, urlParameter, headParameter, request.getChart().ToJsonString());
        return new UpdateChartResponse(response.getHeaders());
    }

    @Override
    public DeleteChartResponse deleteChart(DeleteChartRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        CodingUtils.assertStringNotNullOrEmpty(request.GetProject(), "projectName");
        Map<String, String> headParameter = this.GetCommonHeadPara(request.GetProject());
        CodingUtils.validateDashboardName(request.getDashboardName());
        String resourceUri = "/dashboards/" + request.getDashboardName() + "/charts/" + request.getChartName();
        headParameter.put("Content-Type", "application/json");
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(request.GetProject(), HttpMethod.DELETE, resourceUri, urlParameter, headParameter);
        return new DeleteChartResponse(response.getHeaders());
    }

    protected Chart ExtractChartFromResponse(JSONObject dict, String requestId) throws LogException {
        Chart chart = new Chart();
        try {
            chart.FromJsonString(dict.toString());
        }
        catch (LogException e) {
            throw new LogException(e.GetErrorCode(), e.GetErrorMessage(), e.getCause(), requestId);
        }
        return chart;
    }

    @Override
    public GetChartResponse getChart(GetChartRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        Map<String, String> headParameter = this.GetCommonHeadPara(request.GetProject());
        CodingUtils.validateDashboardName(request.getDashboardName());
        String resourceUri = "/dashboards/" + request.getDashboardName() + "/charts/" + request.getChartName();
        headParameter.put("Content-Type", "application/json");
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(request.GetProject(), HttpMethod.GET, resourceUri, urlParameter, headParameter);
        String requestId = this.GetRequestId(response.getHeaders());
        JSONObject object = this.parseResponseBody(response, requestId);
        Chart chart = this.ExtractChartFromResponse(object, requestId);
        return new GetChartResponse(response.getHeaders(), chart);
    }

    @Override
    public CreateDashboardResponse createDashboard(CreateDashboardRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        CodingUtils.assertStringNotNullOrEmpty(request.GetProject(), "projectName");
        Map<String, String> headParameter = this.GetCommonHeadPara(request.GetProject());
        String resourceUri = "/dashboards";
        headParameter.put("Content-Type", "application/json");
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(request.GetProject(), HttpMethod.POST, resourceUri, urlParameter, headParameter, request.getDashboard().ToJsonString());
        return new CreateDashboardResponse(response.getHeaders());
    }

    @Override
    public UpdateDashboardResponse updateDashboard(UpdateDashboardRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        CodingUtils.assertStringNotNullOrEmpty(request.GetProject(), "projectName");
        Map<String, String> headParameter = this.GetCommonHeadPara(request.GetProject());
        CodingUtils.validateDashboardName(request.getDashboard().getDashboardName());
        String resourceUri = "/dashboards/" + request.getDashboard().getDashboardName();
        headParameter.put("Content-Type", "application/json");
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(request.GetProject(), HttpMethod.PUT, resourceUri, urlParameter, headParameter, request.getDashboard().ToJsonString());
        return new UpdateDashboardResponse(response.getHeaders());
    }

    @Override
    public DeleteDashboardResponse deleteDashboard(DeleteDashboardRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        CodingUtils.assertStringNotNullOrEmpty(request.GetProject(), "projectName");
        Map<String, String> headParameter = this.GetCommonHeadPara(request.GetProject());
        CodingUtils.validateDashboardName(request.getDashboardName());
        String resourceUri = "/dashboards/" + request.getDashboardName();
        headParameter.put("Content-Type", "application/json");
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(request.GetProject(), HttpMethod.DELETE, resourceUri, urlParameter, headParameter);
        return new DeleteDashboardResponse(response.getHeaders());
    }

    protected Dashboard ExtractDashboardFromResponse(JSONObject dict, String requestId) throws LogException {
        Dashboard dashboard = new Dashboard();
        try {
            dashboard.FromJsonString(dict.toString());
        }
        catch (LogException e) {
            throw new LogException(e.GetErrorCode(), e.GetErrorMessage(), e.getCause(), requestId);
        }
        return dashboard;
    }

    @Override
    public GetDashboardResponse getDashboard(GetDashboardRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        Map<String, String> headParameter = this.GetCommonHeadPara(request.GetProject());
        CodingUtils.validateDashboardName(request.getDashboardName());
        String resourceUri = "/dashboards/" + request.getDashboardName();
        headParameter.put("Content-Type", "application/json");
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(request.GetProject(), HttpMethod.GET, resourceUri, urlParameter, headParameter);
        String requestId = this.GetRequestId(response.getHeaders());
        JSONObject object = this.parseResponseBody(response, requestId);
        Dashboard dashboard = this.ExtractDashboardFromResponse(object, requestId);
        return new GetDashboardResponse(response.getHeaders(), dashboard);
    }

    protected List<Dashboard> ExtractDashboards(JSONObject object, String requestId) throws LogException {
        ArrayList<Dashboard> dashboards = new ArrayList<Dashboard>();
        if (object == null) {
            return dashboards;
        }
        JSONArray array = new JSONArray();
        try {
            array = object.getJSONArray("dashboardItems");
            if (array == null) {
                return dashboards;
            }
            for (int index = 0; index < array.size(); ++index) {
                JSONObject jsonObject = array.getJSONObject(index);
                if (jsonObject == null) continue;
                Dashboard dashboard = new Dashboard();
                dashboard.setDashboardName(jsonObject.getString("dashboardName"));
                dashboard.setDisplayName(jsonObject.getString("displayName"));
                dashboards.add(dashboard);
            }
        }
        catch (JSONException e) {
            throw new LogException("BadResponse", "The response is not valid config json array string : " + array.toString(), e, requestId);
        }
        return dashboards;
    }

    @Override
    public ListDashboardResponse listDashboard(ListDashboardRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        CodingUtils.assertStringNotNullOrEmpty(request.GetProject(), "projectName");
        Map<String, String> headParameter = this.GetCommonHeadPara(request.GetProject());
        String resourceUri = "/dashboards";
        headParameter.put("Content-Type", "application/json");
        Map<String, String> urlParameter = request.GetAllParams();
        ResponseMessage response = this.SendData(request.GetProject(), HttpMethod.GET, resourceUri, urlParameter, headParameter);
        String requestId = this.GetRequestId(response.getHeaders());
        JSONObject object = this.parseResponseBody(response, requestId);
        int total = object.getIntValue("total");
        int count = object.getIntValue("count");
        List<Dashboard> dashboards = this.ExtractDashboards(object, requestId);
        return new ListDashboardResponse(response.getHeaders(), count, total, dashboards);
    }

    @Override
    public CreateSavedSearchResponse createSavedSearch(CreateSavedSearchRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        CodingUtils.assertStringNotNullOrEmpty(request.GetProject(), "projectName");
        this.checkSavedSearchResource(request.getSavedSearch());
        Map<String, String> headParameter = this.GetCommonHeadPara(request.GetProject());
        String resourceUri = "/savedsearches";
        headParameter.put("Content-Type", "application/json");
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(request.GetProject(), HttpMethod.POST, resourceUri, urlParameter, headParameter, request.getSavedSearch().ToJsonString());
        return new CreateSavedSearchResponse(response.getHeaders());
    }

    @Override
    public UpdateSavedSearchResponse updateSavedSearch(UpdateSavedSearchRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        CodingUtils.assertStringNotNullOrEmpty(request.GetProject(), "projectName");
        this.checkSavedSearchResource(request.getSavedSearch());
        Map<String, String> headParameter = this.GetCommonHeadPara(request.GetProject());
        String resourceUri = "/savedsearches/" + request.getSavedSearch().getSavedSearchName();
        headParameter.put("Content-Type", "application/json");
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(request.GetProject(), HttpMethod.PUT, resourceUri, urlParameter, headParameter, request.getSavedSearch().ToJsonString());
        return new UpdateSavedSearchResponse(response.getHeaders());
    }

    @Override
    public DeleteSavedSearchResponse deleteSavedSearch(DeleteSavedSearchRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        CodingUtils.assertStringNotNullOrEmpty(request.GetProject(), "projectName");
        CodingUtils.validateSavedSearch(request.getSavedSearchName());
        Map<String, String> headParameter = this.GetCommonHeadPara(request.GetProject());
        String resourceUri = "/savedsearches/" + request.getSavedSearchName();
        headParameter.put("Content-Type", "application/json");
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(request.GetProject(), HttpMethod.DELETE, resourceUri, urlParameter, headParameter);
        return new DeleteSavedSearchResponse(response.getHeaders());
    }

    protected SavedSearch ExtractSavedSearchFromResponse(JSONObject dict, String requestId) throws LogException {
        SavedSearch savedSearch = new SavedSearch();
        try {
            savedSearch.FromJsonString(dict.toString());
        }
        catch (LogException e) {
            throw new LogException(e.GetErrorCode(), e.GetErrorMessage(), e.getCause(), requestId);
        }
        return savedSearch;
    }

    @Override
    public GetSavedSearchResponse getSavedSearch(GetSavedSearchRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        CodingUtils.assertStringNotNullOrEmpty(request.GetProject(), "projectName");
        CodingUtils.validateSavedSearch(request.getSavedSearchName());
        Map<String, String> headParameter = this.GetCommonHeadPara(request.GetProject());
        String resourceUri = "/savedsearches/" + request.getSavedSearchName();
        headParameter.put("Content-Type", "application/json");
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(request.GetProject(), HttpMethod.GET, resourceUri, urlParameter, headParameter);
        String requestId = this.GetRequestId(response.getHeaders());
        JSONObject object = this.parseResponseBody(response, requestId);
        SavedSearch savedSearch = this.ExtractSavedSearchFromResponse(object, requestId);
        return new GetSavedSearchResponse(response.getHeaders(), savedSearch);
    }

    protected List<SavedSearch> ExtractSavedSearches(JSONObject object, String requestId) throws LogException {
        ArrayList<SavedSearch> savedSearches = new ArrayList<SavedSearch>();
        if (object == null) {
            return savedSearches;
        }
        JSONArray array = new JSONArray();
        try {
            array = object.getJSONArray("savedsearchItems");
            if (array == null) {
                return savedSearches;
            }
            for (int index = 0; index < array.size(); ++index) {
                JSONObject jsonObject = array.getJSONObject(index);
                if (jsonObject == null) continue;
                SavedSearch savedSearch = new SavedSearch();
                savedSearch.setSavedSearchName(jsonObject.getString("savedsearchName"));
                savedSearch.setDisplayName(jsonObject.getString("displayName"));
                savedSearches.add(savedSearch);
            }
        }
        catch (JSONException e) {
            throw new LogException("BadResponse", "The response is not valid config json array string : " + array.toString(), e, requestId);
        }
        return savedSearches;
    }

    @Override
    public ListSavedSearchResponse listSavedSearch(ListSavedSearchRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        CodingUtils.assertStringNotNullOrEmpty(request.GetProject(), "projectName");
        Map<String, String> headParameter = this.GetCommonHeadPara(request.GetProject());
        String resourceUri = "/savedsearches";
        headParameter.put("Content-Type", "application/json");
        Map<String, String> urlParameter = request.GetAllParams();
        ResponseMessage response = this.SendData(request.GetProject(), HttpMethod.GET, resourceUri, urlParameter, headParameter);
        String requestId = this.GetRequestId(response.getHeaders());
        JSONObject object = this.parseResponseBody(response, requestId);
        int total = object.getIntValue("total");
        int count = object.getIntValue("count");
        List<SavedSearch> savedSearches = this.ExtractSavedSearches(object, requestId);
        return new ListSavedSearchResponse(response.getHeaders(), count, total, savedSearches);
    }

    @Override
    public CreateDomainResponse createDomain(String project, Domain domain) throws LogException {
        CreateDomainRequest request = new CreateDomainRequest(project, domain);
        return this.createDomain(request);
    }

    @Override
    public CreateDomainResponse createDomain(CreateDomainRequest request) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(request.GetProject(), "projectName");
        CodingUtils.assertStringNotNullOrEmpty(request.getDomain().getDomainName(), "domainName");
        Map<String, String> headParameter = this.GetCommonHeadPara(request.GetProject());
        String resourceUri = "/domains";
        headParameter.put("Content-Type", "application/json");
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(request.GetProject(), HttpMethod.POST, resourceUri, urlParameter, headParameter, request.getDomain().toJsonString());
        return new CreateDomainResponse(response.getHeaders());
    }

    @Override
    public DeleteDomainResponse deleteDomain(String project, String domainName) throws LogException {
        DeleteDomainRequest request = new DeleteDomainRequest(project, domainName);
        return this.deleteDomain(request);
    }

    @Override
    public DeleteDomainResponse deleteDomain(DeleteDomainRequest request) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(request.GetProject(), "projectName");
        CodingUtils.assertStringNotNullOrEmpty(request.getDomainName(), "domainName");
        Map<String, String> headParameter = this.GetCommonHeadPara(request.GetProject());
        String resourceUri = "/domains/" + request.getDomainName();
        headParameter.put("Content-Type", "application/json");
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(request.GetProject(), HttpMethod.DELETE, resourceUri, urlParameter, headParameter);
        return new DeleteDomainResponse(response.getHeaders());
    }

    @Override
    public ListDomainsResponse listDomains(String project, String domainName, int offset, int size) throws LogException {
        ListDomainsRequest request = new ListDomainsRequest(project, domainName, offset, size);
        return this.listDomains(request);
    }

    protected List<Domain> ExtractDomains(JSONObject object, String requestId) throws LogException {
        ArrayList<Domain> domains = new ArrayList<Domain>();
        if (object == null) {
            return domains;
        }
        JSONArray array = new JSONArray();
        try {
            array = object.getJSONArray("domains");
            if (array == null) {
                return domains;
            }
            for (int index = 0; index < array.size(); ++index) {
                Domain domain = new Domain();
                domain.setDomainName(array.getString(index));
                domains.add(domain);
            }
        }
        catch (JSONException e) {
            throw new LogException("BadResponse", "The response is not valid config json array string : " + array.toString(), e, requestId);
        }
        return domains;
    }

    @Override
    public ListDomainsResponse listDomains(ListDomainsRequest request) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(request.GetProject(), "projectName");
        Map<String, String> headParameter = this.GetCommonHeadPara(request.GetProject());
        String resourceUri = "/domains";
        headParameter.put("Content-Type", "application/json");
        Map<String, String> urlParameter = request.GetAllParams();
        ResponseMessage response = this.SendData(request.GetProject(), HttpMethod.GET, resourceUri, urlParameter, headParameter);
        String requestId = this.GetRequestId(response.getHeaders());
        JSONObject object = this.parseResponseBody(response, requestId);
        int total = object.getIntValue("total");
        int count = object.getIntValue("count");
        List<Domain> domains = this.ExtractDomains(object, requestId);
        return new ListDomainsResponse(response.getHeaders(), count, total, domains);
    }

    @Override
    public CreateIngestionResponse createIngestion(CreateIngestionRequest request) throws LogException {
        ResponseMessage responseMessage = this.send(request);
        return new CreateIngestionResponse(responseMessage.getHeaders());
    }

    @Override
    public UpdateIngestionResponse updateIngestion(UpdateIngestionRequest request) throws LogException {
        ResponseMessage responseMessage = this.send(request);
        return new UpdateIngestionResponse(responseMessage.getHeaders());
    }

    @Override
    public DeleteIngestionResponse deleteIngestion(DeleteIngestionRequest request) throws LogException {
        ResponseMessage responseMessage = this.send(request);
        return new DeleteIngestionResponse(responseMessage.getHeaders());
    }

    @Override
    public GetIngestionResponse getIngestion(GetIngestionRequest request) throws LogException {
        ResponseMessage response = this.send(request);
        JSONObject responseBody = this.parseResponseBody(response, response.getRequestId());
        GetIngestionResponse ingestionResponse = new GetIngestionResponse(response.getHeaders());
        ingestionResponse.deserialize(responseBody, response.getRequestId());
        return ingestionResponse;
    }

    @Override
    public ListIngestionResponse listIngestion(ListIngestionRequest request) throws LogException {
        ResponseMessage response = this.send(request);
        JSONObject responseBody = this.parseResponseBody(response, response.getRequestId());
        ListIngestionResponse listIngestionResponse = new ListIngestionResponse(response.getHeaders());
        listIngestionResponse.deserialize(responseBody, response.getRequestId());
        return listIngestionResponse;
    }

    @Override
    public StopIngestionResponse stopIngestion(StopIngestionRequest request) throws LogException {
        ResponseMessage responseMessage = this.send(request);
        return new StopIngestionResponse(responseMessage.getHeaders());
    }

    @Override
    public StartIngestionResponse startIngestion(StartIngestionRequest request) throws LogException {
        ResponseMessage responseMessage = this.send(request);
        return new StartIngestionResponse(responseMessage.getHeaders());
    }

    @Override
    public StartIngestionResponse restartIngestion(RestartIngestionRequest request) throws LogException {
        ResponseMessage responseMessage = this.send(request);
        return new StartIngestionResponse(responseMessage.getHeaders());
    }

    @Override
    public CreateRebuildIndexResponse createRebuildIndex(CreateRebuildIndexRequest request) throws LogException {
        ResponseMessage responseMessage = this.send(request);
        return new CreateRebuildIndexResponse(responseMessage.getHeaders());
    }

    @Override
    public GetRebuildIndexResponse getRebuildIndex(GetRebuildIndexRequest request) throws LogException {
        ResponseMessage message = this.send(request);
        JSONObject responseBody = this.parseResponseBody(message, message.getRequestId());
        GetRebuildIndexResponse response = new GetRebuildIndexResponse(message.getHeaders());
        response.deserialize(responseBody, message.getRequestId());
        return response;
    }

    @Override
    public DeleteRebuildIndexResponse deleteRebuildIndex(DeleteRebuildIndexRequest request) throws LogException {
        ResponseMessage responseMessage = this.send(request);
        return new DeleteRebuildIndexResponse(responseMessage.getHeaders());
    }

    @Override
    public ListRebuildIndexResponse listRebuildIndex(ListRebuildIndexRequest request) throws LogException {
        ResponseMessage message = this.send(request);
        JSONObject responseBody = this.parseResponseBody(message, message.getRequestId());
        ListRebuildIndexResponse response = new ListRebuildIndexResponse(message.getHeaders());
        response.deserialize(responseBody, message.getRequestId());
        return response;
    }

    @Override
    public StopRebuildIndexResponse stopRebuildIndex(StopRebuildIndexRequest request) throws LogException {
        ResponseMessage responseMessage = this.send(request);
        return new StopRebuildIndexResponse(responseMessage.getHeaders());
    }

    @Override
    public CreateAuditJobResponse createAuditJob(CreateAuditJobRequest request) throws LogException {
        ResponseMessage responseMessage = this.send(request, request.getBody().toString());
        return new CreateAuditJobResponse(responseMessage.getHeaders());
    }

    @Override
    public UpdateAuditJobResponse updateAuditJob(UpdateAuditJobRequest request) throws LogException {
        ResponseMessage responseMessage = this.send(request, request.getBody().toString());
        return new UpdateAuditJobResponse(responseMessage.getHeaders());
    }

    @Override
    public GetAuditJobResponse getAuditJob(GetAuditJobRequest request) throws LogException {
        ResponseMessage message = this.send(request);
        JSONObject responseBody = this.parseResponseBody(message, message.getRequestId());
        GetAuditJobResponse response = new GetAuditJobResponse(message.getHeaders());
        response.deserialize(responseBody, message.getRequestId());
        return response;
    }

    @Override
    public DeleteAuditJobResponse deleteAuditJob(DeleteAuditJobRequest request) throws LogException {
        ResponseMessage responseMessage = this.send(request);
        return new DeleteAuditJobResponse(responseMessage.getHeaders());
    }

    @Override
    public ListAuditJobResponse listAuditJob(ListAuditJobRequest request) throws LogException {
        ResponseMessage resp = this.send(request);
        JSONObject respBody = this.parseResponseBody(resp, resp.getRequestId());
        ListAuditJobResponse listResp = new ListAuditJobResponse(resp.getHeaders());
        listResp.deserialize(respBody, resp.getRequestId());
        return listResp;
    }

    @Override
    public StopAuditJobResponse stopAuditJob(StopAuditJobRequest request) throws LogException {
        ResponseMessage responseMessage = this.send(request);
        return new StopAuditJobResponse(responseMessage.getHeaders());
    }

    @Override
    public CreateTopostoreResponse createTopostore(CreateTopostoreRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        CodingUtils.assertParameterNotNull(request.getTopostore(), "topostore");
        Topostore topostore = request.getTopostore();
        topostore.checkForCreate();
        Map<String, String> headParameter = this.GetCommonHeadPara(request.GetProject());
        byte[] body = Client.encodeToUtf8(topostore.ToJsonString());
        headParameter.put("Content-Type", "application/json");
        String resourceUri = "/topostores";
        ResponseMessage response = this.SendData(request.GetProject(), HttpMethod.POST, resourceUri, request.GetAllParams(), headParameter, body);
        return new CreateTopostoreResponse(response.getHeaders());
    }

    @Override
    public UpdateTopostoreResponse updateTopostore(UpdateTopostoreRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        CodingUtils.assertParameterNotNull(request.getTopostore(), "topostore");
        Topostore topostore = request.getTopostore();
        topostore.checkForUpdate();
        Map<String, String> headParameter = this.GetCommonHeadPara(request.GetProject());
        byte[] body = Client.encodeToUtf8(topostore.ToJsonString());
        headParameter.put("Content-Type", "application/json");
        String resourceUri = "/topostores/" + topostore.getName();
        ResponseMessage response = this.SendData(request.GetProject(), HttpMethod.PUT, resourceUri, request.GetAllParams(), headParameter, body);
        return new UpdateTopostoreResponse(response.getHeaders());
    }

    protected Topostore extractTopostoreFromResponse(JSONObject dict, String requestId) throws LogException {
        Topostore topostore = new Topostore();
        try {
            topostore.FromJsonObject(dict);
        }
        catch (JSONException e) {
            throw new LogException("BadResponse", "The response is not valid json string : " + dict.toString(), e, requestId);
        }
        return topostore;
    }

    protected List<Topostore> extractTopostores(JSONObject object, String requestId) throws LogException {
        ArrayList<Topostore> topostores = new ArrayList<Topostore>();
        if (object == null) {
            return topostores;
        }
        JSONArray array = new JSONArray();
        try {
            array = object.getJSONArray("items");
            if (array == null) {
                return topostores;
            }
            for (int index = 0; index < array.size(); ++index) {
                JSONObject jsonObject = array.getJSONObject(index);
                if (jsonObject == null) continue;
                Topostore topostore = new Topostore();
                topostore.FromJsonObject(jsonObject);
                topostores.add(topostore);
            }
        }
        catch (JSONException e) {
            throw new LogException("BadResponse", "The response is not valid config json array string : " + array.toString(), e, requestId);
        }
        return topostores;
    }

    @Override
    public GetTopostoreResponse getTopostore(GetTopostoreRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        CodingUtils.assertParameterNotNull(request.getTopostoreName(), "topostoreName");
        Map<String, String> headParameter = this.GetCommonHeadPara(request.GetProject());
        String resourceUri = "/topostores/" + request.getTopostoreName();
        headParameter.put("Content-Type", "application/json");
        ResponseMessage response = this.SendData(request.GetProject(), HttpMethod.GET, resourceUri, request.GetAllParams(), headParameter);
        String requestId = this.GetRequestId(response.getHeaders());
        JSONObject object = this.parseResponseBody(response, requestId);
        Topostore topostore = this.extractTopostoreFromResponse(object, requestId);
        return new GetTopostoreResponse(response.getHeaders(), topostore);
    }

    @Override
    public ListTopostoreResponse listTopostore(ListTopostoreRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        Map<String, String> headParameter = this.GetCommonHeadPara(request.GetProject());
        String resourceUri = "/topostores";
        headParameter.put("Content-Type", "application/json");
        ResponseMessage response = this.SendData(request.GetProject(), HttpMethod.GET, resourceUri, request.GetAllParams(), headParameter);
        String requestId = this.GetRequestId(response.getHeaders());
        JSONObject object = this.parseResponseBody(response, requestId);
        int count = object.getIntValue("count");
        int total = object.getIntValue("total");
        List<Topostore> topostores = this.extractTopostores(object, requestId);
        return new ListTopostoreResponse(response.getHeaders(), topostores, count, total);
    }

    @Override
    public DeleteTopostoreResponse deleteTopostore(DeleteTopostoreRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        CodingUtils.assertParameterNotNull(request.getTopostoreName(), "topostoreName");
        Map<String, String> headParameter = this.GetCommonHeadPara(request.GetProject());
        String resourceUri = "/topostores/" + request.getTopostoreName();
        headParameter.put("Content-Type", "application/json");
        ResponseMessage response = this.SendData(request.GetProject(), HttpMethod.DELETE, resourceUri, request.GetAllParams(), headParameter);
        return new DeleteTopostoreResponse(response.getHeaders());
    }

    @Override
    public CreateTopostoreNodeResponse createTopostoreNode(CreateTopostoreNodeRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        CodingUtils.assertParameterNotNull(request.getTopostoreName(), "topostoreName");
        CodingUtils.assertParameterNotNull(request.getTopostoreNode(), "topostoreNode");
        TopostoreNode topostoreNode = request.getTopostoreNode();
        topostoreNode.checkForCreate();
        Map<String, String> headParameter = this.GetCommonHeadPara(request.GetProject());
        byte[] body = Client.encodeToUtf8(topostoreNode.ToJsonString());
        headParameter.put("Content-Type", "application/json");
        String resourceUri = "/topostores/" + request.getTopostoreName() + "/nodes";
        ResponseMessage response = this.SendData(request.GetProject(), HttpMethod.POST, resourceUri, request.GetAllParams(), headParameter, body);
        return new CreateTopostoreNodeResponse(response.getHeaders());
    }

    @Override
    public UpdateTopostoreNodeResponse updateTopostoreNode(UpdateTopostoreNodeRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        CodingUtils.assertParameterNotNull(request.getTopostoreName(), "topostoreName");
        CodingUtils.assertParameterNotNull(request.getTopostoreNode(), "topostoreNode");
        TopostoreNode topostoreNode = request.getTopostoreNode();
        topostoreNode.checkForUpdate();
        Map<String, String> headParameter = this.GetCommonHeadPara(request.GetProject());
        byte[] body = Client.encodeToUtf8(topostoreNode.ToJsonString());
        headParameter.put("Content-Type", "application/json");
        String resourceUri = "/topostores/" + request.getTopostoreName() + "/nodes/" + topostoreNode.getNodeId();
        ResponseMessage response = this.SendData(request.GetProject(), HttpMethod.PUT, resourceUri, request.GetAllParams(), headParameter, body);
        return new UpdateTopostoreNodeResponse(response.getHeaders());
    }

    @Override
    public DeleteTopostoreNodeResponse deleteTopostoreNode(DeleteTopostoreNodeRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        CodingUtils.assertParameterNotNull(request.getTopostoreName(), "topostoreName");
        CodingUtils.assertParameterNotNull(request.getTopostoreNodeIds(), "topostoreNodeIds");
        Map<String, String> headParameter = this.GetCommonHeadPara(request.GetProject());
        headParameter.put("Content-Type", "application/json");
        String resourceUri = "/topostores/" + request.getTopostoreName() + "/nodes";
        ResponseMessage response = this.SendData(request.GetProject(), HttpMethod.DELETE, resourceUri, request.GetAllParams(), headParameter);
        return new DeleteTopostoreNodeResponse(response.getHeaders());
    }

    protected TopostoreNode extractTopostoreNodeFromResponse(JSONObject dict, String requestId) throws LogException {
        TopostoreNode node = new TopostoreNode();
        try {
            node.FromJsonObject(dict);
        }
        catch (JSONException e) {
            throw new LogException("BadResponse", "The response is not valid json string : " + dict.toString(), e, requestId);
        }
        return node;
    }

    public GetTopostoreNodeResponse getTopostoreNode(GetTopostoreNodeRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        CodingUtils.assertParameterNotNull(request.getTopostoreName(), "topostoreName");
        Map<String, String> headParameter = this.GetCommonHeadPara(request.GetProject());
        String resourceUri = "/topostores/" + request.getTopostoreName() + "/nodes/" + request.getTopostoreNodeId();
        headParameter.put("Content-Type", "application/json");
        ResponseMessage response = this.SendData(request.GetProject(), HttpMethod.GET, resourceUri, request.GetAllParams(), headParameter);
        String requestId = this.GetRequestId(response.getHeaders());
        JSONObject object = this.parseResponseBody(response, requestId);
        TopostoreNode node = this.extractTopostoreNodeFromResponse(object, requestId);
        return new GetTopostoreNodeResponse(response.getHeaders(), node);
    }

    protected List<TopostoreNode> extractTopostoreNodesFromResponse(JSONObject object, String requestId) throws LogException {
        ArrayList<TopostoreNode> topostoreNodes = new ArrayList<TopostoreNode>();
        if (object == null) {
            return topostoreNodes;
        }
        JSONArray array = new JSONArray();
        try {
            array = object.getJSONArray("items");
            if (array == null) {
                return topostoreNodes;
            }
            for (int index = 0; index < array.size(); ++index) {
                JSONObject jsonObject = array.getJSONObject(index);
                if (jsonObject == null) continue;
                TopostoreNode node = new TopostoreNode();
                node.FromJsonObject(jsonObject);
                topostoreNodes.add(node);
            }
        }
        catch (JSONException e) {
            throw new LogException("BadResponse", "The response is not valid config json array string : " + array.toString(), e, requestId);
        }
        return topostoreNodes;
    }

    @Override
    public ListTopostoreNodeResponse listTopostoreNode(ListTopostoreNodeRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        Map<String, String> headParameter = this.GetCommonHeadPara(request.GetProject());
        String resourceUri = "/topostores/" + request.getTopostoreName() + "/nodes";
        headParameter.put("Content-Type", "application/json");
        ResponseMessage response = this.SendData(request.GetProject(), HttpMethod.GET, resourceUri, request.GetAllParams(), headParameter);
        String requestId = this.GetRequestId(response.getHeaders());
        JSONObject object = this.parseResponseBody(response, requestId);
        List<TopostoreNode> nodes = this.extractTopostoreNodesFromResponse(object, requestId);
        int total = object.getIntValue("total");
        int count = object.getIntValue("count");
        return new ListTopostoreNodeResponse(response.getHeaders(), nodes, count, total);
    }

    @Override
    public UpsertTopostoreNodeResponse upsertTopostoreNode(UpsertTopostoreNodeRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        CodingUtils.assertStringNotNullOrEmpty(request.getTopostoreName(), "topostoreName");
        CodingUtils.assertParameterNotNull(request.getTopostoreNodes(), "topostoreNodes");
        for (TopostoreNode n : request.getTopostoreNodes()) {
            n.checkForUpsert();
        }
        Map<String, String> headParameter = this.GetCommonHeadPara(request.GetProject());
        byte[] body = Client.encodeToUtf8(request.getPostBody());
        headParameter.put("Content-Type", "application/json");
        String resourceUri = "/topostores/" + request.getTopostoreName() + "/nodes";
        ResponseMessage response = this.SendData(request.GetProject(), HttpMethod.PUT, resourceUri, request.GetAllParams(), headParameter, body);
        return new UpsertTopostoreNodeResponse(response.getHeaders());
    }

    @Override
    public CreateTopostoreRelationResponse createTopostoreRelation(CreateTopostoreRelationRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        CodingUtils.assertParameterNotNull(request.getTopostoreName(), "topostoreName");
        CodingUtils.assertParameterNotNull(request.getTopostoreRelation(), "topostoreRelation");
        TopostoreRelation topostoreRelation = request.getTopostoreRelation();
        topostoreRelation.checkForCreate();
        Map<String, String> headParameter = this.GetCommonHeadPara(request.GetProject());
        byte[] body = Client.encodeToUtf8(topostoreRelation.ToJsonString());
        headParameter.put("Content-Type", "application/json");
        String resourceUri = "/topostores/" + request.getTopostoreName() + "/relations";
        ResponseMessage response = this.SendData(request.GetProject(), HttpMethod.POST, resourceUri, request.GetAllParams(), headParameter, body);
        return new CreateTopostoreRelationResponse(response.getHeaders());
    }

    @Override
    public UpdateTopostoreRelationResponse updateTopostoreRelation(UpdateTopostoreRelationRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        CodingUtils.assertParameterNotNull(request.getTopostoreName(), "topostoreName");
        CodingUtils.assertParameterNotNull(request.getTopostoreRelation(), "topostoreRelation");
        TopostoreRelation topostoreRelation = request.getTopostoreRelation();
        topostoreRelation.checkForUpdate();
        Map<String, String> headParameter = this.GetCommonHeadPara(request.GetProject());
        byte[] body = Client.encodeToUtf8(topostoreRelation.ToJsonString());
        headParameter.put("Content-Type", "application/json");
        String resourceUri = "/topostores/" + request.getTopostoreName() + "/relations/" + topostoreRelation.getRelationId();
        ResponseMessage response = this.SendData(request.GetProject(), HttpMethod.PUT, resourceUri, request.GetAllParams(), headParameter, body);
        return new UpdateTopostoreRelationResponse(response.getHeaders());
    }

    @Override
    public DeleteTopostoreRelationResponse deleteTopostoreRelation(DeleteTopostoreRelationRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        CodingUtils.assertParameterNotNull(request.getTopostoreName(), "topostoreName");
        CodingUtils.assertParameterNotNull(request.getTopostoreRelationIds(), "topostoreRelationIds");
        Map<String, String> headParameter = this.GetCommonHeadPara(request.GetProject());
        headParameter.put("Content-Type", "application/json");
        String resourceUri = "/topostores/" + request.getTopostoreName() + "/relations";
        ResponseMessage response = this.SendData(request.GetProject(), HttpMethod.DELETE, resourceUri, request.GetAllParams(), headParameter);
        return new DeleteTopostoreRelationResponse(response.getHeaders());
    }

    protected TopostoreRelation extractTopostoreRelationFromResponse(JSONObject dict, String requestId) throws LogException {
        TopostoreRelation relation = new TopostoreRelation();
        try {
            relation.FromJsonObject(dict);
        }
        catch (JSONException e) {
            throw new LogException("BadResponse", "The response is not valid json string : " + dict.toString(), e, requestId);
        }
        return relation;
    }

    public GetTopostoreRelationResponse getTopostoreRelation(GetTopostoreRelationRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        CodingUtils.assertParameterNotNull(request.getTopostoreName(), "topostoreName");
        Map<String, String> headParameter = this.GetCommonHeadPara(request.GetProject());
        String resourceUri = "/topostores/" + request.getTopostoreName() + "/relations/" + request.getTopostoreRelationId();
        headParameter.put("Content-Type", "application/json");
        ResponseMessage response = this.SendData(request.GetProject(), HttpMethod.GET, resourceUri, request.GetAllParams(), headParameter);
        String requestId = this.GetRequestId(response.getHeaders());
        JSONObject object = this.parseResponseBody(response, requestId);
        TopostoreRelation relation = this.extractTopostoreRelationFromResponse(object, requestId);
        return new GetTopostoreRelationResponse(response.getHeaders(), relation);
    }

    protected List<TopostoreRelation> extractTopostoreRelationsFromResponse(JSONObject object, String requestId) throws LogException {
        ArrayList<TopostoreRelation> topostoreRelations = new ArrayList<TopostoreRelation>();
        if (object == null) {
            return topostoreRelations;
        }
        JSONArray array = new JSONArray();
        try {
            array = object.getJSONArray("items");
            if (array == null) {
                return topostoreRelations;
            }
            for (int index = 0; index < array.size(); ++index) {
                JSONObject jsonObject = array.getJSONObject(index);
                if (jsonObject == null) continue;
                TopostoreRelation relation = new TopostoreRelation();
                relation.FromJsonObject(jsonObject);
                topostoreRelations.add(relation);
            }
        }
        catch (JSONException e) {
            throw new LogException("BadResponse", "The response is not valid config json array string : " + array.toString(), e, requestId);
        }
        return topostoreRelations;
    }

    @Override
    public ListTopostoreRelationResponse listTopostoreRelation(ListTopostoreRelationRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        Map<String, String> headParameter = this.GetCommonHeadPara(request.GetProject());
        String resourceUri = "/topostores/" + request.getTopostoreName() + "/relations";
        headParameter.put("Content-Type", "application/json");
        ResponseMessage response = this.SendData(request.GetProject(), HttpMethod.GET, resourceUri, request.GetAllParams(), headParameter);
        String requestId = this.GetRequestId(response.getHeaders());
        JSONObject object = this.parseResponseBody(response, requestId);
        List<TopostoreRelation> relations = this.extractTopostoreRelationsFromResponse(object, requestId);
        int total = object.getIntValue("total");
        int count = object.getIntValue("count");
        return new ListTopostoreRelationResponse(response.getHeaders(), relations, count, total);
    }

    @Override
    public UpsertTopostoreRelationResponse upsertTopostoreRelation(UpsertTopostoreRelationRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        CodingUtils.assertStringNotNullOrEmpty(request.getTopostoreName(), "topostoreName");
        CodingUtils.assertParameterNotNull(request.getTopostoreRelations(), "topostoreRelations");
        for (TopostoreRelation n : request.getTopostoreRelations()) {
            n.checkForUpsert();
        }
        Map<String, String> headParameter = this.GetCommonHeadPara(request.GetProject());
        byte[] body = Client.encodeToUtf8(request.getPostBody());
        headParameter.put("Content-Type", "application/json");
        String resourceUri = "/topostores/" + request.getTopostoreName() + "/relations";
        ResponseMessage response = this.SendData(request.GetProject(), HttpMethod.PUT, resourceUri, request.GetAllParams(), headParameter, body);
        return new UpsertTopostoreRelationResponse(response.getHeaders());
    }

    public List<Set<String>> traverseNodeRelations(Map<String, List<TopostoreRelation>> nodeRelationMap, String direction, String nodeId, long depth, boolean depthMode, List<String> relationTypes) {
        if (depthMode && depth < 0L) {
            return new ArrayList<Set<String>>();
        }
        HashSet<String> nodeIds = new HashSet<String>();
        nodeIds.add(nodeId);
        HashSet<String> relationIds = new HashSet<String>();
        ArrayList<Set<String>> ret = new ArrayList<Set<String>>();
        if (depthMode && depth == 0L) {
            ret.add(nodeIds);
            ret.add(relationIds);
            return ret;
        }
        if (nodeRelationMap.containsKey(nodeId)) {
            for (TopostoreRelation relation : nodeRelationMap.get(nodeId)) {
                if (relationTypes != null && relationTypes.size() != 0 && !relationTypes.contains(relation.getRelationType())) continue;
                String mNodeId = null;
                if (direction.equals("in")) {
                    mNodeId = relation.getSrcNodeId();
                } else if (direction.equals("out")) {
                    mNodeId = relation.getDstNodeId();
                }
                if (mNodeId == null) continue;
                nodeIds.add(mNodeId);
                relationIds.add(relation.getRelationId());
                nodeRelationMap.remove(nodeId);
                List<Set<String>> childs = this.traverseNodeRelations(nodeRelationMap, direction, mNodeId, depth - 1L, depthMode, relationTypes);
                if (childs.size() != 2) continue;
                for (String n : childs.get(0)) {
                    nodeIds.add(n);
                }
                for (String r : childs.get(1)) {
                    relationIds.add(r);
                }
            }
        }
        ret.add(nodeIds);
        ret.add(relationIds);
        return ret;
    }

    private List<TopostoreNode> listTopostoreNodeWithAutoPage(String topostoreName, List<String> reqNodeIds, List<String> nodeTypes, Map<String, String> nodeProperties, Map<String, String> params) throws LogException {
        ArrayList<TopostoreNode> finalNodes = new ArrayList<TopostoreNode>();
        if (reqNodeIds.size() == 0) {
            int offset = 0;
            int total = 100000;
            while (offset < total) {
                ListTopostoreNodeRequest listNodeReq = new ListTopostoreNodeRequest();
                listNodeReq.setTopostoreName(topostoreName);
                listNodeReq.setProperties(nodeProperties);
                listNodeReq.setNodeTypes(nodeTypes);
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    listNodeReq.SetParam(entry.getKey(), entry.getValue());
                }
                ListTopostoreNodeResponse listNodeResp = this.listTopostoreNode(listNodeReq);
                total = listNodeResp.getTotal();
                for (TopostoreNode n : listNodeResp.getTopostoreNodes()) {
                    ++offset;
                    finalNodes.add(n);
                }
            }
        } else {
            int i;
            ArrayList reqNodeIdLists = new ArrayList();
            for (i = 0; i < reqNodeIds.size(); ++i) {
                if (i % 200 == 0) {
                    reqNodeIdLists.add(new ArrayList());
                }
                ((List)reqNodeIdLists.get(i / 200)).add(reqNodeIds.get(i));
            }
            for (i = 0; i < reqNodeIdLists.size(); ++i) {
                ListTopostoreNodeRequest listNodeReq = new ListTopostoreNodeRequest();
                listNodeReq.setTopostoreName(topostoreName);
                listNodeReq.setNodeIds((List)reqNodeIdLists.get(i));
                listNodeReq.setProperties(nodeProperties);
                listNodeReq.setNodeTypes(nodeTypes);
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    listNodeReq.SetParam(entry.getKey(), entry.getValue());
                }
                ListTopostoreNodeResponse listNodeResp = this.listTopostoreNode(listNodeReq);
                for (TopostoreNode n : listNodeResp.getTopostoreNodes()) {
                    finalNodes.add(n);
                }
            }
        }
        return finalNodes;
    }

    private List<TopostoreRelation> listTopostoreRelationWithAutoPage(String topostoreName, List<String> reqRelationIds, Map<String, String> params) throws LogException {
        ArrayList reqRelationIdLists = new ArrayList();
        for (int i = 0; i < reqRelationIds.size(); ++i) {
            if (i % 200 == 0) {
                reqRelationIdLists.add(new ArrayList());
            }
            ((List)reqRelationIdLists.get(i / 200)).add(reqRelationIds.get(i));
        }
        ArrayList<TopostoreRelation> finalRelations = new ArrayList<TopostoreRelation>();
        for (int i = 0; i < reqRelationIdLists.size(); ++i) {
            ListTopostoreRelationRequest listRelationReq = new ListTopostoreRelationRequest();
            listRelationReq.setTopostoreName(topostoreName);
            listRelationReq.setRelationIds((List)reqRelationIdLists.get(i));
            for (Map.Entry<String, String> kv : params.entrySet()) {
                listRelationReq.SetParam(kv.getKey(), kv.getValue());
            }
            ListTopostoreRelationResponse listRelationResp = this.listTopostoreRelation(listRelationReq);
            for (TopostoreRelation r : listRelationResp.getTopostoreRelations()) {
                finalRelations.add(r);
            }
        }
        return finalRelations;
    }

    public ListTopostoreNodeRelationResponse listTopostoreNodeRelations(ListTopostoreNodeRelationRequest request) throws LogException {
        ListTopostoreNodeRelationResponse response = new ListTopostoreNodeRelationResponse();
        ArrayList<String> allNodeIds = new ArrayList<String>();
        List<TopostoreNode> allTopoNodes = this.listTopostoreNodeWithAutoPage(request.getTopostoreName(), request.getNodeIds(), request.getNodeTypes(), request.getNodeProperities(), request.GetParam());
        for (TopostoreNode n : allTopoNodes) {
            allNodeIds.add(n.getNodeId());
        }
        if (request.getDepth() == 0L || allNodeIds.size() == 0) {
            response.setRelations(new ArrayList<TopostoreRelation>());
            response.setNodes(allTopoNodes);
            return response;
        }
        int relationOffset = 0;
        int relationTotal = 100000;
        HashMap nodeRelationMap = new HashMap();
        nodeRelationMap.put("in", new HashMap());
        nodeRelationMap.put("out", new HashMap());
        while (relationOffset < relationTotal) {
            ListTopostoreRelationRequest listRelationReq = new ListTopostoreRelationRequest();
            listRelationReq.setTopostoreName(request.getTopostoreName());
            for (Map.Entry<String, String> entry : request.GetParam().entrySet()) {
                listRelationReq.SetParam(entry.getKey(), entry.getValue());
            }
            listRelationReq.setOffset(relationOffset);
            ListTopostoreRelationResponse listRelationResp = this.listTopostoreRelation(listRelationReq);
            relationTotal = listRelationResp.getTotal();
            relationOffset += listRelationResp.getCount();
            for (TopostoreRelation relation : listRelationResp.getTopostoreRelations()) {
                String srcNodeId = relation.getSrcNodeId();
                String dstNodeId = relation.getDstNodeId();
                if (!((Map)nodeRelationMap.get("in")).containsKey(dstNodeId)) {
                    ((Map)nodeRelationMap.get("in")).put(dstNodeId, new ArrayList());
                }
                ((List)((Map)nodeRelationMap.get("in")).get(dstNodeId)).add(relation);
                if (!((Map)nodeRelationMap.get("out")).containsKey(srcNodeId)) {
                    ((Map)nodeRelationMap.get("out")).put(srcNodeId, new ArrayList());
                }
                ((List)((Map)nodeRelationMap.get("out")).get(srcNodeId)).add(relation);
            }
        }
        HashSet<String> finalNodeIds = new HashSet<String>();
        HashSet<String> finalRelationIds = new HashSet<String>();
        for (String nodeId : allNodeIds) {
            for (Map.Entry entry : nodeRelationMap.entrySet()) {
                List<Set<String>> ret;
                if (!request.getDirection().equals(entry.getKey()) && !request.getDirection().equals("both")) continue;
                boolean depthMode = false;
                if (request.getDepth() > 0L) {
                    depthMode = true;
                }
                if ((ret = this.traverseNodeRelations((Map)entry.getValue(), (String)entry.getKey(), nodeId, request.getDepth(), depthMode, request.getRelationTypes())).size() != 2) continue;
                for (String n : ret.get(0)) {
                    finalNodeIds.add(n);
                }
                for (String r : ret.get(1)) {
                    finalRelationIds.add(r);
                }
            }
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(finalNodeIds);
        if (arrayList.size() > 0) {
            response.setNodes(this.listTopostoreNodeWithAutoPage(request.getTopostoreName(), arrayList, null, null, request.GetParam()));
        } else {
            response.setNodes(new ArrayList<TopostoreNode>());
        }
        ArrayList<String> reqRelationIds = new ArrayList<String>();
        reqRelationIds.addAll(finalRelationIds);
        if (reqRelationIds.size() > 0) {
            response.setRelations(this.listTopostoreRelationWithAutoPage(request.getTopostoreName(), reqRelationIds, request.GetParam()));
        } else {
            response.setRelations(new ArrayList<TopostoreRelation>());
        }
        return response;
    }

    @Override
    public CreateResourceResponse createResource(CreateResourceRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        CodingUtils.assertParameterNotNull(request.getResource(), "resource");
        Resource resource = request.getResource();
        resource.checkForCreate();
        Map<String, String> headParameter = this.GetCommonHeadPara(request.GetProject());
        byte[] body = Client.encodeToUtf8(resource.ToJsonString());
        headParameter.put("Content-Type", "application/json");
        String resourceUri = "/resources";
        ResponseMessage response = this.SendData(request.GetProject(), HttpMethod.POST, resourceUri, request.GetAllParams(), headParameter, body);
        return new CreateResourceResponse(response.getHeaders());
    }

    @Override
    public UpdateResourceResponse updateResource(UpdateResourceRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        CodingUtils.assertParameterNotNull(request.getResource(), "resource");
        request.getResource().checkForUpdate();
        Map<String, String> headParameter = this.GetCommonHeadPara(request.GetProject());
        byte[] body = Client.encodeToUtf8(request.getResource().ToJsonString());
        headParameter.put("Content-Type", "application/json");
        CodingUtils.validateResource(request.getResource().getName());
        String resourceUri = String.format("/resources/%s", request.getResource().getName());
        HashMap urlParameter = new HashMap();
        ResponseMessage response = this.SendData(request.GetProject(), HttpMethod.PUT, resourceUri, request.GetAllParams(), headParameter, body);
        return new UpdateResourceResponse(response.getHeaders());
    }

    @Override
    public DeleteResourceResponse deleteResource(DeleteResourceRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        CodingUtils.assertStringNotNullOrEmpty(request.getResourceName(), "resourceName");
        Map<String, String> headParameter = this.GetCommonHeadPara(request.GetProject());
        String resourceUri = String.format("/resources/%s", request.getResourceName());
        headParameter.put("Content-Type", "application/json");
        ResponseMessage response = this.SendData(request.GetProject(), HttpMethod.DELETE, resourceUri, request.GetAllParams(), headParameter);
        return new DeleteResourceResponse(response.getHeaders());
    }

    @Override
    public GetResourceResponse getResource(GetResourceRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        CodingUtils.assertStringNotNullOrEmpty(request.getResourceName(), "resourceName");
        Map<String, String> headParameter = this.GetCommonHeadPara(request.GetProject());
        String resourceUri = String.format("/resources/%s", request.getResourceName());
        headParameter.put("Content-Type", "application/json");
        ResponseMessage response = this.SendData(request.GetProject(), HttpMethod.GET, resourceUri, request.GetAllParams(), headParameter);
        String requestId = this.GetRequestId(response.getHeaders());
        JSONObject object = this.parseResponseBody(response, requestId);
        Resource resource = this.extractResourceFromResponse(object, requestId);
        return new GetResourceResponse(response.getHeaders(), resource);
    }

    protected Resource extractResourceFromResponse(JSONObject dict, String requestId) throws LogException {
        Resource resource = new Resource();
        try {
            resource.FromJsonObject(dict);
        }
        catch (JSONException e) {
            throw new LogException("BadResponse", "The response is not valid json string : " + dict.toString(), e, requestId);
        }
        return resource;
    }

    @Override
    public ListResourceResponse listResource(ListResourceRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        Map<String, String> headParameter = this.GetCommonHeadPara(request.GetProject());
        String resourceUri = "/resources";
        headParameter.put("Content-Type", "application/json");
        Map<String, String> urlParameter = request.GetAllParams();
        ResponseMessage response = this.SendData(request.GetProject(), HttpMethod.GET, resourceUri, urlParameter, headParameter);
        String requestId = this.GetRequestId(response.getHeaders());
        JSONObject object = this.parseResponseBody(response, requestId);
        int total = object.getIntValue("total");
        int count = object.getIntValue("count");
        List<Resource> resources = this.extractResources(object, requestId);
        return new ListResourceResponse(response.getHeaders(), count, total, resources);
    }

    protected List<Resource> extractResources(JSONObject object, String requestId) throws LogException {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        if (object == null) {
            return resources;
        }
        JSONArray array = new JSONArray();
        try {
            array = object.getJSONArray("items");
            if (array == null) {
                return resources;
            }
            for (int index = 0; index < array.size(); ++index) {
                JSONObject jsonObject = array.getJSONObject(index);
                if (jsonObject == null) continue;
                Resource resource = new Resource();
                resource.FromJsonObject(jsonObject);
                resources.add(resource);
            }
        }
        catch (JSONException e) {
            throw new LogException("BadResponse", "The response is not valid config json array string : " + array.toString(), e, requestId);
        }
        return resources;
    }

    @Override
    public CreateResourceRecordResponse createResourceRecord(CreateResourceRecordRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        CodingUtils.assertStringNotNullOrEmpty(request.getResourceName(), "resourceName");
        CodingUtils.assertParameterNotNull(request.getRecord(), "record");
        request.getRecord().checkForCreate();
        Map<String, String> headParameter = this.GetCommonHeadPara(request.GetProject());
        byte[] body = Client.encodeToUtf8(request.getRecord().ToJsonString());
        headParameter.put("Content-Type", "application/json");
        String resourceUri = String.format("/resources/%s/records", request.getResourceName());
        ResponseMessage response = this.SendData(request.GetProject(), HttpMethod.POST, resourceUri, request.GetAllParams(), headParameter, body);
        return new CreateResourceRecordResponse(response.getHeaders());
    }

    @Override
    public UpsertResourceRecordResponse upsertResourceRecord(UpsertResourceRecordRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        CodingUtils.assertStringNotNullOrEmpty(request.getResourceName(), "resourceName");
        CodingUtils.assertParameterNotNull(request.getRecords(), "records");
        for (ResourceRecord r : request.getRecords()) {
            CodingUtils.assertParameterNotNull(r, "record");
            r.checkForUpsert();
        }
        Map<String, String> headParameter = this.GetCommonHeadPara(request.GetProject());
        byte[] body = Client.encodeToUtf8(request.getPostBody());
        headParameter.put("Content-Type", "application/json");
        String resourceUri = String.format("/resources/%s/records", request.getResourceName());
        ResponseMessage response = this.SendData(request.GetProject(), HttpMethod.PUT, resourceUri, request.GetAllParams(), headParameter, body);
        return new UpsertResourceRecordResponse(response.getHeaders());
    }

    @Override
    public UpdateResourceRecordResponse updateResourceRecord(UpdateResourceRecordRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        CodingUtils.assertStringNotNullOrEmpty(request.getResourceName(), "resourceName");
        CodingUtils.assertParameterNotNull(request.getRecord(), "record");
        CodingUtils.assertStringNotNullOrEmpty(request.getRecord().getId(), "recordId");
        request.getRecord().checkForUpdate();
        Map<String, String> headParameter = this.GetCommonHeadPara(request.GetProject());
        byte[] body = Client.encodeToUtf8(request.getRecord().ToJsonString());
        headParameter.put("Content-Type", "application/json");
        String resourceUri = String.format("/resources/%s/records/%s", request.getResourceName(), request.getRecord().getId());
        ResponseMessage response = this.SendData(request.GetProject(), HttpMethod.PUT, resourceUri, request.GetAllParams(), headParameter, body);
        return new UpdateResourceRecordResponse(response.getHeaders());
    }

    @Override
    public DeleteResourceRecordResponse deleteResourceRecord(DeleteResourceRecordRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        CodingUtils.assertStringNotNullOrEmpty(request.getResourceName(), "resourceName");
        CodingUtils.assertParameterNotNull(request.getRecordIds(), "recordIds");
        for (String id : request.getRecordIds()) {
            CodingUtils.assertStringNotNullOrEmpty(id, "recordId");
        }
        Map<String, String> headParameter = this.GetCommonHeadPara(request.GetProject());
        headParameter.put("Content-Type", "application/json");
        String resourceUri = String.format("/resources/%s/records", request.getResourceName());
        Map<String, String> urlParameter = request.GetAllParams();
        ResponseMessage response = this.SendData(request.GetProject(), HttpMethod.DELETE, resourceUri, urlParameter, headParameter);
        return new DeleteResourceRecordResponse(response.getHeaders());
    }

    @Override
    public GetResourceRecordResponse getResourceRecord(GetResourceRecordRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        CodingUtils.assertStringNotNullOrEmpty(request.getResourceName(), "resourceName");
        CodingUtils.assertStringNotNullOrEmpty(request.getRecordId(), "recordId");
        Map<String, String> headParameter = this.GetCommonHeadPara(request.GetProject());
        String resourceUri = String.format("/resources/%s/records/%s", request.getResourceName(), request.getRecordId());
        headParameter.put("Content-Type", "application/json");
        HashMap urlParameter = new HashMap();
        ResponseMessage response = this.SendData(request.GetProject(), HttpMethod.GET, resourceUri, request.GetAllParams(), headParameter);
        String requestId = this.GetRequestId(response.getHeaders());
        JSONObject object = this.parseResponseBody(response, requestId);
        ResourceRecord record = this.extractResourceRecordFromResponse(object, requestId);
        return new GetResourceRecordResponse(response.getHeaders(), record);
    }

    protected ResourceRecord extractResourceRecordFromResponse(JSONObject dict, String requestId) throws LogException {
        ResourceRecord record = new ResourceRecord();
        try {
            record.FromJsonObject(dict);
        }
        catch (JSONException e) {
            throw new LogException("BadResponse", "The response is not valid json string : " + dict.toString(), e, requestId);
        }
        return record;
    }

    @Override
    public ListResourceRecordResponse listResourceRecord(ListResourceRecordRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        CodingUtils.assertStringNotNullOrEmpty(request.getResourceName(), "resourceName");
        Map<String, String> headParameter = this.GetCommonHeadPara(request.GetProject());
        String resourceUri = String.format("/resources/%s/records", request.getResourceName());
        headParameter.put("Content-Type", "application/json");
        Map<String, String> urlParameter = request.GetAllParams();
        ResponseMessage response = this.SendData(request.GetProject(), HttpMethod.GET, resourceUri, urlParameter, headParameter);
        String requestId = this.GetRequestId(response.getHeaders());
        JSONObject object = this.parseResponseBody(response, requestId);
        int total = object.getIntValue("total");
        int count = object.getIntValue("count");
        List<ResourceRecord> records = this.extractResourceRecords(object, requestId);
        return new ListResourceRecordResponse(response.getHeaders(), count, total, records);
    }

    protected List<ResourceRecord> extractResourceRecords(JSONObject object, String requestId) throws LogException {
        ArrayList<ResourceRecord> records = new ArrayList<ResourceRecord>();
        if (object == null) {
            return records;
        }
        JSONArray array = new JSONArray();
        try {
            array = object.getJSONArray("items");
            if (array == null) {
                return records;
            }
            for (int index = 0; index < array.size(); ++index) {
                JSONObject jsonObject = array.getJSONObject(index);
                if (jsonObject == null) continue;
                ResourceRecord record = new ResourceRecord();
                record.FromJsonObject(jsonObject);
                records.add(record);
            }
        }
        catch (JSONException e) {
            throw new LogException("BadResponse", "The response is not valid config json array string : " + array.toString(), e, requestId);
        }
        return records;
    }

    @Override
    public StartAuditJobResponse startAuditJob(StartAuditJobRequest request) throws LogException {
        ResponseMessage responseMessage = this.send(request);
        return new StartAuditJobResponse(responseMessage.getHeaders());
    }

    @Override
    public UpdateAlertResponse updateAlert(UpdateAlertRequest request) throws LogException {
        ResponseMessage message = this.send(request);
        return new UpdateAlertResponse(message.getHeaders());
    }

    @Override
    public DeleteAlertResponse deleteAlert(DeleteAlertRequest request) throws LogException {
        ResponseMessage responseMessage = this.send(request);
        return new DeleteAlertResponse(responseMessage.getHeaders());
    }

    @Override
    public GetAlertResponse getAlert(GetAlertRequest request) throws LogException {
        ResponseMessage response = this.send(request);
        JSONObject responseBody = this.parseResponseBody(response, response.getRequestId());
        GetAlertResponse alertResponse = new GetAlertResponse(response.getHeaders());
        alertResponse.deserialize(responseBody, response.getRequestId());
        return alertResponse;
    }

    @Override
    public ListAlertResponse listAlert(ListAlertRequest request) throws LogException {
        ResponseMessage response = this.send(request);
        JSONObject responseBody = this.parseResponseBody(response, response.getRequestId());
        ListAlertResponse alertResponse = new ListAlertResponse(response.getHeaders());
        alertResponse.deserialize(responseBody, response.getRequestId());
        return alertResponse;
    }

    @Override
    public CreateReportResponse createReport(CreateReportRequest request) throws LogException {
        ResponseMessage responseMessage = this.send(request);
        return new CreateReportResponse(responseMessage.getHeaders());
    }

    @Override
    public GetReportResponse getReport(GetReportRequest request) throws LogException {
        ResponseMessage response = this.send(request);
        JSONObject responseBody = this.parseResponseBody(response, response.getRequestId());
        GetReportResponse getReportResponse = new GetReportResponse(response.getHeaders());
        getReportResponse.deserialize(responseBody, response.getRequestId());
        return getReportResponse;
    }

    @Override
    public UpdateReportResponse updateReport(UpdateReportRequest request) throws LogException {
        ResponseMessage message = this.send(request);
        return new UpdateReportResponse(message.getHeaders());
    }

    @Override
    public DeleteReportResponse deleteReport(DeleteReportRequest request) throws LogException {
        ResponseMessage responseMessage = this.send(request);
        return new DeleteReportResponse(responseMessage.getHeaders());
    }

    @Override
    public ListReportResponse listReport(ListReportRequest request) throws LogException {
        ResponseMessage response = this.send(request);
        JSONObject responseBody = this.parseResponseBody(response, response.getRequestId());
        ListReportResponse listReportResponse = new ListReportResponse(response.getHeaders());
        listReportResponse.deserialize(responseBody, response.getRequestId());
        return listReportResponse;
    }

    @Override
    public EnableReportResponse enableReport(EnableReportRequest request) throws LogException {
        ResponseMessage responseMessage = this.send(request);
        return new EnableReportResponse(responseMessage.getHeaders());
    }

    @Override
    public DisableReportResponse disableReport(DisableReportRequest request) throws LogException {
        ResponseMessage responseMessage = this.send(request);
        return new DisableReportResponse(responseMessage.getHeaders());
    }

    @Override
    public SetLogstoreReplicationResponse setLogstoreReplication(String project, String logStore, boolean enable) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        SetLogstoreReplicationRequest request = new SetLogstoreReplicationRequest(project, logStore, enable);
        return this.setLogstoreReplication(request);
    }

    @Override
    public SetLogstoreReplicationResponse setLogstoreReplication(SetLogstoreReplicationRequest request) throws LogException {
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String logStore = request.getLogStore();
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/logstores/" + logStore + "/" + "replication";
        Map<String, String> urlParameter = request.GetAllParams();
        JSONObject requestBodyJsonObject = new JSONObject();
        requestBodyJsonObject.put("enableReplication", (Object)request.getEnable());
        ResponseMessage response = this.SendData(project, HttpMethod.POST, resourceUri, urlParameter, headParameter, requestBodyJsonObject.toString());
        return new SetLogstoreReplicationResponse(response.getHeaders());
    }

    @Override
    public GetLogstoreReplicationResponse getLogstoreReplication(String project, String logStore) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        GetLogstoreReplicationRequest request = new GetLogstoreReplicationRequest(project, logStore);
        return this.getLogstoreReplication(request);
    }

    @Override
    public GetLogstoreReplicationResponse getLogstoreReplication(GetLogstoreReplicationRequest request) throws LogException {
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String logStore = request.getLogStore();
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/logstores/" + logStore + "/" + "replication";
        Map<String, String> urlParameter = request.GetAllParams();
        ResponseMessage response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        String requestId = this.GetRequestId(resHeaders);
        JSONObject object = this.parseResponseBody(response, requestId);
        boolean enable = object.getBoolean("enableReplication");
        return new GetLogstoreReplicationResponse(response.getHeaders(), enable);
    }

    @Override
    public CreateEtlJobResponse createEtlJob(CreateEtlJobRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        EtlJob etlJob = request.getEtlJob();
        CodingUtils.assertParameterNotNull(etlJob, "etlJob");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        byte[] body = Client.encodeToUtf8(etlJob.toJsonString(true, true));
        headParameter.put("Content-Type", "application/json");
        String resourceUri = "/etljobs";
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(project, HttpMethod.POST, resourceUri, urlParameter, headParameter, body);
        return new CreateEtlJobResponse(response.getHeaders());
    }

    @Override
    public DeleteEtlJobResponse deleteEtlJob(DeleteEtlJobRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String etlJobName = request.getEtlJobName();
        CodingUtils.validateETLJob(etlJobName);
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/etljobs/" + etlJobName;
        Map<String, String> urlParameter = request.GetAllParams();
        ResponseMessage response = this.SendData(project, HttpMethod.DELETE, resourceUri, urlParameter, headParameter);
        return new DeleteEtlJobResponse(response.getHeaders());
    }

    @Override
    public UpdateEtlJobResponse updateEtlJob(UpdateEtlJobRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        EtlJob etlJob = request.getEtlJob();
        CodingUtils.assertParameterNotNull(etlJob, "etlJob");
        CodingUtils.validateETLJob(etlJob.getJobName());
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        byte[] body = Client.encodeToUtf8(etlJob.toJsonString(false, false));
        headParameter.put("Content-Type", "application/json");
        String resourceUri = "/etljobs/" + etlJob.getJobName();
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(project, HttpMethod.PUT, resourceUri, urlParameter, headParameter, body);
        return new UpdateEtlJobResponse(response.getHeaders());
    }

    @Override
    public GetEtlJobResponse getEtlJob(GetEtlJobRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String etlJobName = request.getEtlJobName();
        CodingUtils.validateETLJob(etlJobName);
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/etljobs/" + etlJobName;
        Map<String, String> urlParameter = request.GetAllParams();
        ResponseMessage response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        String requestId = this.GetRequestId(resHeaders);
        JSONObject object = this.parseResponseBody(response, requestId);
        EtlJob etlJob = new EtlJob();
        etlJob.fromJsonObject(object);
        return new GetEtlJobResponse(resHeaders, etlJob);
    }

    @Override
    public ListEtlJobResponse listEtlJob(ListEtlJobRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        CodingUtils.assertStringNotNullOrEmpty(request.GetProject(), "project");
        Map<String, String> headParameter = this.GetCommonHeadPara(request.GetProject());
        String resourceUri = "/etljobs";
        headParameter.put("Content-Type", "application/json");
        Map<String, String> urlParameter = request.GetAllParams();
        ResponseMessage response = this.SendData(request.GetProject(), HttpMethod.GET, resourceUri, urlParameter, headParameter);
        String requestId = this.GetRequestId(response.getHeaders());
        JSONObject object = this.parseResponseBody(response, requestId);
        ListEtlJobResponse listResp = new ListEtlJobResponse(response.getHeaders(), object.getIntValue("total"));
        listResp.setEtlJobNameList(this.ExtractJsonArray("etlJobNameList", object));
        return listResp;
    }

    @Override
    public CreateEtlMetaResponse createEtlMeta(String project, EtlMeta etlMeta) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertParameterNotNull(etlMeta, "etlMeta");
        etlMeta.checkForCreate();
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        headParameter.put("Content-Type", "application/json");
        String resourceUri = "/etlmetas";
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(project, HttpMethod.POST, resourceUri, urlParameter, headParameter, etlMeta.toJsonObject().toString());
        return new CreateEtlMetaResponse(response.getHeaders());
    }

    @Override
    public CreateEtlMetaResponse batchCreateEtlMeta(String project, ArrayList<EtlMeta> etlMetaList) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertParameterNotNull(etlMetaList, "etlMetaList");
        if (etlMetaList.size() == 0 || etlMetaList.size() > 100) {
            throw new IllegalArgumentException("etlMetaList size not valid, should be [1, 100]");
        }
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        headParameter.put("Content-Type", "application/json");
        String resourceUri = "/etlmetas";
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        JSONObject requestBodyJsonObject = new JSONObject();
        JSONArray etlMetaJsonArray = new JSONArray();
        for (EtlMeta meta : etlMetaList) {
            meta.checkForCreate();
            etlMetaJsonArray.add(meta.toJsonObject());
        }
        requestBodyJsonObject.put("etlMetaList", (Object)etlMetaJsonArray);
        ResponseMessage response = this.SendData(project, HttpMethod.POST, resourceUri, urlParameter, headParameter, requestBodyJsonObject.toString());
        return new CreateEtlMetaResponse(response.getHeaders());
    }

    @Override
    public DeleteEtlMetaResponse deleteEtlMeta(String project, String etlMetaName, String etlMetaKey) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(etlMetaName, "etlMetaName");
        CodingUtils.assertStringNotNullOrEmpty(etlMetaKey, "etlMetaKey");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/etlmetas";
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        urlParameter.put("etlMetaName", etlMetaName);
        urlParameter.put("etlMetaKey", etlMetaKey);
        urlParameter.put("etlMetaTag", "__all_etl_meta_tag_match__");
        ResponseMessage response = this.SendData(project, HttpMethod.DELETE, resourceUri, urlParameter, headParameter);
        return new DeleteEtlMetaResponse(response.getHeaders());
    }

    @Override
    public DeleteEtlMetaResponse deleteEtlMeta(String project, String etlMetaName, String etlMetaKey, String etlMetaTag) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(etlMetaName, "etlMetaName");
        CodingUtils.assertStringNotNullOrEmpty(etlMetaKey, "etlMetaKey");
        CodingUtils.assertParameterNotNull(etlMetaTag, "etlMetaTag");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/etlmetas";
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        urlParameter.put("etlMetaName", etlMetaName);
        urlParameter.put("etlMetaKey", etlMetaKey);
        urlParameter.put("etlMetaTag", etlMetaTag);
        ResponseMessage response = this.SendData(project, HttpMethod.DELETE, resourceUri, urlParameter, headParameter);
        return new DeleteEtlMetaResponse(response.getHeaders());
    }

    @Override
    public BatchModifyEtlMetaStatusResponse batchModifyEtlMetaStatus(String project, String etlMetaName, String etlMetaTag, Consts.BatchModifyEtlMetaType type) throws LogException {
        return this.batchModifyEtlMetaStatus(project, etlMetaName, null, etlMetaTag, "all", type);
    }

    @Override
    public BatchModifyEtlMetaStatusResponse batchModifyEtlMetaStatus(String project, String etlMetaName, ArrayList<String> etlMetaKeyList, Consts.BatchModifyEtlMetaType type) throws LogException {
        return this.batchModifyEtlMetaStatus(project, etlMetaName, etlMetaKeyList, "__all_etl_meta_tag_match__", type);
    }

    @Override
    public BatchModifyEtlMetaStatusResponse batchModifyEtlMetaStatus(String project, String etlMetaName, ArrayList<String> etlMetaKeyList, String etlMetaTag, Consts.BatchModifyEtlMetaType type) throws LogException {
        return this.batchModifyEtlMetaStatus(project, etlMetaName, etlMetaKeyList, etlMetaTag, "list", type);
    }

    private BatchModifyEtlMetaStatusResponse batchModifyEtlMetaStatus(String project, String etlMetaName, ArrayList<String> etlMetaKeyList, String etlMetaTag, String range, Consts.BatchModifyEtlMetaType type) throws LogException {
        if (range.equals("list")) {
            if (etlMetaKeyList == null || etlMetaKeyList.size() == 0 || etlMetaKeyList.size() > 200) {
                throw new IllegalArgumentException("etlMetaKeyList size not valid, should be [1, 200]");
            }
        } else if (range.equals("all")) {
            if (etlMetaTag.equals("__all_etl_meta_tag_match__")) {
                throw new IllegalArgumentException("parameter etlMetaTag can not be `__all_etl_meta_tag_match__` when batchDelete by tag");
            }
        } else {
            throw new IllegalArgumentException("range not valid, should be `all` or `list`");
        }
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(etlMetaName, "etlMetaName");
        CodingUtils.assertParameterNotNull(etlMetaTag, "etlMetaTag");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/etlmetas";
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        urlParameter.put("type", type.toString());
        JSONObject requestBodyJsonObject = new JSONObject();
        requestBodyJsonObject.put("etlMetaName", (Object)etlMetaName);
        requestBodyJsonObject.put("etlMetaTag", (Object)etlMetaTag);
        requestBodyJsonObject.put("range", (Object)range);
        if (range.equals("list")) {
            JSONArray etlMetaKeyJsonArray = new JSONArray();
            etlMetaKeyJsonArray.addAll((Collection<?>)etlMetaKeyList);
            requestBodyJsonObject.put("etlMetaKeyList", (Object)etlMetaKeyJsonArray);
        }
        ResponseMessage response = this.SendData(project, HttpMethod.PUT, resourceUri, urlParameter, headParameter, requestBodyJsonObject.toString());
        return new BatchModifyEtlMetaStatusResponse(response.getHeaders());
    }

    @Override
    public UpdateEtlMetaResponse updateEtlMeta(String project, EtlMeta etlMeta) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertParameterNotNull(etlMeta, "etlMeta");
        etlMeta.checkForUpdate();
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        headParameter.put("Content-Type", "application/json");
        String resourceUri = "/etlmetas";
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(project, HttpMethod.PUT, resourceUri, urlParameter, headParameter, etlMeta.toJsonObject().toString());
        return new UpdateEtlMetaResponse(response.getHeaders());
    }

    @Override
    public UpdateEtlMetaResponse batchUpdateEtlMeta(String project, ArrayList<EtlMeta> etlMetaList) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertParameterNotNull(etlMetaList, "etlMetaList");
        if (etlMetaList.size() == 0 || etlMetaList.size() > 100) {
            throw new IllegalArgumentException("etlMetaList size not valid, should be [1, 100]");
        }
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        headParameter.put("Content-Type", "application/json");
        String resourceUri = "/etlmetas";
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        JSONObject requestBodyJsonObject = new JSONObject();
        JSONArray etlMetaJsonArray = new JSONArray();
        for (EtlMeta meta : etlMetaList) {
            meta.checkForUpdate();
            etlMetaJsonArray.add(meta.toJsonObject());
        }
        requestBodyJsonObject.put("etlMetaList", (Object)etlMetaJsonArray);
        ResponseMessage response = this.SendData(project, HttpMethod.PUT, resourceUri, urlParameter, headParameter, requestBodyJsonObject.toString());
        return new UpdateEtlMetaResponse(response.getHeaders());
    }

    @Override
    public ListEtlMetaNameResponse listEtlMetaName(String project, int offset, int size) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertParameterNotNull(offset, "offset");
        CodingUtils.assertParameterNotNull(size, "size");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/etlmetanames";
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        urlParameter.put("offset", String.valueOf(offset));
        urlParameter.put("size", String.valueOf(size));
        ResponseMessage response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        String requestId = this.GetRequestId(resHeaders);
        JSONObject object = this.parseResponseBody(response, requestId);
        ListEtlMetaNameResponse listResp = new ListEtlMetaNameResponse(response.getHeaders(), object.getIntValue("total"));
        listResp.setEtlMetaNameList(this.ExtractJsonArray("etlMetaNameList", object));
        return listResp;
    }

    private ListEtlMetaResponse listEtlMeta(ListEtlMetaRequest request) throws LogException {
        Map<String, String> headParameter = this.GetCommonHeadPara(request.GetProject());
        Map<String, String> urlParameter = request.GetAllParams();
        String resourceUri = "/etlmetas";
        ResponseMessage response = this.SendData(request.GetProject(), HttpMethod.GET, resourceUri, urlParameter, headParameter);
        String requestId = this.GetRequestId(response.getHeaders());
        JSONObject object = this.parseResponseBody(response, requestId);
        ListEtlMetaResponse listResp = new ListEtlMetaResponse(response.getHeaders(), object.getIntValue("total"));
        try {
            JSONArray items = object.getJSONArray("etlMetaList");
            if (items == null) {
                return listResp;
            }
            for (int i = 0; i < items.size(); ++i) {
                JSONObject jsonObject = items.getJSONObject(i);
                if (jsonObject == null) continue;
                EtlMeta meta = new EtlMeta();
                meta.fromJsonObject(jsonObject);
                listResp.addEtlMeta(meta);
            }
        }
        catch (JSONException e) {
            throw new LogException("BadResponse", e.getMessage(), listResp.GetRequestId());
        }
        return listResp;
    }

    @Override
    public ListEtlMetaResponse listEtlMeta(String project, String etlMetaName, int offset, int size) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(etlMetaName, "etlMetaName");
        CodingUtils.assertParameterNotNull(offset, "offset");
        CodingUtils.assertParameterNotNull(size, "size");
        ListEtlMetaRequest request = new ListEtlMetaRequest(project, offset, size);
        request.setEtlMetaName(etlMetaName);
        request.setEtlMetaKey("");
        request.setEtlMetaTag("__all_etl_meta_tag_match__");
        return this.listEtlMeta(request);
    }

    @Override
    public ListEtlMetaResponse listEtlMeta(String project, String etlMetaName, String etlMetaTag, int offset, int size) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(etlMetaName, "etlMetaName");
        CodingUtils.assertParameterNotNull(etlMetaTag, "etlMetaTag");
        CodingUtils.assertParameterNotNull(offset, "offset");
        CodingUtils.assertParameterNotNull(size, "size");
        ListEtlMetaRequest request = new ListEtlMetaRequest(project, offset, size);
        request.setEtlMetaName(etlMetaName);
        request.setEtlMetaKey("");
        request.setEtlMetaTag(etlMetaTag);
        return this.listEtlMeta(request);
    }

    @Override
    public ListEtlMetaResponse listEtlMeta(String project, String etlMetaName, String dispatchProject, String dispatchLogstore, int offset, int size) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(etlMetaName, "etlMetaName");
        CodingUtils.assertParameterNotNull(dispatchProject, "dispatchProject");
        CodingUtils.assertParameterNotNull(dispatchLogstore, "dispatchLogstore");
        CodingUtils.assertParameterNotNull(offset, "offset");
        CodingUtils.assertParameterNotNull(size, "size");
        ListEtlMetaRequest request = new ListEtlMetaRequest(project, offset, size);
        request.setEtlMetaName(etlMetaName);
        request.setEtlMetaKey("");
        request.setEtlMetaTag("__all_etl_meta_tag_match__");
        request.setDispatchProject(dispatchProject);
        request.setDispatchLogstore(dispatchLogstore);
        return this.listEtlMeta(request);
    }

    @Override
    public ListEtlMetaResponse getEtlMeta(String project, String etlMetaName, String etlMetaKey) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(etlMetaName, "etlMetaName");
        CodingUtils.assertStringNotNullOrEmpty(etlMetaKey, "etlMetaKey");
        ListEtlMetaRequest request = new ListEtlMetaRequest(project, 0, 1);
        request.setEtlMetaName(etlMetaName);
        request.setEtlMetaKey(etlMetaKey);
        request.setEtlMetaTag("__all_etl_meta_tag_match__");
        return this.listEtlMeta(request);
    }

    @Override
    public CreateLoggingResponse createLogging(CreateLoggingRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        Map<String, String> headers = this.GetCommonHeadPara(project);
        Logging logging = request.getLogging();
        ResponseMessage response = this.SendData(project, HttpMethod.POST, "/logging", Collections.<String, String>emptyMap(), headers, logging.marshal().toString());
        return new CreateLoggingResponse(response.getHeaders());
    }

    @Override
    public UpdateLoggingResponse updateLogging(UpdateLoggingRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        Map<String, String> headers = this.GetCommonHeadPara(project);
        Logging logging = request.getLogging();
        ResponseMessage response = this.SendData(project, HttpMethod.PUT, "/logging", Collections.<String, String>emptyMap(), headers, logging.marshal().toString());
        return new UpdateLoggingResponse(response.getHeaders());
    }

    @Override
    public GetLoggingResponse getLogging(GetLoggingRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        Map<String, String> headers = this.GetCommonHeadPara(project);
        ResponseMessage response = this.SendData(project, HttpMethod.GET, "/logging", Collections.<String, String>emptyMap(), headers);
        JSONObject responseBody = this.parseResponseBody(response, response.getRequestId());
        try {
            return new GetLoggingResponse(response.getHeaders(), Logging.unmarshal(responseBody));
        }
        catch (JSONException ex) {
            throw new LogException("BadResponse", ex.getMessage(), response.getRequestId());
        }
    }

    @Override
    public DeleteLoggingResponse deleteLogging(DeleteLoggingRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        Map<String, String> headers = this.GetCommonHeadPara(project);
        ResponseMessage response = this.SendData(project, HttpMethod.DELETE, "/logging", Collections.<String, String>emptyMap(), headers);
        return new DeleteLoggingResponse(response.getHeaders());
    }

    @Override
    public CreateJobResponse createJob(CreateJobRequest request) throws LogException {
        ResponseMessage response = this.send(request);
        return new CreateJobResponse(response.getHeaders());
    }

    @Override
    public CreateAlertResponse createAlert(CreateAlertRequest request) throws LogException {
        ResponseMessage responseMessage = this.send(request);
        return new CreateAlertResponse(responseMessage.getHeaders());
    }

    @Override
    public GetJobResponse getJob(GetJobRequest request) throws LogException {
        ResponseMessage response = this.send(request);
        JSONObject responseBody = this.parseResponseBody(response, response.getRequestId());
        GetJobResponse getJobResponse = new GetJobResponse(response.getHeaders());
        getJobResponse.deserialize(responseBody, response.getRequestId());
        return getJobResponse;
    }

    @Override
    public UpdateJobResponse updateJob(UpdateJobRequest request) throws LogException {
        ResponseMessage response = this.send(request);
        return new UpdateJobResponse(response.getHeaders());
    }

    @Override
    public DeleteJobResponse deleteJob(DeleteJobRequest request) throws LogException {
        ResponseMessage response = this.send(request);
        return new DeleteJobResponse(response.getHeaders());
    }

    @Override
    public EnableJobResponse enableJob(EnableJobRequest request) throws LogException {
        ResponseMessage response = this.send(request);
        return new EnableJobResponse(response.getHeaders());
    }

    @Override
    public EnableAlertResponse enableAlert(EnableAlertRequest request) throws LogException {
        ResponseMessage response = this.send(request);
        return new EnableAlertResponse(response.getHeaders());
    }

    @Override
    public DisableJobResponse disableJob(DisableJobRequest request) throws LogException {
        ResponseMessage response = this.send(request);
        return new DisableJobResponse(response.getHeaders());
    }

    @Override
    public DisableAlertResponse disableAlert(DisableAlertRequest request) throws LogException {
        ResponseMessage response = this.send(request);
        return new DisableAlertResponse(response.getHeaders());
    }

    @Override
    public ListJobsResponse listJobs(ListJobsRequest request) throws LogException {
        ResponseMessage response = this.send(request);
        JSONObject responseBody = this.parseResponseBody(response, response.getRequestId());
        ListJobsResponse jobsResponse = new ListJobsResponse(response.getHeaders());
        jobsResponse.deserialize(responseBody, response.getRequestId());
        return jobsResponse;
    }

    @Override
    public CreateETLV2Response createETLV2(CreateETLV2Request request) throws LogException {
        ResponseMessage resp = this.send(request);
        return new CreateETLV2Response(resp.getHeaders());
    }

    @Override
    public UpdateETLV2Response updateETLV2(UpdateETLV2Request request) throws LogException {
        ResponseMessage resp = this.send(request);
        return new UpdateETLV2Response(resp.getHeaders());
    }

    @Override
    public DeleteETLV2Response deleteETLV2(DeleteETLV2Request request) throws LogException {
        ResponseMessage resp = this.send(request);
        return new DeleteETLV2Response(resp.getHeaders());
    }

    @Override
    public GetETLV2Response getETLV2(GetETLV2Request request) throws LogException {
        ResponseMessage response = this.send(request);
        JSONObject responseBody = this.parseResponseBody(response, response.getRequestId());
        GetETLV2Response etlResponse = new GetETLV2Response(response.getHeaders());
        etlResponse.deserialize(responseBody, response.getRequestId());
        return etlResponse;
    }

    @Override
    public ListETLV2Response listETLV2(ListETLV2Request request) throws LogException {
        ResponseMessage resp = this.send(request);
        JSONObject respBody = this.parseResponseBody(resp, resp.getRequestId());
        ListETLV2Response listResp = new ListETLV2Response(resp.getHeaders());
        listResp.deserialize(respBody, resp.getRequestId());
        return listResp;
    }

    @Override
    public StopETLV2Response stopETLV2(StopETLV2Request request) throws LogException {
        ResponseMessage responseMessage = this.send(request);
        return new StopETLV2Response(responseMessage.getHeaders());
    }

    @Override
    public StartETLV2Response startETLV2(StartETLV2Request request) throws LogException {
        ResponseMessage responseMessage = this.send(request);
        return new StartETLV2Response(responseMessage.getHeaders());
    }

    @Override
    public ReStartETLV2Response reStartETLV2(ReStartETLV2Request request) throws LogException {
        ResponseMessage responseMessage = this.send(request);
        return new ReStartETLV2Response(responseMessage.getHeaders());
    }

    @Override
    public CreateExportResponse createExport(CreateExportRequest request) throws LogException {
        ResponseMessage resp = this.send(request);
        return new CreateExportResponse(resp.getHeaders());
    }

    @Override
    public UpdateExportResponse updateExport(UpdateExportRequest request) throws LogException {
        ResponseMessage resp = this.send(request);
        return new UpdateExportResponse(resp.getHeaders());
    }

    @Override
    public DeleteExportResponse deleteExport(DeleteExportRequest request) throws LogException {
        ResponseMessage resp = this.send(request);
        return new DeleteExportResponse(resp.getHeaders());
    }

    @Override
    public GetExportResponse getExport(GetExportRequest request) throws LogException {
        ResponseMessage resp = this.send(request);
        JSONObject respBody = this.parseResponseBody(resp, resp.getRequestId());
        GetExportResponse exportResp = new GetExportResponse(resp.getHeaders());
        exportResp.deserialize(respBody, resp.getRequestId());
        return exportResp;
    }

    @Override
    public ListExportResponse listExport(ListExportRequest request) throws LogException {
        ResponseMessage resp = this.send(request);
        JSONObject respBody = this.parseResponseBody(resp, resp.getRequestId());
        ListExportResponse listResp = new ListExportResponse(resp.getHeaders());
        listResp.deserialize(respBody, resp.getRequestId());
        return listResp;
    }

    @Override
    public StopExportResponse stopExport(StopExportRequest request) throws LogException {
        ResponseMessage responseMessage = this.send(request);
        return new StopExportResponse(responseMessage.getHeaders());
    }

    @Override
    public StartExportResponse startExport(StartExportRequest request) throws LogException {
        ResponseMessage responseMessage = this.send(request);
        return new StartExportResponse(responseMessage.getHeaders());
    }

    @Override
    public RestartExportResponse restartExport(RestartExportRequest request) throws LogException {
        ResponseMessage responseMessage = this.send(request);
        return new RestartExportResponse(responseMessage.getHeaders());
    }

    @Override
    public CreateScheduledSQLResponse createScheduledSQL(CreateScheduledSQLRequest request) throws LogException {
        boolean sustained;
        ScheduledSQL scheduledSQL = (ScheduledSQL)request.getBody();
        Long fromTime = scheduledSQL.getConfiguration().getFromTime();
        Long toTime = scheduledSQL.getConfiguration().getToTime();
        boolean timeRange = fromTime > 1451577600L && toTime > fromTime;
        boolean bl = sustained = fromTime > 1451577600L && toTime == 0L;
        if (!timeRange && !sustained) {
            throw new IllegalArgumentException("Invalid fromTime: " + fromTime + " toTime: " + toTime + ", please ensure fromTime more than 1451577600.");
        }
        ResponseMessage resp = this.send(request);
        return new CreateScheduledSQLResponse(resp.getHeaders());
    }

    @Override
    public DeleteScheduledSQLResponse deleteScheduledSQL(DeleteScheduledSQLRequest request) throws LogException {
        ResponseMessage resp = this.send(request);
        return new DeleteScheduledSQLResponse(resp.getHeaders());
    }

    @Override
    public GetScheduledSQLResponse getScheduledSQL(GetScheduledSQLRequest request) throws LogException {
        ResponseMessage resp = this.send(request);
        JSONObject respBody = this.parseResponseBody(resp, resp.getRequestId());
        GetScheduledSQLResponse scheduledSQLResp = new GetScheduledSQLResponse(resp.getHeaders());
        scheduledSQLResp.deserialize(respBody, resp.getRequestId());
        return scheduledSQLResp;
    }

    @Override
    public ListScheduledSQLResponse listScheduledSQL(ListScheduledSQLRequest request) throws LogException {
        ResponseMessage resp = this.send(request);
        JSONObject respBody = this.parseResponseBody(resp, resp.getRequestId());
        ListScheduledSQLResponse listResp = new ListScheduledSQLResponse(resp.getHeaders());
        listResp.deserialize(respBody, resp.getRequestId());
        return listResp;
    }

    @Override
    public UpdateScheduledSQLResponse updateScheduledSQL(UpdateScheduledSQLRequest request) throws LogException {
        ResponseMessage resp = this.send(request);
        return new UpdateScheduledSQLResponse(resp.getHeaders());
    }

    @Override
    public GetJobInstanceResponse getJobInstance(GetJobInstanceRequest request) throws LogException {
        ResponseMessage resp = this.send(request);
        JSONObject respBody = this.parseResponseBody(resp, resp.getRequestId());
        GetJobInstanceResponse getJobInstanceRes = new GetJobInstanceResponse(resp.getHeaders());
        getJobInstanceRes.deserialize(respBody, resp.getRequestId());
        return getJobInstanceRes;
    }

    @Override
    public ModifyJobInstanceStateResponse modifyJobInstanceState(ModifyJobInstanceStateRequest request) throws LogException {
        ResponseMessage responseMessage = this.send(request);
        return new ModifyJobInstanceStateResponse(responseMessage.getHeaders());
    }

    @Override
    public ListJobInstancesResponse listJobInstances(ListJobInstancesRequest request) throws LogException {
        ResponseMessage resp = this.send(request);
        JSONObject respBody = this.parseResponseBody(resp, resp.getRequestId());
        ListJobInstancesResponse listResp = new ListJobInstancesResponse(resp.getHeaders());
        listResp.deserialize(respBody, resp.getRequestId());
        return listResp;
    }

    private ResponseMessage send(BasicRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        Map<String, String> headers = this.GetCommonHeadPara(project);
        Object body = request.getBody();
        byte[] requestBody = body == null ? new byte[]{} : Client.encodeToUtf8(JsonUtils.serialize(body));
        return this.SendData(project, request.getMethod(), request.getUri(), request.GetAllParams(), headers, requestBody);
    }

    private ResponseMessage send(BasicRequest request, String body) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        Map<String, String> headers = this.GetCommonHeadPara(project);
        byte[] requestBody = Client.encodeToUtf8(body);
        return this.SendData(project, request.getMethod(), request.getUri(), request.GetAllParams(), headers, requestBody);
    }

    private void ExtractProjectConsumerGroup(JSONArray array, String requestId, List<ProjectConsumerGroup> consumerGroups) throws LogException {
        try {
            for (int i = 0; i < array.size(); ++i) {
                JSONObject consumerGroup = array.getJSONObject(i);
                consumerGroups.add(new ProjectConsumerGroup(consumerGroup.getString("name"), consumerGroup.getString("logstoreName"), consumerGroup.getIntValue("timeout"), consumerGroup.getBoolean("order")));
            }
        }
        catch (JSONException e) {
            throw new LogException("BadResponse", "The response is not valid consumer group json array string : " + array.toString(), e, requestId);
        }
    }

    public String getRealServerIP() {
        return this.realServerIP;
    }

    public void setRealServerIP(String realServerIP) {
        this.realServerIP = realServerIP;
    }

    @Override
    public CreateOrUpdateSqlInstanceResponse createSqlInstance(CreateOrUpdateSqlInstanceRequest request) throws LogException {
        return this.createOrUpdateSqlInstance(request, HttpMethod.POST);
    }

    @Override
    public CreateOrUpdateSqlInstanceResponse updateSqlInstance(CreateOrUpdateSqlInstanceRequest request) throws LogException {
        return this.createOrUpdateSqlInstance(request, HttpMethod.PUT);
    }

    public CreateOrUpdateSqlInstanceResponse createOrUpdateSqlInstance(CreateOrUpdateSqlInstanceRequest request, HttpMethod method) throws LogException {
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        int cu = request.getCu();
        JSONObject object = new JSONObject();
        object.put("cu", (Object)cu);
        object.put("useAsDefault", (Object)request.isUseAsDefault());
        byte[] body = Client.encodeToUtf8(object.toJSONString());
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        headParameter.put("Content-Type", "application/json");
        String resourceUri = "/sqlinstance";
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(project, method, resourceUri, urlParameter, headParameter, body);
        Map<String, String> resHeaders = response.getHeaders();
        return new CreateOrUpdateSqlInstanceResponse(resHeaders);
    }

    @Override
    public ListSqlInstanceResponse listSqlInstance(ListSqlInstanceRequest request) throws LogException {
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        String resourceUri = "/sqlinstance";
        ResponseMessage response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        String requestId = this.GetRequestId(resHeaders);
        JSONArray array = this.ParseResponseMessageToArray(response, requestId);
        ArrayList<SqlInstance> sqlInstances = new ArrayList<SqlInstance>();
        for (int i = 0; array != null && i < array.size(); ++i) {
            SqlInstance sqlInstance = new SqlInstance();
            sqlInstance.fromJson(array.getJSONObject(i));
            sqlInstances.add(sqlInstance);
        }
        return new ListSqlInstanceResponse(resHeaders, sqlInstances);
    }

    @Override
    public SetProjectPolicyResponse setProjectPolicy(String projectName, String policyText) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(projectName, "project");
        CodingUtils.assertParameterNotNull(policyText, "policy");
        Map<String, String> headParameter = this.GetCommonHeadPara(projectName);
        String resourceUri = "/policy";
        headParameter.put("Content-Type", "application/json");
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(projectName, HttpMethod.POST, resourceUri, urlParameter, headParameter, policyText);
        Map<String, String> resHeaders = response.getHeaders();
        return new SetProjectPolicyResponse(resHeaders);
    }

    @Override
    public GetProjectPolicyReponse getProjectPolicy(String projectName) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(projectName, "project");
        Map<String, String> headParameter = this.GetCommonHeadPara(projectName);
        String resourceUri = "/policy";
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(projectName, HttpMethod.GET, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        return new GetProjectPolicyReponse(resHeaders, response.GetStringBody());
    }

    @Override
    public DeleteProjectPolicyReponse deleteProjectPolicy(String projectName) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(projectName, "project");
        String resourceUri = "/policy";
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        Map<String, String> headParameter = this.GetCommonHeadPara(projectName);
        ResponseMessage response = this.SendData(projectName, HttpMethod.DELETE, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        return new DeleteProjectPolicyReponse(resHeaders);
    }

    @Override
    public SetProjectCnameResponse setProjectCname(SetProjectCnameRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        Map<String, String> headParameter = this.GetCommonHeadPara(request.GetProject());
        headParameter.put("Content-Type", "application/json");
        ResponseMessage response = this.SendData(request.GetProject(), HttpMethod.POST, "/cname", Collections.<String, String>emptyMap(), headParameter, request.marshal().toString());
        SetProjectCnameResponse addCnameResponse = new SetProjectCnameResponse(response.getHeaders());
        String requestId = this.GetRequestId(response.getHeaders());
        JSONObject object = this.parseResponseBody(response, requestId);
        addCnameResponse.setCertId(object.getString("certId"));
        return addCnameResponse;
    }

    @Override
    public ListProjectCnameResponse listProjectCname(String project) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        headParameter.put("Content-Type", "application/json");
        ResponseMessage response = this.SendData(project, HttpMethod.GET, "/cname", Collections.<String, String>emptyMap(), headParameter);
        ListProjectCnameResponse listCnameResponse = new ListProjectCnameResponse(response.getHeaders());
        String requestId = this.GetRequestId(response.getHeaders());
        JSONArray result = this.ParseResponseMessageToArray(response, requestId);
        listCnameResponse.unmarshal(result);
        return listCnameResponse;
    }

    @Override
    public VoidResponse deleteProjectCname(String project, String domain) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(domain, "domain");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        headParameter.put("Content-Type", "application/json");
        ResponseMessage response = this.SendData(project, HttpMethod.DELETE, "/cname/" + domain, Collections.<String, String>emptyMap(), headParameter);
        return new VoidResponse(response.getHeaders());
    }

    @Override
    public CreateLogStoreResponse createEventStore(CreateLogStoreRequest request) throws LogException {
        return this.createEventStore(request.GetProject(), request.GetLogStore(), null);
    }

    @Override
    public CreateLogStoreResponse createEventStore(String project, LogStore logStore, Index index) throws LogException {
        logStore.setTelemetryType("Event");
        CreateLogStoreResponse createLogStoreResponse = this.CreateLogStore(project, logStore);
        if (index == null) {
            index = new Index();
            index.FromJsonString("{\"max_text_len\":16384,\"ttl\":7,\"log_reduce\":false,\"line\":{\"caseSensitive\":false,\"chn\":true,\"token\":[\",\",\" \",\"'\",\"\\\"\",\";\",\"=\",\"(\",\")\",\"[\",\"]\",\"{\",\"}\",\"?\",\"@\",\"&\",\"<\",\">\",\"/\",\":\",\"\\n\",\"\\t\",\"\\r\"]},\"keys\":{\"specversion\":{\"type\":\"text\",\"doc_value\":true,\"alias\":\"\",\"caseSensitive\":false,\"chn\":false,\"token\":[\",\",\" \",\"'\",\"\\\"\",\";\",\"=\",\"(\",\")\",\"[\",\"]\",\"{\",\"}\",\"?\",\"@\",\"&\",\"<\",\">\",\"/\",\":\",\"\\n\",\"\\t\",\"\\r\"]},\"id\":{\"type\":\"text\",\"doc_value\":true,\"alias\":\"\",\"caseSensitive\":false,\"chn\":false,\"token\":[\",\",\" \",\"'\",\"\\\"\",\";\",\"=\",\"(\",\")\",\"[\",\"]\",\"{\",\"}\",\"?\",\"@\",\"&\",\"<\",\">\",\"/\",\":\",\"\\n\",\"\\t\",\"\\r\"]},\"source\":{\"type\":\"text\",\"doc_value\":true,\"alias\":\"\",\"caseSensitive\":false,\"chn\":false,\"token\":[\",\",\" \",\"'\",\"\\\"\",\";\",\"=\",\"(\",\")\",\"[\",\"]\",\"{\",\"}\",\"?\",\"@\",\"&\",\"<\",\">\",\"/\",\"\\n\",\"\\t\",\"\\r\"]},\"type\":{\"type\":\"text\",\"doc_value\":true,\"alias\":\"\",\"caseSensitive\":false,\"chn\":false,\"token\":[\",\",\" \",\"'\",\"\\\"\",\";\",\"=\",\"(\",\")\",\"[\",\"]\",\"{\",\"}\",\"?\",\"@\",\"&\",\"<\",\">\",\"/\",\":\",\"\\n\",\"\\t\",\"\\r\"]},\"subject\":{\"type\":\"text\",\"doc_value\":true,\"alias\":\"\",\"caseSensitive\":false,\"chn\":false,\"token\":[\",\",\" \",\"'\",\"\\\"\",\";\",\"=\",\"(\",\")\",\"[\",\"]\",\"{\",\"}\",\"?\",\"@\",\"&\",\"<\",\">\",\"/\",\":\",\"\\n\",\"\\t\",\"\\r\"]},\"datacontenttype\":{\"type\":\"text\",\"doc_value\":true,\"alias\":\"\",\"caseSensitive\":false,\"chn\":false,\"token\":[\",\",\" \",\"'\",\"\\\"\",\";\",\"=\",\"(\",\")\",\"[\",\"]\",\"{\",\"}\",\"?\",\"@\",\"&\",\"<\",\">\",\"/\",\":\",\"\\n\",\"\\t\",\"\\r\"]},\"dataschema\":{\"type\":\"text\",\"doc_value\":true,\"alias\":\"\",\"caseSensitive\":false,\"chn\":false,\"token\":[\",\",\" \",\"'\",\"\\\"\",\";\",\"=\",\"(\",\")\",\"[\",\"]\",\"{\",\"}\",\"?\",\"@\",\"&\",\"<\",\">\",\"/\",\":\",\"\\n\",\"\\t\",\"\\r\"]},\"data\":{\"type\":\"json\",\"doc_value\":true,\"alias\":\"\",\"caseSensitive\":false,\"chn\":false,\"token\":[\",\",\" \",\"'\",\"\\\"\",\";\",\"=\",\"(\",\")\",\"[\",\"]\",\"{\",\"}\",\"?\",\"@\",\"&\",\"<\",\">\",\"/\",\":\",\"\\n\",\"\\t\",\"\\r\"],\"index_all\":true,\"max_depth\":-1,\"json_keys\":{}},\"time\":{\"type\":\"text\",\"doc_value\":true,\"alias\":\"\",\"caseSensitive\":false,\"chn\":false,\"token\":[\",\",\" \",\"'\",\"\\\"\",\";\",\"=\",\"(\",\")\",\"[\",\"]\",\"{\",\"}\",\"?\",\"@\",\"&\",\"<\",\">\",\"/\",\":\",\"\\n\",\"\\t\",\"\\r\"]},\"title\":{\"type\":\"text\",\"doc_value\":true,\"alias\":\"\",\"caseSensitive\":false,\"chn\":false,\"token\":[\",\",\" \",\"'\",\"\\\"\",\";\",\"=\",\"(\",\")\",\"[\",\"]\",\"{\",\"}\",\"?\",\"@\",\"&\",\"<\",\">\",\"/\",\":\",\"\\n\",\"\\t\",\"\\r\"]},\"message\":{\"type\":\"text\",\"doc_value\":true,\"alias\":\"\",\"caseSensitive\":false,\"chn\":false,\"token\":[\",\",\" \",\"'\",\"\\\"\",\";\",\"=\",\"(\",\")\",\"[\",\"]\",\"{\",\"}\",\"?\",\"@\",\"&\",\"<\",\">\",\"/\",\":\",\"\\n\",\"\\t\",\"\\r\"]},\"status\":{\"type\":\"text\",\"doc_value\":true,\"alias\":\"\",\"caseSensitive\":false,\"chn\":false,\"token\":[\",\",\" \",\"'\",\"\\\"\",\";\",\"=\",\"(\",\")\",\"[\",\"]\",\"{\",\"}\",\"?\",\"@\",\"&\",\"<\",\">\",\"/\",\":\",\"\\n\",\"\\t\",\"\\r\"]}}}");
            index.SetTtl(logStore.GetTtl());
        }
        this.CreateIndex(project, logStore.GetLogStoreName(), index);
        return createLogStoreResponse;
    }

    @Override
    public UpdateLogStoreResponse updateEventStore(UpdateLogStoreRequest request) throws LogException {
        request.GetLogStore().setTelemetryType("Event");
        return this.UpdateLogStore(request);
    }

    @Override
    public DeleteLogStoreResponse deleteEventStore(DeleteLogStoreRequest request) throws LogException {
        return this.DeleteLogStore(request);
    }

    @Override
    public GetLogStoreResponse getEventStore(GetLogStoreRequest request) throws LogException {
        return this.GetLogStore(request);
    }

    @Override
    public ListLogStoresResponse listEventStores(ListLogStoresRequest request) throws LogException {
        request.SetTelemetryType("Event");
        return this.ListLogStores(request);
    }

    @Override
    public VoidResponse updateLogStoreMeteringMode(UpdateLogStoreMeteringModeRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        Map<String, String> urlParameter = request.GetAllParams();
        String project = request.GetProject();
        String logstore = request.getLogStore();
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        CodingUtils.validateLogstore(logstore);
        String resourceUri = "/logstores/" + logstore + "/meteringmode";
        ResponseMessage message = this.SendData(project, HttpMethod.PUT, resourceUri, urlParameter, headParameter, request.getRequestBody());
        return new VoidResponse(message.getHeaders());
    }

    @Override
    public GetLogStoreMeteringModeResponse getLogStoreMeteringMode(GetLogStoreMeteringModeRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        Map<String, String> urlParameter = request.GetAllParams();
        String project = request.GetProject();
        String logstore = request.getLogStore();
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        CodingUtils.validateLogstore(logstore);
        String resourceUri = "/logstores/" + logstore + "/meteringmode";
        ResponseMessage message = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter, new byte[0]);
        GetLogStoreMeteringModeResponse response = new GetLogStoreMeteringModeResponse(message.getHeaders());
        response.deserializeFrom(this.parseResponseBody(message, message.getRequestId()));
        return response;
    }

    @Override
    public CreateMetricsConfigResponse createMetricsConfig(CreateMetricsConfigRequest request) throws LogException {
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(request.getMetricsName(), "metrics");
        String config = JSONObject.toJSONString(request.getMetricsConfig());
        CodingUtils.assertStringNotNullOrEmpty(config, "metricsConfig");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/metricsconfigs";
        JSONObject jsonBody = new JSONObject();
        jsonBody.put("metricStore", (Object)request.getMetricsName());
        jsonBody.put("metricsConfigDetail", (Object)config);
        byte[] body = Client.encodeToUtf8(jsonBody.toString());
        headParameter.put("Content-Type", "application/json");
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(project, HttpMethod.POST, resourceUri, urlParameter, headParameter, body);
        Map<String, String> resHeaders = response.getHeaders();
        return new CreateMetricsConfigResponse(resHeaders);
    }

    @Override
    public UpdateMetricsConfigResponse updateMetricsConfig(UpdateMetricsConfigRequest request) throws LogException {
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(request.getMetricsName(), "metrics");
        String config = JSONObject.toJSONString(request.getMetricsConfig());
        CodingUtils.assertStringNotNullOrEmpty(config, "metricsConfig");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/metricsconfigs/" + request.getMetricsName();
        JSONObject jsonBody = new JSONObject();
        jsonBody.put("metricStore", (Object)request.getMetricsName());
        jsonBody.put("metricsConfigDetail", (Object)config);
        byte[] body = Client.encodeToUtf8(jsonBody.toString());
        headParameter.put("Content-Type", "application/json");
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(project, HttpMethod.PUT, resourceUri, urlParameter, headParameter, body);
        Map<String, String> resHeaders = response.getHeaders();
        return new UpdateMetricsConfigResponse(resHeaders);
    }

    @Override
    public DeleteMetricsConfigResponse deleteMetricsConfig(DeleteMetricsConfigRequest request) throws LogException {
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(request.getMetricsName(), "metrics");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/metricsconfigs/" + request.getMetricsName();
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(project, HttpMethod.DELETE, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        return new DeleteMetricsConfigResponse(resHeaders);
    }

    @Override
    public GetMetricsConfigResponse getMetricsConfig(GetMetricsConfigRequest request) throws LogException {
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(request.getMetricsName(), "metrics");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/metricsconfigs/" + request.getMetricsName();
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        GetMetricsConfigResponse getMetricsConfigResponse = new GetMetricsConfigResponse(resHeaders);
        String requestId = this.GetRequestId(resHeaders);
        JSONObject object = this.parseResponseBody(response, requestId);
        getMetricsConfigResponse.fromJsonObject(object);
        return getMetricsConfigResponse;
    }

    @Override
    public ListMetricsConfigResponse listMetricsConfig(ListMetricsConfigRequest request) throws LogException {
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String resourceUri = "/metricsconfigs";
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        Map<String, String> urlParameter = request.GetAllParams();
        ResponseMessage response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        String requestId = this.GetRequestId(resHeaders);
        JSONObject object = this.parseResponseBody(response, requestId);
        ListMetricsConfigResponse listMetricsConfigResponse = new ListMetricsConfigResponse(resHeaders);
        listMetricsConfigResponse.fromJSON(object);
        return listMetricsConfigResponse;
    }

    @Override
    public CreateShipperMigrationResponse createShipperMigration(CreateShipperMigrationRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        CodingUtils.assertParameterNotNull(request.getMigration(), "migration");
        request.getMigration().checkForCreate();
        Map<String, String> headParameter = this.GetCommonHeadPara(request.GetProject());
        byte[] body = Client.encodeToUtf8(request.getMigration().ToCreateJsonString());
        headParameter.put("Content-Type", "application/json");
        String migrationUri = "/shippermigrations";
        ResponseMessage response = this.SendData(request.GetProject(), HttpMethod.POST, migrationUri, request.GetAllParams(), headParameter, body);
        return new CreateShipperMigrationResponse(response.getHeaders());
    }

    @Override
    public GetShipperMigrationResponse getShipperMigration(GetShipperMigrationRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        CodingUtils.assertStringNotNullOrEmpty(request.getName(), "name");
        Map<String, String> headParameter = this.GetCommonHeadPara(request.GetProject());
        String resourceUri = String.format("/shippermigrations/%s", request.getName());
        headParameter.put("Content-Type", "application/json");
        ResponseMessage response = this.SendData(request.GetProject(), HttpMethod.GET, resourceUri, request.GetAllParams(), headParameter);
        String requestId = this.GetRequestId(response.getHeaders());
        JSONObject object = this.parseResponseBody(response, requestId);
        ShipperMigration migration = ShipperMigration.extractGetMigration(object, requestId);
        return new GetShipperMigrationResponse(response.getHeaders(), migration);
    }

    @Override
    public ListShipperMigrationResponse listShipperMigration(ListShipperMigrationRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        Map<String, String> headParameter = this.GetCommonHeadPara(request.GetProject());
        String resourceUri = "/shippermigrations";
        headParameter.put("Content-Type", "application/json");
        Map<String, String> urlParameter = request.GetAllParams();
        ResponseMessage response = this.SendData(request.GetProject(), HttpMethod.GET, resourceUri, urlParameter, headParameter);
        String requestId = this.GetRequestId(response.getHeaders());
        JSONObject object = this.parseResponseBody(response, requestId);
        int total = object.getIntValue("total");
        int count = object.getIntValue("count");
        List<ShipperMigration> migrations = ShipperMigration.extractMigrations(object, requestId);
        return new ListShipperMigrationResponse(response.getHeaders(), count, total, migrations);
    }

    private void setSignV4IfInAcdr(String endpoint) {
        String region = Utils.parseRegion(endpoint);
        if (region != null && region.contains("-acdr-ut-")) {
            this.getClientConfiguration().setSignatureVersion(SignVersion.V4);
            this.getClientConfiguration().setRegion(region);
        }
    }
}

