/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.selectdb.config;

import java.util.Map;
import java.util.UUID;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.Options;

public class SelectDBSinkOptions {
    public static final String IDENTIFIER = "SelectDBCloud";
    private static final int DEFAULT_SINK_MAX_RETRIES = 3;
    private static final int DEFAULT_SINK_BUFFER_SIZE = 0xA00000;
    private static final int DEFAULT_SINK_BUFFER_COUNT = 10000;
    public static final Option<String> LOAD_URL = Options.key((String)"load-url").stringType().noDefaultValue().withDescription("SelectDB load http address.");
    public static final Option<String> JDBC_URL = Options.key((String)"jdbc-url").stringType().noDefaultValue().withDescription("SelectDB jdbc query address.");
    public static final Option<String> CLUSTER_NAME = Options.key((String)"cluster-name").stringType().noDefaultValue().withDescription("SelectDB cluster name.");
    public static final Option<String> TABLE_IDENTIFIER = Options.key((String)"table.identifier").stringType().noDefaultValue().withDescription("the jdbc table name.");
    public static final Option<String> USERNAME = Options.key((String)"username").stringType().noDefaultValue().withDescription("the jdbc user name.");
    public static final Option<String> PASSWORD = Options.key((String)"password").stringType().noDefaultValue().withDescription("the jdbc password.");
    public static final Option<Boolean> SINK_ENABLE_2PC = Options.key((String)"sink.enable-2pc").booleanType().defaultValue((Object)true).withDescription("enable 2PC while loading");
    public static final Option<Integer> SINK_MAX_RETRIES = Options.key((String)"sink.max-retries").intType().defaultValue((Object)3).withDescription("the max retry times if writing records to database failed.");
    public static final Option<Integer> SINK_BUFFER_SIZE = Options.key((String)"sink.buffer-size").intType().defaultValue((Object)0xA00000).withDescription("the buffer size to cache data for stream load.");
    public static final Option<Integer> SINK_BUFFER_COUNT = Options.key((String)"sink.buffer-count").intType().defaultValue((Object)10000).withDescription("the buffer count to cache data for stream load.");
    public static final Option<String> SINK_LABEL_PREFIX = Options.key((String)"sink.label-prefix").stringType().defaultValue((Object)UUID.randomUUID().toString()).withDescription("the unique label prefix.");
    public static final Option<Boolean> SINK_ENABLE_DELETE = Options.key((String)"sink.enable-delete").booleanType().defaultValue((Object)false).withDescription("whether to enable the delete function");
    public static final Option<Integer> SINK_FLUSH_QUEUE_SIZE = Options.key((String)"sink.flush.queue-size").intType().defaultValue((Object)1).withDescription("Queue length for async upload to object storage");
    public static final Option<Map<String, String>> SELECTDB_SINK_CONFIG_PREFIX = Options.key((String)"selectdb.config").mapType().noDefaultValue().withDescription("The parameter of the Copy Into data_desc. The way to specify the parameter is to add the prefix `selectdb.config` to the original load parameter name ");
}

