/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.selectdb.config;

import java.util.Map;
import java.util.Properties;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.connectors.selectdb.config.SelectDBSinkOptions;

public class SelectDBConfig {
    private String loadUrl;
    private String jdbcUrl;
    private String clusterName;
    private String username;
    private String password;
    private String tableIdentifier;
    private Boolean enableDelete;
    private String labelPrefix;
    private boolean enable2PC;
    private Integer maxRetries;
    private Integer bufferSize;
    private Integer bufferCount;
    private Integer flushQueueSize;
    private Properties StageLoadProps;

    public static SelectDBConfig loadConfig(ReadonlyConfig pluginConfig) {
        SelectDBConfig selectdbConfig = new SelectDBConfig();
        selectdbConfig.setLoadUrl((String)pluginConfig.get(SelectDBSinkOptions.LOAD_URL));
        selectdbConfig.setJdbcUrl((String)pluginConfig.get(SelectDBSinkOptions.JDBC_URL));
        selectdbConfig.setClusterName((String)pluginConfig.get(SelectDBSinkOptions.CLUSTER_NAME));
        selectdbConfig.setUsername((String)pluginConfig.get(SelectDBSinkOptions.USERNAME));
        selectdbConfig.setPassword((String)pluginConfig.get(SelectDBSinkOptions.PASSWORD));
        selectdbConfig.setTableIdentifier((String)pluginConfig.get(SelectDBSinkOptions.TABLE_IDENTIFIER));
        if (pluginConfig.getOptional(SelectDBSinkOptions.SELECTDB_SINK_CONFIG_PREFIX).isPresent()) {
            Properties properties = new Properties();
            properties.putAll((Map<?, ?>)((Map)pluginConfig.get(SelectDBSinkOptions.SELECTDB_SINK_CONFIG_PREFIX)));
            selectdbConfig.setStageLoadProps(properties);
        }
        selectdbConfig.setLabelPrefix((String)pluginConfig.get(SelectDBSinkOptions.SINK_LABEL_PREFIX));
        selectdbConfig.setMaxRetries((Integer)pluginConfig.get(SelectDBSinkOptions.SINK_MAX_RETRIES));
        selectdbConfig.setEnable2PC((Boolean)pluginConfig.get(SelectDBSinkOptions.SINK_ENABLE_2PC));
        selectdbConfig.setBufferSize((Integer)pluginConfig.get(SelectDBSinkOptions.SINK_BUFFER_SIZE));
        selectdbConfig.setBufferCount((Integer)pluginConfig.get(SelectDBSinkOptions.SINK_BUFFER_COUNT));
        selectdbConfig.setEnableDelete((Boolean)pluginConfig.get(SelectDBSinkOptions.SINK_ENABLE_DELETE));
        selectdbConfig.setFlushQueueSize((Integer)pluginConfig.get(SelectDBSinkOptions.SINK_FLUSH_QUEUE_SIZE));
        return selectdbConfig;
    }

    public void setLoadUrl(String loadUrl) {
        this.loadUrl = loadUrl;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setTableIdentifier(String tableIdentifier) {
        this.tableIdentifier = tableIdentifier;
    }

    public void setEnableDelete(Boolean enableDelete) {
        this.enableDelete = enableDelete;
    }

    public void setLabelPrefix(String labelPrefix) {
        this.labelPrefix = labelPrefix;
    }

    public void setEnable2PC(boolean enable2PC) {
        this.enable2PC = enable2PC;
    }

    public void setMaxRetries(Integer maxRetries) {
        this.maxRetries = maxRetries;
    }

    public void setBufferSize(Integer bufferSize) {
        this.bufferSize = bufferSize;
    }

    public void setBufferCount(Integer bufferCount) {
        this.bufferCount = bufferCount;
    }

    public void setFlushQueueSize(Integer flushQueueSize) {
        this.flushQueueSize = flushQueueSize;
    }

    public void setStageLoadProps(Properties StageLoadProps) {
        this.StageLoadProps = StageLoadProps;
    }

    public String getLoadUrl() {
        return this.loadUrl;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getTableIdentifier() {
        return this.tableIdentifier;
    }

    public Boolean getEnableDelete() {
        return this.enableDelete;
    }

    public String getLabelPrefix() {
        return this.labelPrefix;
    }

    public boolean isEnable2PC() {
        return this.enable2PC;
    }

    public Integer getMaxRetries() {
        return this.maxRetries;
    }

    public Integer getBufferSize() {
        return this.bufferSize;
    }

    public Integer getBufferCount() {
        return this.bufferCount;
    }

    public Integer getFlushQueueSize() {
        return this.flushQueueSize;
    }

    public Properties getStageLoadProps() {
        return this.StageLoadProps;
    }

    public String toString() {
        return "SelectDBConfig(loadUrl=" + this.getLoadUrl() + ", jdbcUrl=" + this.getJdbcUrl() + ", clusterName=" + this.getClusterName() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", tableIdentifier=" + this.getTableIdentifier() + ", enableDelete=" + this.getEnableDelete() + ", labelPrefix=" + this.getLabelPrefix() + ", enable2PC=" + this.isEnable2PC() + ", maxRetries=" + this.getMaxRetries() + ", bufferSize=" + this.getBufferSize() + ", bufferCount=" + this.getBufferCount() + ", flushQueueSize=" + this.getFlushQueueSize() + ", StageLoadProps=" + this.getStageLoadProps() + ")";
    }
}

