/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.rocketmq.sink;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.sink.SinkWriter;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.connectors.seatunnel.common.sink.AbstractSimpleSink;
import org.apache.seatunnel.connectors.seatunnel.common.sink.AbstractSinkWriter;
import org.apache.seatunnel.connectors.seatunnel.rocketmq.common.RocketMqBaseConfiguration;
import org.apache.seatunnel.connectors.seatunnel.rocketmq.common.SchemaFormat;
import org.apache.seatunnel.connectors.seatunnel.rocketmq.config.RocketMqSinkOptions;
import org.apache.seatunnel.connectors.seatunnel.rocketmq.sink.ProducerMetadata;
import org.apache.seatunnel.connectors.seatunnel.rocketmq.sink.RocketMqSinkWriter;

public class RocketMqSink
extends AbstractSimpleSink<SeaTunnelRow, Void> {
    private final CatalogTable catalogTable;
    private final ProducerMetadata producerMetadata;

    public RocketMqSink(ReadonlyConfig pluginConfig, CatalogTable catalogTable) {
        this.catalogTable = catalogTable;
        this.producerMetadata = new ProducerMetadata();
        this.producerMetadata.setTopic((String)pluginConfig.get(RocketMqSinkOptions.TOPIC));
        if (pluginConfig.getOptional(RocketMqSinkOptions.TAG).isPresent()) {
            this.producerMetadata.setTag((String)pluginConfig.get(RocketMqSinkOptions.TAG));
        }
        RocketMqBaseConfiguration.Builder baseConfigurationBuilder = RocketMqBaseConfiguration.newBuilder().producer().namesrvAddr((String)pluginConfig.get(RocketMqSinkOptions.NAME_SRV_ADDR));
        baseConfigurationBuilder.aclEnable((Boolean)pluginConfig.get(RocketMqSinkOptions.ACL_ENABLED));
        if (pluginConfig.getOptional(RocketMqSinkOptions.ACCESS_KEY).isPresent()) {
            baseConfigurationBuilder.accessKey((String)pluginConfig.get(RocketMqSinkOptions.ACCESS_KEY));
        }
        if (pluginConfig.getOptional(RocketMqSinkOptions.SECRET_KEY).isPresent()) {
            baseConfigurationBuilder.secretKey((String)pluginConfig.get(RocketMqSinkOptions.SECRET_KEY));
        }
        baseConfigurationBuilder.groupId((String)pluginConfig.get(RocketMqSinkOptions.PRODUCER_GROUP));
        baseConfigurationBuilder.maxMessageSize((Integer)pluginConfig.get(RocketMqSinkOptions.MAX_MESSAGE_SIZE));
        baseConfigurationBuilder.sendMsgTimeout((Integer)pluginConfig.get(RocketMqSinkOptions.SEND_MESSAGE_TIMEOUT_MILLIS));
        this.producerMetadata.setConfiguration(baseConfigurationBuilder.build());
        this.producerMetadata.setFormat((SchemaFormat)((Object)pluginConfig.get(RocketMqSinkOptions.FORMAT)));
        this.producerMetadata.setFieldDelimiter((String)pluginConfig.get(RocketMqSinkOptions.FIELD_DELIMITER));
        if (pluginConfig.getOptional(RocketMqSinkOptions.PARTITION_KEY_FIELDS).isPresent()) {
            this.producerMetadata.setPartitionKeyFields((List)pluginConfig.get(RocketMqSinkOptions.PARTITION_KEY_FIELDS));
        }
        this.producerMetadata.setExactlyOnce((Boolean)pluginConfig.get(RocketMqSinkOptions.EXACTLY_ONCE));
        this.producerMetadata.setSync((Boolean)pluginConfig.get(RocketMqSinkOptions.SEND_SYNC));
    }

    public String getPluginName() {
        return "Rocketmq";
    }

    @Override
    public AbstractSinkWriter<SeaTunnelRow, Void> createWriter(SinkWriter.Context context) throws IOException {
        return new RocketMqSinkWriter(this.producerMetadata, this.catalogTable.getSeaTunnelRowType());
    }

    public Optional<CatalogTable> getWriteCatalogTable() {
        return Optional.ofNullable(this.catalogTable);
    }
}

