/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.rocketmq.common;

import java.io.Serializable;
import java.util.Objects;

public class RocketMqBaseConfiguration
implements Serializable {
    private String namesrvAddr;
    private String groupId;
    private boolean aclEnable;
    private String accessKey;
    private String secretKey;
    private Integer batchSize;
    private Long pollTimeoutMillis;
    private Integer maxMessageSize;
    private Integer sendMsgTimeout;

    private RocketMqBaseConfiguration(String groupId, String namesrvAddr, boolean aclEnable, String accessKey, String secretKey) {
        this.groupId = groupId;
        this.namesrvAddr = namesrvAddr;
        this.aclEnable = aclEnable;
        this.accessKey = accessKey;
        this.secretKey = secretKey;
    }

    private RocketMqBaseConfiguration(String groupId, String namesrvAddr, boolean aclEnable, String accessKey, String secretKey, int pullBatchSize, Long consumerPullTimeoutMillis) {
        this(groupId, namesrvAddr, aclEnable, accessKey, secretKey);
        this.batchSize = pullBatchSize;
        this.pollTimeoutMillis = consumerPullTimeoutMillis;
    }

    private RocketMqBaseConfiguration(String groupId, String namesrvAddr, boolean aclEnable, String accessKey, String secretKey, int maxMessageSize, int sendMsgTimeout) {
        this(groupId, namesrvAddr, aclEnable, accessKey, secretKey);
        this.maxMessageSize = maxMessageSize;
        this.sendMsgTimeout = sendMsgTimeout;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RocketMqBaseConfiguration that = (RocketMqBaseConfiguration)o;
        return this.aclEnable == that.aclEnable && this.batchSize == that.batchSize && this.pollTimeoutMillis == that.pollTimeoutMillis && this.maxMessageSize == that.maxMessageSize && this.sendMsgTimeout == that.sendMsgTimeout && Objects.equals(this.namesrvAddr, that.namesrvAddr) && Objects.equals(this.groupId, that.groupId) && Objects.equals(this.accessKey, that.accessKey) && Objects.equals(this.secretKey, that.secretKey);
    }

    public int hashCode() {
        return Objects.hash(this.namesrvAddr, this.groupId, this.aclEnable, this.accessKey, this.secretKey, this.batchSize, this.pollTimeoutMillis, this.maxMessageSize, this.sendMsgTimeout);
    }

    public String toString() {
        return "RocketMqBaseConfiguration{namesrvAddr='" + this.namesrvAddr + '\'' + ", groupId='" + this.groupId + '\'' + ", aclEnable=" + this.aclEnable + ", accessKey='" + this.accessKey + '\'' + ", secretKey='" + this.secretKey + '\'' + ", pullBatchSize=" + this.batchSize + ", pollTimeoutMillis=" + this.pollTimeoutMillis + ", maxMessageSize=" + this.maxMessageSize + ", sendMsgTimeout=" + this.sendMsgTimeout + '}';
    }

    public void setNamesrvAddr(String namesrvAddr) {
        this.namesrvAddr = namesrvAddr;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setAclEnable(boolean aclEnable) {
        this.aclEnable = aclEnable;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public void setBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
    }

    public void setPollTimeoutMillis(Long pollTimeoutMillis) {
        this.pollTimeoutMillis = pollTimeoutMillis;
    }

    public void setMaxMessageSize(Integer maxMessageSize) {
        this.maxMessageSize = maxMessageSize;
    }

    public void setSendMsgTimeout(Integer sendMsgTimeout) {
        this.sendMsgTimeout = sendMsgTimeout;
    }

    public String getNamesrvAddr() {
        return this.namesrvAddr;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public boolean isAclEnable() {
        return this.aclEnable;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public Integer getBatchSize() {
        return this.batchSize;
    }

    public Long getPollTimeoutMillis() {
        return this.pollTimeoutMillis;
    }

    public Integer getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public Integer getSendMsgTimeout() {
        return this.sendMsgTimeout;
    }

    public static class Builder {
        private String namesrvAddr;
        private String groupId;
        private boolean aclEnable;
        private String accessKey;
        private String secretKey;
        private Integer batchSize;
        private Long pollTimeoutMillis;
        private Integer maxMessageSize;
        private Integer sendMsgTimeout;
        private ConfigType configType = ConfigType.NONE;

        public Builder consumer() {
            this.configType = ConfigType.CONSUMER;
            return this;
        }

        public Builder producer() {
            this.configType = ConfigType.PRODUCER;
            return this;
        }

        public Builder namesrvAddr(String namesrvAddr) {
            this.namesrvAddr = namesrvAddr;
            return this;
        }

        public Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public Builder aclEnable(boolean aclEnable) {
            this.aclEnable = aclEnable;
            return this;
        }

        public Builder accessKey(String accessKey) {
            this.accessKey = accessKey;
            return this;
        }

        public Builder secretKey(String secretKey) {
            this.secretKey = secretKey;
            return this;
        }

        public Builder batchSize(int batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public Builder pollTimeoutMillis(long consumerPullTimeoutMillis) {
            this.pollTimeoutMillis = consumerPullTimeoutMillis;
            return this;
        }

        public Builder maxMessageSize(int maxMessageSize) {
            this.maxMessageSize = maxMessageSize;
            return this;
        }

        public Builder sendMsgTimeout(int sendMsgTimeout) {
            this.sendMsgTimeout = sendMsgTimeout;
            return this;
        }

        public RocketMqBaseConfiguration build() {
            switch (this.configType) {
                case CONSUMER: {
                    return new RocketMqBaseConfiguration(this.groupId, this.namesrvAddr, this.aclEnable, this.accessKey, this.secretKey, (int)this.batchSize, this.pollTimeoutMillis);
                }
                case PRODUCER: {
                    return new RocketMqBaseConfiguration(this.groupId, this.namesrvAddr, this.aclEnable, this.accessKey, this.secretKey, (int)this.maxMessageSize, this.sendMsgTimeout);
                }
            }
            return new RocketMqBaseConfiguration(this.groupId, this.namesrvAddr, this.aclEnable, this.accessKey, this.secretKey);
        }
    }

    static enum ConfigType {
        NONE,
        CONSUMER,
        PRODUCER;

    }
}

