/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.common.protocol;

import org.apache.rocketmq.common.protocol.header.namesrv.RegisterBrokerRequestHeader;
import org.apache.rocketmq.logging.InternalLogger;
import org.apache.rocketmq.logging.InternalLoggerFactory;
import org.apache.rocketmq.remoting.common.RemotingHelper;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;

public class MQProtosHelper {
    private static final InternalLogger log = InternalLoggerFactory.getLogger("RocketmqCommon");

    public static boolean registerBrokerToNameServer(String nsaddr, String brokerAddr, long timeoutMillis) {
        RegisterBrokerRequestHeader requestHeader = new RegisterBrokerRequestHeader();
        requestHeader.setBrokerAddr(brokerAddr);
        RemotingCommand request = RemotingCommand.createRequestCommand(103, requestHeader);
        try {
            RemotingCommand response = RemotingHelper.invokeSync(nsaddr, request, timeoutMillis);
            if (response != null) {
                return 0 == response.getCode();
            }
        }
        catch (Exception e) {
            log.error("Failed to register broker", e);
        }
        return false;
    }
}

