/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.acl.common;

import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import java.util.SortedMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.acl.common.AclClientRPCHook;
import org.apache.rocketmq.acl.common.AclException;
import org.apache.rocketmq.acl.common.AclSigner;
import org.apache.rocketmq.acl.common.SessionCredentials;
import org.apache.rocketmq.logging.InternalLogger;
import org.apache.rocketmq.logging.InternalLoggerFactory;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.yaml.snakeyaml.Yaml;

public class AclUtils {
    private static final InternalLogger log = InternalLoggerFactory.getLogger("RocketmqCommon");

    public static byte[] combineRequestContent(RemotingCommand request, SortedMap<String, String> fieldsMap) {
        try {
            StringBuilder sb = new StringBuilder("");
            for (Map.Entry<String, String> entry : fieldsMap.entrySet()) {
                if ("Signature".equals(entry.getKey())) continue;
                sb.append(entry.getValue());
            }
            return AclUtils.combineBytes(sb.toString().getBytes(SessionCredentials.CHARSET), request.getBody());
        }
        catch (Exception e) {
            throw new RuntimeException("Incompatible exception.", e);
        }
    }

    public static byte[] combineBytes(byte[] b1, byte[] b2) {
        int size = (null != b1 ? b1.length : 0) + (null != b2 ? b2.length : 0);
        byte[] total = new byte[size];
        if (null != b1) {
            System.arraycopy(b1, 0, total, 0, b1.length);
        }
        if (null != b2) {
            System.arraycopy(b2, 0, total, b1.length, b2.length);
        }
        return total;
    }

    public static String calSignature(byte[] data, String secretKey) {
        String signature = AclSigner.calSignature(data, secretKey);
        return signature;
    }

    public static void IPv6AddressCheck(String netaddress) {
        if (AclUtils.isAsterisk(netaddress) || AclUtils.isMinus(netaddress)) {
            int asterisk = netaddress.indexOf("*");
            int minus = netaddress.indexOf("-");
            if (asterisk > -1 && asterisk != netaddress.length() - 1) {
                throw new AclException(String.format("Netaddress examine scope Exception netaddress is %s", netaddress));
            }
            if (minus > -1 && (asterisk == -1 ? minus <= netaddress.lastIndexOf(":") : minus <= netaddress.lastIndexOf(":", netaddress.lastIndexOf(":") - 1))) {
                throw new AclException(String.format("Netaddress examine scope Exception netaddress is %s", netaddress));
            }
        }
    }

    public static String v6ipProcess(String netaddress) {
        String subAddress;
        int part;
        boolean isAsterisk = AclUtils.isAsterisk(netaddress);
        boolean isMinus = AclUtils.isMinus(netaddress);
        if (isAsterisk && isMinus) {
            part = 6;
            int lastColon = netaddress.lastIndexOf(58);
            int secondLastColon = netaddress.substring(0, lastColon).lastIndexOf(58);
            subAddress = netaddress.substring(0, secondLastColon);
        } else if (!isAsterisk && !isMinus) {
            part = 8;
            subAddress = netaddress;
        } else {
            part = 7;
            subAddress = netaddress.substring(0, netaddress.lastIndexOf(58));
        }
        return AclUtils.expandIP(subAddress, part);
    }

    public static void verify(String netaddress, int index) {
        if (!AclUtils.isScope(netaddress, index)) {
            throw new AclException(String.format("Netaddress examine scope Exception netaddress is %s", netaddress));
        }
    }

    public static String[] getAddresses(String netaddress, String partialAddress) {
        String[] parAddStrArray = StringUtils.split(partialAddress.substring(1, partialAddress.length() - 1), ",");
        String address = netaddress.substring(0, netaddress.indexOf("{"));
        String[] addreeStrArray = new String[parAddStrArray.length];
        for (int i = 0; i < parAddStrArray.length; ++i) {
            addreeStrArray[i] = address + parAddStrArray[i];
        }
        return addreeStrArray;
    }

    public static boolean isScope(String netaddress, int index) {
        if (AclUtils.isColon(netaddress)) {
            netaddress = AclUtils.expandIP(netaddress, 8);
            String[] strArray = StringUtils.split(netaddress, ":");
            return AclUtils.isIPv6Scope(strArray, index);
        }
        String[] strArray = StringUtils.split(netaddress, ".");
        if (strArray.length != 4) {
            return false;
        }
        return AclUtils.isScope(strArray, index);
    }

    public static boolean isScope(String[] num, int index) {
        if (num.length <= index) {
            // empty if block
        }
        for (int i = 0; i < index; ++i) {
            if (AclUtils.isScope(num[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isColon(String netaddress) {
        return netaddress.indexOf(58) > -1;
    }

    public static boolean isScope(String num) {
        return AclUtils.isScope(Integer.parseInt(num.trim()));
    }

    public static boolean isScope(int num) {
        return num >= 0 && num <= 255;
    }

    public static boolean isAsterisk(String asterisk) {
        return asterisk.indexOf(42) > -1;
    }

    public static boolean isComma(String colon) {
        return colon.indexOf(44) > -1;
    }

    public static boolean isMinus(String minus) {
        return minus.indexOf(45) > -1;
    }

    public static boolean isIPv6Scope(String[] num, int index) {
        for (int i = 0; i < index; ++i) {
            int value;
            try {
                value = Integer.parseInt(num[i], 16);
            }
            catch (NumberFormatException e) {
                return false;
            }
            if (AclUtils.isIPv6Scope(value)) continue;
            return false;
        }
        return true;
    }

    public static boolean isIPv6Scope(int num) {
        int min = Integer.parseInt("0", 16);
        int max = Integer.parseInt("ffff", 16);
        return num >= min && num <= max;
    }

    public static String expandIP(String netaddress, int part) {
        int i;
        int separatorCount = StringUtils.countMatches((CharSequence)(netaddress = netaddress.toUpperCase()), ":");
        int padCount = part - separatorCount;
        if (padCount > 0) {
            StringBuilder padStr = new StringBuilder(":");
            for (i = 0; i < padCount; ++i) {
                padStr.append(":");
            }
            netaddress = StringUtils.replace(netaddress, "::", padStr.toString());
        }
        String[] strArray = StringUtils.splitPreserveAllTokens(netaddress, ":");
        for (i = 0; i < strArray.length; ++i) {
            if (strArray[i].length() >= 4) continue;
            strArray[i] = StringUtils.leftPad(strArray[i], 4, '0');
        }
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < strArray.length; ++i2) {
            sb.append(strArray[i2]);
            if (i2 == strArray.length - 1) continue;
            sb.append(":");
        }
        return sb.toString();
    }

    public static <T> T getYamlDataObject(String path, Class<T> clazz) {
        T t;
        Yaml yaml = new Yaml();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(new File(path));
            t = yaml.loadAs(fis, clazz);
        }
        catch (FileNotFoundException ignore) {
            T t2 = null;
            return t2;
        }
        catch (Exception e) {
            throw new AclException(e.getMessage());
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return t;
    }

    public static boolean writeDataObject(String path, Map<String, Object> dataMap) {
        Yaml yaml = new Yaml();
        try (PrintWriter pw = null;){
            pw = new PrintWriter(new FileWriter(path));
            String dumpAsMap = yaml.dumpAsMap(dataMap);
            pw.print(dumpAsMap);
            pw.flush();
        }
        return true;
    }

    public static RPCHook getAclRPCHook(String fileName) {
        JSONObject yamlDataObject = null;
        try {
            yamlDataObject = AclUtils.getYamlDataObject(fileName, JSONObject.class);
        }
        catch (Exception e) {
            log.error("Convert yaml file to data object error, ", e);
            return null;
        }
        if (yamlDataObject == null || yamlDataObject.isEmpty()) {
            log.warn("Cannot find conf file :{}, acl isn't be enabled.", (Object)fileName);
            return null;
        }
        String accessKey = yamlDataObject.getString("accessKey");
        String secretKey = yamlDataObject.getString("secretKey");
        if (StringUtils.isBlank(accessKey) || StringUtils.isBlank(secretKey)) {
            log.warn("AccessKey or secretKey is blank, the acl is not enabled.");
            return null;
        }
        return new AclClientRPCHook(new SessionCredentials(accessKey, secretKey));
    }
}

