/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.qdrant.config;

import io.qdrant.client.QdrantClient;
import io.qdrant.client.QdrantGrpcClient;
import java.io.Serializable;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.connectors.seatunnel.qdrant.config.QdrantBaseOptions;

public class QdrantParameters
implements Serializable {
    private String host;
    private int port;
    private String apiKey;
    private String collectionName;
    private boolean useTls;

    public QdrantParameters(ReadonlyConfig config) {
        this.host = (String)config.get(QdrantBaseOptions.HOST);
        this.port = (Integer)config.get(QdrantBaseOptions.PORT);
        this.apiKey = (String)config.get(QdrantBaseOptions.API_KEY);
        this.collectionName = (String)config.get(QdrantBaseOptions.COLLECTION_NAME);
        this.useTls = (Boolean)config.get(QdrantBaseOptions.USE_TLS);
    }

    public QdrantClient buildQdrantClient() {
        return new QdrantClient(QdrantGrpcClient.newBuilder(this.host, this.port, this.useTls).build());
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public boolean isUseTls() {
        return this.useTls;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    public void setUseTls(boolean useTls) {
        this.useTls = useTls;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QdrantParameters)) {
            return false;
        }
        QdrantParameters other = (QdrantParameters)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        if (this.isUseTls() != other.isUseTls()) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$apiKey = this.getApiKey();
        String other$apiKey = other.getApiKey();
        if (this$apiKey == null ? other$apiKey != null : !this$apiKey.equals(other$apiKey)) {
            return false;
        }
        String this$collectionName = this.getCollectionName();
        String other$collectionName = other.getCollectionName();
        return !(this$collectionName == null ? other$collectionName != null : !this$collectionName.equals(other$collectionName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof QdrantParameters;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPort();
        result = result * 59 + (this.isUseTls() ? 79 : 97);
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $apiKey = this.getApiKey();
        result = result * 59 + ($apiKey == null ? 43 : $apiKey.hashCode());
        String $collectionName = this.getCollectionName();
        result = result * 59 + ($collectionName == null ? 43 : $collectionName.hashCode());
        return result;
    }

    public String toString() {
        return "QdrantParameters(host=" + this.getHost() + ", port=" + this.getPort() + ", apiKey=" + this.getApiKey() + ", collectionName=" + this.getCollectionName() + ", useTls=" + this.isUseTls() + ")";
    }
}

