/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.mongodb.source;

import com.google.auto.service.AutoService;
import java.util.ArrayList;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.options.ConnectorCommonOptions;
import org.apache.seatunnel.api.source.SeaTunnelSource;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.CatalogTableUtil;
import org.apache.seatunnel.api.table.connector.TableSource;
import org.apache.seatunnel.api.table.factory.Factory;
import org.apache.seatunnel.api.table.factory.TableSourceFactory;
import org.apache.seatunnel.api.table.factory.TableSourceFactoryContext;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.connectors.seatunnel.mongodb.config.MongodbConfig;
import org.apache.seatunnel.connectors.seatunnel.mongodb.source.MongodbSource;
import org.apache.seatunnel.connectors.seatunnel.mongodb.source.split.MongoSplit;

@AutoService(value={Factory.class})
public class MongodbSourceFactory
implements TableSourceFactory {
    public String factoryIdentifier() {
        return "MongoDB";
    }

    public OptionRule optionRule() {
        return OptionRule.builder().required(new Option[]{MongodbConfig.URI, MongodbConfig.DATABASE, MongodbConfig.COLLECTION, ConnectorCommonOptions.SCHEMA}).optional(new Option[]{MongodbConfig.PROJECTION, MongodbConfig.MATCH_QUERY, MongodbConfig.SPLIT_SIZE, MongodbConfig.SPLIT_KEY, MongodbConfig.CURSOR_NO_TIMEOUT, MongodbConfig.FETCH_SIZE, MongodbConfig.MAX_TIME_MIN}).build();
    }

    public Class<? extends SeaTunnelSource<SeaTunnelRow, MongoSplit, ArrayList<MongoSplit>>> getSourceClass() {
        return MongodbSource.class;
    }

    public TableSource<SeaTunnelRow, MongoSplit, ArrayList<MongoSplit>> createSource(TableSourceFactoryContext context) {
        return () -> {
            ReadonlyConfig options = context.getOptions();
            CatalogTable table = options.getOptional(ConnectorCommonOptions.SCHEMA).isPresent() ? CatalogTableUtil.buildWithConfig((ReadonlyConfig)options) : CatalogTableUtil.buildSimpleTextTable();
            return new MongodbSource(table, options);
        };
    }
}

