/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.mongodb.serde;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import org.apache.seatunnel.api.table.type.ArrayType;
import org.apache.seatunnel.api.table.type.DecimalType;
import org.apache.seatunnel.api.table.type.MapType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.api.table.type.SqlType;
import org.apache.seatunnel.common.exception.CommonErrorCodeDeprecated;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.mongodb.exception.MongodbConnectorException;
import org.apache.seatunnel.connectors.seatunnel.mongodb.serde.BsonToRowDataConverters;
import org.apache.seatunnel.connectors.seatunnel.mongodb.serde.SerializableFunction;
import org.bson.BsonArray;
import org.bson.BsonBinary;
import org.bson.BsonBoolean;
import org.bson.BsonDateTime;
import org.bson.BsonDecimal128;
import org.bson.BsonDocument;
import org.bson.BsonDouble;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonNull;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.json.JsonParseException;
import org.bson.types.Decimal128;

public class RowDataToBsonConverters
implements Serializable {
    private static final long serialVersionUID = 1L;

    public static RowDataToBsonConverter createConverter(SeaTunnelDataType<?> type) {
        final SerializableFunction<Object, BsonValue> internalRowConverter = RowDataToBsonConverters.createNullSafeInternalConverter(type);
        return new RowDataToBsonConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public BsonDocument convert(SeaTunnelRow rowData) {
                return (BsonDocument)internalRowConverter.apply(rowData);
            }
        };
    }

    private static SerializableFunction<Object, BsonValue> createNullSafeInternalConverter(SeaTunnelDataType<?> type) {
        return RowDataToBsonConverters.wrapIntoNullSafeInternalConverter(RowDataToBsonConverters.createInternalConverter(type), type);
    }

    private static SerializableFunction<Object, BsonValue> wrapIntoNullSafeInternalConverter(final SerializableFunction<Object, BsonValue> internalConverter, final SeaTunnelDataType<?> type) {
        return new SerializableFunction<Object, BsonValue>(){
            private static final long serialVersionUID = 1L;

            @Override
            public BsonValue apply(Object value) {
                if (value == null || SqlType.NULL.equals((Object)type.getSqlType())) {
                    return new BsonNull();
                }
                return (BsonValue)internalConverter.apply(value);
            }
        };
    }

    private static SerializableFunction<Object, BsonValue> createInternalConverter(final SeaTunnelDataType<?> type) {
        switch (type.getSqlType()) {
            case NULL: {
                return new SerializableFunction<Object, BsonValue>(){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public BsonValue apply(Object value) {
                        return BsonNull.VALUE;
                    }
                };
            }
            case BOOLEAN: {
                return new SerializableFunction<Object, BsonValue>(){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public BsonValue apply(Object value) {
                        return new BsonBoolean((Boolean)value);
                    }
                };
            }
            case TINYINT: 
            case SMALLINT: 
            case INT: {
                return new SerializableFunction<Object, BsonValue>(){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public BsonValue apply(Object value) {
                        int intValue = value instanceof Byte ? (Byte)value & 0xFF : (value instanceof Short ? ((Short)value).intValue() : ((Integer)value).intValue());
                        return new BsonInt32(intValue);
                    }
                };
            }
            case BIGINT: {
                return new SerializableFunction<Object, BsonValue>(){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public BsonValue apply(Object value) {
                        return new BsonInt64((Long)value);
                    }
                };
            }
            case FLOAT: 
            case DOUBLE: {
                return new SerializableFunction<Object, BsonValue>(){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public BsonValue apply(Object value) {
                        double v = value instanceof Float ? ((Float)value).doubleValue() : ((Double)value).doubleValue();
                        return new BsonDouble(v);
                    }
                };
            }
            case STRING: {
                return new SerializableFunction<Object, BsonValue>(){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public BsonValue apply(Object value) {
                        String val = value.toString();
                        if (val.startsWith("{") && val.endsWith("}") && val.contains("_value")) {
                            try {
                                BsonDocument doc = BsonDocument.parse(val);
                                if (doc.containsKey("_value")) {
                                    return doc.get("_value");
                                }
                            }
                            catch (JsonParseException e) {
                                return new BsonString(value.toString());
                            }
                        }
                        return new BsonString(value.toString());
                    }
                };
            }
            case BYTES: {
                return new SerializableFunction<Object, BsonValue>(){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public BsonValue apply(Object value) {
                        return new BsonBinary((byte[])value);
                    }
                };
            }
            case DATE: {
                return new SerializableFunction<Object, BsonValue>(){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public BsonValue apply(Object value) {
                        LocalDate localDate = (LocalDate)value;
                        return new BsonDateTime(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant().toEpochMilli());
                    }
                };
            }
            case TIMESTAMP: {
                return new SerializableFunction<Object, BsonValue>(){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public BsonValue apply(Object value) {
                        LocalDateTime localDateTime = (LocalDateTime)value;
                        return new BsonDateTime(localDateTime.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli());
                    }
                };
            }
            case DECIMAL: {
                return new SerializableFunction<Object, BsonValue>(){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public BsonValue apply(Object value) {
                        DecimalType decimalType = (DecimalType)type;
                        BigDecimal decimalVal = (BigDecimal)value;
                        return new BsonDecimal128(new Decimal128(Objects.requireNonNull(BsonToRowDataConverters.fromBigDecimal(decimalVal, decimalType.getPrecision(), decimalType.getScale()))));
                    }
                };
            }
            case ARRAY: {
                return RowDataToBsonConverters.createArrayConverter((ArrayType)type);
            }
            case MAP: {
                MapType mapType = (MapType)type;
                return RowDataToBsonConverters.createMapConverter(mapType.toString(), mapType.getKeyType(), mapType.getValueType());
            }
            case ROW: {
                return RowDataToBsonConverters.createRowConverter((SeaTunnelRowType)type);
            }
        }
        throw new MongodbConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_DATA_TYPE, "Not support to parse type: " + type);
    }

    private static SerializableFunction<Object, BsonValue> createArrayConverter(ArrayType<?, ?> arrayType) {
        final SerializableFunction<Object, BsonValue> elementConverter = RowDataToBsonConverters.createNullSafeInternalConverter(arrayType.getElementType());
        return new SerializableFunction<Object, BsonValue>(){
            private static final long serialVersionUID = 1L;

            @Override
            public BsonValue apply(Object value) {
                Object[] arrayData = (Object[])value;
                ArrayList<BsonValue> bsonValues = new ArrayList<BsonValue>();
                for (Object element : arrayData) {
                    bsonValues.add((BsonValue)elementConverter.apply(element));
                }
                return new BsonArray(bsonValues);
            }
        };
    }

    private static SerializableFunction<Object, BsonValue> createMapConverter(String typeSummary, SeaTunnelDataType<?> keyType, SeaTunnelDataType<?> valueType) {
        if (!SqlType.STRING.equals((Object)keyType.getSqlType())) {
            throw new MongodbConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_OPERATION, "JSON format doesn't support non-string as key type of map. The type is: " + typeSummary);
        }
        final SerializableFunction<Object, BsonValue> valueConverter = RowDataToBsonConverters.createNullSafeInternalConverter(valueType);
        return new SerializableFunction<Object, BsonValue>(){
            private static final long serialVersionUID = 1L;

            @Override
            public BsonValue apply(Object value) {
                Map mapData = (Map)value;
                BsonDocument document = new BsonDocument();
                for (Map.Entry entry : mapData.entrySet()) {
                    String fieldName = (String)entry.getKey();
                    document.append(fieldName, (BsonValue)valueConverter.apply(entry.getValue()));
                }
                return document;
            }
        };
    }

    private static SerializableFunction<Object, BsonValue> createRowConverter(SeaTunnelRowType rowType) {
        final SerializableFunction[] fieldConverters = (SerializableFunction[])rowType.getChildren().stream().map(RowDataToBsonConverters::createNullSafeInternalConverter).toArray(SerializableFunction[]::new);
        final int fieldCount = rowType.getTotalFields();
        final String[] fieldNames = rowType.getFieldNames();
        return new SerializableFunction<Object, BsonValue>(){
            private static final long serialVersionUID = 1L;

            @Override
            public BsonValue apply(Object value) {
                SeaTunnelRow rowData = (SeaTunnelRow)value;
                BsonDocument document = new BsonDocument();
                for (int i = 0; i < fieldCount; ++i) {
                    document.append(fieldNames[i], (BsonValue)fieldConverters[i].apply(rowData.getField(i)));
                }
                return document;
            }
        };
    }

    @FunctionalInterface
    public static interface RowDataToBsonConverter
    extends Serializable {
        public BsonDocument convert(SeaTunnelRow var1);
    }
}

