/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.types;

import com.pingcap.tidb.tipb.ExprType;
import org.tikv.common.codec.Codec;
import org.tikv.common.codec.CodecDataInput;
import org.tikv.common.codec.CodecDataOutput;
import org.tikv.common.exception.ConvertNotSupportException;
import org.tikv.common.exception.ConvertOverflowException;
import org.tikv.common.exception.TypeException;
import org.tikv.common.exception.UnsupportedTypeException;
import org.tikv.common.meta.TiColumnInfo;
import org.tikv.common.types.DataType;
import org.tikv.common.types.MySQLType;

public class SetType
extends DataType {
    public static final SetType SET = new SetType(MySQLType.TypeSet);
    public static final MySQLType[] subTypes = new MySQLType[]{MySQLType.TypeSet};

    private SetType(MySQLType tp) {
        super(tp);
    }

    protected SetType(TiColumnInfo.InternalTypeHolder holder) {
        super(holder);
    }

    @Override
    protected Object decodeNotNull(int flag, CodecDataInput cdi) {
        long number;
        switch (flag) {
            case 9: {
                number = Codec.IntegerCodec.readUVarLong(cdi);
                break;
            }
            case 4: {
                number = Codec.IntegerCodec.readULong(cdi);
                break;
            }
            default: {
                throw new TypeException("Invalid IntegerType flag: " + flag);
            }
        }
        return Codec.SetCodec.readSetFromLong(number, this.getElems());
    }

    @Override
    protected Object doConvertToTiDBType(Object value) throws ConvertNotSupportException, ConvertOverflowException {
        return new ConvertNotSupportException(value.getClass().getName(), this.getClass().getName());
    }

    @Override
    protected void encodeKey(CodecDataOutput cdo, Object value) {
        throw new UnsupportedTypeException("Set type cannot be pushed down.");
    }

    @Override
    protected void encodeValue(CodecDataOutput cdo, Object value) {
        throw new UnsupportedTypeException("Set type cannot be pushed down.");
    }

    @Override
    protected void encodeProto(CodecDataOutput cdo, Object value) {
        throw new UnsupportedTypeException("Set type cannot be pushed down.");
    }

    @Override
    public String getName() {
        return "SET";
    }

    @Override
    public ExprType getProtoExprType() {
        return ExprType.MysqlSet;
    }

    @Override
    public Object getOriginDefaultValueNonNull(String value, long version) {
        return value;
    }

    @Override
    public boolean isPushDownSupported() {
        return false;
    }
}

