/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.pd;

import org.tikv.kvproto.Pdpb;

public final class PDError {
    private final Pdpb.Error error;
    private final ErrorType errorType;

    private PDError(Pdpb.Error error) {
        this.error = error;
        this.errorType = ErrorType.PD_ERROR;
    }

    private PDError(Pdpb.Error error, ErrorType errorType) {
        this.error = error;
        this.errorType = errorType;
    }

    public static PDError buildFromPdpbError(Pdpb.Error error) {
        return new PDError(error);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Pdpb.Error error) {
        return new Builder(error);
    }

    public Pdpb.Error getError() {
        return this.error;
    }

    public ErrorType getErrorType() {
        return this.errorType;
    }

    public String getMessage() {
        return this.getError().getMessage();
    }

    public String toString() {
        return "\nErrorType: " + (Object)((Object)this.errorType) + "\nError: " + this.error;
    }

    public static final class Builder {
        private Pdpb.Error error_;
        private ErrorType errorType_ = ErrorType.PD_ERROR;

        public Builder() {
        }

        public Builder(Pdpb.Error error) {
            this.error_ = error;
        }

        public Builder setError(Pdpb.Error error) {
            this.error_ = error;
            return this;
        }

        public Builder setErrorType(ErrorType errorType) {
            this.errorType_ = errorType;
            return this;
        }

        public PDError build() {
            return new PDError(this.error_, this.errorType_);
        }
    }

    public static final class RegionPeerNotElected {
        private static final String ERROR_MESSAGE = "Region Peer not elected. Please try later";
        private static final Pdpb.Error DEFAULT_ERROR = Pdpb.Error.newBuilder().setMessage("Region Peer not elected. Please try later").build();
        private static final ErrorType ERROR_TYPE = ErrorType.REGION_PEER_NOT_ELECTED;
        public static final PDError DEFAULT_INSTANCE = PDError.newBuilder(DEFAULT_ERROR).setErrorType(ERROR_TYPE).build();
    }

    public static enum ErrorType {
        PD_ERROR,
        REGION_PEER_NOT_ELECTED;

    }
}

