/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.meta;

import org.tikv.common.exception.TiClientInternalException;

public enum IndexType {
    IndexTypeInvalid(0),
    IndexTypeBtree(1),
    IndexTypeHash(2);

    private final int type;

    private IndexType(int type) {
        this.type = type;
    }

    public static IndexType fromValue(int type) {
        for (IndexType e : IndexType.values()) {
            if (e.type != type) continue;
            return e;
        }
        throw new TiClientInternalException("Invalid index type code: " + type);
    }

    public int getTypeCode() {
        return this.type;
    }

    public String toString() {
        switch (this.type) {
            case 1: {
                return "BTREE";
            }
            case 2: {
                return "HASH";
            }
        }
        return "Invalid";
    }
}

