/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.psql;

import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.api.table.type.ArrayType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.api.table.type.SqlType;
import org.apache.seatunnel.common.exception.CommonErrorCodeDeprecated;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.jdbc.exception.JdbcConnectorErrorCode;
import org.apache.seatunnel.connectors.seatunnel.jdbc.exception.JdbcConnectorException;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.converter.AbstractJdbcRowConverter;
import org.apache.seatunnel.connectors.seatunnel.jdbc.utils.JdbcFieldTypeUtils;
import org.postgresql.util.PGobject;

public class PostgresJdbcRowConverter
extends AbstractJdbcRowConverter {
    private static final String PG_GEOMETRY = "GEOMETRY";
    private static final String PG_GEOGRAPHY = "GEOGRAPHY";

    @Override
    public String converterName() {
        return "Postgres";
    }

    @Override
    public SeaTunnelRow toInternal(ResultSet rs, TableSchema tableSchema) throws SQLException {
        SeaTunnelRowType typeInfo = tableSchema.toPhysicalRowDataType();
        Object[] fields = new Object[typeInfo.getTotalFields()];
        block17: for (int fieldIndex = 0; fieldIndex < typeInfo.getTotalFields(); ++fieldIndex) {
            SeaTunnelDataType seaTunnelDataType = typeInfo.getFieldType(fieldIndex);
            int resultSetIndex = fieldIndex + 1;
            String metaDataColumnType = rs.getMetaData().getColumnTypeName(resultSetIndex).toUpperCase(Locale.ROOT);
            switch (seaTunnelDataType.getSqlType()) {
                case STRING: {
                    if (metaDataColumnType.equals(PG_GEOMETRY) || metaDataColumnType.equals(PG_GEOGRAPHY)) {
                        fields[fieldIndex] = rs.getObject(resultSetIndex) == null ? null : rs.getObject(resultSetIndex).toString();
                        continue block17;
                    }
                    fields[fieldIndex] = JdbcFieldTypeUtils.getString(rs, resultSetIndex);
                    continue block17;
                }
                case BOOLEAN: {
                    fields[fieldIndex] = JdbcFieldTypeUtils.getBoolean(rs, resultSetIndex);
                    continue block17;
                }
                case TINYINT: {
                    fields[fieldIndex] = JdbcFieldTypeUtils.getByte(rs, resultSetIndex);
                    continue block17;
                }
                case SMALLINT: {
                    fields[fieldIndex] = JdbcFieldTypeUtils.getShort(rs, resultSetIndex);
                    continue block17;
                }
                case INT: {
                    fields[fieldIndex] = JdbcFieldTypeUtils.getInt(rs, resultSetIndex);
                    continue block17;
                }
                case BIGINT: {
                    fields[fieldIndex] = JdbcFieldTypeUtils.getLong(rs, resultSetIndex);
                    continue block17;
                }
                case FLOAT: {
                    fields[fieldIndex] = JdbcFieldTypeUtils.getFloat(rs, resultSetIndex);
                    continue block17;
                }
                case DOUBLE: {
                    fields[fieldIndex] = JdbcFieldTypeUtils.getDouble(rs, resultSetIndex);
                    continue block17;
                }
                case DECIMAL: {
                    fields[fieldIndex] = JdbcFieldTypeUtils.getBigDecimal(rs, resultSetIndex);
                    continue block17;
                }
                case DATE: {
                    Date sqlDate = JdbcFieldTypeUtils.getDate(rs, resultSetIndex);
                    fields[fieldIndex] = Optional.ofNullable(sqlDate).map(e -> e.toLocalDate()).orElse(null);
                    continue block17;
                }
                case TIME: {
                    Time sqlTime = JdbcFieldTypeUtils.getTime(rs, resultSetIndex);
                    fields[fieldIndex] = Optional.ofNullable(sqlTime).map(e -> e.toLocalTime()).orElse(null);
                    continue block17;
                }
                case TIMESTAMP: {
                    Timestamp sqlTimestamp = JdbcFieldTypeUtils.getTimestamp(rs, resultSetIndex);
                    fields[fieldIndex] = Optional.ofNullable(sqlTimestamp).map(e -> e.toLocalDateTime()).orElse(null);
                    continue block17;
                }
                case BYTES: {
                    fields[fieldIndex] = JdbcFieldTypeUtils.getBytes(rs, resultSetIndex);
                    continue block17;
                }
                case NULL: {
                    fields[fieldIndex] = null;
                    continue block17;
                }
                case ARRAY: {
                    Array jdbcArray = rs.getArray(resultSetIndex);
                    if (jdbcArray == null) {
                        fields[fieldIndex] = null;
                        continue block17;
                    }
                    Object arrayObject = jdbcArray.getArray();
                    if (((ArrayType)seaTunnelDataType).getTypeClass().equals(arrayObject.getClass())) {
                        fields[fieldIndex] = arrayObject;
                        continue block17;
                    }
                    throw new JdbcConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_DATA_TYPE, "Unexpected value: " + seaTunnelDataType.getTypeClass());
                }
                default: {
                    throw new JdbcConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_DATA_TYPE, "Unexpected value: " + seaTunnelDataType);
                }
            }
        }
        return new SeaTunnelRow(fields);
    }

    @Override
    public PreparedStatement toExternal(TableSchema tableSchema, @Nullable TableSchema databaseTableSchema, SeaTunnelRow row, PreparedStatement statement) throws SQLException {
        SeaTunnelRowType rowType = tableSchema.toPhysicalRowDataType();
        String[] sourceTypes = (String[])tableSchema.getColumns().stream().filter(Column::isPhysical).map(Column::getSourceType).toArray(String[]::new);
        for (int fieldIndex = 0; fieldIndex < rowType.getTotalFields(); ++fieldIndex) {
            try {
                SeaTunnelDataType seaTunnelDataType = rowType.getFieldType(fieldIndex);
                int statementIndex = fieldIndex + 1;
                Object fieldValue = row.getField(fieldIndex);
                if (fieldValue == null) {
                    statement.setObject(statementIndex, null);
                    continue;
                }
                switch (seaTunnelDataType.getSqlType()) {
                    case STRING: {
                        String sourceType = sourceTypes[fieldIndex];
                        if ("inet".equalsIgnoreCase(sourceType)) {
                            PGobject inetObject = new PGobject();
                            inetObject.setType("inet");
                            inetObject.setValue(String.valueOf(row.getField(fieldIndex)));
                            statement.setObject(statementIndex, inetObject);
                            break;
                        }
                        statement.setString(statementIndex, (String)row.getField(fieldIndex));
                        break;
                    }
                    case BOOLEAN: {
                        statement.setBoolean(statementIndex, (Boolean)row.getField(fieldIndex));
                        break;
                    }
                    case TINYINT: {
                        statement.setByte(statementIndex, (Byte)row.getField(fieldIndex));
                        break;
                    }
                    case SMALLINT: {
                        statement.setShort(statementIndex, (Short)row.getField(fieldIndex));
                        break;
                    }
                    case INT: {
                        statement.setInt(statementIndex, (Integer)row.getField(fieldIndex));
                        break;
                    }
                    case BIGINT: {
                        statement.setLong(statementIndex, (Long)row.getField(fieldIndex));
                        break;
                    }
                    case FLOAT: {
                        statement.setFloat(statementIndex, ((Float)row.getField(fieldIndex)).floatValue());
                        break;
                    }
                    case DOUBLE: {
                        statement.setDouble(statementIndex, (Double)row.getField(fieldIndex));
                        break;
                    }
                    case DECIMAL: {
                        statement.setBigDecimal(statementIndex, (BigDecimal)row.getField(fieldIndex));
                        break;
                    }
                    case DATE: {
                        LocalDate localDate = (LocalDate)row.getField(fieldIndex);
                        statement.setDate(statementIndex, Date.valueOf(localDate));
                        break;
                    }
                    case TIME: {
                        this.writeTime(statement, statementIndex, (LocalTime)row.getField(fieldIndex));
                        break;
                    }
                    case TIMESTAMP: {
                        LocalDateTime localDateTime = (LocalDateTime)row.getField(fieldIndex);
                        statement.setTimestamp(statementIndex, Timestamp.valueOf(localDateTime));
                        break;
                    }
                    case BYTES: {
                        statement.setBytes(statementIndex, (byte[])row.getField(fieldIndex));
                        break;
                    }
                    case NULL: {
                        statement.setNull(statementIndex, 0);
                        break;
                    }
                    case ARRAY: {
                        SeaTunnelDataType elementType = ((ArrayType)seaTunnelDataType).getElementType();
                        Object[] array = (Object[])row.getField(fieldIndex);
                        if (array == null) {
                            statement.setNull(statementIndex, 2003);
                            break;
                        }
                        if (SqlType.TINYINT.equals((Object)elementType.getSqlType())) {
                            Short[] shortArray = new Short[array.length];
                            for (int i = 0; i < array.length; ++i) {
                                shortArray[i] = Short.valueOf(array[i].toString());
                            }
                            statement.setObject(statementIndex, shortArray);
                            break;
                        }
                        statement.setObject(statementIndex, array);
                        break;
                    }
                    default: {
                        throw new JdbcConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_DATA_TYPE, "Unexpected value: " + seaTunnelDataType);
                    }
                }
                continue;
            }
            catch (Exception e) {
                throw new JdbcConnectorException(JdbcConnectorErrorCode.DATA_TYPE_CAST_FAILED, "error field:" + rowType.getFieldNames()[fieldIndex], e);
            }
        }
        return statement;
    }
}

