/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.iris;

import com.google.auto.service.AutoService;
import java.util.Objects;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.PhysicalColumn;
import org.apache.seatunnel.api.table.converter.BasicTypeDefine;
import org.apache.seatunnel.api.table.converter.TypeConverter;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.DecimalType;
import org.apache.seatunnel.api.table.type.LocalTimeType;
import org.apache.seatunnel.api.table.type.PrimitiveByteArrayType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.common.exception.CommonError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={TypeConverter.class})
public class IrisTypeConverter
implements TypeConverter<BasicTypeDefine> {
    private static final Logger log = LoggerFactory.getLogger(IrisTypeConverter.class);
    public static final String IRIS_NULL = "NULL";
    public static final String IRIS_NUMERIC = "NUMERIC";
    public static final String IRIS_MONEY = "MONEY";
    public static final String IRIS_SMALLMONEY = "SMALLMONEY";
    public static final String IRIS_NUMBER = "NUMBER";
    public static final String IRIS_DEC = "DEC";
    public static final String IRIS_DECIMAL = "DECIMAL";
    public static final String IRIS_INTEGER = "INTEGER";
    public static final String IRIS_INT = "INT";
    public static final String IRIS_ROWVERSION = "ROWVERSION";
    public static final String IRIS_BIGINT = "BIGINT";
    public static final String IRIS_SERIAL = "SERIAL";
    public static final String IRIS_TINYINT = "TINYINT";
    public static final String IRIS_SMALLINT = "SMALLINT";
    public static final String IRIS_MEDIUMINT = "MEDIUMINT";
    public static final String IRIS_FLOAT = "FLOAT";
    public static final String IRIS_DOUBLE = "DOUBLE";
    public static final String IRIS_REAL = "REAL";
    public static final String IRIS_DOUBLE_PRECISION = "DOUBLE PRECISION";
    public static final String IRIS_CHAR = "CHAR";
    public static final String IRIS_CHAR_VARYING = "CHAR VARYING";
    public static final String IRIS_CHARACTER_VARYING = "CHARACTER VARYING";
    public static final String IRIS_NATIONAL_CHAR = "NATIONAL CHAR";
    public static final String IRIS_NATIONAL_CHAR_VARYING = "NATIONAL CHAR VARYING";
    public static final String IRIS_NATIONAL_CHARACTER = "NATIONAL CHARACTER";
    public static final String IRIS_NATIONAL_CHARACTER_VARYING = "NATIONAL CHARACTER VARYING";
    public static final String IRIS_NATIONAL_VARCHAR = "NATIONAL VARCHAR";
    public static final String IRIS_NCHAR = "NCHAR";
    public static final String IRIS_NVARCHAR = "NVARCHAR";
    public static final String IRIS_SYSNAME = "SYSNAME";
    public static final String IRIS_VARCHAR2 = "VARCHAR2";
    public static final String IRIS_VARCHAR = "VARCHAR";
    public static final String IRIS_UNIQUEIDENTIFIER = "UNIQUEIDENTIFIER";
    public static final String IRIS_GUID = "GUID";
    public static final String IRIS_CHARACTER = "CHARACTER";
    public static final String IRIS_NTEXT = "NTEXT";
    public static final String IRIS_CLOB = "CLOB";
    public static final String IRIS_LONG_VARCHAR = "LONG VARCHAR";
    public static final String IRIS_LONG = "LONG";
    public static final String IRIS_LONGTEXT = "LONGTEXT";
    public static final String IRIS_MEDIUMTEXT = "MEDIUMTEXT";
    public static final String IRIS_TEXT = "TEXT";
    public static final String IRIS_LONGVARCHAR = "LONGVARCHAR";
    public static final String IRIS_DATE = "DATE";
    public static final String IRIS_TIME = "TIME";
    public static final String IRIS_TIMESTAMP = "TIMESTAMP";
    public static final String IRIS_POSIXTIME = "POSIXTIME";
    public static final String IRIS_TIMESTAMP2 = "TIMESTAMP2";
    public static final String IRIS_DATETIME = "DATETIME";
    public static final String IRIS_SMALLDATETIME = "SMALLDATETIME";
    public static final String IRIS_DATETIME2 = "DATETIME2";
    public static final String IRIS_BINARY = "BINARY";
    public static final String IRIS_VARBINARY = "VARBINARY";
    public static final String IRIS_RAW = "RAW";
    public static final String IRIS_LONGVARBINARY = "LONGVARBINARY";
    public static final String IRIS_BINARY_VARYING = "BINARY VARYING";
    public static final String IRIS_BLOB = "BLOB";
    public static final String IRIS_IMAGE = "IMAGE";
    public static final String IRIS_LONG_BINARY = "LONG BINARY";
    public static final String IRIS_LONG_RAW = "LONG RAW";
    public static final String IRIS_BIT = "BIT";
    public static final int MAX_SCALE = 18;
    public static final int DEFAULT_SCALE = 0;
    public static final int MAX_PRECISION = 37;
    public static final int DEFAULT_PRECISION = 15;
    public static final int MAX_TIME_SCALE = 9;
    public static final long GUID_LENGTH = 36L;
    public static final long MAX_VARCHAR_LENGTH = Integer.MAX_VALUE;
    public static final long MAX_BINARY_LENGTH = Integer.MAX_VALUE;
    public static final IrisTypeConverter INSTANCE = new IrisTypeConverter();

    public String identifier() {
        return "IRIS";
    }

    public Column convert(BasicTypeDefine typeDefine) {
        Long typeDefineLength = typeDefine.getLength();
        PhysicalColumn.PhysicalColumnBuilder builder = PhysicalColumn.builder().name(typeDefine.getName()).sourceType(typeDefine.getColumnType()).columnLength(typeDefineLength).scale(typeDefine.getScale()).nullable(typeDefine.isNullable()).defaultValue(typeDefine.getDefaultValue()).comment(typeDefine.getComment());
        String irisDataType = typeDefine.getDataType().toUpperCase();
        long charOrBinaryLength = Objects.nonNull(typeDefineLength) && typeDefineLength > 0L ? typeDefineLength : 1L;
        switch (irisDataType) {
            case "NULL": {
                builder.dataType((SeaTunnelDataType)BasicType.VOID_TYPE);
                break;
            }
            case "BIT": {
                builder.dataType((SeaTunnelDataType)BasicType.BOOLEAN_TYPE);
                break;
            }
            case "NUMERIC": 
            case "MONEY": 
            case "SMALLMONEY": 
            case "NUMBER": 
            case "DEC": 
            case "DECIMAL": {
                DecimalType decimalType = typeDefine.getPrecision() != null && typeDefine.getPrecision() > 0L ? new DecimalType(typeDefine.getPrecision().intValue(), typeDefine.getScale().intValue()) : new DecimalType(15, 0);
                builder.dataType((SeaTunnelDataType)decimalType);
                builder.columnLength(Long.valueOf(decimalType.getPrecision()));
                builder.scale(Integer.valueOf(decimalType.getScale()));
                break;
            }
            case "INT": 
            case "INTEGER": 
            case "MEDIUMINT": {
                builder.dataType((SeaTunnelDataType)BasicType.INT_TYPE);
                break;
            }
            case "ROWVERSION": 
            case "BIGINT": 
            case "SERIAL": {
                builder.dataType((SeaTunnelDataType)BasicType.LONG_TYPE);
                break;
            }
            case "TINYINT": {
                builder.dataType((SeaTunnelDataType)BasicType.BYTE_TYPE);
                break;
            }
            case "SMALLINT": {
                builder.dataType((SeaTunnelDataType)BasicType.SHORT_TYPE);
                break;
            }
            case "FLOAT": {
                builder.dataType((SeaTunnelDataType)BasicType.FLOAT_TYPE);
                break;
            }
            case "DOUBLE": 
            case "REAL": 
            case "DOUBLE PRECISION": {
                builder.dataType((SeaTunnelDataType)BasicType.DOUBLE_TYPE);
                break;
            }
            case "CHAR": 
            case "CHAR VARYING": 
            case "CHARACTER VARYING": 
            case "NATIONAL CHAR": 
            case "NATIONAL CHAR VARYING": 
            case "NATIONAL CHARACTER": 
            case "NATIONAL CHARACTER VARYING": 
            case "NATIONAL VARCHAR": 
            case "NCHAR": 
            case "SYSNAME": 
            case "VARCHAR2": 
            case "VARCHAR": 
            case "NVARCHAR": 
            case "UNIQUEIDENTIFIER": 
            case "GUID": 
            case "CHARACTER": {
                builder.dataType((SeaTunnelDataType)BasicType.STRING_TYPE);
                builder.columnLength(Long.valueOf(charOrBinaryLength));
                break;
            }
            case "NTEXT": 
            case "CLOB": 
            case "LONG VARCHAR": 
            case "LONG": 
            case "LONGTEXT": 
            case "MEDIUMTEXT": 
            case "TEXT": 
            case "LONGVARCHAR": {
                builder.dataType((SeaTunnelDataType)BasicType.STRING_TYPE);
                builder.columnLength(Long.valueOf(Integer.MAX_VALUE));
                break;
            }
            case "DATE": {
                builder.dataType((SeaTunnelDataType)LocalTimeType.LOCAL_DATE_TYPE);
                break;
            }
            case "TIME": {
                builder.dataType((SeaTunnelDataType)LocalTimeType.LOCAL_TIME_TYPE);
                break;
            }
            case "DATETIME": 
            case "DATETIME2": 
            case "SMALLDATETIME": 
            case "TIMESTAMP": 
            case "TIMESTAMP2": 
            case "POSIXTIME": {
                builder.dataType((SeaTunnelDataType)LocalTimeType.LOCAL_DATE_TIME_TYPE);
                break;
            }
            case "BINARY": 
            case "BINARY VARYING": 
            case "RAW": 
            case "VARBINARY": {
                builder.dataType((SeaTunnelDataType)PrimitiveByteArrayType.INSTANCE);
                builder.columnLength(Long.valueOf(charOrBinaryLength));
                break;
            }
            case "LONGVARBINARY": 
            case "BLOB": 
            case "IMAGE": 
            case "LONG BINARY": 
            case "LONG RAW": {
                builder.dataType((SeaTunnelDataType)PrimitiveByteArrayType.INSTANCE);
                builder.columnLength(Long.valueOf(Integer.MAX_VALUE));
                break;
            }
            default: {
                throw CommonError.convertToSeaTunnelTypeError((String)"IRIS", (String)irisDataType, (String)typeDefine.getName());
            }
        }
        return builder.build();
    }

    public BasicTypeDefine reconvert(Column column) {
        BasicTypeDefine.BasicTypeDefineBuilder builder = BasicTypeDefine.builder().name(column.getName()).precision(column.getColumnLength()).length(column.getColumnLength()).nullable(column.isNullable()).comment(column.getComment()).scale(column.getScale()).defaultValue(column.getDefaultValue());
        switch (column.getDataType().getSqlType()) {
            case NULL: {
                builder.columnType(IRIS_NULL);
                builder.dataType(IRIS_NULL);
                break;
            }
            case STRING: {
                if (column.getColumnLength() == null || column.getColumnLength() <= 0L) {
                    builder.columnType(String.format("%s(%s)", IRIS_VARCHAR, Integer.MAX_VALUE));
                    builder.dataType(IRIS_VARCHAR);
                    break;
                }
                if (column.getColumnLength() < Integer.MAX_VALUE) {
                    builder.columnType(String.format("%s(%s)", IRIS_VARCHAR, column.getColumnLength()));
                    builder.dataType(IRIS_VARCHAR);
                    break;
                }
                builder.columnType(IRIS_LONG_VARCHAR);
                builder.dataType(IRIS_LONG_VARCHAR);
                break;
            }
            case BOOLEAN: {
                builder.columnType(IRIS_BIT);
                builder.dataType(IRIS_BIT);
                break;
            }
            case TINYINT: {
                builder.columnType(IRIS_TINYINT);
                builder.dataType(IRIS_TINYINT);
                break;
            }
            case SMALLINT: {
                builder.columnType(IRIS_SMALLINT);
                builder.dataType(IRIS_SMALLINT);
                break;
            }
            case INT: {
                builder.columnType(IRIS_INTEGER);
                builder.dataType(IRIS_INTEGER);
                break;
            }
            case BIGINT: {
                builder.columnType(IRIS_BIGINT);
                builder.dataType(IRIS_BIGINT);
                break;
            }
            case FLOAT: {
                builder.columnType(IRIS_FLOAT);
                builder.dataType(IRIS_FLOAT);
                break;
            }
            case DOUBLE: {
                builder.columnType(IRIS_DOUBLE);
                builder.dataType(IRIS_DOUBLE);
                break;
            }
            case DECIMAL: {
                DecimalType decimalType = (DecimalType)column.getDataType();
                long precision = decimalType.getPrecision();
                int scale = decimalType.getScale();
                if (scale < 0) {
                    scale = 0;
                    log.warn("The decimal column {} type decimal({},{}) is out of range, which is scale less than 0, it will be converted to decimal({},{})", new Object[]{column.getName(), decimalType.getPrecision(), decimalType.getScale(), precision, scale});
                } else if (scale > 18) {
                    scale = 18;
                    log.warn("The decimal column {} type decimal({},{}) is out of range, which exceeds the maximum scale of {}, it will be converted to decimal({},{})", new Object[]{column.getName(), decimalType.getPrecision(), decimalType.getScale(), 18, precision, scale});
                }
                if (precision < (long)scale) {
                    precision = scale;
                }
                if (precision <= 0L) {
                    precision = 15L;
                    scale = 0;
                    log.warn("The decimal column {} type decimal({},{}) is out of range, which is precision less than 0, it will be converted to decimal({},{})", new Object[]{column.getName(), decimalType.getPrecision(), decimalType.getScale(), precision, scale});
                } else if (precision > 37L) {
                    scale = 18;
                    precision = 37L;
                    log.warn("The decimal column {} type decimal({},{}) is out of range, which exceeds the maximum precision of {}, it will be converted to decimal({},{})", new Object[]{column.getName(), decimalType.getPrecision(), decimalType.getScale(), 37, precision, scale});
                }
                builder.columnType(String.format("%s(%s,%s)", IRIS_DECIMAL, precision, scale));
                builder.dataType(IRIS_DECIMAL);
                builder.precision(Long.valueOf(precision));
                builder.scale(Integer.valueOf(scale));
                break;
            }
            case BYTES: {
                if (column.getColumnLength() == null || column.getColumnLength() <= 0L) {
                    builder.columnType(IRIS_LONG_BINARY);
                    builder.dataType(IRIS_LONG_BINARY);
                    break;
                }
                if (column.getColumnLength() < Integer.MAX_VALUE) {
                    builder.dataType(IRIS_BINARY);
                    builder.columnType(String.format("%s(%s)", IRIS_BINARY, column.getColumnLength()));
                    break;
                }
                builder.columnType(IRIS_LONG_BINARY);
                builder.dataType(IRIS_LONG_BINARY);
                break;
            }
            case DATE: {
                builder.columnType(IRIS_DATE);
                builder.dataType(IRIS_DATE);
                break;
            }
            case TIME: {
                builder.dataType(IRIS_TIME);
                if (Objects.nonNull(column.getScale()) && column.getScale() > 0) {
                    Integer timeScale = column.getScale();
                    if (timeScale > 9) {
                        timeScale = 9;
                        log.warn("The time column {} type time({}) is out of range, which exceeds the maximum scale of {}, it will be converted to time({})", new Object[]{column.getName(), column.getScale(), 9, timeScale});
                    }
                    builder.columnType(String.format("%s(%s)", IRIS_TIME, timeScale));
                    builder.scale(timeScale);
                    break;
                }
                builder.columnType(IRIS_TIME);
                break;
            }
            case TIMESTAMP: {
                builder.columnType(IRIS_TIMESTAMP2);
                builder.dataType(IRIS_TIMESTAMP2);
                break;
            }
            default: {
                throw CommonError.convertToConnectorTypeError((String)"IRIS", (String)column.getDataType().getSqlType().name(), (String)column.getName());
            }
        }
        return builder.build();
    }
}

