/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.iotdb.source;

import java.util.Collections;
import java.util.List;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.source.Boundedness;
import org.apache.seatunnel.api.source.SeaTunnelSource;
import org.apache.seatunnel.api.source.SourceReader;
import org.apache.seatunnel.api.source.SourceSplitEnumerator;
import org.apache.seatunnel.api.source.SupportColumnProjection;
import org.apache.seatunnel.api.source.SupportParallelism;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.connectors.seatunnel.iotdb.source.IoTDBSourceReader;
import org.apache.seatunnel.connectors.seatunnel.iotdb.source.IoTDBSourceSplit;
import org.apache.seatunnel.connectors.seatunnel.iotdb.source.IoTDBSourceSplitEnumerator;
import org.apache.seatunnel.connectors.seatunnel.iotdb.state.IoTDBSourceState;

public class IoTDBSource
implements SeaTunnelSource<SeaTunnelRow, IoTDBSourceSplit, IoTDBSourceState>,
SupportParallelism,
SupportColumnProjection {
    private CatalogTable catalogTable;
    private ReadonlyConfig pluginConfig;

    public IoTDBSource(CatalogTable catalogTable, ReadonlyConfig pluginConfig) {
        this.catalogTable = catalogTable;
        this.pluginConfig = pluginConfig;
    }

    public String getPluginName() {
        return "IoTDB";
    }

    public Boundedness getBoundedness() {
        return Boundedness.BOUNDED;
    }

    public SourceReader<SeaTunnelRow, IoTDBSourceSplit> createReader(SourceReader.Context readerContext) {
        return new IoTDBSourceReader(this.pluginConfig, readerContext, this.catalogTable.getSeaTunnelRowType());
    }

    public SourceSplitEnumerator<IoTDBSourceSplit, IoTDBSourceState> createEnumerator(SourceSplitEnumerator.Context<IoTDBSourceSplit> enumeratorContext) throws Exception {
        return new IoTDBSourceSplitEnumerator(enumeratorContext, this.pluginConfig);
    }

    public SourceSplitEnumerator<IoTDBSourceSplit, IoTDBSourceState> restoreEnumerator(SourceSplitEnumerator.Context<IoTDBSourceSplit> enumeratorContext, IoTDBSourceState checkpointState) throws Exception {
        return new IoTDBSourceSplitEnumerator(enumeratorContext, this.pluginConfig, checkpointState);
    }

    public List<CatalogTable> getProducedCatalogTables() {
        return Collections.singletonList(this.catalogTable);
    }
}

