/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.rpc;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import org.apache.iotdb.protocol.influxdb.rpc.thrift.InfluxDBService;
import org.apache.iotdb.rpc.BatchExecutionException;
import org.apache.iotdb.rpc.InfluxDBSynchronizedHandler;
import org.apache.iotdb.rpc.RedirectException;
import org.apache.iotdb.rpc.SessionTimeoutException;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.rpc.SynchronizedHandler;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.EndPoint;
import org.apache.iotdb.service.rpc.thrift.TSExecuteStatementResp;
import org.apache.iotdb.service.rpc.thrift.TSFetchResultsResp;
import org.apache.iotdb.service.rpc.thrift.TSIService;
import org.apache.iotdb.service.rpc.thrift.TSStatus;

public class RpcUtils {
    public static final int THRIFT_DEFAULT_BUF_CAPACITY = 1024;
    public static final int THRIFT_FRAME_MAX_SIZE = 0x20000000;
    public static final int MAX_BUFFER_OVERSIZE_TIME = 5;
    public static final long MIN_SHRINK_INTERVAL = 60000L;
    public static final TSStatus SUCCESS_STATUS = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
    public static final String DEFAULT_TIME_FORMAT = "default";
    public static final String DEFAULT_TIMESTAMP_PRECISION = "ms";

    private RpcUtils() {
    }

    public static TSIService.Iface newSynchronizedClient(TSIService.Iface client) {
        return (TSIService.Iface)Proxy.newProxyInstance(RpcUtils.class.getClassLoader(), new Class[]{TSIService.Iface.class}, (InvocationHandler)new SynchronizedHandler(client));
    }

    public static InfluxDBService.Iface newSynchronizedClient(InfluxDBService.Iface client) {
        return (InfluxDBService.Iface)Proxy.newProxyInstance(RpcUtils.class.getClassLoader(), new Class[]{InfluxDBService.Iface.class}, (InvocationHandler)new InfluxDBSynchronizedHandler(client));
    }

    public static void verifySuccess(TSStatus status) throws StatementExecutionException {
        if (status.getCode() == TSStatusCode.MULTIPLE_ERROR.getStatusCode()) {
            RpcUtils.verifySuccess(status.getSubStatus());
            return;
        }
        if (status.getCode() == TSStatusCode.NEED_REDIRECTION.getStatusCode()) {
            return;
        }
        if (status.getCode() == TSStatusCode.SESSION_TIMEOUT.getStatusCode()) {
            throw new SessionTimeoutException(status);
        }
        if (status.code != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new StatementExecutionException(status);
        }
    }

    public static void verifySuccess(org.apache.iotdb.protocol.influxdb.rpc.thrift.TSStatus status) throws StatementExecutionException {
        if (status.getCode() == TSStatusCode.NEED_REDIRECTION.getStatusCode()) {
            return;
        }
        if (status.code != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new StatementExecutionException(status);
        }
    }

    public static void verifySuccessWithRedirection(TSStatus status) throws StatementExecutionException, RedirectException {
        RpcUtils.verifySuccess(status);
        if (status.isSetRedirectNode()) {
            throw new RedirectException(status.getRedirectNode());
        }
    }

    public static void verifySuccessWithRedirectionForMultiDevices(TSStatus status, List<String> devices) throws StatementExecutionException, RedirectException {
        RpcUtils.verifySuccess(status);
        if (status.getCode() == TSStatusCode.MULTIPLE_ERROR.getStatusCode() || status.getCode() == TSStatusCode.NEED_REDIRECTION.getStatusCode()) {
            HashMap<String, EndPoint> deviceEndPointMap = new HashMap<String, EndPoint>();
            List<TSStatus> statusSubStatus = status.getSubStatus();
            for (int i = 0; i < statusSubStatus.size(); ++i) {
                TSStatus subStatus = statusSubStatus.get(i);
                if (!subStatus.isSetRedirectNode()) continue;
                deviceEndPointMap.put(devices.get(i), subStatus.getRedirectNode());
            }
            throw new RedirectException(deviceEndPointMap);
        }
    }

    public static void verifySuccess(List<TSStatus> statuses) throws BatchExecutionException {
        StringBuilder errMsgs = new StringBuilder().append(TSStatusCode.MULTIPLE_ERROR.getStatusCode()).append(": ");
        for (TSStatus status : statuses) {
            if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() || status.getCode() == TSStatusCode.NEED_REDIRECTION.getStatusCode()) continue;
            errMsgs.append(status.getMessage()).append("; ");
        }
        if (errMsgs.length() > 0) {
            throw new BatchExecutionException(statuses, errMsgs.toString());
        }
    }

    public static TSStatus getStatus(TSStatusCode tsStatusCode) {
        return new TSStatus(tsStatusCode.getStatusCode());
    }

    public static TSStatus getStatus(List<TSStatus> statusList) {
        TSStatus status = new TSStatus(TSStatusCode.MULTIPLE_ERROR.getStatusCode());
        status.setSubStatus(statusList);
        return status;
    }

    public static TSStatus getStatus(TSStatusCode tsStatusCode, String message) {
        TSStatus status = new TSStatus(tsStatusCode.getStatusCode());
        status.setMessage(message);
        return status;
    }

    public static TSStatus getStatus(int code, String message) {
        TSStatus status = new TSStatus(code);
        status.setMessage(message);
        return status;
    }

    public static org.apache.iotdb.protocol.influxdb.rpc.thrift.TSStatus getInfluxDBStatus(TSStatusCode tsStatusCode) {
        return new org.apache.iotdb.protocol.influxdb.rpc.thrift.TSStatus(tsStatusCode.getStatusCode());
    }

    public static org.apache.iotdb.protocol.influxdb.rpc.thrift.TSStatus getInfluxDBStatus(int code, String message) {
        org.apache.iotdb.protocol.influxdb.rpc.thrift.TSStatus status = new org.apache.iotdb.protocol.influxdb.rpc.thrift.TSStatus(code);
        status.setMessage(message);
        return status;
    }

    public static TSExecuteStatementResp getTSExecuteStatementResp(TSStatusCode tsStatusCode) {
        TSStatus status = RpcUtils.getStatus(tsStatusCode);
        return RpcUtils.getTSExecuteStatementResp(status);
    }

    public static TSExecuteStatementResp getTSExecuteStatementResp(TSStatusCode tsStatusCode, String message) {
        TSStatus status = RpcUtils.getStatus(tsStatusCode, message);
        return RpcUtils.getTSExecuteStatementResp(status);
    }

    public static TSExecuteStatementResp getTSExecuteStatementResp(TSStatus status) {
        TSExecuteStatementResp resp = new TSExecuteStatementResp();
        TSStatus tsStatus = new TSStatus(status);
        resp.setStatus(tsStatus);
        return resp;
    }

    public static TSFetchResultsResp getTSFetchResultsResp(TSStatusCode tsStatusCode) {
        TSStatus status = RpcUtils.getStatus(tsStatusCode);
        return RpcUtils.getTSFetchResultsResp(status);
    }

    public static TSFetchResultsResp getTSFetchResultsResp(TSStatusCode tsStatusCode, String appendMessage) {
        TSStatus status = RpcUtils.getStatus(tsStatusCode, appendMessage);
        return RpcUtils.getTSFetchResultsResp(status);
    }

    public static TSFetchResultsResp getTSFetchResultsResp(TSStatus status) {
        TSFetchResultsResp resp = new TSFetchResultsResp();
        TSStatus tsStatus = new TSStatus(status);
        resp.setStatus(tsStatus);
        return resp;
    }

    public static String setTimeFormat(String newTimeFormat) {
        String timeFormat;
        switch (newTimeFormat.trim().toLowerCase()) {
            case "long": 
            case "number": 
            case "default": 
            case "iso8601": {
                timeFormat = newTimeFormat.trim().toLowerCase();
                break;
            }
            default: {
                new SimpleDateFormat(newTimeFormat.trim());
                timeFormat = newTimeFormat;
            }
        }
        return timeFormat;
    }

    public static String formatDatetime(String timeFormat, String timePrecision, long timestamp, ZoneId zoneId) {
        switch (timeFormat) {
            case "long": 
            case "number": {
                return Long.toString(timestamp);
            }
            case "default": 
            case "iso8601": {
                return RpcUtils.parseLongToDateWithPrecision(DateTimeFormatter.ISO_OFFSET_DATE_TIME, timestamp, zoneId, timePrecision);
            }
        }
        ZonedDateTime dateTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(timestamp), zoneId);
        return dateTime.format(DateTimeFormatter.ofPattern(timeFormat));
    }

    public static String parseLongToDateWithPrecision(DateTimeFormatter formatter, long timestamp, ZoneId zoneid, String timestampPrecision) {
        if (DEFAULT_TIMESTAMP_PRECISION.equals(timestampPrecision)) {
            long integerofDate = timestamp / 1000L;
            StringBuilder digits = new StringBuilder(Long.toString(timestamp % 1000L));
            ZonedDateTime dateTime = ZonedDateTime.ofInstant(Instant.ofEpochSecond(integerofDate), zoneid);
            String datetime = dateTime.format(formatter);
            int length = digits.length();
            if (length != 3) {
                for (int i = 0; i < 3 - length; ++i) {
                    digits.insert(0, "0");
                }
            }
            return datetime.substring(0, 19) + "." + digits + datetime.substring(19);
        }
        if ("us".equals(timestampPrecision)) {
            long integerofDate = timestamp / 1000000L;
            StringBuilder digits = new StringBuilder(Long.toString(timestamp % 1000000L));
            ZonedDateTime dateTime = ZonedDateTime.ofInstant(Instant.ofEpochSecond(integerofDate), zoneid);
            String datetime = dateTime.format(formatter);
            int length = digits.length();
            if (length != 6) {
                for (int i = 0; i < 6 - length; ++i) {
                    digits.insert(0, "0");
                }
            }
            return datetime.substring(0, 19) + "." + digits + datetime.substring(19);
        }
        long integerofDate = timestamp / 1000000000L;
        StringBuilder digits = new StringBuilder(Long.toString(timestamp % 1000000000L));
        ZonedDateTime dateTime = ZonedDateTime.ofInstant(Instant.ofEpochSecond(integerofDate), zoneid);
        String datetime = dateTime.format(formatter);
        int length = digits.length();
        if (length != 9) {
            for (int i = 0; i < 9 - length; ++i) {
                digits.insert(0, "0");
            }
        }
        return datetime.substring(0, 19) + "." + digits + datetime.substring(19);
    }
}

