/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.influxdb.converter;

import java.util.ArrayList;
import java.util.List;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.api.table.type.SqlType;
import org.apache.seatunnel.common.exception.CommonErrorCodeDeprecated;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.influxdb.exception.InfluxdbConnectorException;

public class InfluxDBRowConverter {
    public static SeaTunnelRow convert(List<Object> values2, SeaTunnelRowType typeInfo, List<Integer> indexList) {
        SeaTunnelDataType[] seaTunnelDataTypes = typeInfo.getFieldTypes();
        ArrayList<Boolean> fields = new ArrayList<Boolean>(seaTunnelDataTypes.length);
        for (int i = 0; i <= seaTunnelDataTypes.length - 1; ++i) {
            Object seaTunnelField;
            int columnIndex = indexList.get(i);
            SeaTunnelDataType seaTunnelDataType = seaTunnelDataTypes[i];
            SqlType fieldSqlType = seaTunnelDataType.getSqlType();
            if (null == values2.get(columnIndex)) {
                seaTunnelField = null;
            } else if (SqlType.BOOLEAN.equals((Object)fieldSqlType)) {
                seaTunnelField = Boolean.parseBoolean(values2.get(columnIndex).toString());
            } else if (SqlType.SMALLINT.equals((Object)fieldSqlType)) {
                seaTunnelField = Short.valueOf(values2.get(columnIndex).toString());
            } else if (SqlType.INT.equals((Object)fieldSqlType)) {
                seaTunnelField = Integer.valueOf(values2.get(columnIndex).toString());
            } else if (SqlType.BIGINT.equals((Object)fieldSqlType)) {
                seaTunnelField = Long.valueOf(values2.get(columnIndex).toString());
            } else if (SqlType.FLOAT.equals((Object)fieldSqlType)) {
                seaTunnelField = Float.valueOf(((Double)values2.get(columnIndex)).floatValue());
            } else if (SqlType.DOUBLE.equals((Object)fieldSqlType)) {
                seaTunnelField = values2.get(columnIndex);
            } else if (SqlType.STRING.equals((Object)fieldSqlType)) {
                seaTunnelField = values2.get(columnIndex);
            } else {
                throw new InfluxdbConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_DATA_TYPE, "Unsupported data type: " + seaTunnelDataType);
            }
            fields.add((Boolean)seaTunnelField);
        }
        return new SeaTunnelRow(fields.toArray());
    }
}

