/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.influxdb.config;

import java.util.List;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.connectors.seatunnel.influxdb.config.InfluxDBConfig;
import org.apache.seatunnel.connectors.seatunnel.influxdb.config.InfluxDBSourceOptions;

public class SourceConfig
extends InfluxDBConfig {
    public static final int DEFAULT_PARTITIONS = (Integer)InfluxDBSourceOptions.PARTITION_NUM.defaultValue();
    private String sql;
    private int partitionNum = 0;
    private String splitKey;
    private long lowerBound;
    private long upperBound;
    List<Integer> columnsIndex;

    public SourceConfig(ReadonlyConfig config) {
        super(config);
    }

    public static SourceConfig loadConfig(ReadonlyConfig config) {
        SourceConfig sourceConfig = new SourceConfig(config);
        sourceConfig.sql = (String)config.get(InfluxDBSourceOptions.SQL);
        sourceConfig.partitionNum = (Integer)config.get(InfluxDBSourceOptions.PARTITION_NUM);
        if (config.getOptional(InfluxDBSourceOptions.UPPER_BOUND).isPresent()) {
            sourceConfig.upperBound = ((Integer)config.get(InfluxDBSourceOptions.UPPER_BOUND)).intValue();
        }
        if (config.getOptional(InfluxDBSourceOptions.LOWER_BOUND).isPresent()) {
            sourceConfig.lowerBound = ((Integer)config.get(InfluxDBSourceOptions.LOWER_BOUND)).intValue();
        }
        if (config.getOptional(InfluxDBSourceOptions.SPLIT_COLUMN).isPresent()) {
            sourceConfig.splitKey = (String)config.get(InfluxDBSourceOptions.SPLIT_COLUMN);
        }
        return sourceConfig;
    }

    public String getSql() {
        return this.sql;
    }

    public int getPartitionNum() {
        return this.partitionNum;
    }

    public String getSplitKey() {
        return this.splitKey;
    }

    public long getLowerBound() {
        return this.lowerBound;
    }

    public long getUpperBound() {
        return this.upperBound;
    }

    public List<Integer> getColumnsIndex() {
        return this.columnsIndex;
    }
}

