/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.influxdb.config;

import java.util.List;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.connectors.seatunnel.influxdb.config.InfluxDBConfig;
import org.apache.seatunnel.connectors.seatunnel.influxdb.config.InfluxDBSinkOptions;
import org.apache.seatunnel.connectors.seatunnel.influxdb.config.TimePrecision;

public class SinkConfig
extends InfluxDBConfig {
    private static final TimePrecision DEFAULT_TIME_PRECISION = TimePrecision.NS;
    private String rp;
    private String measurement;
    private int writeTimeout;
    private String keyTime;
    private List<String> keyTags;
    private int batchSize;
    private int maxRetries;
    private int retryBackoffMultiplierMs;
    private int maxRetryBackoffMs;
    private TimePrecision precision = DEFAULT_TIME_PRECISION;

    public SinkConfig(ReadonlyConfig config) {
        super(config);
        this.loadConfig(config);
    }

    public void loadConfig(ReadonlyConfig config) {
        this.setKeyTime((String)config.get(InfluxDBSinkOptions.KEY_TIME));
        this.setKeyTags((List)config.get(InfluxDBSinkOptions.KEY_TAGS));
        this.setBatchSize((Integer)config.get(InfluxDBSinkOptions.BATCH_SIZE));
        if (config.getOptional(InfluxDBSinkOptions.MAX_RETRIES).isPresent()) {
            this.setMaxRetries((Integer)config.get(InfluxDBSinkOptions.MAX_RETRIES));
        }
        if (config.getOptional(InfluxDBSinkOptions.RETRY_BACKOFF_MULTIPLIER_MS).isPresent()) {
            this.setRetryBackoffMultiplierMs((Integer)config.get(InfluxDBSinkOptions.RETRY_BACKOFF_MULTIPLIER_MS));
        }
        if (config.getOptional(InfluxDBSinkOptions.MAX_RETRY_BACKOFF_MS).isPresent()) {
            this.setMaxRetryBackoffMs((Integer)config.get(InfluxDBSinkOptions.MAX_RETRY_BACKOFF_MS));
        }
        this.setWriteTimeout((Integer)config.get(InfluxDBSinkOptions.WRITE_TIMEOUT));
        this.setRp((String)config.get(InfluxDBSinkOptions.RETENTION_POLICY));
        this.setPrecision(TimePrecision.getPrecision((String)config.get(InfluxDBSinkOptions.EPOCH)));
        this.setMeasurement((String)config.get(InfluxDBSinkOptions.KEY_MEASUREMENT));
    }

    public void setRp(String rp) {
        this.rp = rp;
    }

    public void setMeasurement(String measurement) {
        this.measurement = measurement;
    }

    public void setWriteTimeout(int writeTimeout) {
        this.writeTimeout = writeTimeout;
    }

    public void setKeyTime(String keyTime) {
        this.keyTime = keyTime;
    }

    public void setKeyTags(List<String> keyTags) {
        this.keyTags = keyTags;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public void setRetryBackoffMultiplierMs(int retryBackoffMultiplierMs) {
        this.retryBackoffMultiplierMs = retryBackoffMultiplierMs;
    }

    public void setMaxRetryBackoffMs(int maxRetryBackoffMs) {
        this.maxRetryBackoffMs = maxRetryBackoffMs;
    }

    public void setPrecision(TimePrecision precision) {
        this.precision = precision;
    }

    public String getRp() {
        return this.rp;
    }

    public String getMeasurement() {
        return this.measurement;
    }

    public int getWriteTimeout() {
        return this.writeTimeout;
    }

    public String getKeyTime() {
        return this.keyTime;
    }

    public List<String> getKeyTags() {
        return this.keyTags;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public int getRetryBackoffMultiplierMs() {
        return this.retryBackoffMultiplierMs;
    }

    public int getMaxRetryBackoffMs() {
        return this.maxRetryBackoffMs;
    }

    public TimePrecision getPrecision() {
        return this.precision;
    }

    @Override
    public String toString() {
        return "SinkConfig(rp=" + this.getRp() + ", measurement=" + this.getMeasurement() + ", writeTimeout=" + this.getWriteTimeout() + ", keyTime=" + this.getKeyTime() + ", keyTags=" + this.getKeyTags() + ", batchSize=" + this.getBatchSize() + ", maxRetries=" + this.getMaxRetries() + ", retryBackoffMultiplierMs=" + this.getRetryBackoffMultiplierMs() + ", maxRetryBackoffMs=" + this.getMaxRetryBackoffMs() + ", precision=" + (Object)((Object)this.getPrecision()) + ")";
    }
}

