/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.elasticsearch.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.Options;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.config.ElasticsearchBaseOptions;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.config.SearchApiTypeEnum;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.config.SearchTypeEnum;
import org.apache.seatunnel.shade.com.fasterxml.jackson.core.type.TypeReference;

public class ElasticsearchSourceOptions
extends ElasticsearchBaseOptions {
    public static final Option<List<Map<String, Object>>> INDEX_LIST = Options.key((String)"index_list").type((TypeReference)new TypeReference<List<Map<String, Object>>>(){}).noDefaultValue().withDescription("index_list for multiTable sync");
    public static final Option<List<String>> SOURCE = Options.key((String)"source").listType().noDefaultValue().withDescription("The fields of index. You can get the document id by specifying the field _id.If sink _id to other index,you need specify an alias for _id due to the Elasticsearch limit");
    public static final Option<Map<String, String>> ARRAY_COLUMN = Options.key((String)"array_column").mapType().defaultValue(new HashMap()).withDescription("Because there is no array type in es,so need specify array Type.");
    public static final Option<String> SCROLL_TIME = Options.key((String)"scroll_time").stringType().defaultValue((Object)"1m").withDescription("Amount of time Elasticsearch will keep the search context alive for scroll requests");
    public static final Option<SearchTypeEnum> SEARCH_TYPE = Options.key((String)"search_type").enumType(SearchTypeEnum.class).defaultValue((Object)SearchTypeEnum.DSL).withDescription("Choose query type: DSL (Domain Specific Language) or SQL.");
    public static final Option<SearchApiTypeEnum> SEARCH_API_TYPE = Options.key((String)"search_api_type").enumType(SearchApiTypeEnum.class).defaultValue((Object)SearchApiTypeEnum.SCROLL).withDescription("Choose API type for pagination: SCROLL or PIT (Point in Time).");
    public static final Option<String> SQL_QUERY = Options.key((String)"sql_query").stringType().noDefaultValue().withDescription("X-pack sql,if search_type is sql, this value is required.");
    public static final Option<Integer> SCROLL_SIZE = Options.key((String)"scroll_size").intType().defaultValue((Object)100).withDescription("Maximum number of hits to be returned with each Elasticsearch scroll request");
    public static final Option<Map<String, Object>> QUERY = Options.key((String)"query").type((TypeReference)new TypeReference<Map<String, Object>>(){}).defaultValue(Collections.singletonMap("match_all", new HashMap())).withDescription("Elasticsearch query language. You can control the range of data read");
    public static final Option<Long> PIT_KEEP_ALIVE = Options.key((String)"pit_keep_alive").longType().defaultValue((Object)TimeUnit.MINUTES.toMillis(1L)).withDescription("The amount of time (in milliseconds) for which the PIT should be kept alive. Default is 1 minute.");
    public static final Option<Integer> PIT_BATCH_SIZE = Options.key((String)"pit_batch_size").intType().defaultValue((Object)100).withDescription("Maximum number of hits to be returned with each PIT search request. Similar to scroll_size but for PIT API.");
}

