/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.elasticsearch.client.auth;

import java.util.HashMap;
import java.util.Map;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.client.auth.ApiKeyAuthProvider;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.client.auth.ApiKeyEncodedAuthProvider;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.client.auth.AuthenticationProvider;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.client.auth.BasicAuthProvider;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.config.AuthTypeEnum;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.config.ElasticsearchBaseOptions;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.exception.ElasticsearchConnectorErrorCode;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.exception.ElasticsearchConnectorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationProviderFactory {
    private static final Logger log = LoggerFactory.getLogger(AuthenticationProviderFactory.class);
    private static final AuthTypeEnum DEFAULT_AUTH_TYPE = AuthTypeEnum.BASIC;
    private static final Map<AuthTypeEnum, Class<? extends AuthenticationProvider>> PROVIDER_REGISTRY = new HashMap<AuthTypeEnum, Class<? extends AuthenticationProvider>>();

    public static AuthenticationProvider createProvider(ReadonlyConfig config) {
        AuthTypeEnum authType = config.getOptional(ElasticsearchBaseOptions.AUTH_TYPE).orElse(DEFAULT_AUTH_TYPE);
        log.debug("Creating authentication provider for type: {}", (Object)authType);
        Class<? extends AuthenticationProvider> providerClass = PROVIDER_REGISTRY.get((Object)authType);
        if (providerClass == null) {
            throw new ElasticsearchConnectorException((SeaTunnelErrorCode)ElasticsearchConnectorErrorCode.UNSUPPORTED_AUTH_TYPE, String.format("Unsupported authentication type: %s. Supported types: %s", new Object[]{authType, PROVIDER_REGISTRY.keySet()}));
        }
        try {
            AuthenticationProvider provider = providerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            provider.validate(config);
            log.info("Successfully created authentication provider: {}", (Object)authType);
            return provider;
        }
        catch (Exception e) {
            throw new ElasticsearchConnectorException(ElasticsearchConnectorErrorCode.UNSUPPORTED_AUTH_TYPE, String.format("Failed to create authentication provider for type: %s", new Object[]{authType}), e);
        }
    }

    static {
        PROVIDER_REGISTRY.put(AuthTypeEnum.BASIC, BasicAuthProvider.class);
        PROVIDER_REGISTRY.put(AuthTypeEnum.API_KEY, ApiKeyAuthProvider.class);
        PROVIDER_REGISTRY.put(AuthTypeEnum.API_KEY_ENCODED, ApiKeyEncodedAuthProvider.class);
    }
}

