/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.elasticsearch.client.auth;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Optional;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.client.auth.AbstractAuthenticationProvider;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.config.ElasticsearchBaseOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiKeyAuthProvider
extends AbstractAuthenticationProvider {
    private static final Logger log = LoggerFactory.getLogger(ApiKeyAuthProvider.class);
    private static final String AUTH_TYPE = "api_key";
    private static final String API_KEY_HEADER = "Authorization";
    private static final String API_KEY_PREFIX = "ApiKey ";

    @Override
    protected void configureAuthentication(HttpAsyncClientBuilder httpClientBuilder, ReadonlyConfig config) {
        String encodedApiKey = this.getEncodedApiKey(config);
        if (encodedApiKey != null) {
            log.debug("Configuring API key authentication");
            httpClientBuilder.addInterceptorFirst((request, context) -> request.setHeader(API_KEY_HEADER, API_KEY_PREFIX + encodedApiKey));
            log.info("API key authentication configured successfully");
        } else {
            log.debug("No API key credentials provided, skipping API key authentication configuration");
        }
    }

    @Override
    public String getAuthType() {
        return AUTH_TYPE;
    }

    @Override
    public void validate(ReadonlyConfig config) {
        Optional apiKeyId = config.getOptional(ElasticsearchBaseOptions.API_KEY_ID);
        Optional apiKey = config.getOptional(ElasticsearchBaseOptions.API_KEY);
        Optional apiKeyEncoded = config.getOptional(ElasticsearchBaseOptions.API_KEY_ENCODED);
        if (!apiKeyId.isPresent() || !apiKey.isPresent()) {
            throw new IllegalArgumentException("API key authentication with auth_type='api_key' requires both api_key_id and api_key");
        }
        this.validateApiKeyIdAndSecret((String)apiKeyId.get(), (String)apiKey.get());
        log.debug("API key authentication configuration validated");
    }

    private String getEncodedApiKey(ReadonlyConfig config) {
        Optional apiKeyId = config.getOptional(ElasticsearchBaseOptions.API_KEY_ID);
        Optional apiKey = config.getOptional(ElasticsearchBaseOptions.API_KEY);
        if (apiKeyId.isPresent() && apiKey.isPresent()) {
            String credentials = (String)apiKeyId.get() + ":" + (String)apiKey.get();
            return Base64.getEncoder().encodeToString(credentials.getBytes(StandardCharsets.UTF_8));
        }
        return null;
    }

    private void validateApiKeyIdAndSecret(String apiKeyId, String apiKey) {
        if (apiKeyId == null || apiKeyId.trim().isEmpty()) {
            throw new IllegalArgumentException("API key ID cannot be null or empty");
        }
        if (apiKey == null || apiKey.trim().isEmpty()) {
            throw new IllegalArgumentException("API key cannot be null or empty");
        }
    }
}

