/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.search.fetch.subphase;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.lucene.document.HalfFloatPoint;
import org.apache.lucene.document.InetAddressPoint;
import org.apache.lucene.geo.GeoEncodingUtils;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;
import org.easysearch.common.network.NetworkAddress;
import org.easysearch.index.mapper.MappedFieldType;
import org.easysearch.search.lookup.SourceLookup;

public class ReuseDocValueFetcher {
    private final String typeName;
    private final String field;
    private SourceDocvalues sourceDocvalues;
    private boolean isNull = true;
    private final MappedFieldType fieldType;

    public ReuseDocValueFetcher(MappedFieldType fieldType) {
        this.typeName = fieldType.typeName();
        this.field = fieldType.name();
        this.fieldType = fieldType;
    }

    public void setSourceDocvalues(SourceDocvalues sourceDocvalues) {
        this.sourceDocvalues = sourceDocvalues;
        this.isNull = false;
    }

    public boolean isNull() {
        return this.isNull;
    }

    public String getField() {
        return this.field;
    }

    public String toString() {
        return this.field + "  " + this.typeName + " isNull:" + this.isNull;
    }

    public List<Object> fetchValues(SourceLookup lookup) throws IOException {
        return this.fetchValues(lookup.docId());
    }

    public List<Object> fetchValues(int docId) throws IOException {
        if (this.isNull || !this.sourceDocvalues.advanceExact(docId)) {
            return Collections.emptyList();
        }
        List<Object> result = this.sourceDocvalues.values();
        ArrayList<Object> result2 = new ArrayList<Object>(result.size());
        for (Object value : result) {
            value = this.convert(value);
            result2.add(value);
        }
        return result2;
    }

    private Object convert(Object value) {
        switch (this.typeName) {
            case "float": {
                value = Float.valueOf(NumericUtils.sortableIntToFloat((int)((int)((Long)((Object)value)).longValue())));
                break;
            }
            case "double": {
                value = NumericUtils.sortableLongToDouble((long)((Long)((Object)value)));
                break;
            }
            case "keyword": {
                value = this.fieldType.docValueFormat(null, null).format((BytesRef)value);
                break;
            }
            case "boolean": {
                value = this.fieldType.docValueFormat(null, null).format((Long)((Object)value));
                break;
            }
            case "ip": {
                BytesRef bytesRef = (BytesRef)value;
                byte[] bytes = Arrays.copyOfRange(bytesRef.bytes, bytesRef.offset, bytesRef.offset + bytesRef.length);
                value = NetworkAddress.format(InetAddressPoint.decode((byte[])bytes));
                break;
            }
            case "half_float": {
                long val0 = (Long)((Object)value);
                value = Float.valueOf(HalfFloatPoint.sortableShortToHalfFloat((short)((short)val0)));
                break;
            }
            case "geo_point": {
                long val0 = (Long)((Object)value);
                HashMap<String, Double> map = new HashMap<String, Double>(2);
                map.put("lat", GeoEncodingUtils.decodeLatitude((int)((int)(val0 >>> 32))));
                map.put("lon", GeoEncodingUtils.decodeLongitude((int)((int)val0)));
                value = map;
                break;
            }
        }
        return value;
    }

    public static SourceDocvalues docValuesOrNull(LeafReader reader, ReuseDocValueFetcher fetcher) throws IOException {
        if (fetcher.typeName.equals("keyword") || fetcher.typeName.equals("ip")) {
            SortedSetDocValues docValues = DocValues.getSortedSet((LeafReader)reader, (String)fetcher.field);
            if (docValues.getValueCount() != 0L) {
                return new TermSourceDocvalues(docValues);
            }
        } else {
            SortedNumericDocValues dv = reader.getSortedNumericDocValues(fetcher.field);
            if (dv != null) {
                return new NumSourceDocvalues(dv);
            }
            NumericDocValues single = reader.getNumericDocValues(fetcher.field);
            if (single != null) {
                return new NumSourceDocvalues(DocValues.singleton((NumericDocValues)single));
            }
        }
        return null;
    }

    public static interface SourceDocvalues {
        public boolean advanceExact(int var1) throws IOException;

        public int docValueCount() throws IOException;

        public List<Object> values() throws IOException;
    }

    static class TermSourceDocvalues
    implements SourceDocvalues {
        SortedSetDocValues sortedSetDocValues;
        private boolean hasValue;

        public TermSourceDocvalues(SortedSetDocValues sortedSetDocValues) {
            this.sortedSetDocValues = sortedSetDocValues;
        }

        @Override
        public boolean advanceExact(int docId) throws IOException {
            this.hasValue = this.sortedSetDocValues.advanceExact(docId);
            return this.hasValue;
        }

        @Override
        public int docValueCount() throws IOException {
            return this.hasValue ? (int)this.sortedSetDocValues.getValueCount() : 0;
        }

        @Override
        public List<Object> values() throws IOException {
            long ord;
            if (!this.hasValue) {
                return Collections.emptyList();
            }
            ArrayList<Object> list = new ArrayList<Object>(2);
            while ((ord = this.sortedSetDocValues.nextOrd()) != -1L) {
                BytesRef value = this.sortedSetDocValues.lookupOrd(ord);
                list.add(value);
            }
            return list;
        }
    }

    static class NumSourceDocvalues
    implements SourceDocvalues {
        SortedNumericDocValues sortedNumericDocValues;
        private boolean hasValue;

        public NumSourceDocvalues(SortedNumericDocValues sortedNumericDocValues) {
            this.sortedNumericDocValues = sortedNumericDocValues;
        }

        @Override
        public boolean advanceExact(int docId) throws IOException {
            this.hasValue = this.sortedNumericDocValues.advanceExact(docId);
            return this.hasValue;
        }

        @Override
        public int docValueCount() throws IOException {
            return this.hasValue ? this.sortedNumericDocValues.docValueCount() : 0;
        }

        @Override
        public List<Object> values() throws IOException {
            if (!this.hasValue) {
                return Collections.emptyList();
            }
            ArrayList<Object> result = new ArrayList<Object>(this.sortedNumericDocValues.docValueCount());
            int count = this.sortedNumericDocValues.docValueCount();
            for (int i = 0; i < count; ++i) {
                result.add(this.sortedNumericDocValues.nextValue());
            }
            return result;
        }
    }
}

