/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.search.fetch.subphase;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.easysearch.EasysearchException;
import org.easysearch.common.bytes.BytesArray;
import org.easysearch.common.bytes.BytesReference;
import org.easysearch.common.document.DocumentField;
import org.easysearch.common.io.stream.BytesStreamOutput;
import org.easysearch.common.util.JsonUtils;
import org.easysearch.common.xcontent.XContentBuilder;
import org.easysearch.index.engine.EngineConfig;
import org.easysearch.index.mapper.MapperParsingException;
import org.easysearch.index.mapper.MapperService;
import org.easysearch.search.SearchHit;
import org.easysearch.search.fetch.FetchContext;
import org.easysearch.search.fetch.FetchSubPhase;
import org.easysearch.search.fetch.FetchSubPhaseProcessor;
import org.easysearch.search.fetch.subphase.FetchSourceContext;
import org.easysearch.search.fetch.subphase.ReuseDocValueFetcher;
import org.easysearch.search.fetch.subphase.ReuseFietcherUtil;
import org.easysearch.search.lookup.SourceLookup;

public final class FetchSourcePhase
implements FetchSubPhase {
    @Override
    public FetchSubPhaseProcessor getProcessor(FetchContext fetchContext) {
        final FetchSourceContext fetchSourceContext = fetchContext.fetchSourceContext();
        final MapperService mapperService = fetchContext.mapperService();
        if (fetchSourceContext == null || !fetchSourceContext.fetchSource()) {
            return null;
        }
        final String index = fetchContext.getIndexName();
        assert (fetchSourceContext.fetchSource());
        boolean reuse = mapperService.getIndexSettings().getValue(EngineConfig.INDEX_SOURCE_REUSE);
        final HashMap<String, ReuseDocValueFetcher> reuseFieldFetchers = new HashMap<String, ReuseDocValueFetcher>();
        if (reuse) {
            ReuseFietcherUtil.genFetchers(mapperService, reuseFieldFetchers);
        }
        return new FetchSubPhaseProcessor(){

            @Override
            public void setNextReader(LeafReaderContext readerContext) throws IOException {
                for (ReuseDocValueFetcher fetcher : reuseFieldFetchers.values()) {
                    ReuseDocValueFetcher.SourceDocvalues sourceDocvalues = ReuseDocValueFetcher.docValuesOrNull(readerContext.reader(), fetcher);
                    if (sourceDocvalues == null) continue;
                    fetcher.setSourceDocvalues(sourceDocvalues);
                }
            }

            @Override
            public void process(FetchSubPhase.HitContext hitContext) throws IOException {
                for (Map.Entry entry : reuseFieldFetchers.entrySet()) {
                    List<Object> vals;
                    if (((ReuseDocValueFetcher)entry.getValue()).isNull() || (vals = ((ReuseDocValueFetcher)entry.getValue()).fetchValues(hitContext.sourceLookup())).isEmpty()) continue;
                    DocumentField hitField = new DocumentField((String)entry.getKey(), new ArrayList<Object>(2));
                    hitField.getValues().addAll(vals);
                    hitContext.getReuseFields().put((String)entry.getKey(), hitField);
                }
                FetchSourcePhase.this.hitExecute(index, fetchSourceContext, hitContext, mapperService);
            }
        };
    }

    private void hitExecute(String index, FetchSourceContext fetchSourceContext, FetchSubPhase.HitContext hitContext, MapperService mapperService) {
        boolean nestedHit = hitContext.hit().getNestedIdentity() != null;
        SourceLookup source = hitContext.sourceLookup();
        if (source.source() == null && source.internalSourceRef() == null) {
            if (FetchSourcePhase.containsFilters(fetchSourceContext)) {
                throw new IllegalArgumentException("unable to fetch fields from _source field: _source is disabled in the mappings for index [" + index + "]");
            }
            return;
        }
        if (!nestedHit) {
            boolean reuse = mapperService.getIndexSettings().getValue(EngineConfig.INDEX_SOURCE_REUSE);
            if (reuse) {
                JsonNode jsonNode = JsonUtils.convertBytesRefToJsonNode(source.internalSourceRef().toBytesRef());
                ObjectNode objectNode = (ObjectNode)jsonNode;
                for (Map.Entry<String, DocumentField> entry : hitContext.getReuseFields().entrySet()) {
                    if (entry.getValue().getValues().size() > 1) {
                        objectNode.putPOJO(entry.getKey(), entry.getValue().getValues());
                        continue;
                    }
                    objectNode.putPOJO(entry.getKey(), entry.getValue().getValue());
                }
                try {
                    jsonNode = JsonUtils.nestedJson(jsonNode);
                    BytesArray bytesArray = new BytesArray(JsonUtils.convertJsonNodeToBytes(jsonNode));
                    hitContext.hit().sourceRef(bytesArray);
                    source.setSource(bytesArray);
                }
                catch (Exception e) {
                    throw new MapperParsingException("failed to parse source", (Throwable)e, jsonNode);
                }
            }
            if (!FetchSourcePhase.containsFilters(fetchSourceContext)) {
                hitContext.hit().sourceRef(source.internalSourceRef());
                return;
            }
        }
        Map<String, Object> value = source.filter(fetchSourceContext);
        if (nestedHit) {
            value = this.getNestedSource(value, hitContext);
        }
        try {
            int initialCapacity = nestedHit ? 1024 : Math.min(1024, source.internalSourceRef().length());
            BytesStreamOutput streamOutput = new BytesStreamOutput(initialCapacity);
            XContentBuilder builder = new XContentBuilder(source.sourceContentType().xContent(), streamOutput);
            if (value != null) {
                builder.value(value);
            } else {
                builder.startObject();
                builder.endObject();
            }
            hitContext.hit().sourceRef(BytesReference.bytes(builder));
        }
        catch (IOException e) {
            throw new EasysearchException("Error filtering source", (Throwable)e, new Object[0]);
        }
    }

    private static boolean containsFilters(FetchSourceContext context) {
        return context.includes().length != 0 || context.excludes().length != 0;
    }

    private Map<String, Object> getNestedSource(Map<String, Object> sourceAsMap, FetchSubPhase.HitContext hitContext) {
        for (SearchHit.NestedIdentity o = hitContext.hit().getNestedIdentity(); o != null; o = o.getChild()) {
            if ((sourceAsMap = (Map)sourceAsMap.get(o.getField().string())) != null) continue;
            return null;
        }
        return sourceAsMap;
    }
}

