/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.search.fetch.subphase;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.LeafReaderContext;
import org.easysearch.common.document.DocumentField;
import org.easysearch.index.mapper.MapperService;
import org.easysearch.search.SearchHit;
import org.easysearch.search.fetch.FetchContext;
import org.easysearch.search.fetch.FetchSubPhase;
import org.easysearch.search.fetch.FetchSubPhaseProcessor;
import org.easysearch.search.fetch.subphase.FetchFieldsContext;
import org.easysearch.search.fetch.subphase.FieldFetcher;
import org.easysearch.search.lookup.SearchLookup;
import org.easysearch.search.lookup.SourceLookup;

public final class FetchFieldsPhase
implements FetchSubPhase {
    @Override
    public FetchSubPhaseProcessor getProcessor(FetchContext fetchContext) {
        FetchFieldsContext fetchFieldsContext = fetchContext.fetchFieldsContext();
        if (fetchFieldsContext == null) {
            return null;
        }
        MapperService mapperService = fetchContext.mapperService();
        SearchLookup searchLookup = fetchContext.searchLookup();
        if (!fetchContext.mapperService().documentMapper().sourceMapper().enabled()) {
            throw new IllegalArgumentException("Unable to retrieve the requested [fields] since _source is disabled in the mappings for index [" + fetchContext.getIndexName() + "]");
        }
        final FieldFetcher fieldFetcher = FieldFetcher.create(mapperService, searchLookup, fetchFieldsContext.fields());
        return new FetchSubPhaseProcessor(){

            @Override
            public void setNextReader(LeafReaderContext readerContext) {
                fieldFetcher.setNextReader(readerContext);
            }

            @Override
            public void process(FetchSubPhase.HitContext hitContext) throws IOException {
                SearchHit hit = hitContext.hit();
                SourceLookup sourceLookup = hitContext.sourceLookup();
                Set<String> ignoredFields = FetchFieldsPhase.this.getIgnoredFields(hit);
                Map<String, DocumentField> documentFields = fieldFetcher.fetch(sourceLookup, ignoredFields);
                for (Map.Entry<String, DocumentField> entry : documentFields.entrySet()) {
                    hit.setDocumentField(entry.getKey(), entry.getValue());
                }
            }
        };
    }

    private Set<String> getIgnoredFields(SearchHit hit) {
        DocumentField field = hit.field("_ignored");
        if (field == null) {
            return org.easysearch.common.collect.Set.of();
        }
        HashSet<String> ignoredFields = new HashSet<String>();
        for (Object value : field.getValues()) {
            ignoredFields.add((String)value);
        }
        return ignoredFields;
    }
}

