/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.search.aggregations.support;

import java.io.IOException;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.function.LongSupplier;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.util.BytesRef;
import org.easysearch.common.Rounding;
import org.easysearch.common.geo.GeoPoint;
import org.easysearch.common.time.DateFormatter;
import org.easysearch.index.fielddata.IndexFieldData;
import org.easysearch.index.fielddata.IndexGeoPointFieldData;
import org.easysearch.index.fielddata.IndexNumericFieldData;
import org.easysearch.index.fielddata.IndexOrdinalsFieldData;
import org.easysearch.index.mapper.DateFieldMapper;
import org.easysearch.index.mapper.MappedFieldType;
import org.easysearch.index.mapper.RangeFieldMapper;
import org.easysearch.script.AggregationScript;
import org.easysearch.search.DocValueFormat;
import org.easysearch.search.aggregations.AggregationExecutionException;
import org.easysearch.search.aggregations.support.FieldContext;
import org.easysearch.search.aggregations.support.MissingValues;
import org.easysearch.search.aggregations.support.ValueType;
import org.easysearch.search.aggregations.support.ValuesSource;
import org.easysearch.search.aggregations.support.ValuesSourceType;

public enum CoreValuesSourceType implements ValuesSourceType
{
    NUMERIC{

        @Override
        public ValuesSource getEmpty() {
            return ValuesSource.Numeric.EMPTY;
        }

        @Override
        public ValuesSource getScript(AggregationScript.LeafFactory script, ValueType scriptValueType) {
            return new ValuesSource.Numeric.Script(script, scriptValueType);
        }

        @Override
        public ValuesSource getField(FieldContext fieldContext, AggregationScript.LeafFactory script) {
            if (!(fieldContext.indexFieldData() instanceof IndexNumericFieldData)) {
                throw new IllegalArgumentException("Expected numeric type on field [" + fieldContext.field() + "], but got [" + fieldContext.fieldType().typeName() + "]");
            }
            ValuesSource.Numeric dataSource = new ValuesSource.Numeric.FieldData((IndexNumericFieldData)fieldContext.indexFieldData());
            if (script != null) {
                dataSource = new ValuesSource.Numeric.WithScript(dataSource, script);
            }
            return dataSource;
        }

        @Override
        public ValuesSource replaceMissing(ValuesSource valuesSource, Object rawMissing, DocValueFormat docValueFormat, LongSupplier now) {
            Double missing = docValueFormat.parseDouble(rawMissing.toString(), false, now);
            return MissingValues.replaceMissing((ValuesSource.Numeric)valuesSource, missing);
        }

        @Override
        public DocValueFormat getFormatter(String format, ZoneId tz) {
            if (format == null) {
                return DocValueFormat.RAW;
            }
            return new DocValueFormat.Decimal(format);
        }
    }
    ,
    BYTES{

        @Override
        public ValuesSource getEmpty() {
            return ValuesSource.Bytes.WithOrdinals.EMPTY;
        }

        @Override
        public ValuesSource getScript(AggregationScript.LeafFactory script, ValueType scriptValueType) {
            return new ValuesSource.Bytes.Script(script);
        }

        @Override
        public ValuesSource getField(FieldContext fieldContext, AggregationScript.LeafFactory script) {
            IndexFieldData<?> indexFieldData = fieldContext.indexFieldData();
            ValuesSource.Bytes dataSource = indexFieldData instanceof IndexOrdinalsFieldData ? new ValuesSource.Bytes.WithOrdinals.FieldData((IndexOrdinalsFieldData)indexFieldData) : new ValuesSource.Bytes.FieldData(indexFieldData);
            if (script != null) {
                dataSource = new ValuesSource.Bytes.WithScript(dataSource, script);
            }
            return dataSource;
        }

        @Override
        public ValuesSource replaceMissing(ValuesSource valuesSource, Object rawMissing, DocValueFormat docValueFormat, LongSupplier now) {
            BytesRef missing = docValueFormat.parseBytesRef(rawMissing.toString());
            if (valuesSource instanceof ValuesSource.Bytes.WithOrdinals) {
                return MissingValues.replaceMissing((ValuesSource.Bytes.WithOrdinals)valuesSource, missing);
            }
            return MissingValues.replaceMissing((ValuesSource.Bytes)valuesSource, missing);
        }
    }
    ,
    GEOPOINT{

        @Override
        public ValuesSource getEmpty() {
            return ValuesSource.GeoPoint.EMPTY;
        }

        @Override
        public ValuesSource getScript(AggregationScript.LeafFactory script, ValueType scriptValueType) {
            throw new AggregationExecutionException("value source of type [" + this.value() + "] is not supported by scripts");
        }

        @Override
        public ValuesSource getField(FieldContext fieldContext, AggregationScript.LeafFactory script) {
            if (!(fieldContext.indexFieldData() instanceof IndexGeoPointFieldData)) {
                throw new IllegalArgumentException("Expected geo_point type on field [" + fieldContext.field() + "], but got [" + fieldContext.fieldType().typeName() + "]");
            }
            return new ValuesSource.GeoPoint.Fielddata((IndexGeoPointFieldData)fieldContext.indexFieldData());
        }

        @Override
        public ValuesSource replaceMissing(ValuesSource valuesSource, Object rawMissing, DocValueFormat docValueFormat, LongSupplier now) {
            GeoPoint missing = new GeoPoint(rawMissing.toString());
            return MissingValues.replaceMissing((ValuesSource.GeoPoint)valuesSource, missing);
        }

        @Override
        public DocValueFormat getFormatter(String format, ZoneId tz) {
            return DocValueFormat.GEOHASH;
        }
    }
    ,
    RANGE{

        @Override
        public ValuesSource getEmpty() {
            throw new IllegalArgumentException("Can't deal with unmapped ValuesSource type " + this.value());
        }

        @Override
        public ValuesSource getScript(AggregationScript.LeafFactory script, ValueType scriptValueType) {
            throw new AggregationExecutionException("value source of type [" + this.value() + "] is not supported by scripts");
        }

        @Override
        public ValuesSource getField(FieldContext fieldContext, AggregationScript.LeafFactory script) {
            MappedFieldType fieldType = fieldContext.fieldType();
            if (!(fieldType instanceof RangeFieldMapper.RangeFieldType)) {
                throw new IllegalStateException("Asked for range ValuesSource, but field is of type " + fieldType.name());
            }
            RangeFieldMapper.RangeFieldType rangeFieldType = (RangeFieldMapper.RangeFieldType)fieldType;
            return new ValuesSource.Range(fieldContext.indexFieldData(), rangeFieldType.rangeType());
        }

        @Override
        public ValuesSource replaceMissing(ValuesSource valuesSource, Object rawMissing, DocValueFormat docValueFormat, LongSupplier now) {
            throw new IllegalArgumentException("Can't apply missing values on a " + valuesSource.getClass());
        }
    }
    ,
    IP{

        @Override
        public ValuesSource getEmpty() {
            return BYTES.getEmpty();
        }

        @Override
        public ValuesSource getScript(AggregationScript.LeafFactory script, ValueType scriptValueType) {
            return BYTES.getScript(script, scriptValueType);
        }

        @Override
        public ValuesSource getField(FieldContext fieldContext, AggregationScript.LeafFactory script) {
            return BYTES.getField(fieldContext, script);
        }

        @Override
        public ValuesSource replaceMissing(ValuesSource valuesSource, Object rawMissing, DocValueFormat docValueFormat, LongSupplier now) {
            return BYTES.replaceMissing(valuesSource, rawMissing, docValueFormat, now);
        }

        @Override
        public DocValueFormat getFormatter(String format, ZoneId tz) {
            return DocValueFormat.IP;
        }
    }
    ,
    DATE{

        @Override
        public ValuesSource getEmpty() {
            return NUMERIC.getEmpty();
        }

        @Override
        public ValuesSource getScript(AggregationScript.LeafFactory script, ValueType scriptValueType) {
            return NUMERIC.getScript(script, scriptValueType);
        }

        @Override
        public ValuesSource getField(FieldContext fieldContext, AggregationScript.LeafFactory script) {
            ValuesSource.Numeric dataSource = this.fieldData(fieldContext);
            if (script != null) {
                return new ValuesSource.Numeric.WithScript(dataSource, script);
            }
            return dataSource;
        }

        private ValuesSource.Numeric fieldData(final FieldContext fieldContext) {
            if (!(fieldContext.indexFieldData() instanceof IndexNumericFieldData)) {
                throw new IllegalArgumentException("Expected numeric type on field [" + fieldContext.field() + "], but got [" + fieldContext.fieldType().typeName() + "]");
            }
            if (!fieldContext.fieldType().isSearchable() || !(fieldContext.fieldType() instanceof DateFieldMapper.DateFieldType)) {
                return new ValuesSource.Numeric.FieldData((IndexNumericFieldData)fieldContext.indexFieldData());
            }
            return new ValuesSource.Numeric.FieldData((IndexNumericFieldData)fieldContext.indexFieldData()){

                @Override
                public Function<Rounding, Rounding.Prepared> roundingPreparer(IndexReader reader) throws IOException {
                    DateFieldMapper.DateFieldType dft = (DateFieldMapper.DateFieldType)fieldContext.fieldType();
                    byte[] min2 = PointValues.getMinPackedValue((IndexReader)reader, (String)fieldContext.field());
                    if (min2 == null) {
                        return Rounding::prepareForUnknown;
                    }
                    byte[] max = PointValues.getMaxPackedValue((IndexReader)reader, (String)fieldContext.field());
                    long minUtcMillis = dft.resolution().parsePointAsMillis(min2);
                    long maxUtcMillis = dft.resolution().parsePointAsMillis(max);
                    return rounding -> rounding.prepare(minUtcMillis, maxUtcMillis);
                }
            };
        }

        @Override
        public ValuesSource replaceMissing(ValuesSource valuesSource, Object rawMissing, DocValueFormat docValueFormat, LongSupplier now) {
            return NUMERIC.replaceMissing(valuesSource, rawMissing, docValueFormat, now);
        }

        @Override
        public DocValueFormat getFormatter(String format, ZoneId tz) {
            return new DocValueFormat.DateTime(format == null ? DateFieldMapper.DEFAULT_DATE_TIME_FORMATTER : DateFormatter.forPattern(format), tz == null ? ZoneOffset.UTC : tz, DateFieldMapper.Resolution.MILLISECONDS);
        }
    }
    ,
    BOOLEAN{

        @Override
        public ValuesSource getEmpty() {
            return NUMERIC.getEmpty();
        }

        @Override
        public ValuesSource getScript(AggregationScript.LeafFactory script, ValueType scriptValueType) {
            return NUMERIC.getScript(script, scriptValueType);
        }

        @Override
        public ValuesSource getField(FieldContext fieldContext, AggregationScript.LeafFactory script) {
            return NUMERIC.getField(fieldContext, script);
        }

        @Override
        public ValuesSource replaceMissing(ValuesSource valuesSource, Object rawMissing, DocValueFormat docValueFormat, LongSupplier now) {
            return NUMERIC.replaceMissing(valuesSource, rawMissing, docValueFormat, now);
        }

        @Override
        public DocValueFormat getFormatter(String format, ZoneId tz) {
            return DocValueFormat.BOOLEAN;
        }
    };

    public static List<ValuesSourceType> ALL_CORE;

    public static ValuesSourceType fromString(String name) {
        return CoreValuesSourceType.valueOf(name.trim().toUpperCase(Locale.ROOT));
    }

    public String value() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    @Override
    public String typeName() {
        return this.value();
    }

    static {
        ALL_CORE = Arrays.asList(CoreValuesSourceType.values());
    }
}

