/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.search.aggregations.pipeline;

import java.io.IOException;
import org.easysearch.common.xcontent.ObjectParser;
import org.easysearch.common.xcontent.ToXContent;
import org.easysearch.common.xcontent.XContentBuilder;
import org.easysearch.common.xcontent.XContentParser;
import org.easysearch.search.aggregations.Aggregation;
import org.easysearch.search.aggregations.metrics.ParsedSingleValueNumericMetricsAggregation;
import org.easysearch.search.aggregations.pipeline.SimpleValue;

public class ParsedSimpleValue
extends ParsedSingleValueNumericMetricsAggregation
implements SimpleValue {
    private static final ObjectParser<ParsedSimpleValue, Void> PARSER = new ObjectParser(ParsedSimpleValue.class.getSimpleName(), true, ParsedSimpleValue::new);

    @Override
    public String getType() {
        return "simple_value";
    }

    public static ParsedSimpleValue fromXContent(XContentParser parser, String name) {
        ParsedSimpleValue simpleValue = PARSER.apply(parser, null);
        simpleValue.setName(name);
        return simpleValue;
    }

    @Override
    protected XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean hasValue = !Double.isNaN(this.value);
        builder.field(Aggregation.CommonFields.VALUE.getPreferredName(), hasValue ? Double.valueOf(this.value) : null);
        if (hasValue && this.valueAsString != null) {
            builder.field(Aggregation.CommonFields.VALUE_AS_STRING.getPreferredName(), this.valueAsString);
        }
        return builder;
    }

    static {
        ParsedSimpleValue.declareSingleValueFields(PARSER, Double.NaN);
    }
}

