/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.search.aggregations.metrics;

import com.tdunning.math.stats.TDigest;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.common.io.stream.StreamOutput;
import org.easysearch.common.xcontent.ToXContent;
import org.easysearch.common.xcontent.XContentBuilder;
import org.easysearch.search.DocValueFormat;
import org.easysearch.search.aggregations.Aggregation;
import org.easysearch.search.aggregations.InternalAggregation;
import org.easysearch.search.aggregations.metrics.InternalNumericMetricsAggregation;
import org.easysearch.search.aggregations.metrics.MedianAbsoluteDeviation;
import org.easysearch.search.aggregations.metrics.TDigestState;

public class InternalMedianAbsoluteDeviation
extends InternalNumericMetricsAggregation.SingleValue
implements MedianAbsoluteDeviation {
    private final TDigestState valuesSketch;
    private final double medianAbsoluteDeviation;

    static double computeMedianAbsoluteDeviation(TDigestState valuesSketch) {
        if (valuesSketch.size() == 0L) {
            return Double.NaN;
        }
        double approximateMedian = valuesSketch.quantile(0.5);
        TDigestState approximatedDeviationsSketch = new TDigestState(valuesSketch.compression());
        valuesSketch.centroids().forEach(centroid -> {
            double deviation = Math.abs(approximateMedian - centroid.mean());
            approximatedDeviationsSketch.add(deviation, centroid.count());
        });
        return approximatedDeviationsSketch.quantile(0.5);
    }

    InternalMedianAbsoluteDeviation(String name, Map<String, Object> metadata, DocValueFormat format, TDigestState valuesSketch) {
        super(name, metadata);
        this.format = Objects.requireNonNull(format);
        this.valuesSketch = Objects.requireNonNull(valuesSketch);
        this.medianAbsoluteDeviation = InternalMedianAbsoluteDeviation.computeMedianAbsoluteDeviation(this.valuesSketch);
    }

    public InternalMedianAbsoluteDeviation(StreamInput in) throws IOException {
        super(in);
        this.format = in.readNamedWriteable(DocValueFormat.class);
        this.valuesSketch = TDigestState.read(in);
        this.medianAbsoluteDeviation = in.readDouble();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable(this.format);
        TDigestState.write(this.valuesSketch, out);
        out.writeDouble(this.medianAbsoluteDeviation);
    }

    @Override
    public InternalAggregation reduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        TDigestState valueMerged = new TDigestState(this.valuesSketch.compression());
        for (InternalAggregation aggregation : aggregations) {
            InternalMedianAbsoluteDeviation madAggregation = (InternalMedianAbsoluteDeviation)aggregation;
            valueMerged.add((TDigest)madAggregation.valuesSketch);
        }
        return new InternalMedianAbsoluteDeviation(this.name, this.metadata, this.format, valueMerged);
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean anyResults = this.valuesSketch.size() > 0L;
        Double mad = anyResults ? Double.valueOf(this.getMedianAbsoluteDeviation()) : null;
        builder.field(Aggregation.CommonFields.VALUE.getPreferredName(), mad);
        if (this.format != DocValueFormat.RAW && anyResults) {
            builder.field(Aggregation.CommonFields.VALUE_AS_STRING.getPreferredName(), this.format.format(mad).toString());
        }
        return builder;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.valuesSketch});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        InternalMedianAbsoluteDeviation other = (InternalMedianAbsoluteDeviation)obj;
        return Objects.equals((Object)this.valuesSketch, (Object)other.valuesSketch);
    }

    @Override
    public String getWriteableName() {
        return "median_absolute_deviation";
    }

    TDigestState getValuesSketch() {
        return this.valuesSketch;
    }

    @Override
    public double value() {
        return this.getMedianAbsoluteDeviation();
    }

    @Override
    public double getMedianAbsoluteDeviation() {
        return this.medianAbsoluteDeviation;
    }
}

