/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.search.aggregations.metrics;

abstract class AbstractCardinalityAlgorithm {
    public static final int MIN_PRECISION = 4;
    public static final int MAX_PRECISION = 18;
    protected final int p;

    AbstractCardinalityAlgorithm(int precision) {
        if (precision < 4) {
            throw new IllegalArgumentException("precision must be >= 4");
        }
        if (precision > 18) {
            throw new IllegalArgumentException("precision must be <= 18");
        }
        this.p = precision;
    }

    public int precision() {
        return this.p;
    }

    public abstract long cardinality(long var1);

    static long linearCounting(long m3, long v) {
        return Math.round((double)m3 * Math.log((double)m3 / (double)v));
    }
}

