/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.search.aggregations.bucket.terms;

import org.easysearch.common.lease.Releasable;
import org.easysearch.common.util.BigArrays;
import org.easysearch.common.util.LongHash;
import org.easysearch.common.util.LongLongHash;
import org.easysearch.search.aggregations.CardinalityUpperBound;

public abstract class LongKeyedBucketOrds
implements Releasable {
    public static LongKeyedBucketOrds build(BigArrays bigArrays, CardinalityUpperBound cardinality) {
        return cardinality.map(estimate -> estimate < 2 ? new FromSingle(bigArrays) : new FromMany(bigArrays));
    }

    private LongKeyedBucketOrds() {
    }

    public abstract long add(long var1, long var3);

    public abstract long bucketsInOrd(long var1);

    public abstract long find(long var1, long var3);

    public abstract long get(long var1);

    public abstract long size();

    public abstract long maxOwningBucketOrd();

    public abstract BucketOrdsEnum ordsEnum(long var1);

    public static class FromSingle
    extends LongKeyedBucketOrds {
        private final LongHash ords;

        public FromSingle(BigArrays bigArrays) {
            this.ords = new LongHash(1L, bigArrays);
        }

        @Override
        public long add(long owningBucketOrd, long value) {
            assert (owningBucketOrd == 0L);
            return this.ords.add(value);
        }

        @Override
        public long find(long owningBucketOrd, long value) {
            assert (owningBucketOrd == 0L);
            return this.ords.find(value);
        }

        @Override
        public long get(long ordinal) {
            return this.ords.get(ordinal);
        }

        @Override
        public long bucketsInOrd(long owningBucketOrd) {
            assert (owningBucketOrd == 0L);
            return this.ords.size();
        }

        @Override
        public long size() {
            return this.ords.size();
        }

        @Override
        public long maxOwningBucketOrd() {
            return 0L;
        }

        @Override
        public BucketOrdsEnum ordsEnum(long owningBucketOrd) {
            assert (owningBucketOrd == 0L);
            return new BucketOrdsEnum(){
                private long ord = -1L;
                private long value;

                @Override
                public boolean next() {
                    ++this.ord;
                    if (this.ord >= ords.size()) {
                        return false;
                    }
                    this.value = ords.get(this.ord);
                    return true;
                }

                @Override
                public long value() {
                    return this.value;
                }

                @Override
                public long ord() {
                    return this.ord;
                }
            };
        }

        @Override
        public void close() {
            this.ords.close();
        }
    }

    public static class FromMany
    extends LongKeyedBucketOrds {
        private final LongLongHash ords;

        public FromMany(BigArrays bigArrays) {
            this.ords = new LongLongHash(2L, bigArrays);
        }

        @Override
        public long add(long owningBucketOrd, long value) {
            return this.ords.add(owningBucketOrd, value);
        }

        @Override
        public long find(long owningBucketOrd, long value) {
            return this.ords.find(owningBucketOrd, value);
        }

        @Override
        public long get(long ordinal) {
            return this.ords.getKey2(ordinal);
        }

        @Override
        public long bucketsInOrd(long owningBucketOrd) {
            long count = 0L;
            for (long i = 0L; i < this.ords.size(); ++i) {
                if (this.ords.getKey1(i) != owningBucketOrd) continue;
                ++count;
            }
            return count;
        }

        @Override
        public long size() {
            return this.ords.size();
        }

        @Override
        public long maxOwningBucketOrd() {
            long max = -1L;
            for (long i = 0L; i < this.ords.size(); ++i) {
                max = Math.max(max, this.ords.getKey1(i));
            }
            return max;
        }

        @Override
        public BucketOrdsEnum ordsEnum(final long owningBucketOrd) {
            return new BucketOrdsEnum(){
                private long ord = -1L;
                private long value;

                @Override
                public boolean next() {
                    do {
                        ++this.ord;
                        if (this.ord < ords.size()) continue;
                        return false;
                    } while (ords.getKey1(this.ord) != owningBucketOrd);
                    this.value = ords.getKey2(this.ord);
                    return true;
                }

                @Override
                public long value() {
                    return this.value;
                }

                @Override
                public long ord() {
                    return this.ord;
                }
            };
        }

        @Override
        public void close() {
            this.ords.close();
        }
    }

    public static interface BucketOrdsEnum {
        public static final BucketOrdsEnum EMPTY = new BucketOrdsEnum(){

            @Override
            public boolean next() {
                return false;
            }

            @Override
            public long ord() {
                return 0L;
            }

            @Override
            public long value() {
                return 0L;
            }
        };

        public boolean next();

        public long ord();

        public long value();
    }
}

